'''OpenGL extension ARB.shadow_ambient

Overview (from the spec)
	
	This is based on the GL_SGIX_shadow_ambient extension and is layered
	upon the GL_ARB_shadow extension.
	
	Basically, this extension allows the user to specify the texture
	value to use when the texture compare function fails.  Normally
	this value is zero.  By allowing an arbitrary value we can get
	functionality which otherwise requires an advanced texture
	combine extension (such as GL_NV_register_combiners) and multiple
	texture units.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/ARB/shadow_ambient.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_ARB_shadow_ambient'
GL_TEXTURE_COMPARE_FAIL_VALUE_ARB = constant.Constant( 'GL_TEXTURE_COMPARE_FAIL_VALUE_ARB', 0x80BF )


def glInitShadowAmbientARB():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
