# -*- text -*-

# file stdtoolbars.inc
# This file is part of LyX, the document processor.
# Licence details can be found in the file COPYING.

# author Jean-Marc Lasgouttes
# author John Levon

# Full author contact details are available in file CREDITS.

# The interface is designed (partially) following the KDE Human Interface
# Guidelines (http://usability.kde.org/hig/)

# Casing rules for "The tooltip":
# Capitalize the first letter of the first word, and any other words normally
# capitalized in sentences, such as application names.
#
# Casing Rules for the "GUI Name":
# Capitalize all words in the element, with the following exceptions: 
# * Articles: a, an, the. 
# * Conjunctions: and, but, for, not, so, yet ...  
# * Prepositions of three or fewer letters: at, for, by, in, to ...
#
# (http://library.gnome.org/devel/hig-book/stable/design-text-labels.html.en)

# A Toolbar starts like :
#
# Toolbar "name" "GUI Name"
#
# Only seven commands are allowed inside the Toolbar and End
# directives:
#   Item "The tooltip" "<action> [<parameter>]" adds an icon to the toolbar performing
#          "<action> <parameter>"
#      Examples:
#      Item "Small font" "font-size small"
#      Item Emphasized set-emph
#
#   Layouts adds the layouts combo-box to the toolbar
#
#   Separator adds some spacing to the toolbar
#
#   Minibuffer adds the command buffer (Qt only, only one may exist)
#
#   TableInsert "The tooltip" adds a special widget for quick insertion of tables
#
#   PopupMenu "name" "The tooltip"
#
#   ... inserts a button with a popup menu derived from Toolbar "name"
#
#   IconPalette "name" "The tooltip"
#
#   ... inserts a button with a popup iconpalette derived from Toolbar "name"
#
#
# The icons are found in the lib/images/ direcory under the name
# action.png or action_parameter.png, except for math-insert, which
# is e.g. lib/image/math/sum.png. Note that some characters are
# replaced (e.g. ')' -> rbracket).
#
#  All other lyx commands will get a "unknown" icon.
#
# This is the default toolbar:

ToolbarSet

	Toolbar "standard" "Standard"
		Layouts
		Item "New document" "buffer-new"
		Item "Open document" "file-open"
		Item "Save document" "buffer-write"
		Item "Print document" "dialog-show print"
		Separator
		Item "Check spelling" "dialog-show spellchecker"
		Separator
		Item "Undo" "undo"
		Item "Redo" "redo"
		Item "Cut" "cut"
		Item "Copy" "copy"
		Item "Paste" "paste"
		Item "Find and replace" "dialog-show findreplace"
		Item "Navigate back" "bookmark-goto 0"
		Separator
		Item "Toggle emphasis" "font-emph"
		Item "Toggle noun" "font-noun"
		Item "Apply last" "textstyle-apply"
		Separator
		Item "Insert math" "math-mode"
		Item "Insert graphics" "dialog-show-new-inset graphics"
		TableInsert "Insert table"
		Separator
		Item "Toggle outline" "dialog-toggle toc"
		Item "Toggle math toolbar" "toolbar-toggle math"
		Item "Toggle table toolbar" "toolbar-toggle table"
	End

	Toolbar "extra" "Extra"
		Item "Default" "layout"
		Item "Numbered list" "layout Enumerate"
		Item "Itemized list" "layout Itemize"
		Item "List" "layout List"
		Item "Description" "layout Description"
		Item "Increase depth" "depth-increment"
		Item "Decrease depth" "depth-decrement"
		Separator
		Item "Insert figure float" "float-insert figure"
		Item "Insert table float" "float-insert table"
		Item "Insert label" "label-insert"
		Item "Insert cross-reference" "dialog-show-new-inset ref"
		Item "Insert citation" "dialog-show-new-inset citation"
		Item "Insert index entry" "index-insert"
		Item "Insert nomenclature entry" "nomencl-insert"
		Separator
		Item "Insert footnote" "footnote-insert"
		Item "Insert margin note" "marginalnote-insert"
		Item "Insert note" "note-insert"
		Item "Insert box" "box-insert Frameless"
		Item "Insert hyperlink" "href-insert"
		Item "Insert TeX code" "ert-insert"
		Item "Insert math macro" "math-macro newmacroname newcommand"
		Item "Include file" "dialog-show-new-inset include"
		Separator
		Item "Text style" "dialog-show character"
		Item "Paragraph settings" "layout-paragraph"
		Item "Thesaurus" "thesaurus-entry"
	End
	
	Toolbar "table" "Table"
		Item "Add row" "tabular-feature append-row"
		Item "Add column" "tabular-feature append-column"
		Item "Delete row" "tabular-feature delete-row"
		Item "Delete column" "tabular-feature delete-column"
		Separator
		Item "Set top line" "tabular-feature toggle-line-top"
		Item "Set bottom line" "tabular-feature toggle-line-bottom"
		Item "Set left line" "tabular-feature toggle-line-left"
		Item "Set right line" "tabular-feature toggle-line-right"
		Item "Set border lines" "tabular-feature set-border-lines"
		Item "Set all lines" "tabular-feature set-all-lines"
		Item "Unset all lines" "tabular-feature unset-all-lines"
		Separator
		Item "Align left" "command-alternatives tabular-feature m-align-left;tabular-feature align-left"
		Item "Align center" "command-alternatives tabular-feature m-align-center;tabular-feature align-center"
		Item "Align right" "command-alternatives tabular-feature m-align-right;tabular-feature align-right"
		Separator
		Item "Align top" "command-alternatives tabular-feature m-valign-top;tabular-feature valign-top"
		Item "Align middle" "command-alternatives tabular-feature m-valign-middle;tabular-feature valign-middle"
		Item "Align bottom" "command-alternatives tabular-feature m-valign-bottom;tabular-feature valign-bottom"
		Separator
		Item "Rotate cell" "tabular-feature toggle-rotate-cell"
		Item "Rotate table" "tabular-feature toggle-rotate-tabular"
		Item "Set multi-column" "tabular-feature multicolumn"
	End
	
	Toolbar "math" "Math"
		Item "Set display mode" "math-display"
		Separator
		Item "Subscript" "math-subscript"
		Item "Superscript" "math-superscript"
		Item "Insert square root" "math-insert \sqrt"
		Item "Insert root" "math-insert \root"
		Item "Insert standard fraction" "math-insert \frac"
		Item "Insert sum" "math-insert \sum"
		Item "Insert integral" "math-insert \int"
		Item "Insert product" "math-insert \prod"
		Separator
		Item "Insert ( )" "math-delim ( )"
		Item "Insert [ ]" "math-delim [ ]"
		Item "Insert { }" "math-delim { }"
		Item "Insert delimiters" "dialog-show mathdelimiter"
		Separator
		Item "Insert matrix" "dialog-show mathmatrix"
		Item "Insert cases environment" "math-insert \cases"
		Item "Add row" "tabular-feature append-row"
		Item "Add column" "tabular-feature append-column"
		Item "Delete row" "tabular-feature delete-row"
		Item "Delete column" "tabular-feature delete-column"
		Separator
		Item "Toggle math panels" "toolbar-toggle math_panels"
	End

	Toolbar "mathmacrotemplate" "Math Macros"
		Item "Remove last argument" "math-macro-remove-param"
		Item "Append argument" "math-macro-add-param"
		Separator
		Item "Make first non-optional into optional argument" "math-macro-make-optional"
		Item "Make last optional into non-optional argument"
		"math-macro-make-nonoptional"
		Item "Remove optional argument" "math-macro-remove-optional-param"
		Item "Insert optional argument" "math-macro-add-optional-param"
		Separator
		Item "Remove last argument spitting out to the right" "math-macro-remove-greedy-param"
		Item "Append argument eating from the right" "math-macro-append-greedy-param"
		Item "Append optional argument eating from the right" "math-macro-add-greedy-optional-param"
	End

	Toolbar "minibuffer" "Command Buffer"
		Minibuffer
	End
	
	Toolbar "review" "Review[[Toolbar]]"
		Item "Track changes" "changes-track"
		Item "Show changes in output" "changes-output"
		Separator
		Item "Next change" "change-next"
		Item "Accept change inside selection" "change-accept"
		Item "Reject change inside selection" "change-reject"
		Separator
		Item "Merge changes" "changes-merge"
		Item "Accept all changes" "all-changes-accept"
		Item "Reject all changes" "all-changes-reject"
		Separator
		Item "Insert note" "note-insert"
		Item "Next note" "note-next"
	End
	
	Toolbar "view/update" "View/Update"
		Item "View DVI" "buffer-view dvi"
		Item "Update DVI" "buffer-update dvi"
		Item "View PDF (pdflatex)" "buffer-view pdf2"
		Item "Update PDF (pdflatex)" "buffer-update pdf2"
		Item "View PostScript" "buffer-view ps"
		Item "Update PostScript" "buffer-update ps"
	End

	Toolbar "vcs" "Version Control"
		Item "Register" "vc-register"
		Item "Check-out for edit" "vc-check-out"
		Item "Check-in changes" "vc-check-in"
		Item "View revision log" "dialog-show vclog"
		Item "Revert changes" "vc-revert"
		Separator
		Item "Use SVN file locking property" "vc-locking-toggle"
		Separator
		Item "Update local directory from repository" "vc-repo-update"
	End

	Toolbar "math_panels" "Math Panels"
		PopupMenu "space" "Math spacings"
		PopupMenu "style" "Styles"
		PopupMenu "frac-square" "Fractions"
		PopupMenu "font" "Fonts"
		PopupMenu "functions" "Functions"
		IconPalette "latex_deco" "Frame decorations"
		IconPalette "latex_varsz" "Big operators"
		IconPalette "latex_misc" "Miscellaneous"
		IconPalette "latex_greek" "Greek"
		IconPalette "latex_arrow" "Arrows"
		IconPalette "latex_ams_arrows" "AMS arrows"
		IconPalette "latex_bop" "Operators"
		IconPalette "latex_brel" "Relations"
		IconPalette "latex_ams_rel" "AMS relations"
		IconPalette "latex_ams_nrel" "AMS negative relations"
		IconPalette "latex_dots" "Dots"
		IconPalette "latex_ams_ops" "AMS operators"
		IconPalette "latex_ams_misc" "AMS miscellaneous"
	End

	Toolbar "functions" "Functions"
		Item "arccos" "math-insert \arccos"
		Item "arcsin" "math-insert \arcsin"
		Item "arctan" "math-insert \arctan"
		Item "arg" "math-insert \arg"
		Item "bmod" "math-insert \bmod"
		Item "cos" "math-insert \cos"
		Item "cosh" "math-insert \cosh"
		Item "cot" "math-insert \cot"
		Item "coth" "math-insert \coth"
		Item "csc" "math-insert \csc"
		Item "deg" "math-insert \deg"
		Item "det" "math-insert \det"
		Item "dim" "math-insert \dim"
		Item "exp" "math-insert \exp"
		Item "gcd" "math-insert \gcd"
		Item "hom" "math-insert \hom"
		Item "inf" "math-insert \inf"
		Item "ker" "math-insert \ker"
		Item "lg" "math-insert \lg"
		Item "lim" "math-insert \lim"
		Item "liminf" "math-insert \liminf"
		Item "limsup" "math-insert \limsup"
		Item "ln" "math-insert \ln"
		Item "log" "math-insert \log"
		Item "max" "math-insert \max"
		Item "min" "math-insert \min"
		Item "sec" "math-insert \sec"
		Item "sin" "math-insert \sin"
		Item "sinh" "math-insert \sinh"
		Item "sup" "math-insert \sup"
		Item "tan" "math-insert \tan"
		Item "tanh" "math-insert \tanh"
		Item "Pr" "math-insert \Pr"
	End

	Toolbar "space" "Spacings"
		Item "Thin space	\\," "math-insert \,"
		Item "Medium space	\\:" "math-insert \:"
		Item "Thick space	\\;" "math-insert \;"
		Item "Quadratin space	\\quad" "math-insert \quad"
		Item "Double quadratin space	\\qquad" "math-insert \qquad"
		Item "Negative space	\\!" "math-insert \!"
		Item "Placeholder	\\phantom" "math-insert \phantom"
		Item "Horizontal placeholder	\\hphantom" "math-insert \hphantom"
		Item "Vertical placeholder	\\vphantom" "math-insert \vphantom"
	End

	Toolbar "sqrt-square" "Roots"
		Item "Square root	\\sqrt" "math-insert \sqrt"
		Item "Other root	\\root" "math-insert \root"
	End
	
	Toolbar "style" "Styles"
		Item "Display style	\\displaystyle" "math-size \displaystyle"
		Item "Normal text style	\\textstyle" "math-size \textstyle"
		Item "Script (small) style	\\scriptstyle" "math-size \scriptstyle"
		Item "Scriptscript (smaller) style	\\scriptscriptstyle" "math-size \scriptscriptstyle"
	End

	Toolbar "frac-square" "Fractions"
		Item "Standard	\\frac" "math-insert \frac"
		Item "No horizontal line	\\atop" "math-insert \atop"
		Item "Nice fraction (3/4)	\\nicefrac" "math-insert \nicefrac"
		Item "Unit (km)	\\unit" "math-insert \unitone"
		Item "Unit (864 m)	\\unit" "math-insert \unittwo"
		Item "Unit fraction (km/h)	\\unitfrac" "math-insert \unitfrac"
		Item "Unit fraction (20 km/h)	\\unitfrac" "math-insert \unitfracthree"
		Item "Text fraction	\\tfrac" "math-insert \tfrac"
		Item "Display fraction	\\dfrac" "math-insert \dfrac"
		Item "Continued fraction	\\cfrac" "math-insert \cfrac"
		Item "Continued fraction (left)	\\cfrac" "math-insert \cfracleft"
		Item "Continued fraction (right)	\\cfrac" "math-insert \cfracright"
		Item "Binomial	\\binom" "math-insert \binom"
		Item "Text binomial	\\tbinom" "math-insert \tbinom"
		Item "Display binomial	\\dbinom" "math-insert \dbinom"
	End

	Toolbar "font" "Fonts"
		Item "Roman	\\mathrm" "math-insert \mathrm"
		Item "Bold	\\mathbf" "math-insert \mathbf"
		Item "Bold symbol	\\boldsymbol" "math-insert \boldsymbol"
		Item "Sans serif	\\mathsf" "math-insert \mathsf"
		Item "Italic	\\mathit" "math-insert \mathit"
		Item "Typewriter	\\mathtt" "math-insert \mathtt"
		Item "Blackboard	\\mathbb" "math-insert \mathbb"
		Item "Fraktur	\\mathfrak" "math-insert \mathfrak"
		Item "Calligraphic	\\mathcal" "math-insert \mathcal"
		Item "Normal text mode	\\textrm" "math-insert \textrm"
	End

	Toolbar "latex_dots" "Dots"
		Item "ldots" "math-insert \ldots"
		Item "cdots" "math-insert \cdots"
		Item "vdots" "math-insert \vdots"
		Item "ddots" "math-insert \ddots"
	End

	Toolbar "latex_deco" "Frame Decorations"
		Item "hat" "math-insert \hat"
		Item "tilde" "math-insert \tilde"
		Item "bar" "math-insert \bar"
		Item "grave" "math-insert \grave"
		Item "dot" "math-insert \dot"
		Item "check" "math-insert \check"
		Item "widehat" "math-insert \widehat"
		Item "widetilde" "math-insert \widetilde"
		Item "vec" "math-insert \vec"
		Item "acute" "math-insert \acute"
		Item "ddot" "math-insert \ddot"
		Item "breve" "math-insert \breve"
		Item "overline" "math-insert \overline"
		Item "overbrace" "math-insert \overbrace"
		Item "overleftarrow" "math-insert \overleftarrow"
		Item "overrightarrow" "math-insert \overrightarrow"
		Item "overleftrightarrow" "math-insert \overleftrightarrow"
		Item "overset" "math-insert \overset"
		Item "underline" "math-insert \underline"
		Item "underbrace" "math-insert \underbrace"
		Item "underleftarrow" "math-insert \underleftarrow"
		Item "underrightarrow" "math-insert \underrightarrow"
		Item "underleftrightarrow" "math-insert \underleftrightarrow"
		Item "underset" "math-insert \underset"
	End

	Toolbar "latex_arrow" "Arrows"
		Item "leftarrow" "math-insert \leftarrow"
		Item "rightarrow" "math-insert \rightarrow"
		Item "downarrow" "math-insert \downarrow"
		Item "uparrow" "math-insert \uparrow"
		Item "updownarrow" "math-insert \updownarrow"
		Item "leftrightarrow" "math-insert \leftrightarrow"
		Item "Leftarrow" "math-insert \Leftarrow"
		Item "Rightarrow" "math-insert \Rightarrow"
		Item "Downarrow" "math-insert \Downarrow"
		Item "Uparrow" "math-insert \Uparrow"
		Item "Updownarrow" "math-insert \Updownarrow"
		Item "Leftrightarrow" "math-insert \Leftrightarrow"
		Item "Longleftrightarrow" "math-insert \Longleftrightarrow"
		Item "Longleftarrow" "math-insert \Longleftarrow"
		Item "Longrightarrow" "math-insert \Longrightarrow"
		Item "longleftrightarrow" "math-insert \longleftrightarrow"
		Item "longleftarrow" "math-insert \longleftarrow"
		Item "longrightarrow" "math-insert \longrightarrow"
		Item "leftharpoondown" "math-insert \leftharpoondown"
		Item "rightharpoondown" "math-insert \rightharpoondown"
		Item "mapsto" "math-insert \mapsto"
		Item "longmapsto" "math-insert \longmapsto"
		Item "nwarrow" "math-insert \nwarrow"
		Item "nearrow" "math-insert \nearrow"
		Item "leftharpoonup" "math-insert \leftharpoonup"
		Item "rightharpoonup" "math-insert \rightharpoonup"
		Item "hookleftarrow" "math-insert \hookleftarrow"
		Item "hookrightarrow" "math-insert \hookrightarrow"
		Item "swarrow" "math-insert \swarrow"
		Item "searrow" "math-insert \searrow"
		Item "rightleftharpoons" "math-insert \rightleftharpoons"
	End

	Toolbar "latex_bop" "Operators"
		Item "pm" "math-insert \pm"
		Item "cap" "math-insert \cap"
		Item "diamond" "math-insert \diamond"
		Item "oplus" "math-insert \oplus"
		Item "mp" "math-insert \mp"
		Item "cup" "math-insert \cup"
		Item "bigtriangleup" "math-insert \bigtriangleup"
		Item "ominus" "math-insert \ominus"
		Item "times" "math-insert \times"
		Item "uplus" "math-insert \uplus"
		Item "bigtriangledown" "math-insert \bigtriangledown"
		Item "otimes" "math-insert \otimes"
		Item "div" "math-insert \div"
		Item "sqcap" "math-insert \sqcap"
		Item "triangleright" "math-insert \triangleright"
		Item "oslash" "math-insert \oslash"
		Item "cdot" "math-insert \cdot"
		Item "sqcup" "math-insert \sqcup"
		Item "triangleleft" "math-insert \triangleleft"
		Item "odot" "math-insert \odot"
		Item "star" "math-insert \star"
		Item "vee" "math-insert \vee"
		Item "amalg" "math-insert \amalg"
		Item "bigcirc" "math-insert \bigcirc"
		Item "setminus" "math-insert \setminus"
		Item "wedge" "math-insert \wedge"
		Item "dagger" "math-insert \dagger"
		Item "circ" "math-insert \circ"
		Item "bullet" "math-insert \bullet"
		Item "wr" "math-insert \wr"
		Item "ddagger" "math-insert \ddagger"
	End

	Toolbar "latex_brel" "Relations"
		Item "leq" "math-insert \leq"
		Item "geq" "math-insert \geq"
		Item "equiv" "math-insert \equiv"
		Item "models" "math-insert \models"
		Item "prec" "math-insert \prec"
		Item "succ" "math-insert \succ"
		Item "sim" "math-insert \sim"
		Item "perp" "math-insert \perp"
		Item "preceq" "math-insert \preceq"
		Item "succeq" "math-insert \succeq"
		Item "simeq" "math-insert \simeq"
		Item "mid" "math-insert \mid"
		Item "ll" "math-insert \ll"
		Item "gg" "math-insert \gg"
		Item "asymp" "math-insert \asymp"
		Item "parallel" "math-insert \parallel"
		Item "subset" "math-insert \subset"
		Item "supset" "math-insert \supset"
		Item "approx" "math-insert \approx"
		Item "smile" "math-insert \smile"
		Item "subseteq" "math-insert \subseteq"
		Item "supseteq" "math-insert \supseteq"
		Item "cong" "math-insert \cong"
		Item "frown" "math-insert \frown"
		Item "sqsubseteq" "math-insert \sqsubseteq"
		Item "sqsupseteq" "math-insert \sqsupseteq"
		Item "doteq" "math-insert \doteq"
		Item "neq" "math-insert \neq"
		Item "in" "math-insert \in"
		Item "ni" "math-insert \ni"
		Item "propto" "math-insert \propto"
		Item "notin" "math-insert \notin"
		Item "vdash" "math-insert \vdash"
		Item "dashv" "math-insert \dashv"
		Item "bowtie" "math-insert \bowtie"
	End

	Toolbar "latex_greek" "Greek"
		Item "alpha" "math-insert \alpha"
		Item "beta" "math-insert \beta"
		Item "gamma" "math-insert \gamma"
		Item "delta" "math-insert \delta"
		Item "epsilon" "math-insert \epsilon"
		Item "varepsilon" "math-insert \varepsilon"
		Item "zeta" "math-insert \zeta"
		Item "eta" "math-insert \eta"
		Item "theta" "math-insert \theta"
		Item "vartheta" "math-insert \vartheta"
		Item "iota" "math-insert \iota"
		Item "kappa" "math-insert \kappa"
		Item "lambda" "math-insert \lambda"
		Item "mu" "math-insert \mu"
		Item "nu" "math-insert \nu"
		Item "xi" "math-insert \xi"
		Item "pi" "math-insert \pi"
		Item "varpi" "math-insert \varpi"
		Item "rho" "math-insert \rho"
		Item "varrho" "math-insert \varrho"
		Item "sigma" "math-insert \sigma"
		Item "varsigma" "math-insert \varsigma"
		Item "tau" "math-insert \tau"
		Item "upsilon" "math-insert \upsilon"
		Item "phi" "math-insert \phi"
		Item "varphi" "math-insert \varphi"
		Item "chi" "math-insert \chi"
		Item "psi" "math-insert \psi"
		Item "omega" "math-insert \omega"
		Item "Gamma" "math-insert \Gamma"
		Item "Delta" "math-insert \Delta"
		Item "Theta" "math-insert \Theta"
		Item "Lambda" "math-insert \Lambda"
		Item "Xi" "math-insert \Xi"
		Item "Pi" "math-insert \Pi"
		Item "Sigma" "math-insert \Sigma"
		Item "Upsilon" "math-insert \Upsilon"
		Item "Phi" "math-insert \Phi"
		Item "Psi" "math-insert \Psi"
		Item "Omega" "math-insert \Omega"
	End

	Toolbar "latex_misc" "Miscellaneous"
		Item "nabla" "math-insert \nabla"
		Item "partial" "math-insert \partial"
		Item "infty" "math-insert \infty"
		Item "prime" "math-insert \prime"
		Item "ell" "math-insert \ell"
		Item "emptyset" "math-insert \emptyset"
		Item "exists" "math-insert \exists"
		Item "forall" "math-insert \forall"
		Item "imath" "math-insert \imath"
		Item "jmath" "math-insert \jmath"
		Item "Re" "math-insert \Re"
		Item "Im" "math-insert \Im"
		Item "aleph" "math-insert \aleph"
		Item "wp" "math-insert \wp"
		Item "hbar" "math-insert \hbar"
		Item "angle" "math-insert \angle"
		Item "top" "math-insert \top"
		Item "bot" "math-insert \bot"
		Item "Vert" "math-insert \Vert"
		Item "neg" "math-insert \neg"
		Item "flat" "math-insert \flat"
		Item "natural" "math-insert \natural"
		Item "sharp" "math-insert \sharp"
		Item "surd" "math-insert \surd"
		Item "triangle" "math-insert \triangle"
		Item "diamondsuit" "math-insert \diamondsuit"
		Item "heartsuit" "math-insert \heartsuit"
		Item "clubsuit" "math-insert \clubsuit"
		Item "spadesuit" "math-insert \spadesuit"
		Item "textrm \\AA" "math-insert \textrm \AA"
		Item "textrm \\O" "math-insert \textrm \O"
		Item "mathcircumflex" "math-insert \mathcircumflex"
		Item "_" "math-insert \_"
		Item "mathrm T" "math-insert \mathrm T"
		Item "mathbb N" "math-insert \mathbb N"
		Item "mathbb Z" "math-insert \mathbb Z"
		Item "mathbb Q" "math-insert \mathbb Q"
		Item "mathbb R" "math-insert \mathbb R"
		Item "mathbb C" "math-insert \mathbb C"
		Item "mathbb H" "math-insert \mathbb H"
		Item "mathcal F" "math-insert \mathcal F"
		Item "mathcal L" "math-insert \mathcal L"
		Item "mathcal H" "math-insert \mathcal H"
		Item "mathcal O" "math-insert \mathcal O"
	End

	Toolbar "latex_varsz" "Big Operators"
		Item "intop" "math-insert \intop"
		Item "int" "math-insert \int"
		Item "iint" "math-insert \iint"
		Item "iintop" "math-insert \iintop"
		Item "iiint" "math-insert \iiint"
		Item "iiintop" "math-insert \iiintop"
		Item "iiiint" "math-insert \iiiint"
		Item "iiiintop" "math-insert \iiiintop"
		Item "dotsint" "math-insert \dotsint"
		Item "dotsintop" "math-insert \dotsintop"
		Item "oint" "math-insert \oint"
		Item "ointop" "math-insert \ointop"
		Item "oiint" "math-insert \oiint"
		Item "oiintop" "math-insert \oiintop"
		Item "ointctrclockwiseop" "math-insert \ointctrclockwiseop"
		Item "ointctrclockwise" "math-insert \ointctrclockwise"
		Item "ointclockwiseop" "math-insert \ointclockwiseop"
		Item "ointclockwise" "math-insert \ointclockwise"
		Item "sqint" "math-insert \sqint"
		Item "sqintop" "math-insert \sqintop"
		Item "sqiint" "math-insert \sqiint"
		Item "sqiintop" "math-insert \sqiintop"
		Item "fint" "math-insert \fint"
		Item "fintop" "math-insert \fintop"
		Item "landupint" "math-insert \landupint"
		Item "landupintop" "math-insert \landupintop"
		Item "landdownint" "math-insert \landdownint"
		Item "landdownintop" "math-insert \landdownintop"
		Item "sum" "math-insert \sum"
		Item "prod" "math-insert \prod"
		Item "coprod" "math-insert \coprod"
		Item "bigsqcup" "math-insert \bigsqcup"
		Item "bigotimes" "math-insert \bigotimes"
		Item "bigodot" "math-insert \bigodot"
		Item "bigoplus" "math-insert \bigoplus"
		Item "bigcap" "math-insert \bigcap"
		Item "bigcup" "math-insert \bigcup"
		Item "biguplus" "math-insert \biguplus"
		Item "bigvee" "math-insert \bigvee"
		Item "bigwedge" "math-insert \bigwedge"
	End

	Toolbar "latex_ams_misc" "AMS Miscellaneous"
		Item "digamma" "math-insert \digamma"
		Item "varkappa" "math-insert \varkappa"
		Item "beth" "math-insert \beth"
		Item "daleth" "math-insert \daleth"
		Item "gimel" "math-insert \gimel"
		Item "ulcorner" "math-insert \ulcorner"
		Item "urcorner" "math-insert \urcorner"
		Item "llcorner" "math-insert \llcorner"
		Item "lrcorner" "math-insert \lrcorner"
		Item "hbar" "math-insert \hbar"
		Item "hslash" "math-insert \hslash"
		Item "vartriangle" "math-insert \vartriangle"
		Item "triangledown" "math-insert \triangledown"
		Item "square" "math-insert \square"
		Item "lozenge" "math-insert \lozenge"
		Item "circledS" "math-insert \circledS"
		Item "angle" "math-insert \angle"
		Item "measuredangle" "math-insert \measuredangle"
		Item "nexists" "math-insert \nexists"
		Item "mho" "math-insert \mho"
		Item "Finv" "math-insert \Finv"
		Item "Game" "math-insert \Game"
		Item "Bbbk" "math-insert \Bbbk"
		Item "backprime" "math-insert \backprime"
		Item "varnothing" "math-insert \varnothing"
		Item "Diamond" "math-insert \Diamond"
		Item "blacktriangle" "math-insert \blacktriangle"
		Item "blacktriangledown" "math-insert \blacktriangledown"
		Item "blacksquare" "math-insert \blacksquare"
		Item "blacklozenge" "math-insert \blacklozenge"
		Item "bigstar" "math-insert \bigstar"
		Item "sphericalangle" "math-insert \sphericalangle"
		Item "complement" "math-insert \complement"
		Item "eth" "math-insert \eth"
		Item "diagup" "math-insert \diagup"
		Item "diagdown" "math-insert \diagdown"
	End

	Toolbar "latex_ams_arrows" "AMS Arrows"
		Item "dashleftarrow" "math-insert \dashleftarrow"
		Item "dashrightarrow" "math-insert \dashrightarrow"
		Item "leftleftarrows" "math-insert \leftleftarrows"
		Item "leftrightarrows" "math-insert \leftrightarrows"
		Item "rightrightarrows" "math-insert \rightrightarrows"
		Item "rightleftarrows" "math-insert \rightleftarrows"
		Item "Lleftarrow" "math-insert \Lleftarrow"
		Item "Rrightarrow" "math-insert \Rrightarrow"
		Item "twoheadleftarrow" "math-insert \twoheadleftarrow"
		Item "twoheadrightarrow" "math-insert \twoheadrightarrow"
		Item "leftarrowtail" "math-insert \leftarrowtail"
		Item "rightarrowtail" "math-insert \rightarrowtail"
		Item "looparrowleft" "math-insert \looparrowleft"
		Item "looparrowright" "math-insert \looparrowright"
		Item "curvearrowleft" "math-insert \curvearrowleft"
		Item "curvearrowright" "math-insert \curvearrowright"
		Item "circlearrowleft" "math-insert \circlearrowleft"
		Item "circlearrowright" "math-insert \circlearrowright"
		Item "Lsh" "math-insert \Lsh"
		Item "Rsh" "math-insert \Rsh"
		Item "upuparrows" "math-insert \upuparrows"
		Item "downdownarrows" "math-insert \downdownarrows"
		Item "upharpoonleft" "math-insert \upharpoonleft"
		Item "upharpoonright" "math-insert \upharpoonright"
		Item "downharpoonleft" "math-insert \downharpoonleft"
		Item "downharpoonright" "math-insert \downharpoonright"
		Item "leftrightharpoons" "math-insert \leftrightharpoons"
		Item "rightleftharpoons" "math-insert \rightleftharpoons"
		Item "rightsquigarrow" "math-insert \rightsquigarrow"
		Item "leftrightsquigarrow" "math-insert \leftrightsquigarrow"
		Item "nleftarrow" "math-insert \nleftarrow"
		Item "nrightarrow" "math-insert \nrightarrow"
		Item "nleftrightarrow" "math-insert \nleftrightarrow"
		Item "nLeftarrow" "math-insert \nLeftarrow"
		Item "nRightarrow" "math-insert \nRightarrow"
		Item "nLeftrightarrow" "math-insert \nLeftrightarrow"
		Item "multimap" "math-insert \multimap"
	End

	Toolbar "latex_ams_rel" "AMS Relations"
		Item "leqq" "math-insert \leqq"
		Item "geqq" "math-insert \geqq"
		Item "leqslant" "math-insert \leqslant"
		Item "geqslant" "math-insert \geqslant"
		Item "eqslantless" "math-insert \eqslantless"
		Item "eqslantgtr" "math-insert \eqslantgtr"
		Item "lesssim" "math-insert \lesssim"
		Item "gtrsim" "math-insert \gtrsim"
		Item "lessapprox" "math-insert \lessapprox"
		Item "gtrapprox" "math-insert \gtrapprox"
		Item "approxeq" "math-insert \approxeq"
		Item "triangleq" "math-insert \triangleq"
		Item "lessdot" "math-insert \lessdot"
		Item "gtrdot" "math-insert \gtrdot"
		Item "lll" "math-insert \lll"
		Item "ggg" "math-insert \ggg"
		Item "lessgtr" "math-insert \lessgtr"
		Item "gtrless" "math-insert \gtrless"
		Item "lesseqgtr" "math-insert \lesseqgtr"
		Item "gtreqless" "math-insert \gtreqless"
		Item "lesseqqgtr" "math-insert \lesseqqgtr"
		Item "gtreqqless" "math-insert \gtreqqless"
		Item "eqcirc" "math-insert \eqcirc"
		Item "circeq" "math-insert \circeq"
		Item "thicksim" "math-insert \thicksim"
		Item "thickapprox" "math-insert \thickapprox"
		Item "backsim" "math-insert \backsim"
		Item "backsimeq" "math-insert \backsimeq"
		Item "subseteqq" "math-insert \subseteqq"
		Item "supseteqq" "math-insert \supseteqq"
		Item "Subset" "math-insert \Subset"
		Item "Supset" "math-insert \Supset"
		Item "sqsubset" "math-insert \sqsubset"
		Item "sqsupset" "math-insert \sqsupset"
		Item "preccurlyeq" "math-insert \preccurlyeq"
		Item "succcurlyeq" "math-insert \succcurlyeq"
		Item "curlyeqprec" "math-insert \curlyeqprec"
		Item "curlyeqsucc" "math-insert \curlyeqsucc"
		Item "precsim" "math-insert \precsim"
		Item "succsim" "math-insert \succsim"
		Item "precapprox" "math-insert \precapprox"
		Item "succapprox" "math-insert \succapprox"
		Item "vartriangleleft" "math-insert \vartriangleleft"
		Item "vartriangleright" "math-insert \vartriangleright"
		Item "trianglelefteq" "math-insert \trianglelefteq"
		Item "trianglerighteq" "math-insert \trianglerighteq"
		Item "bumpeq" "math-insert \bumpeq"
		Item "Bumpeq" "math-insert \Bumpeq"
		Item "doteqdot" "math-insert \doteqdot"
		Item "risingdotseq" "math-insert \risingdotseq"
		Item "fallingdotseq" "math-insert \fallingdotseq"
		Item "vDash" "math-insert \vDash"
		Item "Vvdash" "math-insert \Vvdash"
		Item "Vdash" "math-insert \Vdash"
		Item "shortmid" "math-insert \shortmid"
		Item "shortparallel" "math-insert \shortparallel"
		Item "smallsmile" "math-insert \smallsmile"
		Item "smallfrown" "math-insert \smallfrown"
		Item "blacktriangleleft" "math-insert \blacktriangleleft"
		Item "blacktriangleright" "math-insert \blacktriangleright"
		Item "because" "math-insert \because"
		Item "therefore" "math-insert \therefore"
		Item "backepsilon" "math-insert \backepsilon"
		Item "varpropto" "math-insert \varpropto"
		Item "between" "math-insert \between"
		Item "pitchfork" "math-insert \pitchfork"
	End

	Toolbar "latex_ams_nrel" "AMS Negative Relations"
		Item "nless" "math-insert \nless"
		Item "ngtr" "math-insert \ngtr"
		Item "nleq" "math-insert \nleq"
		Item "ngeq" "math-insert \ngeq"
		Item "nleqslant" "math-insert \nleqslant"
		Item "ngeqslant" "math-insert \ngeqslant"
		Item "nleqq" "math-insert \nleqq"
		Item "ngeqq" "math-insert \ngeqq"
		Item "lneq" "math-insert \lneq"
		Item "gneq" "math-insert \gneq"
		Item "lneqq" "math-insert \lneqq"
		Item "gneqq" "math-insert \gneqq"
		Item "lvertneqq" "math-insert \lvertneqq"
		Item "gvertneqq" "math-insert \gvertneqq"
		Item "lnsim" "math-insert \lnsim"
		Item "gnsim" "math-insert \gnsim"
		Item "lnapprox" "math-insert \lnapprox"
		Item "gnapprox" "math-insert \gnapprox"
		Item "nprec" "math-insert \nprec"
		Item "nsucc" "math-insert \nsucc"
		Item "npreceq" "math-insert \npreceq"
		Item "nsucceq" "math-insert \nsucceq"
		Item "precnsim" "math-insert \precnsim"
		Item "succnsim" "math-insert \succnsim"
		Item "precnapprox" "math-insert \precnapprox"
		Item "succnapprox" "math-insert \succnapprox"
		Item "subsetneq" "math-insert \subsetneq"
		Item "supsetneq" "math-insert \supsetneq"
		Item "subsetneqq" "math-insert \subsetneqq"
		Item "supsetneqq" "math-insert \supsetneqq"
		Item "nsubseteq" "math-insert \nsubseteq"
		Item "nsupseteq" "math-insert \nsupseteq"
		Item "nsupseteqq" "math-insert \nsupseteqq"
		Item "nvdash" "math-insert \nvdash"
		Item "nvDash" "math-insert \nvDash"
		Item "nVDash" "math-insert \nVDash"
		Item "varsubsetneq" "math-insert \varsubsetneq"
		Item "varsupsetneq" "math-insert \varsupsetneq"
		Item "varsubsetneqq" "math-insert \varsubsetneqq"
		Item "varsupsetneqq" "math-insert \varsupsetneqq"
		Item "ntriangleleft" "math-insert \ntriangleleft"
		Item "ntriangleright" "math-insert \ntriangleright"
		Item "ntrianglelefteq" "math-insert \ntrianglelefteq"
		Item "ntrianglerighteq" "math-insert \ntrianglerighteq"
		Item "ncong" "math-insert \ncong"
		Item "nsim" "math-insert \nsim"
		Item "nmid" "math-insert \nmid"
		Item "nshortmid" "math-insert \nshortmid"
		Item "nparallel" "math-insert \nparallel"
		Item "nshortparallel" "math-insert \nshortparallel"
	End

	Toolbar "latex_ams_ops" "AMS Operators"
		Item "dotplus" "math-insert \dotplus"
		Item "smallsetminus" "math-insert \smallsetminus"
		Item "Cap" "math-insert \Cap"
		Item "Cup" "math-insert \Cup"
		Item "barwedge" "math-insert \barwedge"
		Item "veebar" "math-insert \veebar"
		Item "doublebarwedge" "math-insert \doublebarwedge"
		Item "boxminus" "math-insert \boxminus"
		Item "boxtimes" "math-insert \boxtimes"
		Item "boxdot" "math-insert \boxdot"
		Item "boxplus" "math-insert \boxplus"
		Item "divideontimes" "math-insert \divideontimes"
		Item "ltimes" "math-insert \ltimes"
		Item "rtimes" "math-insert \rtimes"
		Item "leftthreetimes" "math-insert \leftthreetimes"
		Item "rightthreetimes" "math-insert \rightthreetimes"
		Item "curlywedge" "math-insert \curlywedge"
		Item "curlyvee" "math-insert \curlyvee"
		Item "circleddash" "math-insert \circleddash"
		Item "circledast" "math-insert \circledast"
		Item "circledcirc" "math-insert \circledcirc"
		Item "centerdot" "math-insert \centerdot"
		Item "intercal" "math-insert \intercal"
	End

End
