/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.RecordNumberBinding;
import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.BlockIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.util.keyrange.KeyRangeException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class StoredList
extends StoredCollection
implements List {
    private static final EntryBinding DEFAULT_KEY_BINDING = new IndexKeyBinding(1);
    private int baseIndex = 1;
    private boolean isSubList;

    public StoredList(Database database, EntryBinding entryBinding, boolean bl) {
        super(new DataView(database, DEFAULT_KEY_BINDING, entryBinding, null, bl, null));
    }

    public StoredList(Database database, EntityBinding entityBinding, boolean bl) {
        super(new DataView(database, DEFAULT_KEY_BINDING, null, entityBinding, bl, null));
    }

    public StoredList(Database database, EntryBinding entryBinding, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, DEFAULT_KEY_BINDING, entryBinding, null, true, primaryKeyAssigner));
    }

    public StoredList(Database database, EntityBinding entityBinding, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, DEFAULT_KEY_BINDING, null, entityBinding, true, primaryKeyAssigner));
    }

    private StoredList(DataView dataView, int n) {
        super(dataView);
        this.baseIndex = n;
        this.isSubList = true;
    }

    public void add(int n, Object object) {
        this.checkIterAddAllowed();
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.getSearchKey(new Long(n), null, false);
            if (operationStatus == OperationStatus.SUCCESS) {
                dataCursor.putBefore(object);
                this.closeCursor(dataCursor);
            } else {
                this.closeCursor(dataCursor);
                dataCursor = null;
                this.view.append(object, null, null);
            }
            this.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    public boolean add(Object object) {
        this.checkIterAddAllowed();
        boolean bl = this.beginAutoCommit();
        try {
            this.view.append(object, null, null);
            this.commitAutoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    public int append(Object object) {
        boolean bl = this.beginAutoCommit();
        try {
            Object[] objectArray = new Object[1];
            this.view.append(object, objectArray, null);
            this.commitAutoCommit(bl);
            return ((Number)objectArray[0]).intValue();
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (this.isSubList) {
            throw new UnsupportedOperationException("cannot add to subList");
        }
        if (!this.view.keysRenumbered) {
            throw new UnsupportedOperationException("requires renumbered keys");
        }
    }

    public boolean addAll(int n, Collection collection) {
        this.checkIterAddAllowed();
        DataCursor dataCursor = null;
        Iterator iterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            iterator = this.storedOrExternalIterator(collection);
            if (!iterator.hasNext()) {
                return false;
            }
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.getSearchKey(new Long(n), null, false);
            if (operationStatus == OperationStatus.SUCCESS) {
                while (iterator.hasNext()) {
                    dataCursor.putBefore(iterator.next());
                }
                this.closeCursor(dataCursor);
            } else {
                this.closeCursor(dataCursor);
                dataCursor = null;
                while (iterator.hasNext()) {
                    this.view.append(iterator.next(), null, null);
                }
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public Object get(int n) {
        return super.get(new Long(n));
    }

    public int indexOf(Object object) {
        return this.indexOf(object, true);
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object, false);
    }

    private int indexOf(Object object, boolean bl) {
        int n;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            OperationStatus operationStatus = dataCursor.findValue(object, bl);
            n = operationStatus == OperationStatus.SUCCESS ? dataCursor.getCurrentRecordNumber() - this.baseIndex : -1;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return n;
    }

    int getIndexOffset() {
        return this.baseIndex;
    }

    public ListIterator listIterator() {
        return this.blockIterator();
    }

    public ListIterator listIterator(int n) {
        BlockIterator blockIterator = this.blockIterator();
        if (blockIterator.moveToIndex(n)) {
            return blockIterator;
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    public Object remove(int n) {
        try {
            Object[] objectArray = new Object[1];
            this.removeKey(new Long(n), objectArray);
            return objectArray[0];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
        }
    }

    public boolean remove(Object object) {
        return this.removeValue(object);
    }

    public Object set(int n, Object object) {
        try {
            return this.put(new Long(n), object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
        }
    }

    public List subList(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        try {
            int n3 = this.baseIndex + n;
            return new StoredList(this.view.subView(new Long(n), true, new Long(n2), false, new IndexKeyBinding(n3)), n3);
        }
        catch (KeyRangeException keyRangeException) {
            throw new IndexOutOfBoundsException(keyRangeException.getMessage());
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object var1_1) {
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                if (!(var1_1 instanceof List)) {
                                    return false;
                                }
                                var2_2 = (List)var1_1;
                                var3_3 = null;
                                var4_4 = null;
                                try {
                                    var3_3 = this.storedIterator();
                                    var4_4 = this.storedOrExternalListIterator(var2_2);
lbl9:
                                    // 3 sources

                                    while (var3_3.hasNext()) {
                                        if (!var4_4.hasNext()) {
                                            var5_6 = false;
                                            if (var3_3 != null) {
                                                var3_3.close();
                                            }
                                            break block12;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (Throwable var8_13) {
                                    if (var3_3 != null) {
                                        var3_3.close();
                                    }
                                    StoredIterator.close(var4_4);
                                    throw var8_13;
                                }
                            }
                            StoredIterator.close(var4_4);
                            return var5_6;
lbl-1000:
                            // 1 sources

                            {
                                if (var3_3.nextIndex() == var4_4.nextIndex()) ** GOTO lbl-1000
                                var5_7 = false;
                                if (var3_3 == null) break block13;
                                var3_3.close();
                            }
                        }
                        StoredIterator.close(var4_4);
                        return var5_7;
lbl-1000:
                        // 1 sources

                        {
                            var5_5 = var3_3.next();
                            var6_10 = var4_4.next();
                            if (var5_5 != null) ** GOTO lbl-1000
                            if (var6_10 == null) ** GOTO lbl9
                            var7_11 = false;
                            if (var3_3 == null) break block14;
                            var3_3.close();
                        }
                    }
                    StoredIterator.close(var4_4);
                    return var7_11;
lbl-1000:
                    // 1 sources

                    {
                        if (var5_5.equals(var6_10)) ** GOTO lbl9
                        var7_12 = false;
                        if (var3_3 == null) break block15;
                        var3_3.close();
                    }
                }
                StoredIterator.close(var4_4);
                return var7_12;
lbl-1000:
                // 1 sources

                {
                    if (!var4_4.hasNext()) ** GOTO lbl-1000
                    var5_8 = false;
                    if (var3_3 == null) break block16;
                    var3_3.close();
                }
            }
            StoredIterator.close(var4_4);
            return var5_8;
lbl-1000:
            // 1 sources

            {
                var5_9 = true;
                if (var3_3 == null) break block17;
                var3_3.close();
            }
        }
        StoredIterator.close(var4_4);
        return var5_9;
    }

    final ListIterator storedOrExternalListIterator(List list) {
        if (list instanceof StoredCollection) {
            return ((StoredCollection)((Object)list)).storedIterator();
        }
        return list.listIterator();
    }

    public int hashCode() {
        return super.hashCode();
    }

    Object makeIteratorData(BaseIterator baseIterator, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) {
        return this.view.makeValue(databaseEntry2, databaseEntry3);
    }

    boolean hasValues() {
        return true;
    }

    private static class IndexKeyBinding
    extends RecordNumberBinding {
        private int baseIndex;

        private IndexKeyBinding(int n) {
            this.baseIndex = n;
        }

        public Object entryToObject(DatabaseEntry databaseEntry) {
            return new Long(IndexKeyBinding.entryToRecordNumber(databaseEntry) - (long)this.baseIndex);
        }

        public void objectToEntry(Object object, DatabaseEntry databaseEntry) {
            IndexKeyBinding.recordNumberToEntry(((Number)object).intValue() + this.baseIndex, databaseEntry);
        }
    }
}

