/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.epic.core.util.PerlExecutableUtilities;
import org.epic.core.util.PerlExecutor;
import org.epic.debug.PerlBreakpointManager;
import org.epic.debug.PerlTarget;
import org.epic.debug.ui.PerlImageDescriptorRegistry;
import org.epic.debug.util.LogWriter;
import org.osgi.framework.BundleContext;

public class PerlDebugPlugin
extends AbstractUIPlugin {
    private static final int mScreenLogLevel = 0;
    private static final int mLogLevel = 2;
    private static final String mDefaultDebugPort = "4444";
    private static PerlDebugPlugin plugin;
    private ResourceBundle resourceBundle;
    private static String[] mSystemEnv;
    private static PerlBreakpointManager mBreakPointmanager;
    private ArrayList mDebugger;
    private static PerlImageDescriptorRegistry defaultPerlImageDescriptorRegistry;
    private static final String mDebugOptionsEnvPrefix = "PERLDB_OPTS=RemotePort=";
    private static final String mDebugOptionsValue = "DumpReused ReadLine=0";

    static {
        defaultPerlImageDescriptorRegistry = new PerlImageDescriptorRegistry();
    }

    public PerlDebugPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.epic.debug.DebugPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static void createDefaultIncPath(List fInc) throws CoreException {
        fInc.addAll(PerlDebugPlugin.runHelperScript("get_inc.pl"));
    }

    public static void errorDialog(String message) {
        PerlDebugPlugin.errorDialog(message, null);
    }

    public static void errorDialog(String message, IStatus status) {
        Shell shell = PerlDebugPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            shell.getDisplay().syncExec((Runnable)new DisplayErrorThread(shell, message, status));
        }
    }

    public File extractTempFile(String src, String dest) throws IOException {
        File file;
        FileOutputStream out;
        block11: {
            File destFile = new File(this.getStateLocation().toString(), dest != null ? dest : src);
            InputStream in = null;
            out = null;
            try {
                int len;
                in = this.getBundle().getEntry(src).openStream();
                out = new FileOutputStream(destFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                file = destFile;
                Object var8_9 = null;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var8_10 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (out == null) break block13;
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        if (out != null) {
            try {
                ((OutputStream)out).close();
            }
            catch (Exception exception) {}
        }
        return file;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PerlDebugPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            window = PerlDebugPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0];
        }
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PerlDebugPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static String[] getDebugEnv(ILaunch launch, int debugPort) throws CoreException {
        String[] env = DebugPlugin.getDefault().getLaunchManager().getEnvironment(launch.getLaunchConfiguration());
        if (env == null) {
            env = PerlDebugPlugin.readNativeEnv();
        }
        if (launch.getLaunchMode().equals("debug")) {
            ArrayList<String> envList = new ArrayList<String>(Arrays.asList(env));
            envList.add(PerlDebugPlugin.getPerlDebugEnv(debugPort));
            env = envList.toArray(new String[envList.size()]);
        }
        return env;
    }

    public static PerlDebugPlugin getDefault() {
        return plugin;
    }

    public static String getDefaultDebugPort() {
        return mDefaultDebugPort;
    }

    public static PerlImageDescriptorRegistry getDefaultDesciptorImageRegistry() {
        return defaultPerlImageDescriptorRegistry;
    }

    public String getInternalDebugInc() throws CoreException {
        try {
            PerlDebugPlugin.getDefault().extractTempFile("autoflush_epic.pm", null);
            File dumpvarFile = PerlDebugPlugin.getDefault().extractTempFile("dumpvar_epic.pm", null);
            return PerlExecutableUtilities.resolveIncPath((String)dumpvarFile.getParentFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "extractTempFile failed on dumpvar_epic.pm", (Throwable)e));
        }
    }

    public static PerlBreakpointManager getPerlBreakPointManager() {
        return mBreakPointmanager;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PerlDebugPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String[] getSystemEnv() {
        return mSystemEnv;
    }

    public static String getUniqueIdentifier() {
        PerlDebugPlugin plugin = PerlDebugPlugin.getDefault();
        return plugin != null ? plugin.getBundle().getSymbolicName() : "org.epic.debug";
    }

    public static IWorkbenchWindow getWorkbenchWindow() {
        IWorkbenchWindow window = PerlDebugPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            window = PerlDebugPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0];
        }
        return window;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String loadHelperScript(String scriptName) throws CoreException {
        String string;
        BufferedReader in = null;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        try {
            try {
                in = new BufferedReader(new InputStreamReader(this.getBundle().getEntry(scriptName).openStream(), "ISO-8859-1"));
                while (true) {
                    String line;
                    if ((line = in.readLine()) == null) {
                        out.close();
                        string = sw.toString();
                        Object var6_8 = null;
                        if (in == null) return string;
                        break;
                    }
                    out.println(line);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not load helper script " + scriptName, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        in.close();
        return string;
    }

    public static void log(IStatus status) {
        PerlDebugPlugin.getDefault().getLog().log(status);
        Throwable e = status.getException();
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void log(Throwable e) {
        PerlDebugPlugin.log((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Debug Error", e));
    }

    public void logInfo(String fText) {
        this.log(1, fText, null);
    }

    public void logInfo(String fText, Exception fException) {
        this.log(1, fText, fException);
    }

    public void logOK(String fText) {
        this.log(0, fText, null);
    }

    public void logOK(String fText, Exception fException) {
        this.log(0, fText, fException);
    }

    public void logWarning(String fText) {
        this.log(2, fText, null);
    }

    public void logWarning(String fText, Exception fException) {
        this.log(2, fText, fException);
    }

    public void logError(String fText) {
        this.log(4, fText, null);
    }

    public void logError(String fText, Exception fException) {
        this.log(4, fText, fException);
    }

    public void registerDebugEventListener(IDebugEventSetListener fListener) {
        DebugPlugin.getDefault().addDebugEventListener(fListener);
    }

    public void registerDebugTarget(PerlTarget fDebug) {
        this.mDebugger.add(fDebug);
    }

    public void shutdown() {
        Iterator i = this.mDebugger.iterator();
        while (i.hasNext()) {
            PerlTarget db = (PerlTarget)((Object)i.next());
            if (db == null) continue;
            try {
                db.terminate();
            }
            catch (DebugException debugException) {}
        }
        mBreakPointmanager.dispose();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        mBreakPointmanager = new PerlBreakpointManager();
        this.mDebugger = new ArrayList();
        this.getLog().addLogListener((ILogListener)new LogWriter(new File(this.getStateLocation() + File.separator + ".log"), 2));
        this.getLog().addLogListener((ILogListener)new LogWriter(System.err, 0));
    }

    public void unregisterDebugTarget(PerlTarget fDebug) {
        this.mDebugger.remove((Object)fDebug);
    }

    public void unregisterDebugEventListener(IDebugEventSetListener fListener) {
        DebugPlugin.getDefault().removeDebugEventListener(fListener);
    }

    private static String getPerlDebugEnv(int debugPort) {
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            PerlDebugPlugin.log(e);
            host = "127.0.0.1";
        }
        return mDebugOptionsEnvPrefix + host + ":" + debugPort + " " + mDebugOptionsValue;
    }

    private void log(int fSeverity, String fText, Exception fException) {
        Status result;
        if (fException != null) {
            if (fException instanceof CoreException) {
                MultiStatus multiStatus = new MultiStatus(PerlDebugPlugin.getUniqueIdentifier(), fSeverity, fText, null);
                multiStatus.add(((CoreException)((Object)fException)).getStatus());
                result = multiStatus;
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintWriter swr = new PrintWriter(out);
                fException.printStackTrace(swr);
                String buf = String.valueOf(fException.getMessage()) + "\n" + out.toString();
                StringTokenizer tok = new StringTokenizer(buf, "\n");
                MultiStatus multiStatus = new MultiStatus(PerlDebugPlugin.getUniqueIdentifier(), fSeverity, fText, null);
                while (tok.hasMoreElements()) {
                    Status status = new Status(fSeverity, PerlDebugPlugin.getUniqueIdentifier(), 0, tok.nextToken(), null);
                    multiStatus.add((IStatus)status);
                }
                result = multiStatus;
            }
        } else {
            result = new Status(fSeverity, PerlDebugPlugin.getUniqueIdentifier(), 0, fText, (Throwable)fException);
        }
        PerlDebugPlugin.log((IStatus)new Status(fSeverity, PerlDebugPlugin.getUniqueIdentifier(), 0, fText, (Throwable)fException));
        PerlDebugPlugin.errorDialog(fText, (IStatus)result);
    }

    private static String[] readNativeEnv() throws CoreException {
        String marker = String.valueOf(System.currentTimeMillis()) + " ";
        List lines = PerlDebugPlugin.runHelperScript("get_env.pl", Arrays.asList(marker));
        ArrayList<String> envList = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            if (!line.startsWith(marker)) {
                buf.append(System.getProperty("line.separator"));
                buf.append(line);
                continue;
            }
            if (buf.length() > 0) {
                envList.add(buf.toString());
            }
            buf.setLength(0);
            buf.append(line.substring(marker.length()));
        }
        if (buf.length() > 0) {
            envList.add(buf.toString());
        }
        return envList.toArray(new String[envList.size()]);
    }

    private static List runHelperScript(String scriptName) throws CoreException {
        return PerlDebugPlugin.runHelperScript(scriptName, Collections.EMPTY_LIST);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List runHelperScript(String scriptName, List scriptArgs) throws CoreException {
        List list;
        PerlExecutor executor = new PerlExecutor();
        try {
            try {
                File scriptFile = PerlDebugPlugin.getDefault().extractTempFile(scriptName, null);
                ArrayList<String> args = new ArrayList<String>(1);
                args.add(scriptFile.getAbsolutePath());
                args.addAll(scriptArgs);
                list = executor.execute(scriptFile.getParentFile(), args, "").getStdoutLines();
                Object var5_7 = null;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "extractTempFile failed on " + scriptName, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            executor.dispose();
            throw throwable;
        }
        executor.dispose();
        return list;
    }

    private static class DisplayErrorThread
    implements Runnable {
        Shell mShell;
        String mMessage;
        IStatus mStatus;

        public DisplayErrorThread(Shell fShell, String fMessage, IStatus fStatus) {
            this.mShell = fShell;
            this.mMessage = fMessage;
            this.mStatus = fStatus;
        }

        public void run() {
            if (this.mStatus == null) {
                MessageDialog.openError((Shell)this.mShell, (String)"EPIC Error", (String)this.mMessage);
            } else {
                ErrorDialog.openError((Shell)this.mShell, (String)"Error", null, (IStatus)this.mStatus);
            }
        }
    }
}

