/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.DocumentAdapter;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.util.Messages;

public abstract class RubyModelOperation
implements IWorkspaceRunnable,
IProgressMonitor {
    protected static final int APPEND = 1;
    protected static final int REMOVEALL_APPEND = 2;
    protected static final int KEEP_EXISTING = 3;
    protected static boolean POST_ACTION_VERBOSE;
    protected IPostAction[] actions;
    protected int actionsStart = 0;
    protected int actionsEnd = -1;
    protected HashMap attributes;
    public static final String HAS_MODIFIED_RESOURCE_ATTR = "hasModifiedResource";
    public static final String TRUE = "true";
    protected IRubyElement[] elementsToProcess;
    protected IRubyElement[] parentElements;
    protected static IRubyElement[] NO_ELEMENTS;
    protected IRubyElement[] resultElements = NO_ELEMENTS;
    protected IProgressMonitor progressMonitor = null;
    protected boolean isNested = false;
    protected boolean force = false;
    protected static ThreadLocal operationStacks;

    static {
        NO_ELEMENTS = new IRubyElement[0];
        operationStacks = new ThreadLocal();
    }

    protected RubyModelOperation() {
    }

    protected RubyModelOperation(IRubyElement[] iRubyElementArray) {
        this.elementsToProcess = iRubyElementArray;
    }

    protected RubyModelOperation(IRubyElement[] iRubyElementArray, IRubyElement[] iRubyElementArray2) {
        this.elementsToProcess = iRubyElementArray;
        this.parentElements = iRubyElementArray2;
    }

    protected RubyModelOperation(IRubyElement[] iRubyElementArray, IRubyElement[] iRubyElementArray2, boolean bl) {
        this.elementsToProcess = iRubyElementArray;
        this.parentElements = iRubyElementArray2;
        this.force = bl;
    }

    protected RubyModelOperation(IRubyElement[] iRubyElementArray, boolean bl) {
        this.elementsToProcess = iRubyElementArray;
        this.force = bl;
    }

    protected RubyModelOperation(IRubyElement iRubyElement) {
        this.elementsToProcess = new IRubyElement[]{iRubyElement};
    }

    protected RubyModelOperation(IRubyElement iRubyElement, boolean bl) {
        this.elementsToProcess = new IRubyElement[]{iRubyElement};
        this.force = bl;
    }

    protected void addAction(IPostAction iPostAction) {
        int n = this.actions.length;
        if (n == ++this.actionsEnd) {
            this.actions = new IPostAction[n * 2];
            System.arraycopy(this.actions, 0, this.actions, 0, n);
        }
        this.actions[this.actionsEnd] = iPostAction;
    }

    protected void addDelta(IRubyElementDelta iRubyElementDelta) {
        RubyModelManager.getRubyModelManager().getDeltaProcessor().registerRubyModelDelta(iRubyElementDelta);
    }

    protected void addReconcileDelta(IRubyScript iRubyScript, IRubyElementDelta iRubyElementDelta) {
        HashMap hashMap = RubyModelManager.getRubyModelManager().getDeltaProcessor().reconcileDeltas;
        RubyElementDelta rubyElementDelta = (RubyElementDelta)hashMap.get(iRubyScript);
        if (rubyElementDelta != null) {
            IRubyElementDelta[] iRubyElementDeltaArray = iRubyElementDelta.getAffectedChildren();
            int n = 0;
            int n2 = iRubyElementDeltaArray.length;
            while (n < n2) {
                RubyElementDelta rubyElementDelta2 = (RubyElementDelta)iRubyElementDeltaArray[n];
                rubyElementDelta.insertDeltaTree(rubyElementDelta2.getElement(), rubyElementDelta2);
                ++n;
            }
            if ((iRubyElementDelta.getFlags() & 0x80000) != 0) {
                rubyElementDelta.changedAST(iRubyElementDelta.getRubyScriptAST());
            }
        } else {
            hashMap.put(iRubyScript, iRubyElementDelta);
        }
    }

    protected void removeReconcileDelta(IRubyScript iRubyScript) {
        RubyModelManager.getRubyModelManager().getDeltaProcessor().reconcileDeltas.remove(iRubyScript);
    }

    public void beginTask(String string, int n) {
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask(string, n);
        }
    }

    protected boolean canModifyRoots() {
        return false;
    }

    protected void checkCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException(Messages.operation_cancelled);
        }
    }

    protected IRubyModelStatus commonVerify() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return new RubyModelStatus(968);
        }
        int n = 0;
        while (n < this.elementsToProcess.length) {
            if (this.elementsToProcess[n] == null) {
                return new RubyModelStatus(968);
            }
            ++n;
        }
        return RubyModelStatus.VERIFIED_OK;
    }

    protected void copyResources(IResource[] iResourceArray, IPath iPath) throws RubyModelException {
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(iResourceArray.length);
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.copy(iResourceArray, iPath, false, iProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new RubyModelException(coreException);
        }
    }

    protected void createFile(IContainer iContainer, String string, InputStream inputStream, boolean bl) throws RubyModelException {
        IFile iFile = iContainer.getFile((IPath)new Path(string));
        try {
            iFile.create(inputStream, bl ? 3 : 2, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new RubyModelException(coreException);
        }
    }

    protected void createFolder(IContainer iContainer, String string, boolean bl) throws RubyModelException {
        IFolder iFolder = iContainer.getFolder((IPath)new Path(string));
        try {
            iFolder.create(bl ? 3 : 2, true, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new RubyModelException(coreException);
        }
    }

    protected void deleteResource(IResource iResource, int n) throws RubyModelException {
        try {
            iResource.delete(n, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new RubyModelException(coreException);
        }
    }

    protected void deleteResources(IResource[] iResourceArray, boolean bl) throws RubyModelException {
        if (iResourceArray == null || iResourceArray.length == 0) {
            return;
        }
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(iResourceArray.length);
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.delete(iResourceArray, bl ? 3 : 2, iProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new RubyModelException(coreException);
        }
    }

    public void done() {
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }

    protected boolean equalsOneOf(IPath iPath, IPath[] iPathArray) {
        int n = 0;
        int n2 = iPathArray.length;
        while (n < n2) {
            if (iPath.equals((Object)iPathArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void executeNestedOperation(RubyModelOperation rubyModelOperation, int n) throws RubyModelException {
        IRubyModelStatus iRubyModelStatus = rubyModelOperation.verify();
        if (!iRubyModelStatus.isOK()) {
            throw new RubyModelException(iRubyModelStatus);
        }
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(n);
        try {
            rubyModelOperation.setNested(true);
            rubyModelOperation.run(iProgressMonitor);
        }
        catch (CoreException coreException) {
            Throwable throwable;
            if (coreException instanceof RubyModelException) {
                throw (RubyModelException)coreException;
            }
            if (coreException.getStatus().getCode() == 76 && (throwable = coreException.getStatus().getException()) instanceof RubyModelException) {
                throw (RubyModelException)((Object)throwable);
            }
            throw new RubyModelException(coreException);
        }
    }

    protected abstract void executeOperation() throws RubyModelException;

    protected Object getAttribute(Object object) {
        ArrayList arrayList = this.getCurrentOperationStack();
        if (arrayList.size() == 0) {
            return null;
        }
        RubyModelOperation rubyModelOperation = (RubyModelOperation)arrayList.get(0);
        if (rubyModelOperation.attributes == null) {
            return null;
        }
        return rubyModelOperation.attributes.get(object);
    }

    protected IRubyScript getRubyScripttFor(IRubyElement iRubyElement) {
        return ((RubyElement)iRubyElement).getRubyScript();
    }

    protected ArrayList getCurrentOperationStack() {
        ArrayList arrayList = (ArrayList)operationStacks.get();
        if (arrayList == null) {
            arrayList = new ArrayList();
            operationStacks.set(arrayList);
        }
        return arrayList;
    }

    protected IDocument getDocument(IRubyScript iRubyScript) throws RubyModelException {
        IBuffer iBuffer = iRubyScript.getBuffer();
        if (iBuffer instanceof IDocument) {
            return (IDocument)iBuffer;
        }
        return new DocumentAdapter(iBuffer);
    }

    protected IRubyElement[] getElementsToProcess() {
        return this.elementsToProcess;
    }

    protected IRubyElement getElementToProcess() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return null;
        }
        return this.elementsToProcess[0];
    }

    public IRubyModel getRubyModel() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return this.getParentElement().getRubyModel();
        }
        return this.elementsToProcess[0].getRubyModel();
    }

    protected IRubyElement getParentElement() {
        if (this.parentElements == null || this.parentElements.length == 0) {
            return null;
        }
        return this.parentElements[0];
    }

    protected IRubyElement[] getParentElements() {
        return this.parentElements;
    }

    public IRubyElement[] getResultElements() {
        return this.resultElements;
    }

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IProgressMonitor getSubProgressMonitor(int n) {
        SubProgressMonitor subProgressMonitor = null;
        if (this.progressMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.progressMonitor, n, 4);
        }
        return subProgressMonitor;
    }

    public boolean hasModifiedResource() {
        return !this.isReadOnly() && this.getAttribute(HAS_MODIFIED_RESOURCE_ATTR) == TRUE;
    }

    public void internalWorked(double d) {
        if (this.progressMonitor != null) {
            this.progressMonitor.internalWorked(d);
        }
    }

    public boolean isCanceled() {
        if (this.progressMonitor != null) {
            return this.progressMonitor.isCanceled();
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean isTopLevelOperation() {
        ArrayList arrayList = this.getCurrentOperationStack();
        return arrayList.size() > 0 && arrayList.get(0) == this;
    }

    protected int firstActionWithID(String string, int n) {
        int n2 = n;
        while (n2 <= this.actionsEnd) {
            if (this.actions[n2].getID().equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected void moveResources(IResource[] iResourceArray, IPath iPath) throws RubyModelException {
        SubProgressMonitor subProgressMonitor = null;
        if (this.progressMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.progressMonitor, iResourceArray.length, 4);
        }
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.move(iResourceArray, iPath, false, (IProgressMonitor)subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new RubyModelException(coreException);
        }
    }

    public RubyElementDelta newRubyElementDelta() {
        return new RubyElementDelta(this.getRubyModel());
    }

    protected RubyModelOperation popOperation() {
        ArrayList arrayList = this.getCurrentOperationStack();
        int n = arrayList.size();
        if (n > 0) {
            if (n == 1) {
                operationStacks.set(null);
            }
            return (RubyModelOperation)arrayList.remove(n - 1);
        }
        return null;
    }

    protected void postAction(IPostAction iPostAction, int n) {
        if (POST_ACTION_VERBOSE) {
            System.out.print("(" + Thread.currentThread() + ") [RubyModelOperation.postAction(IPostAction, int)] Posting action " + iPostAction.getID());
            switch (n) {
                case 2: {
                    System.out.println(" (REMOVEALL_APPEND)");
                    break;
                }
                case 3: {
                    System.out.println(" (KEEP_EXISTING)");
                    break;
                }
                case 1: {
                    System.out.println(" (APPEND)");
                }
            }
        }
        RubyModelOperation rubyModelOperation = (RubyModelOperation)this.getCurrentOperationStack().get(0);
        IPostAction[] iPostActionArray = rubyModelOperation.actions;
        if (iPostActionArray == null) {
            rubyModelOperation.actions = iPostActionArray = new IPostAction[1];
            iPostActionArray[0] = iPostAction;
            rubyModelOperation.actionsEnd = 0;
        } else {
            String string = iPostAction.getID();
            switch (n) {
                case 2: {
                    int n2 = this.actionsStart - 1;
                    while ((n2 = rubyModelOperation.firstActionWithID(string, n2 + 1)) >= 0) {
                        System.arraycopy(iPostActionArray, n2 + 1, iPostActionArray, n2, rubyModelOperation.actionsEnd - n2);
                        iPostActionArray[rubyModelOperation.actionsEnd--] = null;
                    }
                    rubyModelOperation.addAction(iPostAction);
                    break;
                }
                case 3: {
                    if (rubyModelOperation.firstActionWithID(string, 0) >= 0) break;
                    rubyModelOperation.addAction(iPostAction);
                    break;
                }
                case 1: {
                    rubyModelOperation.addAction(iPostAction);
                }
            }
        }
    }

    protected boolean prefixesOneOf(IPath iPath, IPath[] iPathArray) {
        int n = 0;
        int n2 = iPathArray.length;
        while (n < n2) {
            if (iPath.isPrefixOf(iPathArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void pushOperation(RubyModelOperation rubyModelOperation) {
        this.getCurrentOperationStack().add(rubyModelOperation);
    }

    protected void removeAllPostAction(String string) {
        if (POST_ACTION_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [RubyModelOperation.removeAllPostAction(String)] Removing actions " + string);
        }
        RubyModelOperation rubyModelOperation = (RubyModelOperation)this.getCurrentOperationStack().get(0);
        IPostAction[] iPostActionArray = rubyModelOperation.actions;
        if (iPostActionArray == null) {
            return;
        }
        int n = this.actionsStart - 1;
        while ((n = rubyModelOperation.firstActionWithID(string, n + 1)) >= 0) {
            System.arraycopy(iPostActionArray, n + 1, iPostActionArray, n, rubyModelOperation.actionsEnd - n);
            iPostActionArray[rubyModelOperation.actionsEnd--] = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor var1_1) throws CoreException {
        var2_2 = RubyModelManager.getRubyModelManager();
        var3_3 = var2_2.getDeltaProcessor();
        var4_4 = var3_3.javaModelDeltas.size();
        try {
            this.progressMonitor = var1_1;
            this.pushOperation(this);
            try {
                if (this.canModifyRoots()) {
                    RubyModelManager.getRubyModelManager().deltaState.initializeRoots();
                }
                this.executeOperation();
            }
            catch (Throwable var6_5) {
                var5_6 = null;
                if (this.isTopLevelOperation() == false) throw var6_5;
                this.runPostActions();
                throw var6_5;
            }
            {
                var5_7 = null;
                if (this.isTopLevelOperation()) {
                    this.runPostActions();
                }
            }
        }
        catch (Throwable var8_8) {
            var7_9 = null;
            try {
                var3_3 = var2_2.getDeltaProcessor();
                var9_11 = var4_4;
                var10_13 = var3_3.javaModelDeltas.size();
                while (true) {
                    if (var9_11 >= var10_13) break;
                    var3_3.updateRubyModel((IRubyElementDelta)var3_3.javaModelDeltas.get(var9_11));
                    ++var9_11;
                }
                var9_11 = 0;
                var10_13 = this.resultElements.length;
                while (true) {
                    block20: {
                        if (var9_11 < var10_13) break block20;
                        if (!(!this.isTopLevelOperation() || var3_3.javaModelDeltas.size() <= var4_4 && var3_3.reconcileDeltas.isEmpty() || this.hasModifiedResource())) {
                            var3_3.fire(null, 0);
                        }
                        ** GOTO lbl-1000
                    }
                    var11_15 = this.resultElements[var9_11];
                    var12_17 = (Openable)var11_15.getOpenable();
                    if (!(var12_17 instanceof RubyScript) || !((RubyScript)var12_17).isWorkingCopy()) {
                        ((RubyElement)var12_17.getParent()).close();
                    }
                    ++var9_11;
                }
            }
            catch (Throwable var14_19) {
                var13_21 = null;
                this.popOperation();
                throw var14_19;
            }
        }
        {
            var7_10 = null;
        }
        ** try [egrp 3[TRYBLOCK] [4 : 90->256)] { 
lbl56:
        // 1 sources

        var3_3 = var2_2.getDeltaProcessor();
        var9_12 = var4_4;
        var10_14 = var3_3.javaModelDeltas.size();
        while (true) {
            if (var9_12 >= var10_14) break;
            var3_3.updateRubyModel((IRubyElementDelta)var3_3.javaModelDeltas.get(var9_12));
            ++var9_12;
        }
        var9_12 = 0;
        var10_14 = this.resultElements.length;
        while (true) {
            block21: {
                if (var9_12 < var10_14) break block21;
                if (!(!this.isTopLevelOperation() || var3_3.javaModelDeltas.size() <= var4_4 && var3_3.reconcileDeltas.isEmpty() || this.hasModifiedResource())) {
                    var3_3.fire(null, 0);
                }
                ** GOTO lbl88
            }
            var11_16 = this.resultElements[var9_12];
            var12_18 = (Openable)var11_16.getOpenable();
            if (!(var12_18 instanceof RubyScript) || !((RubyScript)var12_18).isWorkingCopy()) {
                ((RubyElement)var12_18.getParent()).close();
            }
            ++var9_12;
        }
lbl78:
        // 1 sources

        catch (Throwable var14_20) {
            var13_23 = null;
            this.popOperation();
            throw var14_20;
        }
lbl-1000:
        // 1 sources

        {
            var13_22 = null;
            this.popOperation();
            throw var8_8;
lbl88:
            // 1 sources

            var13_24 = null;
            this.popOperation();
        }
    }

    public void runOperation(IProgressMonitor iProgressMonitor) throws RubyModelException {
        IRubyModelStatus iRubyModelStatus = this.verify();
        if (!iRubyModelStatus.isOK()) {
            throw new RubyModelException(iRubyModelStatus);
        }
        try {
            if (this.isReadOnly()) {
                this.run(iProgressMonitor);
            } else {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)this, this.getSchedulingRule(), 1, iProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            Throwable throwable;
            if (coreException instanceof RubyModelException) {
                throw (RubyModelException)coreException;
            }
            if (coreException.getStatus().getCode() == 76 && (throwable = coreException.getStatus().getException()) instanceof RubyModelException) {
                throw (RubyModelException)((Object)throwable);
            }
            throw new RubyModelException(coreException);
        }
    }

    protected void runPostActions() throws RubyModelException {
        while (this.actionsStart <= this.actionsEnd) {
            IPostAction iPostAction = this.actions[this.actionsStart++];
            if (POST_ACTION_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [RubyModelOperation.runPostActions()] Running action " + iPostAction.getID());
            }
            iPostAction.run();
        }
    }

    protected void setAttribute(Object object, Object object2) {
        RubyModelOperation rubyModelOperation = (RubyModelOperation)this.getCurrentOperationStack().get(0);
        if (rubyModelOperation.attributes == null) {
            rubyModelOperation.attributes = new HashMap();
        }
        rubyModelOperation.attributes.put(object, object2);
    }

    public void setCanceled(boolean bl) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setCanceled(bl);
        }
    }

    protected void setNested(boolean bl) {
        this.isNested = bl;
    }

    public void setTaskName(String string) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setTaskName(string);
        }
    }

    public void subTask(String string) {
        if (this.progressMonitor != null) {
            this.progressMonitor.subTask(string);
        }
    }

    protected IRubyModelStatus verify() {
        return this.commonVerify();
    }

    public void worked(int n) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(n);
            this.checkCanceled();
        }
    }

    protected static interface IPostAction {
        public String getID();

        public void run() throws RubyModelException;
    }
}

