/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.modelquery;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.html.core.internal.modelquery.HTMLModelQueryImpl;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.modelquery.XMLCatalogIdResolver;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapterImpl;

public class ModelQueryAdapterFactoryForHTML
extends AbstractAdapterFactory {
    ModelQueryAdapterImpl modelQueryAdapter;
    IStructuredModel modelStateNotifier;
    private InternalModelStateListener internalModelStateListener;
    static /* synthetic */ Class class$0;

    public ModelQueryAdapterFactoryForHTML() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super((Object)clazz, true);
    }

    protected ModelQueryAdapterFactoryForHTML(Object adapterKey, boolean registerAdapters) {
        super(adapterKey, registerAdapters);
    }

    public INodeAdapterFactory copy() {
        return new ModelQueryAdapterFactoryForHTML();
    }

    public void release() {
        super.release();
        if (this.modelStateNotifier != null) {
            this.modelStateNotifier.removeModelStateListener((IModelStateListener)this.internalModelStateListener);
        }
        this.modelStateNotifier = null;
        if (this.modelQueryAdapter != null) {
            this.modelQueryAdapter.release();
        }
    }

    protected INodeAdapter createAdapter(INodeNotifier target) {
        if (this.modelQueryAdapter == null && target instanceof IDOMNode) {
            IDOMNode xmlNode = (IDOMNode)target;
            this.modelStateNotifier = xmlNode.getModel();
            this.modelStateNotifier.addModelStateListener((IModelStateListener)this.getInternalModelStateListener());
            IDOMModel model = xmlNode.getModel();
            String baseLocation = null;
            String modelsBaseLocation = model.getBaseLocation();
            if (modelsBaseLocation != null) {
                File file = new Path(modelsBaseLocation).toFile();
                if (file.exists()) {
                    baseLocation = file.getAbsolutePath();
                } else {
                    Path basePath = new Path(model.getBaseLocation());
                    IPath derivedPath = null;
                    derivedPath = basePath.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)basePath).getLocation() : ResourcesPlugin.getWorkspace().getRoot().getLocation().append((IPath)basePath);
                    if (derivedPath != null) {
                        baseLocation = derivedPath.toString();
                    }
                }
            }
            CMDocumentCache cmDocumentCache = new CMDocumentCache();
            XMLCatalogIdResolver idResolver = null;
            org.eclipse.wst.sse.core.internal.util.URIResolver resolver = model.getResolver();
            if (baseLocation != null || resolver != null) {
                idResolver = new XMLCatalogIdResolver(baseLocation, resolver);
            }
            HTMLModelQueryImpl modelQuery = new HTMLModelQueryImpl(cmDocumentCache, (URIResolver)idResolver);
            modelQuery.setEditMode(0);
            this.modelQueryAdapter = new ModelQueryAdapterImpl(cmDocumentCache, (ModelQuery)modelQuery, (URIResolver)idResolver);
        }
        return this.modelQueryAdapter;
    }

    private final InternalModelStateListener getInternalModelStateListener() {
        if (this.internalModelStateListener == null) {
            this.internalModelStateListener = new InternalModelStateListener();
        }
        return this.internalModelStateListener;
    }

    class InternalModelStateListener
    implements IModelStateListener {
        InternalModelStateListener() {
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelChanged(IStructuredModel model) {
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
            this.updateResolver(structuredModel);
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
            ModelQueryAdapterFactoryForHTML.this.modelStateNotifier.removeModelStateListener((IModelStateListener)this);
            ModelQueryAdapterFactoryForHTML.this.modelStateNotifier = newModel;
            this.updateResolver(ModelQueryAdapterFactoryForHTML.this.modelStateNotifier);
            ModelQueryAdapterFactoryForHTML.this.modelStateNotifier.addModelStateListener((IModelStateListener)this);
        }

        private void updateResolver(IStructuredModel model) {
            String baseLocation = model.getBaseLocation();
            IFile baseFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(model.getBaseLocation()));
            if (baseFile != null) {
                baseLocation = baseFile.getLocation().toString();
            }
            ModelQueryAdapterFactoryForHTML.this.modelQueryAdapter.setIdResolver((URIResolver)new XMLCatalogIdResolver(baseLocation, model.getResolver()));
        }
    }
}

