/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OutputViewPlugin
extends AbstractUIPlugin {
    protected static final String PROPERTIES = "org/eclipse/wst/rdb/internal/outputview/nl1/OutputView";
    protected static ResourceBundle properties = null;
    private static OutputViewPlugin inst;

    public OutputViewPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public static OutputViewPlugin getPlugin() {
        return inst;
    }

    public static ResourceBundle getResourceBundle() {
        if (properties == null) {
            try {
                properties = ResourceBundle.getBundle(PROPERTIES);
            }
            catch (MissingResourceException exception) {
                OutputViewPlugin.getPlugin().writeLog(4, 0, "OutputViewPlugin:getResourceBundle.", exception);
            }
        }
        return properties;
    }

    public Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            imageRegistry.put(key, this.getImageDescriptor(key));
            image = imageRegistry.get(key);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(this.getBundle().getEntry("/"), "icons" + File.separator + key + ".gif"));
        }
        catch (Exception e) {
            OutputViewPlugin.getPlugin().writeLog(4, 0, "OutputViewPlugin - Invalid URL.", e);
            return null;
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getString(String key) {
        return OutputViewPlugin.getString(key, null);
    }

    public static String getString(String key, Object[] substitutions) {
        String str = OutputViewPlugin.getResourceBundle().getString(key);
        if (substitutions != null) {
            str = MessageFormat.format(str, substitutions);
        }
        return str;
    }

    public void writeLog(int severity, int code, String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(severity, this.getBundle().getSymbolicName(), code, message, exception));
    }
}

