/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import org.eclipse.wst.server.core.internal.IInstallableServer;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class InstallableServerContentProvider
extends AbstractTreeContentProvider {
    public static final byte STYLE_VENDOR = 1;
    public static final byte STYLE_VERSION = 2;

    public InstallableServerContentProvider(byte style) {
        super(style, false);
        this.fillTree();
    }

    public void fillTree() {
        this.clean();
        ArrayList<IInstallableServer> list = new ArrayList<IInstallableServer>();
        if (this.style != 0) {
            IInstallableServer[] iis = ServerPlugin.getInstallableServers();
            if (iis != null) {
                int size = iis.length;
                int i = 0;
                while (i < size) {
                    IInstallableServer is = iis[i];
                    AbstractTreeContentProvider.TreeElement ele = null;
                    if (this.style == 1) {
                        ele = this.getOrCreate(list, is.getVendor());
                        ele.contents.add(is);
                        this.elementToParentMap.put(is, ele);
                    } else if (this.style == 2) {
                        ele = this.getOrCreate(list, is.getVersion());
                        ele.contents.add(is);
                        this.elementToParentMap.put(is, ele);
                    }
                    ++i;
                }
            }
        } else {
            IInstallableServer[] iis = ServerPlugin.getInstallableServers();
            if (iis != null) {
                int size = iis.length;
                int i = 0;
                while (i < size) {
                    list.add(iis[i]);
                    ++i;
                }
            }
        }
        this.elements = list.toArray();
    }
}

