/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.apache.xerces.util.XMLChar;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNameCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.MultiplicitySection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.dialogs.NewTypeDialog;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDSearchListDialogDelegate;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;

public class XSDElementDeclarationSection
extends MultiplicitySection {
    protected Text nameText;
    protected CCombo typeCombo;
    protected CCombo componentNameCombo;
    boolean isElementReference;
    protected String typeName = "";
    private XSDTypeDefinition typeDefinition;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        String typeLabel = org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_LABEL_TYPE;
        GridData data = new GridData();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel nameLabel = factory.createCLabel(this.composite, Messages._UI_LABEL_NAME);
        nameLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        this.nameText.setLayoutData((Object)data);
        this.applyAllListeners((Control)this.nameText);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.nameText, "org.eclipse.wst.xsd.ui.xsdup0230");
        this.createRenameHyperlink(this.composite);
        if (this.isElementReference) {
            data = new GridData();
            data.horizontalAlignment = 32;
            data.grabExcessHorizontalSpace = false;
            CLabel refLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_REFERENCE);
            refLabel.setLayoutData((Object)data);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            this.componentNameCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
            this.componentNameCombo.addSelectionListener((SelectionListener)this);
            this.componentNameCombo.setLayoutData((Object)data);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.componentNameCombo, "org.eclipse.wst.xsd.ui.xsdup0250");
            this.getWidgetFactory().createCLabel(this.composite, "");
        }
        this.getWidgetFactory().createCLabel(this.composite, typeLabel);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.typeCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.typeCombo.setEditable(false);
        this.typeCombo.setLayoutData((Object)data);
        this.typeCombo.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.typeCombo, "org.eclipse.wst.xsd.ui.xsdup0240");
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.getWidgetFactory().createCLabel(this.composite, "");
        this.getWidgetFactory().createCLabel(this.composite, org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_LABEL_MINOCCURS);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.minCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        this.minCombo.setLayoutData((Object)data);
        this.minCombo.add("0");
        this.minCombo.add("1");
        this.applyAllListeners((Control)this.minCombo);
        this.minCombo.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.minCombo, "org.eclipse.wst.xsd.ui.xsdup0180");
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.getWidgetFactory().createCLabel(this.composite, "");
        this.getWidgetFactory().createCLabel(this.composite, org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_LABEL_MAXOCCURS);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.maxCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        this.maxCombo.setLayoutData((Object)data);
        this.maxCombo.add("0");
        this.maxCombo.add("1");
        this.maxCombo.add("unbounded");
        this.applyAllListeners((Control)this.maxCombo);
        this.maxCombo.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.maxCombo, "org.eclipse.wst.xsd.ui.xsdup0190");
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.setListenerEnabled(false);
        this.init();
        this.relayout();
        this.setListenerEnabled(true);
    }

    protected void init() {
        if (this.input instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)this.input;
            this.isElementReference = xsdElementDeclaration.isElementDeclarationReference();
            this.typeDefinition = xsdElementDeclaration.getResolvedElementDeclaration().getTypeDefinition();
        }
    }

    private void fillTypesCombo() {
        IEditorPart editor = this.getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
        ComponentSpecification[] items = manager.getQuickPicks();
        this.typeCombo.removeAll();
        this.typeCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE);
        this.typeCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW);
        int i = 0;
        while (i < items.length) {
            this.typeCombo.add(items[i].getName());
            ++i;
        }
        XSDElementDeclaration namedComponent = ((XSDElementDeclaration)this.input).getResolvedElementDeclaration();
        XSDTypeDefinition td = namedComponent.getType();
        if (td != null) {
            ComponentSpecification ret;
            String currentTypeName = td.getQName((XSDConcreteComponent)this.xsdSchema);
            if (currentTypeName == null) {
                currentTypeName = "**Anonymous**";
            }
            if ((ret = this.getComponentSpecFromQuickPickForValue(currentTypeName, manager)) == null && currentTypeName != null) {
                this.typeCombo.add(currentTypeName);
            }
        }
    }

    private ComponentSpecification getComponentSpecFromQuickPickForValue(String value, ComponentReferenceEditManager editManager) {
        ComponentSpecification[] quickPicks;
        if (editManager != null && (quickPicks = editManager.getQuickPicks()) != null) {
            int i = 0;
            while (i < quickPicks.length) {
                ComponentSpecification componentSpecification = quickPicks[i];
                if (value != null && value.equals(componentSpecification.getName())) {
                    return componentSpecification;
                }
                ++i;
            }
        }
        return null;
    }

    public void refresh() {
        this.setListenerEnabled(false);
        super.refresh();
        XSDElementDeclaration xsdElementDeclaration = ((XSDElementDeclaration)this.input).getResolvedElementDeclaration();
        this.nameText.setText("");
        this.typeCombo.setText("");
        String name = xsdElementDeclaration.getName();
        if (name != null) {
            this.nameText.setText(name);
        }
        if (this.isElementReference) {
            this.refreshRefCombo();
        }
        if (this.input != null && this.input instanceof XSDElementDeclaration) {
            boolean isAnonymous = xsdElementDeclaration.getAnonymousTypeDefinition() != null;
            XSDTypeDefinition typeDef = xsdElementDeclaration.getResolvedElementDeclaration().getTypeDefinition();
            if (typeDef != null) {
                this.typeName = typeDef.getQName((XSDConcreteComponent)this.xsdSchema);
            }
            if (this.typeName == null) {
                this.typeName = "";
            }
            this.fillTypesCombo();
            if (isAnonymous) {
                this.typeCombo.setText("**Anonymous**");
                this.typeName = "**Anonymous**";
            } else if (this.typeDefinition != null) {
                this.typeCombo.setText(this.typeName);
            } else {
                this.typeCombo.setText(org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_NO_TYPE);
            }
            this.maxCombo.setEnabled(!xsdElementDeclaration.isGlobal() || this.isElementReference);
            this.minCombo.setEnabled(!xsdElementDeclaration.isGlobal() || this.isElementReference);
        }
        this.refreshMinMax();
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.typeCombo) {
            IEditorPart editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
            String selection = this.typeCombo.getText();
            IComponentDialog dialog = null;
            if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE)) {
                dialog = manager.getBrowseDialog();
                ((XSDSearchListDialogDelegate)dialog).showComplexTypes(true);
            } else if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW)) {
                dialog = manager.getNewDialog();
                ((NewTypeDialog)dialog).allowComplexType(true);
            }
            if (dialog != null) {
                if (dialog.createAndOpen() == 0) {
                    ComponentSpecification newValue = dialog.getSelectedComponent();
                    manager.modifyComponentReference(this.input, newValue);
                } else {
                    this.typeCombo.setText(this.typeName);
                }
            } else {
                ComponentSpecification newValue = this.getComponentSpecFromQuickPickForValue(selection, manager);
                if (newValue != null) {
                    manager.modifyComponentReference(this.input, newValue);
                }
            }
        } else if (e.widget == this.componentNameCombo) {
            IEditorPart editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDElementReferenceEditManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
            String selection = this.componentNameCombo.getText();
            IComponentDialog dialog = null;
            if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE)) {
                dialog = manager.getBrowseDialog();
            } else if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW)) {
                dialog = manager.getNewDialog();
            }
            if (dialog != null) {
                if (dialog.createAndOpen() == 0) {
                    ComponentSpecification newValue = dialog.getSelectedComponent();
                    manager.modifyComponentReference(this.input, newValue);
                } else {
                    this.componentNameCombo.setText("");
                }
            } else {
                ComponentSpecification newValue = this.getComponentSpecFromQuickPickForValue(selection, manager);
                if (newValue != null) {
                    manager.modifyComponentReference(this.input, newValue);
                }
            }
        } else if (e.widget == this.maxCombo) {
            this.updateMaxAttribute();
        } else if (e.widget == this.minCombo) {
            this.updateMinAttribute();
        }
    }

    protected void relayout() {
        Composite parentComposite = this.composite.getParent();
        parentComposite.getParent().setRedraw(false);
        if (parentComposite != null && !parentComposite.isDisposed()) {
            Control[] children = parentComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        this.createContents(parentComposite);
        parentComposite.getParent().layout(true, true);
        parentComposite.getParent().setRedraw(true);
        this.refresh();
    }

    public void doHandleEvent(Event event) {
        super.doHandleEvent(event);
        if (event.widget == this.nameText) {
            String newValue = this.nameText.getText().trim();
            if (this.input instanceof XSDElementDeclaration) {
                XSDElementDeclaration namedComponent = ((XSDElementDeclaration)this.input).getResolvedElementDeclaration();
                if (!this.validateSection()) {
                    return;
                }
                UpdateNameCommand command = null;
                String oldName = namedComponent.getName();
                if (!newValue.equals(oldName)) {
                    command = new UpdateNameCommand(Messages._UI_ACTION_RENAME, (XSDNamedComponent)namedComponent, newValue);
                }
                if (command != null && this.getCommandStack() != null) {
                    this.getCommandStack().execute((Command)command);
                }
            }
        }
    }

    protected boolean validateSection() {
        if (this.nameText == null || this.nameText.isDisposed()) {
            return true;
        }
        this.setErrorMessage(null);
        String name = this.nameText.getText().trim();
        if (name.length() < 1 || !XMLChar.isValidNCName((String)name)) {
            this.setErrorMessage(Messages._UI_ERROR_INVALID_NAME);
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.componentNameCombo != null && !this.componentNameCombo.isDisposed()) {
            this.componentNameCombo.removeSelectionListener((SelectionListener)this);
        }
        if (this.minCombo != null && !this.minCombo.isDisposed()) {
            this.minCombo.removeSelectionListener((SelectionListener)this);
        }
        if (this.maxCombo != null && !this.maxCombo.isDisposed()) {
            this.maxCombo.removeSelectionListener((SelectionListener)this);
        }
        if (this.typeCombo != null && !this.typeCombo.isDisposed()) {
            this.typeCombo.removeSelectionListener((SelectionListener)this);
        }
        if (this.nameText != null && !this.nameText.isDisposed()) {
            this.removeListeners((Control)this.nameText);
        }
        super.dispose();
    }

    protected void refreshRefCombo() {
        this.componentNameCombo.setText("");
        this.fillElementsCombo();
    }

    private void fillElementsCombo() {
        XSDElementDeclaration namedComponent;
        Element element;
        ComponentSpecification[] history;
        IEditorPart editor = this.getActiveEditor();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDElementReferenceEditManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
        this.componentNameCombo.removeAll();
        this.componentNameCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE);
        this.componentNameCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW);
        ComponentSpecification[] quickPicks = manager.getQuickPicks();
        if (quickPicks != null) {
            int i = 0;
            while (i < quickPicks.length) {
                ComponentSpecification componentSpecification = quickPicks[i];
                this.componentNameCombo.add(componentSpecification.getName());
                ++i;
            }
        }
        if ((history = manager.getHistory()) != null) {
            int i = 0;
            while (i < history.length) {
                ComponentSpecification componentSpecification = history[i];
                this.componentNameCombo.add(componentSpecification.getName());
                ++i;
            }
        }
        if ((element = (namedComponent = (XSDElementDeclaration)this.input).getElement()) != null) {
            ComponentSpecification ret;
            String attrValue = element.getAttribute("ref");
            if (attrValue == null) {
                attrValue = "";
            }
            if ((ret = this.getComponentSpecFromQuickPickForValue(attrValue, manager)) == null) {
                this.componentNameCombo.add(attrValue);
            }
            this.componentNameCombo.setText(attrValue);
        }
    }
}

