/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.CatalogSet;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogEntriesView;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogEntryDetailsView;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogMessages;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogTreeViewer;

public class SelectFromCatalogDialog
extends Dialog {
    private ICatalog workingUserCatalog;
    private ICatalog userCatalog;
    private ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
    private XMLCatalogEntriesView catalogEntriesView;
    private ICatalog systemCatalog;
    private String currentSelectionLocation;
    private String currentSelectionNamespace;

    public SelectFromCatalogDialog(Shell parentShell) {
        super(parentShell);
        INextCatalog[] nextCatalogs = this.defaultCatalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog catalog = nextCatalogs[i];
            ICatalog referencedCatalog = catalog.getReferencedCatalog();
            if (referencedCatalog != null) {
                if ("system_catalog".equals(referencedCatalog.getId())) {
                    this.systemCatalog = referencedCatalog;
                } else if ("user_catalog".equals(referencedCatalog.getId())) {
                    this.userCatalog = referencedCatalog;
                }
            }
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        CatalogSet tempCatalogSet = new CatalogSet();
        this.workingUserCatalog = tempCatalogSet.lookupOrCreateCatalog("working", "");
        this.workingUserCatalog.addEntriesFromCatalog(this.userCatalog);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.heightHint = 500;
        composite.setLayoutData((Object)gridData);
        this.createCatalogEntriesView(composite);
        this.createCatalogDetailsView(composite);
        return composite;
    }

    protected void createCatalogEntriesView(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 370;
        group.setLayoutData((Object)gridData);
        group.setText(XMLCatalogMessages.UI_LABEL_USER_ENTRIES);
        group.setToolTipText(XMLCatalogMessages.UI_LABEL_USER_ENTRIES_TOOL_TIP);
        this.catalogEntriesView = new XMLCatalogEntriesView((Composite)group, this.workingUserCatalog, this.systemCatalog){

            protected void createButtons(Composite parent) {
            }

            protected void updateWidgetEnabledState() {
            }
        };
        this.catalogEntriesView.setLayoutData((Object)gridData);
        XMLCatalogTreeViewer catalogTreeViewer = (XMLCatalogTreeViewer)this.catalogEntriesView.getViewer();
        catalogTreeViewer.resetFilters();
        catalogTreeViewer.addFilter((ViewerFilter)new XMLCatalogTableViewerFilter(new String[]{".xsd"}));
    }

    protected void createCatalogDetailsView(Composite parent) {
        Group detailsGroup = new Group(parent, 0);
        detailsGroup.setLayoutData((Object)new GridData(768));
        detailsGroup.setLayout((Layout)new GridLayout());
        detailsGroup.setText(XMLCatalogMessages.UI_LABEL_DETAILS);
        final XMLCatalogEntryDetailsView detailsView = new XMLCatalogEntryDetailsView((Composite)detailsGroup);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedObject;
                ISelection selection = event.getSelection();
                Object object = selectedObject = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
                if (selectedObject instanceof ICatalogEntry) {
                    ICatalogEntry entry = (ICatalogEntry)selectedObject;
                    detailsView.setCatalogElement(entry);
                    SelectFromCatalogDialog.this.currentSelectionLocation = entry.getURI();
                    SelectFromCatalogDialog.this.currentSelectionNamespace = entry.getKey();
                } else {
                    detailsView.setCatalogElement(null);
                    SelectFromCatalogDialog.this.currentSelectionLocation = "";
                    SelectFromCatalogDialog.this.currentSelectionNamespace = "";
                }
            }
        };
        this.catalogEntriesView.getViewer().addSelectionChangedListener(listener);
    }

    public String getCurrentSelectionLocation() {
        return this.currentSelectionLocation;
    }

    public String getCurrentSelectionNamespace() {
        return this.currentSelectionNamespace;
    }

    private class XMLCatalogTableViewerFilter
    extends ViewerFilter {
        private static final String W3_XMLSCHEMA_NAMESPACE = "http://www.w3.org/2001/";
        protected String[] extensions;

        public XMLCatalogTableViewerFilter(String[] extensions1) {
            this.extensions = extensions1;
        }

        public boolean isFilterProperty(Object element, Object property) {
            return false;
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean result = false;
            if (element instanceof ICatalogEntry) {
                ICatalogEntry catalogEntry = (ICatalogEntry)element;
                int i = 0;
                while (i < this.extensions.length) {
                    if (catalogEntry.getURI().endsWith(this.extensions[i]) && !catalogEntry.getKey().startsWith(W3_XMLSCHEMA_NAMESPACE)) {
                        result = true;
                        break;
                    }
                    ++i;
                }
            } else if (element.equals(XMLCatalogTreeViewer.PLUGIN_SPECIFIED_ENTRIES_OBJECT) || element.equals(XMLCatalogTreeViewer.USER_SPECIFIED_ENTRIES_OBJECT)) {
                return true;
            }
            return result;
        }
    }
}

