/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.connection.internal.ui.wizards;



/**
 * DB2 alias page of the Connection Wizard. Here, users pick an alias, a driver,
 * and complete the connection URL. This page directly owns a combo box to
 * select a JDBC driver supported by DB2, and a URL details panel to contain
 * driver-specific fields used in the composition of the connection URL. The URL
 * details meet the net or JCC type 2 driver requirements.
 * 
 * @version 1.0
 */
public class NewCWFilterPage {}
//extends RDBWizardPage implements IStructuredContentProvider,
//        ICellModifier, Listener //, KeyListener
//{
//    private static final ResourceLoader resource = ResourceLoader.INSTANCE;
//    
//    /** Options for configuring the content of this page. */
//    protected int contentOptions;
//
//    /** Group for the schema filters. */
//    protected Group schemaGroup;
//
//    /** Global AND for schema filter elements. */
//    protected Button schemaAndRadio;
//
//    /** Global OR for schema filter elements. */
//    protected Button schemaOrRadio;
//
//    /** Table for schema filters. */
//    protected Table schemaTable;
//
//    /** Adds a schema filter. */
//    protected Button schemaAddButton;
//
//    /** Edits a schema filter. */
//    protected Button schemaEditButton;
//
//    /** Removes a schema filter. */
//    protected Button schemaRemoveButton;
//
//    /** Group for the object filters. */
//    protected Group objectGroup;
//
//    /** Global AND for object filter elements. */
//    protected Button objectAndRadio;
//
//    /** Global OR for object filter elements. */
//    protected Button objectOrRadio;
//
//    /** Notebook for the object filters. */
//    protected SWWorkbook objectWorkbook;
//
//    /** Tab for table filters. */
//    protected Composite tableTab;
//
//    /** Tab for routine filters. */
//    protected Composite routineTab;
//
//    /** Table for table filters. */
//    protected Table tableTable;
//
//    /** Table for routine filters. */
//    protected Table routineTable;
//
//    /** Adds an object filter. */
//    protected Button objectAddButton;
//
//    /** Edits an object filter. */
//    protected Button objectEditButton;
//
//    /** Removes an object filter. */
//    protected Button objectRemoveButton;
//
//    /**
//     * Tracks whether we are meeting all or any conditions for the table filter
//     * elements.
//     */
//    protected boolean tableAnd;
//
//    /**
//     * Tracks whether we are meeting all or any conditions for the routine
//     * filter elements.
//     */
//    protected boolean routineAnd;
//
//    /* Filter description. */
//    //protected Text descDisplay;
//    /** Record of user actions selecting routine languages. */
//    protected boolean languageFlags[];
//
//    /** The FilterTypeSet for the current SQLVendor. */
//    protected EList filterTypeSet;
//
//    /** The connection filter. */
//    //protected RDBConnectionFilter rdbConFilter;
//
//    /** Image for a selected check box. */
//    protected static Image CHECK_IMAGE = resource.queryImageFromRegistry("enabled.gif");
//
//    /** Image for an unselected check box. */
//    protected static Image UNCHECK_IMAGE = resource.queryImageFromRegistry("disabled.gif");
//
//    /* Image for a combo box drop-down button. */
//    //protected static Image COMBO_IMAGE =
//    //     RSCCoreUIPlugin.getRSCCoreUIPlugin().getImage("combo");
//    /** The table column header texts. */
//    protected static String[] headers;
//
//    /** The widths of the columns. */
//    protected static ColumnLayoutData[] layouts;
//
//    public static final String P_ENABLE = "boolean";
//
//    public static final String P_TARGET_READONLY = "target";
//
//    public static final String P_TARGET = "targetcombo";
//
//    public static final String P_PREDICATE = "predicatecombo";
//
//    public static final String P_TEXT = "string";
//
//    public static final String P_OPERATOR = "operatorcombo";
//
//    //public static final String P_ENABLE_ICON = "enableIcon";
//    //public static final String P_HEADER_ICON = "headerIcon";
//
//    /** Keys for column data for the table and routine tables. */
//    protected static String[] tableColumnProperties = { P_ENABLE, P_TARGET, P_PREDICATE, P_TEXT,
//            P_OPERATOR };
//
//    /** Keys for column data for the table and routine tables. */
//    protected static String[] schemaColumnProperties = { P_ENABLE, P_TARGET_READONLY, P_PREDICATE,
//            P_TEXT, P_OPERATOR };
//
//    /** Values of the schema filter targets. */
//    protected static String[] schemaTargetStates;
//
//    /** Values of the table filter targets. */
//    protected static String[] tableTargetStates;
//
//    /** Values of the routine filter targets. */
//    protected static String[] routineTargetStates;
//
//    /** Values of the filter predicates. */
//    protected static String[] predicateStates;
//
//    /* Values of the filter operators. */
//    //protected static String[] operatorStates;
//    /** Constructs the page with default options. */
//    public NewCWFilterPage(String name)
//    {
//        this(name, NewConnectionWizard.DEFAULT_OPTIONS);
//    }
//
//    /**
//     * Constructs the page with given options.
//     */
//    public NewCWFilterPage(String name, int contentOptions)
//    {
//        super(name);
//        setTitle(getString("CUI_NEWCW_FILTER_TITLE_UI_"));
//        setDescription(getString("CUI_NEWCW_FILTER_DESC_UI_"));
//        this.contentOptions = contentOptions;
//        initialize();
//        dialogSettingInit();
//    }
//
//    /**
//     * Initializes our internal model objects.
//     */
//    protected void initialize()
//    {
//        // Initialize . . .
//    }
//
//    public void dialogSettingInit()
//    {
//        // do nothing
//    }
//
//    public void createControl(Composite parent)
//    {
//        RSCCoreUIWidgetFactory factory = NewConnectionWizard.getUIFactory();
//        Composite composite = factory.createComposite(parent, SWT.NULL);
//        GridLayout layout = new GridLayout();
//        layout.numColumns = 1;
//        layout.verticalSpacing = 5;
//        composite.setLayout(layout);
//        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
//
//        initializeDialogUnits(composite);
//
//        createGUI(composite, factory);
//
//        addWorkbenchHelp(parent);
//        addListeners();
//
//        setPageDefaults();
//        //repopulateFilterTables();
//
//        setPageComplete(determinePageCompletion());
//
//        setControl(composite);
//    }
//
//    /**
//     * Creates and returns a new panel for a GridLayout.
//     */
//    protected Composite createComposite(Composite parent, int columns,
//            RSCCoreUIWidgetFactory factory)
//    {
//        Composite container = factory.createComposite(parent, SWT.NULL);
//        GridLayout layout = new GridLayout();
//        layout.numColumns = columns;
//        layout.marginWidth = 0;
//        layout.marginHeight = 0;
//        layout.horizontalSpacing = 0;
//        layout.verticalSpacing = 0;
//        container.setLayout(layout);
//        container.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
//        return container;
//    }
//
//    /**
//     * Creates UI for picking an existing connection.
//     */
//    protected void createGUI(Composite parent, RSCCoreUIWidgetFactory factory)
//    {
//        GridData gd;
//        // schemaGroup
//        schemaGroup = createGroup(parent, "CUI_NEWCW_FILTER_STEP1_UI_", factory);
//
//        // Meet all and Meet any radio buttons
//        Composite schemaRadios = factory.createComposite(schemaGroup, SWT.NULL);
//        GridLayout schemaRadiosLayout = new GridLayout();
//        schemaRadiosLayout.numColumns = 2;
//        schemaRadiosLayout.marginWidth = 5;
//        schemaRadiosLayout.marginHeight = 5;
//        schemaRadios.setLayout(schemaRadiosLayout);
//        gd = new GridData();
//        gd.horizontalSpan = 2;
//        gd.verticalAlignment = GridData.BEGINNING;
//        gd.horizontalAlignment = GridData.FILL;
//        gd.grabExcessHorizontalSpace = true;
//        schemaRadios.setLayoutData(gd);
//        // And
//        schemaAndRadio = factory.createButton(schemaRadios, SWT.RADIO);
//        schemaAndRadio.setText(getString("CUI_NEWCW_FILTER_GLOBAL1_AND_UI_"));
//        gd = new GridData();
//        gd.verticalAlignment = GridData.BEGINNING;
//        gd.horizontalAlignment = GridData.FILL;
//        //gd.grabExcessHorizontalSpace = true;
//        schemaAndRadio.setLayoutData(gd);
//        // Or
//        schemaOrRadio = factory.createButton(schemaRadios, SWT.RADIO);
//        schemaOrRadio.setText(getString("CUI_NEWCW_FILTER_GLOBAL1_OR_UI_"));
//        schemaOrRadio.setSelection(true);
//        gd = new GridData();
//        gd.verticalAlignment = GridData.BEGINNING;
//        gd.horizontalAlignment = GridData.FILL;
//        gd.grabExcessHorizontalSpace = true;
//        schemaOrRadio.setLayoutData(gd);
//
//        // schemaTable
//        schemaTable = createTable(schemaGroup, factory);
//        gd = new GridData(300, 80);
//        gd.verticalAlignment = GridData.FILL;
//        gd.grabExcessVerticalSpace = true;
//        gd.horizontalAlignment = GridData.FILL;
//        gd.grabExcessHorizontalSpace = true;
//        schemaTable.setLayoutData(gd);
//
//        // Panel for the table buttons
//        Composite schemaButtons = factory.createComposite(schemaGroup, SWT.NULL);
//        GridLayout schemaButtonsLayout = new GridLayout();
//        schemaButtonsLayout.numColumns = 1;
//        schemaButtonsLayout.marginWidth = 5;
//        schemaButtonsLayout.marginHeight = 5;
//        schemaButtons.setLayout(schemaButtonsLayout);
//        gd = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
//        schemaButtons.setLayoutData(gd);
//        // schemaAddButton
//        schemaAddButton = factory.createButton(schemaButtons, SWT.PUSH);
//        schemaAddButton.setText(getString("CUI_NEWCW_FILTER_ADD1_BTN_UI_"));
//        schemaAddButton.setToolTipText(getString("CUI_NEWCW_FILTER_ADD1_TOOLTIP_UI_"));
//        gd = new GridData(GridData.FILL_HORIZONTAL);
//        schemaAddButton.setLayoutData(gd);
//        // schemaEditButton
//        schemaEditButton = factory.createButton(schemaButtons, SWT.PUSH);
//        schemaEditButton.setText(getString("CUI_NEWCW_FILTER_EDIT1_BTN_UI_"));
//        schemaEditButton.setToolTipText(getString("CUI_NEWCW_FILTER_EDIT1_TOOLTIP_UI_"));
//        gd = new GridData(GridData.FILL_HORIZONTAL);
//        schemaEditButton.setLayoutData(gd);
//        // schemaRemoveButton
//        schemaRemoveButton = factory.createButton(schemaButtons, SWT.PUSH);
//        schemaRemoveButton.setText(getString("CUI_NEWCW_FILTER_REMOVE1_BTN_UI_"));
//        schemaRemoveButton.setToolTipText(getString("CUI_NEWCW_FILTER_REMOVE1_TOOLTIP_UI_"));
//        gd = new GridData(GridData.FILL_HORIZONTAL);
//        //gd.verticalIndent = 5;
//        schemaRemoveButton.setLayoutData(gd);
//        // Enabling
//        schemaAddButton.setEnabled(true);
//        schemaEditButton.setEnabled(false);
//        schemaRemoveButton.setEnabled(false);
//
//        // objectGroup
//        objectGroup = createGroup(parent, "CUI_NEWCW_FILTER_STEP2_UI_", factory);
//
//        // Meet all and Meet any radio buttons
//        Composite objectRadios = factory.createComposite(objectGroup, SWT.NULL);
//        GridLayout objectRadiosLayout = new GridLayout();
//        objectRadiosLayout.numColumns = 2;
//        objectRadiosLayout.marginWidth = 5;
//        objectRadiosLayout.marginHeight = 5;
//        objectRadios.setLayout(objectRadiosLayout);
//        gd = new GridData();
//        gd.horizontalSpan = 2;
//        gd.verticalAlignment = GridData.BEGINNING;
//        gd.horizontalAlignment = GridData.FILL;
//        gd.grabExcessHorizontalSpace = true;
//        objectRadios.setLayoutData(gd);
//        // And
//        objectAndRadio = factory.createButton(objectRadios, SWT.RADIO);
//        objectAndRadio.setText(getString("CUI_NEWCW_FILTER_GLOBAL2_AND_UI_"));
//        gd = new GridData();
//        gd.verticalAlignment = GridData.BEGINNING;
//        gd.horizontalAlignment = GridData.FILL;
//        //gd.grabExcessHorizontalSpace = true;
//        objectAndRadio.setLayoutData(gd);
//        // Or
//        objectOrRadio = factory.createButton(objectRadios, SWT.RADIO);
//        objectOrRadio.setText(getString("CUI_NEWCW_FILTER_GLOBAL2_OR_UI_"));
//        objectOrRadio.setSelection(true);
//        tableAnd = false;
//        routineAnd = false;
//        gd = new GridData();
//        gd.verticalAlignment = GridData.BEGINNING;
//        gd.horizontalAlignment = GridData.FILL;
//        gd.grabExcessHorizontalSpace = true;
//        objectOrRadio.setLayoutData(gd);
//
//        // objectWorkbook
//        objectWorkbook = new SWWorkbook(objectGroup);
//        // Set font to tabFolder and "Client Composite"
//        TabFolder tabFolder = objectWorkbook.getTabFolder();
//        gd = new GridData(310, 100);
//        gd.verticalAlignment = GridData.FILL;
//        gd.grabExcessVerticalSpace = true;
//        gd.horizontalAlignment = GridData.FILL;
//        gd.grabExcessHorizontalSpace = true;
//        tabFolder.setLayoutData(gd);
//        tabFolder.setFont(tabFolder.getParent().getFont());
//        Composite workbookClientComposite = objectWorkbook.getClientComposite();
//        workbookClientComposite.setFont(parent.getFont());
//        tableTab = createComposite(workbookClientComposite, 1, factory);
//        routineTab = createComposite(workbookClientComposite, 1, factory);
//        objectWorkbook.addPage(tableTab, getString("CUI_NEWCW_FILTER_TABLE_TAB_UI_"), null, null);
//        objectWorkbook.addPage(routineTab, getString("CUI_NEWCW_FILTER_ROUTINE_TAB_UI_"), null,
//                null);
//        // tables
//        tableTable = createTable(tableTab, factory);
//        routineTable = createTable(routineTab, factory);
//        if (filterTypeSet != null)
//        {
//            // Loic - Commented out
//            //boolean hasSP = isAFilterTarget(FilterTarget.STORED_PROCEDURE_LITERAL);
//            //boolean hasUDF = isAFilterTarget(FilterTarget.USER_DEFINED_FUNCTION_LITERAL);
//            boolean hasSP = isAFilterTarget();
//            boolean hasUDF = isAFilterTarget();
//            // End comment
//            
//            //routineTab.setEnabled(hasSP || hasUDF);
//            //objectWorkbook.getTabFolder().setEnabled(hasSP || hasUDF);
//            routineTable.setEnabled(hasSP || hasUDF);
//        }
//        // Panel for the table buttons
//        Composite objectButtons = factory.createComposite(objectGroup, SWT.NULL);
//        GridLayout objectButtonsLayout = new GridLayout();
//        objectButtonsLayout.numColumns = 1;
//        schemaButtonsLayout.marginWidth = 5;
//        schemaButtonsLayout.marginHeight = 5;
//        objectButtons.setLayout(objectButtonsLayout);
//        gd = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
//        objectButtons.setLayoutData(gd);
//        // objectAddButton
//        objectAddButton = factory.createButton(objectButtons, SWT.PUSH);
//        objectAddButton.setText(getString("CUI_NEWCW_FILTER_ADD2_BTN_UI_"));
//        objectAddButton.setToolTipText(getString("CUI_NEWCW_FILTER_ADD2_TOOLTIP_UI_"));
//        gd = new GridData(GridData.FILL_HORIZONTAL);
//        //gd.verticalIndent = 25;
//        objectAddButton.setLayoutData(gd);
//        // objectEditButton
//        objectEditButton = factory.createButton(objectButtons, SWT.PUSH);
//        objectEditButton.setText(getString("CUI_NEWCW_FILTER_EDIT2_BTN_UI_"));
//        objectEditButton.setToolTipText(getString("CUI_NEWCW_FILTER_EDIT2_TOOLTIP_UI_"));
//        gd = new GridData(GridData.FILL_HORIZONTAL);
//        objectEditButton.setLayoutData(gd);
//        // objectRemoveButton
//        objectRemoveButton = factory.createButton(objectButtons, SWT.PUSH);
//        objectRemoveButton.setText(getString("CUI_NEWCW_FILTER_REMOVE2_BTN_UI_"));
//        objectRemoveButton.setToolTipText(getString("CUI_NEWCW_FILTER_REMOVE2_TOOLTIP_UI_"));
//        gd = new GridData(GridData.FILL_HORIZONTAL);
//        //gd.verticalIndent = 5;
//        objectRemoveButton.setLayoutData(gd);
//        // Enabling
//        objectAddButton.setEnabled(true);
//        objectEditButton.setEnabled(false);
//        objectRemoveButton.setEnabled(false);
//        /*
//         * Filter description Label descLabel = factory.createLabel(parent,
//         * SWT.NONE);
//         * descLabel.setText(getString("CUI_NEWCW_FILTER_DESCRIPTION_UI_"));
//         * descDisplay = factory.createText( parent, SWT.MULTI | SWT.BORDER |
//         * SWT.READ_ONLY | SWT.V_SCROLL | SWT.WRAP); gd = GridUtil.createFill(); //
//         * new GridData(GridData.FILL_BOTH); gd.heightHint = 50;
//         * descDisplay.setLayoutData(gd);
//         */
//    }
//
//    /**
//     * Creates a group for schema or object filters.
//     */
//    protected Group createGroup(Composite parent, String textKey, RSCCoreUIWidgetFactory factory)
//    {
//        Group group = factory.createGroup(parent, getString(textKey), SWT.NONE);
//        GridLayout layout = new GridLayout();
//        layout.numColumns = 2;
//        layout.marginWidth = 5;
//        layout.marginHeight = 5;
//        group.setLayout(layout);
//        group.setLayoutData(GridUtil.createFill());
//        return group;
//    }
//
//    /**
//     * Creates a table for schema or object filters.
//     * 
//     * @param parent
//     *            The containing composite.
//     */
//    protected Table createTable(Composite parent, RSCCoreUIWidgetFactory factory)
//    {
//        Table table = factory.createTable(parent, //SWT.VIRTUAL |
//                SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.SINGLE | SWT.FULL_SELECTION);
//        table.setLinesVisible(true);
//        table.setHeaderVisible(true);
//        table.setLayoutData(GridUtil.createFill());
//        TableLayout layout = new TableLayout();
//        table.setLayout(layout);
//
//        TableViewer viewer = createTableViewer(table); // Save return for
//                                                       // refreshing?
//        table.setData(viewer); // Creates reference from table to viewer.
//
//        if (headers == null)
//            headers = new String[] { getString("CUI_NEWCW_FILTER_ENABLED_COL_UI_"),
//                    getString("CUI_NEWCW_FILTER_TARGET_COL_UI_"),
//                    getString("CUI_NEWCW_FILTER_PREDICATE_COL_UI_"),
//                    getString("CUI_NEWCW_FILTER_FILTER_COL_UI_")
//            //getString("CUI_NEWCW_FILTER_OPERATOR_COL_UI_")
//            };
//
//        if (layouts == null)
//            layouts = new ColumnLayoutData[] { new ColumnPixelData(60, true), // originally
//                                                                              // 19,
//                                                                              // false
//                    new ColumnPixelData(130, true), new ColumnPixelData(65, true),
//                    new ColumnPixelData(140, true)
//            //new ColumnPixelData(60, true)
//            };
//
//        final TableColumn columns[] = new TableColumn[headers.length];
//        int ncolumns = 0;
//        for (int i = 0; i < headers.length; i++)
//        {
//            layout.addColumnData(layouts[i]);
//            TableColumn tc = new TableColumn(table, SWT.LEFT, i);
//            tc.setResizable(layouts[i].resizable);
//            tc.setText(headers[i]);
//            columns[i] = tc;
//        }
//        return table;
//    }
//
//    protected TableViewer createTableViewer(Table table)
//    {
//        // Commented Out - Loic
//        NavigableTableViewer currentViewer = new NavigableTableViewer(table);
//
//        currentViewer.setContentProvider(this);
//        currentViewer.setLabelProvider(new TableLabelProvider(table));
//
//        //DBAFilterList filterList = createFilterList(currentViewer);
//        currentViewer.setInput(table);
//        //currentViewer.setFilterList(filterList);
//
//        CellEditor editors[] = new CellEditor[4];
//        editors[0] = new CheckboxCellEditor(table, SWT.READ_ONLY);
//        editors[1] = new ComboBoxCellEditor(table, getTargetStates(table), SWT.READ_ONLY);
//        editors[2] = new ComboBoxCellEditor(table, getPredicateStates(), SWT.READ_ONLY);
//        editors[3] = new TextCellEditor(table);
//        //editors[4] = new ComboBoxCellEditor(table, getOperatorStates());
//        currentViewer.setCellEditors(editors);
//
//        currentViewer.setCellModifier(this);
//        if (schemaTable == null)
//            currentViewer.setColumnProperties(schemaColumnProperties);
//        else
//            currentViewer.setColumnProperties(tableColumnProperties);
//
//        return currentViewer;
//        //return null;
//    }
//
//    /**
//     * Gets the filter target values for a given table.
//     * 
//     * @param table
//     *            The table.
//     * @return An array of targets.
//     */
//    protected String[] getTargetStates(Table table)
//    {
//        // Can't tell the table by this test because
//        // schemaTable is still null when initializing the !
//        if (schemaTable == null || table == schemaTable)
//        {
//            if (schemaTargetStates == null)
//            {
//                schemaTargetStates = new String[] { getString("CUI_NEWCW_FILTER_SCOPE_SCHEMA_UI_") };
//            }
//            return schemaTargetStates;
//        }
//        else if (null == tableTable || table == tableTable)
//        {
//            if (tableTargetStates == null)
//            {
//                boolean hasTable = true; //isAFilterTarget(FilterTarget.TABLE_LITERAL);
//               
//                // Loic - Commented Out	
//                boolean hasAlias = true;
//                boolean hasNickname = true;
//                boolean hasMQT = true;
//                /*                boolean hasView = isAFilterTarget(FilterTarget.VIEW_LITERAL);
//                boolean hasAlias = isAFilterTarget(FilterTarget.ALIAS_LITERAL);
//                boolean hasNickname = isAFilterTarget(FilterTarget.NICKNAME_LITERAL);
//                boolean hasMQT = isAFilterTarget(FilterTarget.MATERIALIZED_QUERY_TABLE_LITERAL);
//*/                ArrayList states = new ArrayList();
//                // SHOW_COMBINED_FILTERS
//                boolean hasView= true;
//				if ((contentOptions & NewConnectionWizard.SHOW_COMBINED_FILTERS) == NewConnectionWizard.SHOW_COMBINED_FILTERS)
//                {
//                    //if (hasTable)
//                    states.add(getString("CUI_NEWCW_FILTER_SCOPE_TABLE_UI_"));
//                    if (hasTable && hasView && (hasAlias || hasNickname || hasMQT))
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_ALLDATA_UI_"));
//                    if (hasView)
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_VIEW_UI_"));
//                    if (hasAlias)
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_ALIAS_UI_"));
//                    if (hasNickname)
//                    {
//                        // For DB2
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_NICKNAME_UI_"));
//                        //else
//                        // states.add(getString("CUI_NEWCW_FILTER_SCOPE_SYNONYM_UI_"));
//                        // // same as ALIAS if not DB2?
//                    }
//                    if (hasMQT)
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_MQT_UI_"));
//                    if (hasTable && hasView)
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_TABLEVIEW_UI_"));
//                    if (hasView && hasAlias && hasNickname)
//                    {
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_VIEWALIASNICK_UI_"));
//                        //states.add(getString("CUI_NEWCW_FILTER_SCOPE_VIEWALIASSYN_UI_"));
//                    }
//                }
//                else
//                {
//                    if (hasTable)
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_TABLE_UI_"));
//                    if (hasView)
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_VIEW_UI_"));
//                    if (hasAlias)
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_ALIAS_UI_"));
//                    if (hasNickname)
//                    {
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_NICKNAME_UI_"));
//                        //states.add(getString("CUI_NEWCW_FILTER_SCOPE_SYNONYM_UI_"));
//                        // // same as ALIAS if not DB2?
//                    }
//                    if (hasMQT)
//                        states.add(getString("CUI_NEWCW_FILTER_SCOPE_MQT_UI_"));
//                }
//                int size = states.size();
//                tableTargetStates = new String[size];
//                Iterator i = states.iterator();
//                int s = 0;
//                while (i.hasNext())
//                    tableTargetStates[s++] = (String) i.next();
//            }
//            return tableTargetStates;
//        }
//        else
//        {
//            if (routineTargetStates == null)
//            {
//                boolean hasSP = true;//isAFilterTarget(FilterTarget.STORED_PROCEDURE_LITERAL);
//                boolean hasUDF = true;//isAFilterTarget(FilterTarget.USER_DEFINED_FUNCTION_LITERAL);
//                ArrayList states = new ArrayList();
//                if (hasSP)
//                    states.add(getString("CUI_NEWCW_FILTER_SCOPE_SP_UI_"));
//                if (hasUDF)
//                    states.add(getString("CUI_NEWCW_FILTER_SCOPE_UDF_UI_"));
//                if ((contentOptions & NewConnectionWizard.SHOW_COMBINED_FILTERS) == NewConnectionWizard.SHOW_COMBINED_FILTERS
//                        && hasSP && hasUDF)
//                {
//                    states.add(getString("CUI_NEWCW_FILTER_SCOPE_SPUDF_UI_"));
//                }
//                //routineTargetStates = (String[])states.toArray();
//                int size = states.size();
//                routineTargetStates = new String[size];
//                Iterator i = states.iterator();
//                int s = 0;
//                while (i.hasNext())
//                    routineTargetStates[s++] = (String) i.next();
//
//            }
//            return routineTargetStates;
//        }
//    }
//
//    /**
//     * Gets the filter predicate values.
//     * 
//     * @return An array of predicates.
//     */
//    protected String[] getPredicateStates()
//    {
//        if (predicateStates == null)
//        {
//            predicateStates = new String[] { getString("CUI_NEWCW_ADDFILTER_PREDICATE_LIKE_UI_"),
//                    getString("CUI_NEWCW_ADDFILTER_PREDICATE_NOTLIKE_UI_") };
//        }
//        return predicateStates;
//    }
//
//    /**
//     * Gets the filter operator values.
//     * 
//     * @return An array of operators. protected String[] getOperatorStates() {
//     *         if (operatorStates == null) { operatorStates = new String[] {
//     *         getString("CUI_DBAFILTERGROUP_OPERATOR_AND_UI_"),
//     *         getString("CUI_DBAFILTERGROUP_OPERATOR_OR_UI_") }; } return
//     *         operatorStates; }
//     */
//
//    /**
//     * Adds workbench help to various components.
//     */
//    protected void addWorkbenchHelp(Composite parent)
//    {
//        WorkbenchHelp.setHelp(schemaAndRadio,
//                RSCCommonUIContextIds.RSC_NEWCW_FILTER_SCHEMA_AND_RADIO);
//        WorkbenchHelp
//                .setHelp(schemaOrRadio, RSCCommonUIContextIds.RSC_NEWCW_FILTER_SCHEMA_OR_RADIO);
//        WorkbenchHelp.setHelp(objectAndRadio,
//                RSCCommonUIContextIds.RSC_NEWCW_FILTER_OBJECT_AND_RADIO);
//        WorkbenchHelp
//                .setHelp(objectOrRadio, RSCCommonUIContextIds.RSC_NEWCW_FILTER_OBJECT_OR_RADIO);
//        //
//        WorkbenchHelp.setHelp(schemaTable, RSCCommonUIContextIds.RSC_NEWCW_FILTER_SCHEMA_TABLE);
//        WorkbenchHelp.setHelp(tableTable, RSCCommonUIContextIds.RSC_NEWCW_FILTER_TABLE_TABLE);
//        WorkbenchHelp.setHelp(routineTable, RSCCommonUIContextIds.RSC_NEWCW_FILTER_ROUTINE_TABLE);
//        //WorkbenchHelp.setHelp(descDisplay,
//        //      RSCCommonUIContextIds.RSC_FILTER_PROPERTIES_QUERYTXT);
//
//        WorkbenchHelp.setHelp(schemaAddButton, RSCCommonUIContextIds.RSC_NEWCW_FILTER_SCHEMA_ADD);
//        WorkbenchHelp.setHelp(schemaEditButton, RSCCommonUIContextIds.RSC_NEWCW_FILTER_SCHEMA_EDIT);
//        WorkbenchHelp.setHelp(schemaRemoveButton,
//                RSCCommonUIContextIds.RSC_NEWCW_FILTER_SCHEMA_REMOVE);
//
//        WorkbenchHelp.setHelp(objectAddButton, RSCCommonUIContextIds.RSC_NEWCW_FILTER_OBJECT_ADD);
//        WorkbenchHelp.setHelp(objectEditButton, RSCCommonUIContextIds.RSC_NEWCW_FILTER_OBJECT_EDIT);
//        WorkbenchHelp.setHelp(objectRemoveButton,
//                RSCCommonUIContextIds.RSC_NEWCW_FILTER_OBJECT_REMOVE);
//    }
//
//    /**
//     * Adds this as listener to various components.
//     */
//    protected void addListeners()
//    {
//        schemaAndRadio.addListener(SWT.Selection, this);
//        //schemaOrRadio.addListener(SWT.Selection, this);
//        schemaAddButton.addListener(SWT.Selection, this);
//        schemaEditButton.addListener(SWT.Selection, this);
//        schemaRemoveButton.addListener(SWT.Selection, this);
//        objectAndRadio.addListener(SWT.Selection, this);
//        //objectOrRadio.addListener(SWT.Selection, this);
//        objectAddButton.addListener(SWT.Selection, this);
//        objectEditButton.addListener(SWT.Selection, this);
//        objectRemoveButton.addListener(SWT.Selection, this);
//        schemaTable.addListener(SWT.Selection, this);
//        tableTable.addListener(SWT.Selection, this);
//        routineTable.addListener(SWT.Selection, this);
//        objectWorkbook.getTabFolder().addListener(SWT.Selection, this);
//        //schemaTable.addKeyListener((KeyListener)this);
//        //tableTable.addKeyListener((KeyListener)this);
//        //routineTable.addKeyListener((KeyListener)this);
//    }
//
//    /**
//     * Sent when a key is pressed on the system keyboard.
//     * 
//     * @param e
//     *            an event containing information about the key press public
//     *            void keyPressed(KeyEvent e) {
//     *            System.out.println("NewCWFilterPage.keyPressed: " + e); }
//     */
//
//    /**
//     * Sent when a key is released on the system keyboard.
//     * 
//     * @param e
//     *            an event containing information about the key release public
//     *            void keyReleased(KeyEvent e) { }
//     */
//
////    /**
////     * Sets default summary key-value pairs.
////     */
////    protected void setSummaryDetails()
////    {
////        NewConnectionWizard wiz = (NewConnectionWizard) getWizard();
////        summarizeSchemaFilters(wiz);
////        summarizeTableFilters(wiz);
////        summarizeRoutineFilters(wiz);
////        summarizeLanguages(wiz);
////    }
//
////    /**
////     * Summarizes the schema filter settings.
////     */
////    protected void summarizeSchemaFilters(NewConnectionWizard wiz)
////    {
////        String andor = getSchemaOperator();
////        StringBuffer sum = new StringBuffer();
////        TableItem[] items = schemaTable.getItems();
////        Object[] data;
////        for (int i = 0; i < items.length; i++)
////        {
////            data = (Object[]) items[i].getData();
////            if (((Boolean) data[0]).booleanValue())
////            {
////                if (sum.length() > 0)
////                    sum.append(andor);
////                sum.append(items[i].getText(1)).append(' ').append(items[i].getText(2)).append(' ')
////                        .append(items[i].getText(3));
////            }
////        }
////        wiz.setSetting(getString("CUI_NEWCW_SUMMARY_SET_SCHEMA_FILTERS_UI_"), sum.toString());
////    }
////
////    /**
////     * Summarizes the table filter settings.
////     */
////    protected void summarizeTableFilters(NewConnectionWizard wiz)
////    {
////        String andor = getObjectOperator(true);
////        StringBuffer sum = new StringBuffer();
////        TableItem[] items = tableTable.getItems();
////        Object[] data;
////        for (int i = 0; i < items.length; i++)
////        {
////            data = (Object[]) items[i].getData();
////            if (((Boolean) data[0]).booleanValue())
////            {
////                if (sum.length() > 0)
////                    sum.append(andor);
////                sum.append(items[i].getText(1)).append(' ').append(items[i].getText(2)).append(' ')
////                        .append(items[i].getText(3));
////            }
////        }
////        wiz.setSetting(getString("CUI_NEWCW_SUMMARY_SET_TABLE_FILTERS_UI_"), sum.toString());
////    }
////
////    /**
////     * Summarizes the routine filter settings.
////     */
////    protected void summarizeRoutineFilters(NewConnectionWizard wiz)
////    {
////        if (objectWorkbook.getTabFolder().getEnabled())
////        {
////            String andor = getObjectOperator(false);
////            StringBuffer sum = new StringBuffer();
////            TableItem[] items = routineTable.getItems();
////            Object[] data;
////            String routine = getString("CUI_NEWCW_FILTER_SCOPE_SPUDF_UI_");
////            for (int i = 0; i < items.length; i++)
////            {
////                data = (Object[]) items[i].getData();
////                if (((Boolean) data[0]).booleanValue() && !(data[1] instanceof String))
////                {
////                    if (sum.length() > 0)
////                        sum.append(andor);
////                    sum.append(items[i].getText(1)).append(' ').append(items[i].getText(2)).append(
////                            ' ').append(items[i].getText(3));
////                }
////            }
////            wiz.setSetting(getString("CUI_NEWCW_SUMMARY_SET_ROUTINE_FILTERS_UI_"), sum.toString());
////        }
////    }
////
////    /**
////     * Summarizes the language settings.
////     */
////    protected void summarizeLanguages(NewConnectionWizard wiz)
////    {
////        if (objectWorkbook.getTabFolder().getEnabled())
////        {
////            //String andor = getObjectOperator();
////            StringBuffer sum = new StringBuffer();
////            TableItem[] items = routineTable.getItems();
////            Object[] data;
////            String routine = getString("CUI_NEWCW_FILTER_SCOPE_SPUDF_UI_");
////            for (int i = 0; i < items.length; i++)
////            {
////                data = (Object[]) items[i].getData();
////                if (((Boolean) data[0]).booleanValue() && (data[1] instanceof String))
////                //&& items[i].getText().equals(routine))
////                {
////                    if (sum.length() > 0)
////                        sum.append(", ");
////                    sum.append((String) data[3]);
////                }
////            }
////            wiz
////                    .setSetting(getString("CUI_NEWCW_SUMMARY_SET_ROUTINE_LANGUAGES_UI_"), sum
////                            .toString());
////        }
////    }
//
//    protected void setPageDefaults()
//    {
//        // Loic - Commented out
///*        NewConnectionWizard wiz = (NewConnectionWizard) getWizard();
//        ConnectionInfo passedConnection = wiz.getExistingConnection();
//        if (passedConnection != null)
//        {
//            // set filter
//            if (passedConnection.hasFilter())
//            {
//                rdbConFilter = passedConnection.getFilter();
//                //newlyCreatedFilter = false;
//            }
//            //
//            internalLoadWidgetValues();
//            //fillFromConnection(passedConnection);
//        }
//        else
//        // new connection defaults
//        {
//            // construct default filter
//            rdbConFilter = RSCCoreUIPlugin.getRSCCoreUIPlugin().getRDBSchemaFactory()
//                    .createRDBConnectionFilter();
//            // loading of the system filter elements is done in
//            // updateModeledSystemFilters(SQLVendor)
//            // Initialize the SP/UDF language options:
//            rdbConFilter.enableCLanguage();
//            rdbConFilter.enableJavaLanguage();
//            rdbConFilter.enableOtherLanguage();
//            rdbConFilter.enableSQLLanguage();
//
//            internalLoadWidgetValues();
//            //SQLVendor theVendor =
//            // ((NewConnectionWizard)getWizard()).getVendor();
//            //updateModeledSystemFilters(theVendor);
//            //if (theVendor == null)
//            //   repopulateFilterTables();
//            // else updateModeledSystemFilters calls repopulateFilterTables
//        }
//*/    }
//
//    protected void repopulateFilterTables()
//    {
//        // Loic - Commented out
///*        if (rdbConFilter == null || schemaTable == null)
//            return;
//        NewConnectionWizard wiz = (NewConnectionWizard) getWizard();
//        schemaTable.removeAll();
//        tableTable.removeAll();
//        routineTable.removeAll();
//        // Populate the tables with filters
//        EList filterElements = rdbConFilter.getFilterElement();
//        //System.out.println("NewCWFilterPage rdbConFilter isSchemaFilter: " +
//        // rdbConFilter.isSchemaFilter());
//        //int count = filterElements.size();
//        Iterator i = filterElements.iterator();
//        FilterElement fe;
//        while (i.hasNext())
//        {
//            fe = (FilterElement) i.next();
//            //System.out.println("NewCWFilterPage fe: " + fe);
//            addFilter(getTable(fe), fe.isEnabled(), getTarget(fe), getPredicate(fe), fe.getText(),
//            //getOperator(fe),
//                    0);
//        }
//        languageFlags = null; // Causes the language selections to be obtained
//                              // from the filter.
//        updateRoutineLanguages(wiz.getVendor());
//*/    }
//
//    /**
//     * Picks the table to display a given filter element, by its target.
//     * 
//     * @param fe
//     *            A filter element to place in a table.
//     * @return The Table to display the filter element in.
//     */
//    protected Table getTable()
//    {
//        return null;
//        // Loic Commented out
///*        Table table = null;
//        FilterTarget target = fe.getTarget();
//        if (target == FilterTarget.SCHEMA_LITERAL)
//            table = schemaTable;
//        else if (target == FilterTarget.STORED_PROCEDURE_LITERAL
//                || target == FilterTarget.USER_DEFINED_FUNCTION_LITERAL)
//            table = routineTable;
//        else
//            table = tableTable;
//        return table;
//*/    }
//
//    /**
//     * Picks the FilterType for a given table and target index.
//     * 
//     * @param table
//     *            The table to determine the range of targets.
//     * @param index
//     *            The target index from the table data.
//     * @return The corresponding FilterType that can be used to populate a
//     *         FilterElement.
//     */
//    // Loic commented out
///*    protected FilterTarget getTarget(Table table, Integer index)
//    {
//        if (table == schemaTable)
//        {
//            return FilterTarget.SCHEMA_LITERAL;
//        }
//        else if (table == tableTable)
//        {
//            switch (index.intValue())
//            {
//                case 1:
//                    return FilterTarget.VIEW_LITERAL;
//                case 2:
//                    return FilterTarget.ALIAS_LITERAL;
//                case 3:
//                    return FilterTarget.NICKNAME_LITERAL;
//                case 4:
//                    return FilterTarget.MATERIALIZED_QUERY_TABLE_LITERAL;
//                default:
//                    return FilterTarget.TABLE_LITERAL;
//            }
//        }
//        else
//        // routineTable
//        {
//            switch (index.intValue())
//            {
//                case 1:
//                    return FilterTarget.USER_DEFINED_FUNCTION_LITERAL;
//                default:
//                    return FilterTarget.STORED_PROCEDURE_LITERAL;
//            }
//        }
//    }
//*/
//    /**
//     * Picks the FilterTypes for a given table and target index.
//     * 
//     * @param table
//     *            The table to determine the range of targets.
//     * @param index
//     *            The target index from the table data.
//     * @return A list of the corresponding FilterTypes that can be used to
//     *         populate a FilterElement.
//     */
//    // Loic Commented out
///*    protected ArrayList getTargets(Table table, Integer index)
//    {
//        ArrayList list = new ArrayList();
//        if (table == schemaTable)
//        {
//            list.add(FilterTarget.SCHEMA_LITERAL);
//        }
//        else if (table == tableTable)
//        {
//            switch (index.intValue())
//            {
//                case 1:
//                    list.add(FilterTarget.VIEW_LITERAL);
//                    break;
//                case 2:
//                    list.add(FilterTarget.ALIAS_LITERAL);
//                    break;
//                case 3:
//                    list.add(FilterTarget.NICKNAME_LITERAL);
//                    break;
//                case 4:
//                    list.add(FilterTarget.MATERIALIZED_QUERY_TABLE_LITERAL);
//                    break;
//                default:
//                    list.add(FilterTarget.TABLE_LITERAL);
//            }
//        }
//        else
//        // routineTable
//        {
//            switch (index.intValue())
//            {
//                case 1:
//                    list.add(FilterTarget.USER_DEFINED_FUNCTION_LITERAL);
//                    break;
//                default:
//                    list.add(FilterTarget.STORED_PROCEDURE_LITERAL);
//            }
//        }
//        return list;
//    }
//*/
//    /**
//     * Picks the target string for a given filter element, by its target.
//     * 
//     * @param fe
//     *            A filter element to place in a table.
//     * @return The target string to put in the table.
//     */
///*    protected String getTarget(FilterElement fe)
//    {
//        String target = null;
//        FilterTarget ft = fe.getTarget();
//        if (ft == FilterTarget.SCHEMA_LITERAL)
//            target = getString("CUI_NEWCW_FILTER_SCOPE_SCHEMA_UI_");
//        else if (ft == FilterTarget.STORED_PROCEDURE_LITERAL)
//            target = getString("CUI_NEWCW_FILTER_SCOPE_SP_UI_");
//        else if (ft == FilterTarget.USER_DEFINED_FUNCTION_LITERAL)
//            target = getString("CUI_NEWCW_FILTER_SCOPE_UDF_UI_");
//        else if (ft == FilterTarget.VIEW_LITERAL)
//            target = getString("CUI_NEWCW_FILTER_SCOPE_VIEW_UI_");
//        else if (ft == FilterTarget.ALIAS_LITERAL)
//            target = getString("CUI_NEWCW_FILTER_SCOPE_ALIAS_UI_");
//        else if (ft == FilterTarget.NICKNAME_LITERAL)
//            target = getString("CUI_NEWCW_FILTER_SCOPE_NICKNAME_UI_");
//        else if (ft == FilterTarget.MATERIALIZED_QUERY_TABLE_LITERAL)
//            target = getString("CUI_NEWCW_FILTER_SCOPE_MQT_UI_");
//        else
//            // FilterTarget.TABLE
//            target = getString("CUI_NEWCW_FILTER_SCOPE_TABLE_UI_");
//        return target;
//    }
//*/
//    /**
//     * TODO: Extend this to support new FilterTypes. Picks the FilterType for a
//     * given predicate index.
//     * 
//     * @param index
//     *            The predicate index from the table data.
//     * @return The corresponding FilterType that can be used to populate a
//     *         FilterElement.
//     */
///*    protected FilterType getPredicate(Integer index)
//    {
//        switch (index.intValue())
//        {
//            case 0:
//                return FilterType.LIKE_LITERAL;
//            default:
//                return FilterType.NOT_LIKE_LITERAL;
//        }
//    }
//*/
//    /**
//     * Picks the predicate string for a given filter element.
//     * 
//     * @param fe
//     *            A filter element to place in a table.
//     * @return The predicate string to put in the table.
//     */
///*    protected String getPredicate(FilterElement fe)
//    {
//        String pred = null;
//        FilterType type = fe.getPredicate();
//        if (type == FilterType.LIKE_LITERAL)
//            pred = getString("CUI_NEWCW_ADDFILTER_PREDICATE_LIKE_UI_");
//        else
//            pred = getString("CUI_NEWCW_ADDFILTER_PREDICATE_NOTLIKE_UI_");
//        return pred;
//    }
//*/
//    /**
//     * Picks the FilterOperator for the schema filter elements.
//     * 
//     * @return The corresponding FilterOperator that can be used to populate a
//     *         FilterElement.
//     */
///*    protected FilterOperator getSchemaFilterOperator()
//    {
//        if (schemaAndRadio.getSelection())
//            return FilterOperator.AND_LITERAL;
//        else
//            return FilterOperator.OR_LITERAL;
//    }
//*/
//    /**
//     * Picks the FilterOperator for the object filter elements.
//     * 
//     * @param True
//     *            if we want the operator for the table filter elements.
//     * @return The corresponding FilterOperator that can be used to populate a
//     *         FilterElement.
//     */
///*    protected FilterOperator getObjectFilterOperator(boolean tables)
//    {
//        if ((tables && tableAnd) || (!tables && routineAnd))
//            return FilterOperator.AND_LITERAL;
//        else
//            return FilterOperator.OR_LITERAL;
//    }
//*/
//    /**
//     * Picks the operator string for a given filter element.
//     * 
//     * @param fe
//     *            A filter element to place in a table.
//     * @return The operator string to put in the table. protected String
//     *         getOperator(FilterElement fe) { String andor = null;
//     *         FilterOperator op = fe.getOperator(); if (op ==
//     *         FilterOperator.AND_LITERAL) andor =
//     *         getString("CUI_DBAFILTERGROUP_OPERATOR_AND_UI_"); else andor =
//     *         getString("CUI_DBAFILTERGROUP_OPERATOR_OR_UI_"); return andor; }
//     */
//    /**
//     * Picks the operator string for the object tables.
//     * 
//     * @param True
//     *            if we want the operator for the table filter elements.
//     * @return The operator string to put in the summary.
//     */
//    protected String getObjectOperator(boolean tables)
//    {
//        StringBuffer andor = new StringBuffer(10);
//        andor.append(' ');
//        if ((tables && tableAnd) || (!tables && routineAnd))
//            andor.append(getString("CUI_NEWCW_SUMMARY_VAL_AND_UI_"));
//        else
//            andor.append(getString("CUI_NEWCW_SUMMARY_VAL_OR_UI_"));
//        andor.append(' ');
//        return andor.toString();
//    }
//
//    /**
//     * Picks the operator string for the schema table.
//     * 
//     * @return The operator string to put in the summary.
//     */
//    protected String getSchemaOperator()
//    {
//        StringBuffer andor = new StringBuffer(10);
//        andor.append(' ');
//        if (schemaAndRadio.getSelection())
//            andor.append(getString("CUI_NEWCW_SUMMARY_VAL_AND_UI_"));
//        else
//            andor.append(getString("CUI_NEWCW_SUMMARY_VAL_OR_UI_"));
//        andor.append(' ');
//        return andor.toString();
//    }
//
//    /**
//     * Updates when the SQLVendor is selected.
//     * 
//     * @param vendor
//     *            A SQLVendor.
//     */
//    public void updateFromVendor(DatabaseDefinition vendor)
//    {
//        cancelTableEditing();
//        // Loic - Commented Out
//        //if (rdbConFilter == null)
//        //    setPageDefaults();
//        //updateModeledSystemFilters(vendor);
//       // updateFilterTargets(vendor);
//        //updateRoutineLanguages(vendor);
//    }
//
//    /**
//     * Cancels editing of all our tables.
//     */
//    protected void cancelTableEditing()
//    {
//        if (schemaTable != null)
//        {
//            TableViewer viewer = (TableViewer) schemaTable.getData();
//            viewer.cancelEditing();
//            viewer = (TableViewer) tableTable.getData();
//            viewer.cancelEditing();
//            viewer = (TableViewer) routineTable.getData();
//            viewer.cancelEditing();
//        }
//    }
//
//    /**
//     * Updates the filter from the tables.
//     */
//    protected void updateFromTables()
//    {
//        // Loic - Commented Out
///*        if (rdbConFilter != null)
//        {
//            EList connectionFilters = rdbConFilter.getFilterElement();
//            if (connectionFilters != null)
//            {
//                connectionFilters.clear();
//                RDBSchemaFactory factory = RSCCoreUIPlugin.getRSCCoreUIPlugin()
//                        .getRDBSchemaFactory();
//                FilterElement fe;
//                Object[] data;
//                int i;
//                TableItem[] items;
//                // Schema filters
//                items = schemaTable.getItems();
//                ArrayList targets;
//                for (i = 0; i < items.length; i++)
//                {
//                    data = (Object[]) items[i].getData();
//                    fe = factory.createFilterElement();
//                    fe.setEnabled(((Boolean) data[0]).booleanValue());
//
//                    fe.setTarget(getTarget(schemaTable, (Integer) data[1]));
//
//                    //               targets = getTargets(schemaTable, (Integer)data[1]);
//
//                    fe.setPredicate(getPredicate((Integer) data[2]));
//                    fe.setText((String) data[3]);
//                    fe.setOperator(getSchemaFilterOperator());
//                    connectionFilters.add(fe);
//                }
//                // Table filters
//                items = tableTable.getItems();
//                for (i = 0; i < items.length; i++)
//                {
//                    data = (Object[]) items[i].getData();
//                    fe = factory.createFilterElement();
//                    fe.setEnabled(((Boolean) data[0]).booleanValue());
//                    fe.setTarget(getTarget(tableTable, (Integer) data[1]));
//                    fe.setPredicate(getPredicate((Integer) data[2]));
//                    fe.setText((String) data[3]);
//                    fe.setOperator(getObjectFilterOperator(true));
//                    connectionFilters.add(fe);
//                }
//                // Routine filters
//                items = routineTable.getItems();
//                for (i = 0; i < items.length; i++)
//                {
//                    data = (Object[]) items[i].getData();
//                    if (data[1] instanceof String) // Language
//                    {
//                        if ("SQL".equals((String) data[3]))
//                        {
//                            if (((Boolean) data[0]).booleanValue())
//                                rdbConFilter.enableSQLLanguage();
//                            else
//                                rdbConFilter.disableSQLLanguage();
//                        }
//                        else if ("Java".equals((String) data[3]))
//                        {
//                            if (((Boolean) data[0]).booleanValue())
//                                rdbConFilter.enableJavaLanguage();
//                            else
//                                rdbConFilter.disableJavaLanguage();
//                        }
//                        else if ("C".equals((String) data[3]))
//                        {
//                            if (((Boolean) data[0]).booleanValue())
//                                rdbConFilter.enableCLanguage();
//                            else
//                                rdbConFilter.disableCLanguage();
//                        }
//                        else
//                        // getString("CUI_NEWCW_FILTER_LANGUAGE_OTHER_UI_")
//                        {
//                            if (((Boolean) data[0]).booleanValue())
//                                rdbConFilter.enableOtherLanguage();
//                            else
//                                rdbConFilter.disableOtherLanguage();
//                        }
//                    }
//                    else
//                    {
//                        fe = factory.createFilterElement();
//                        fe.setEnabled(((Boolean) data[0]).booleanValue());
//                        fe.setTarget(getTarget(routineTable, (Integer) data[1]));
//                        fe.setPredicate(getPredicate((Integer) data[2]));
//                        fe.setText((String) data[3]);
//                        fe.setOperator(getObjectFilterOperator(false));
//                        connectionFilters.add(fe);
//                    }
//                }
//            }
//        }
//*/    }
//
//    /**
//     * Updates the filters when the DBMS changes.
//     * 
//     * @param vendor
//     *            A SQLVendor.
//     */
///*    protected void updateModeledSystemFilters(SQLVendor theVendor)
//    {
//        NewConnectionWizard wiz = (NewConnectionWizard) getWizard();
//        if (theVendor != null && rdbConFilter != null && !wiz.isEditing())
//        {
//            EList connectionFilters = rdbConFilter.getFilterElement();
//            if (connectionFilters != null)
//            {
//                connectionFilters.clear();
//                if (theVendor.getSystemFilter() != null)
//                {
//                    EList systemConnectionFilters = theVendor.getSystemFilter().getFilterElement();
//                    //System.out.println("NewCWFilterPage modeled system
//                    // filters size: " + systemConnectionFilters.size());
//                    Iterator i = systemConnectionFilters.iterator();
//                    while (i.hasNext())
//                    {
//                        FilterElement fe = (FilterElement) i.next();
//                        //System.out.println("NewCWFilterPage modeled system
//                        // filter: " + fe.getText());
//                        FilterElement feCopy = copyFilterElement(fe);
//                        connectionFilters.add(feCopy);
//                    }
//                }
//                // update the tables:
//                repopulateFilterTables();
//            }
//        }
//    }
//*/
//    /**
//     * Adjusts the language filters for the routines, since not all vendors
//     * support all languages. Routines are shown now only for DB2 and DB2
//     * Cloudscape.
//     */
//    protected void updateRoutineLanguages()
//    {
//
//        /*if (routineTable == null || rdbConFilter == null || vendor == null)
//            return;
//        String scope = getString("CUI_NEWCW_FILTER_SCOPE_SPUDF_UI_");
//        String lpred = getString("CUI_NEWCW_ADDFILTER_PREDICATE_LANGUAGE_UI_");
//        String other = getString("CUI_NEWCW_FILTER_LANGUAGE_OTHER_UI_");
//        // Remove any existing ones, but keep track of which are selected
//        if (languageFlags == null)
//        {
//            languageFlags = new boolean[4];
//            languageFlags[0] = rdbConFilter.isSQLLanguageEnabled();
//            languageFlags[1] = rdbConFilter.isJavaLanguageEnabled();
//            languageFlags[2] = rdbConFilter.isCLanguageEnabled();
//            languageFlags[3] = rdbConFilter.isOtherLanguageEnabled();
//        }
//        TableItem[] items = routineTable.getItems();
//        Object[] data;
//        boolean checked;
//        String lang;
//        for (int i = items.length - 1; i > -1; i--)
//        {
//            data = (Object[]) items[i].getData();
//            if (data[1] instanceof String)
//            {
//                checked = ((Boolean) data[0]).booleanValue();
//                lang = (String) data[3];
//                if (lang.equals("SQL"))
//                    languageFlags[0] = checked;
//                else if (lang.equals("Java"))
//                    languageFlags[1] = checked;
//                else if (lang.equals("C"))
//                    languageFlags[2] = checked;
//                else if (lang.equals(other))
//                    languageFlags[3] = checked;
//                routineTable.remove(i);
//            }
//        }
//        boolean javaOnly = (vendor.getDomainType() == SQLVendorType.DB2CLOUDSCAPE_V82_LITERAL);
//        if (routineTable.getEnabled())
//        {
//            // SQL
//            if (!javaOnly)
//                addFilter(routineTable, languageFlags[0], scope, lpred, "SQL", 1);
//            // Java
//            addFilter(routineTable, languageFlags[1], scope, lpred, "Java", 1);
//            if (!javaOnly)
//            {
//                // C
//                addFilter(routineTable, languageFlags[2], scope, lpred, "C", 1);
//                // Other
//                addFilter(routineTable, languageFlags[3], scope, lpred, other, 1);
//            }
//        }
//*/        /*
//         * Summary of languages: StringBuffer sum = new StringBuffer(); if
//         * (rdbConFilter.isCLanguageEnabled()) sum.append("SQL"); if
//         * (rdbConFilter.isCLanguageEnabled()) { if (sum.length() > 0)
//         * sum.append(", Java"); else sum.append("Java"); } if
//         * (rdbConFilter.isCLanguageEnabled()) { if (sum.length() > 0)
//         * sum.append(", C"); else sum.append("C"); } if
//         * (rdbConFilter.isOtherLanguageEnabled()) { if (sum.length() > 0)
//         * sum.append(", ");
//         * sum.append(getString("CUI_NEWCW_FILTER_LANGUAGE_OTHER_UI_")); }
//         * wiz.setSetting(
//         * getString("CUI_NEWCW_SUMMARY_SET_ROUTINE_LANGUAGES_UI_"),
//         * sum.toString());
//         */
//    }
//
//    /**
//     * Gets the list of valid object types that can be filtered.
//     */
//    protected void updateFilterTargets(DatabaseDefinition vendor)
//    {
//        // Loic - Commented Out
///*        filterTypeSet = vendor.getFilterTypeSet();
//        tableTargetStates = null;
//        routineTargetStates = null;
//        if (routineTab != null)
//        {
//            boolean hasSP = isAFilterTarget(FilterTarget.STORED_PROCEDURE_LITERAL);
//            boolean hasUDF = isAFilterTarget(FilterTarget.USER_DEFINED_FUNCTION_LITERAL);
//            //objectWorkbook.getTabFolder().setEnabled(hasSP || hasUDF);
//            //boolean prevEnabled = routineTable.getEnabled();
//            
//             * if (!(hasSP || hasUDF)) { objectAddButton.setEnabled(false);
//             * objectEditButton.setEnabled(false);
//             * objectRemoveButton.setEnabled(false); //routineTable.removeAll(); }
//             
//            routineTable.setEnabled(hasSP || hasUDF);
//            if (//!prevEnabled &&
//            (hasSP || hasUDF))
//            {
//                objectAddButton.setEnabled(true);
//                //repopulateFilterTables();
//            }
//        }
//*/        
//        //System.out.println("NewCWFilterPage filter set: " + filterTypeSet);
//        //NewCWFilterPage filter set:
//        // [com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@4ed3deab (type:
//        // TABLE), com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@4ec39eab
//        // (type: STORED_PROCEDURE),
//        // com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@4e325eab (type:
//        // USER_DEFINED_FUNCTION),
//        // com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@4bc81eab (type:
//        // VIEW)]
//        //NewCWFilterPage filter set:
//        // [com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@51d4deb6 (type:
//        // TABLE), com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@51c49eb6
//        // (type: STORED_PROCEDURE),
//        // com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@51335eb6 (type:
//        // USER_DEFINED_FUNCTION),
//        // com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@512c1eb6 (type:
//        // VIEW), com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@51185eb6
//        // (type: MATERIALIZED_QUERY_TABLE),
//        // com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@51145eb6 (type:
//        // TABLE_SPACE),
//        // com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@510d9eb6 (type:
//        // PACKAGE), com.ibm.etools.rdbschema.impl.VendorFilterTypeImpl@51075eb6
//        // (type: GROUP)]
//    }
//
//    /**
//     * Returns true if the given FilterTarget literal is in the filter type set
//     * for the current SQLVendor.
//     */
//    //protected boolean isAFilterTarget(FilterTarget literal)
//    protected boolean isAFilterTarget()
//    {
//        return true;
//        // Commented out - Loic
///*        if (filterTypeSet != null)
//        {
//            Iterator i = filterTypeSet.iterator();
//            VendorFilterType vtype;
//            while (i.hasNext())
//            {
//                vtype = (VendorFilterType) i.next();
//                if (vtype.getType() == literal)
//                    return true;
//            }
//            return false;
//        }
//        else
//        {
//            return true;
//        }
//*/    }
//
//    /**
//     * Substitute for EtoolsCopyUtility.createCopy.
//     */
///*    protected FilterElement copyFilterElement(FilterElement fe)
//    {
//        //FilterElement feCopy =
//        // (FilterElement)EtoolsCopyUtility.createCopy(fe);
//        RDBSchemaFactory factory = RSCCoreUIPlugin.getRSCCoreUIPlugin().getRDBSchemaFactory();
//        FilterElement feCopy = factory.createFilterElement();
//        feCopy.setEnabled(true);
//        feCopy.setTarget(fe.getTarget());
//        feCopy.setPredicate(fe.getPredicate());
//        feCopy.setText(fe.getText());
//        //feCopy.setOperator(fe.getOperator());
//        //if (feCopy.getOperator() == null)
//        feCopy.setOperator(FilterOperator.AND_LITERAL);
//        return feCopy;
//    }
//
//    public RDBConnectionFilter getFilter()
//    {
//        return rdbConFilter;
//    }
//*/
//    protected boolean determinePageCompletion()
//    {
//        boolean ok = validatePage();
//        if (ok)
//            setErrorMessage(null);
//        return ok;
//    }
//
//    protected boolean validatePage()
//    {
//        return validatePage_(); //Call local page validation
//    }
//
//    protected boolean validatePage_()
//    {
//        return true;
//    }
//
//    /** Implements the Listener interface. */
//    public void handleEvent(Event e)
//    {
//        Widget source = e.widget;
//        if (source == schemaAddButton)
//        {
//            NewCWAddFilterDialog dialog = new NewCWAddFilterDialog(getShell(), this, true,
//                    NewCWAddFilterDialog.CONTEXT_SCHEMA, contentOptions);
//            int result = dialog.open();
//            if (result == Window.OK)
//            {
//                addFilter(schemaTable, true, dialog.getTargetResult(), dialog.getPredicateResult(),
//                        dialog.getFilterResult(),
//                        //getString("CUI_DBAFILTERGROUP_OPERATOR_AND_UI_"),
//                        0);
//            }
//        }
//        else if (source == schemaEditButton)
//        {
//            NewCWAddFilterDialog dialog = new NewCWAddFilterDialog(getShell(), this, false,
//                    NewCWAddFilterDialog.CONTEXT_SCHEMA, contentOptions);
//            dialog.setEnabled(getCurrentEnabled(schemaTable));
//            dialog.setTarget(getCurrentTarget(schemaTable));
//            dialog.setPredicate(getCurrentPredicate(schemaTable));
//            dialog.setFilter(getCurrentFilter(schemaTable));
//            //dialog.setOperator(getCurrentOperator(schemaTable));
//            int result = dialog.open();
//            if (result == Window.OK)
//            {
//                replaceFilter(schemaTable, dialog.getEnabledResult(), dialog.getTargetResult(),
//                        dialog.getPredicateResult(), dialog.getFilterResult()
//                //dialog.getOperatorResult()
//                );
//            }
//        }
//        else if (source == schemaRemoveButton)
//        {
//            removeFilter(schemaTable);
//            schemaRemoveButton.setEnabled(false);
//        }
//        else if (source == objectAddButton)
//        {
//            int context = NewCWAddFilterDialog.CONTEXT_TABLE;
//            Table table = tableTable;
//            String[] targets = getTargetStates(table);
//            //if (objectWorkbook.getPageBook().getChildren()[1] == routineTab)
//            if (objectWorkbook.getTabFolder().getSelectionIndex() == 1)
//            {
//                context = NewCWAddFilterDialog.CONTEXT_ROUTINE;
//                table = routineTable;
//                targets = getTargetStates(table);
//            }
//            NewCWAddFilterDialog dialog = new NewCWAddFilterDialog(getShell(), this, true, context,
//                    contentOptions, targets);
//            //dialog.setTarget(getCurrentTarget());
//            int result = dialog.open();
//            if (result == Window.OK)
//            {
//                addFilter(table, true, // enabled
//                        dialog.getTargetResult(), dialog.getPredicateResult(), dialog
//                                .getFilterResult(),
//                        //getString("CUI_DBAFILTERGROUP_OPERATOR_AND_UI_"),
//                        0);
//            }
//        }
//        else if (source == objectEditButton)
//        {
//            Table table = tableTable;
//            int context = NewCWAddFilterDialog.CONTEXT_TABLE;
//            if (objectWorkbook.getTabFolder().getSelectionIndex() == 1)
//            {
//                table = routineTable;
//                context = NewCWAddFilterDialog.CONTEXT_ROUTINE;
//            }
//            String[] targetStates = getTargetStates(table);
//            NewCWAddFilterDialog dialog = new NewCWAddFilterDialog(getShell(), this, false,
//                    context, contentOptions, targetStates);
//            dialog.setEnabled(getCurrentEnabled(table));
//            dialog.setTarget(getCurrentTarget(table));
//            dialog.setPredicate(getCurrentPredicate(table));
//            dialog.setFilter(getCurrentFilter(table));
//            //dialog.setOperator(getCurrentOperator(table));
//            int result = dialog.open();
//            if (result == Window.OK)
//            {
//                replaceFilter(table, dialog.getEnabledResult(), dialog.getTargetResult(), dialog
//                        .getPredicateResult(), dialog.getFilterResult()
//                //dialog.getOperatorResult()
//                );
//            }
//        }
//        else if (source == objectRemoveButton)
//        {
//            Table table = tableTable;
//            //if (objectWorkbook.getPageBook().getChildren()[1] == routineTab)
//            if (objectWorkbook.getTabFolder().getSelectionIndex() == 1)
//            {
//                table = routineTable;
//            }
//            removeFilter(table);
//            objectRemoveButton.setEnabled(false);
//        }
//        else if (source == schemaTable)
//        {
//            int s = schemaTable.getSelectionIndex();
//            if (s > -1)
//            {
//                schemaEditButton.setEnabled(true);
//                schemaRemoveButton.setEnabled(true);
//            }
//            else
//            {
//                schemaEditButton.setEnabled(false);
//                schemaRemoveButton.setEnabled(false);
//            }
//        }
//        else if (source == tableTable)
//        {
//            int s = tableTable.getSelectionIndex();
//            if (s > -1)
//            {
//                objectEditButton.setEnabled(true);
//                objectRemoveButton.setEnabled(true);
//            }
//            else
//            {
//                objectEditButton.setEnabled(false);
//                objectRemoveButton.setEnabled(false);
//            }
//        }
//        else if (source == routineTable)
//        {
//            int s = routineTable.getSelectionIndex();
//            // For a language clause, no remove
//            if (s > -1 && !((((Object[]) routineTable.getItem(s).getData()))[1] instanceof String))
//            {
//                objectEditButton.setEnabled(true);
//                objectRemoveButton.setEnabled(true);
//            }
//            else
//            {
//                objectEditButton.setEnabled(false);
//                objectRemoveButton.setEnabled(false);
//            }
//        }
//        else if (source == objectAndRadio)
//        {
//            if (objectWorkbook.getTabFolder().getSelectionIndex() == 1)
//            {
//                // Table filters selected
//                tableAnd = objectAndRadio.getSelection();
//            }
//            else
//            {
//                // Routine filters selected
//                routineAnd = objectAndRadio.getSelection();
//            }
//        }
//        else if (source == objectWorkbook.getTabFolder())
//        {
//            Table table = tableTable;
//            if (objectWorkbook.getTabFolder().getSelectionIndex() == 1)
//            {
//                table = routineTable;
//                objectAddButton.setEnabled(routineTable.getEnabled());
//                objectOrRadio.setSelection(!tableAnd);
//                objectAndRadio.setSelection(tableAnd);
//            }
//            else
//            {
//                objectOrRadio.setSelection(!routineAnd);
//                objectAndRadio.setSelection(routineAnd);
//            }
//            int s = table.getSelectionIndex();
//            if (s > -1)
//                objectRemoveButton.setEnabled(true);
//            else
//                objectRemoveButton.setEnabled(false);
//        }
//        setPageComplete(determinePageCompletion());
//    }
//
//    /**
//     * Gets the value of the enabled column for the selected row of the given
//     * table.
//     * 
//     * @param table
//     *            The table.
//     * @return True if the filter is enabled.
//     */
//    protected boolean getCurrentEnabled(Table table)
//    {
//        int i = table.getSelectionIndex();
//        if (i > -1)
//        {
//            TableItem item = table.getItem(i);
//            Object[] data = (Object[]) item.getData();
//            return ((Boolean) data[0]).booleanValue();
//        }
//        return true;
//    }
//
//    /**
//     * Gets the value of the target column for the selected row of the given
//     * table.
//     * 
//     * @param table
//     *            The table.
//     * @return The selected target.
//     */
//    protected String getCurrentTarget(Table table)
//    {
//        int i = table.getSelectionIndex();
//        if (i > -1)
//        {
//            TableItem item = table.getItem(i);
//            Object[] data = (Object[]) item.getData();
//            int v = ((Integer) data[1]).intValue();
//            String[] states = getTargetStates(table);
//            return states[v];
//        }
//        return null;
//    }
//
//    /**
//     * Gets the value of the predicate column for the selected row of the given
//     * table.
//     * 
//     * @param table
//     *            The table.
//     * @return The selected predicate.
//     */
//    protected String getCurrentPredicate(Table table)
//    {
//        int i = table.getSelectionIndex();
//        if (i > -1)
//        {
//            TableItem item = table.getItem(i);
//            Object[] data = (Object[]) item.getData();
//            int v = ((Integer) data[2]).intValue();
//            String[] states = getPredicateStates();
//            return states[v];
//        }
//        return null;
//    }
//
//    /**
//     * Gets the value of the filter text column for the selected row of the
//     * given table.
//     * 
//     * @param table
//     *            The table.
//     * @return The selected filter text.
//     */
//    protected String getCurrentFilter(Table table)
//    {
//        int i = table.getSelectionIndex();
//        if (i > -1)
//        {
//            TableItem item = table.getItem(i);
//            Object[] data = (Object[]) item.getData();
//            return (String) data[3];
//        }
//        return null;
//    }
//
//    /**
//     * Gets the value of the operator column for the selected row of the given
//     * table.
//     * 
//     * @param table
//     *            The table.
//     * @return The selected operator. protected String getCurrentOperator(Table
//     *         table) { int i = table.getSelectionIndex(); if (i > -1) {
//     *         TableItem item = table.getItem(i); Object[] data =
//     *         (Object[])item.getData(); int v = ((Integer)data[4]).intValue();
//     *         String[] states = getOperatorStates(); return states[v]; } return
//     *         null; }
//     */
//
//    /**
//     * Adds a filter to a given table.
//     * 
//     * @param table
//     *            The table to add the filter to.
//     * @param target
//     *            Names the scope of the filter, what object type should be
//     *            filtered.
//     * @param predicate
//     *            LIKE or NOT LIKE
//     * @param text
//     *            The right-hand side of the expression, such as "SYS%."
//     * @param andor
//     *            AND or OR.
//     * @param code
//     *            1 if language clause; 0 otherwise.
//     */
//    protected void addFilter(Table table, boolean enabled, String target, String predicate,
//            String text,
//            //String andor,
//            int code)
//    {
//        if (table == null)
//            return;
//        TableItem item;
//        item = new TableItem(table, SWT.NONE);
//        if (code == 0) // A normal FilterElement
//        {
//            item.setData(new Object[] { enabled ? Boolean.TRUE : Boolean.FALSE,
//                    getEditorIndex(table, 1, target), getEditorIndex(table, 2, predicate), text
//            //getEditorIndex(table, 4, andor)
//                    });
//        }
//        else
//        // Language clause
//        {
//            item.setData(new Object[] { enabled ? Boolean.TRUE : Boolean.FALSE, target, predicate,
//                    text
//            //andor
//                    });
//        }
//        item.setImage(0, enabled ? CHECK_IMAGE : UNCHECK_IMAGE);
//        item.setText(1, target);
//        item.setText(2, predicate);
//        item.setText(3, text);
//        //item.setText(4, andor);
//    }
//
////    /**
////     * Replaces a filter in a given table. The given filter information updates
////     * the filter currently selected.
////     * 
////     * @param table
////     *            The table to replace the filter in.
////     * @param target
////     *            Names the scope of the filter, what object type should be
////     *            filtered.
////     * @param predicate
////     *            LIKE or NOT LIKE
////     * @param text
////     *            The right-hand side of the expression, such as "SYS%."
////     * @param andor
////     *            AND or OR.
////     */
////    protected void replaceFilter(Table table, boolean enabled, String target, String predicate,
////            String text)
////    //String andor)
////    {
////        if (table == null)
////            return;
////        int i = table.getSelectionIndex();
////        if (i > -1)
////        {
////            TableItem[] item = table.getItems();
////            Object[] data = (Object[]) item[i].getData();
////            boolean previouslyEnabled = ((Boolean) data[0]).booleanValue();
////            data[0] = enabled ? Boolean.TRUE : Boolean.FALSE;
////            data[1] = getEditorIndex(table, 1, target);
////            data[2] = getEditorIndex(table, 2, predicate);
////            data[3] = text;
////            //data[4] = getEditorIndex(table, 4, andor);
////            item[i].setImage(0, enabled ? CHECK_IMAGE : UNCHECK_IMAGE);
////            item[i].setText(1, target);
////            item[i].setText(2, predicate);
////            item[i].setText(3, text);
////            //item[i].setText(4, andor);
////            // Update the summary
////            NewConnectionWizard wiz = (NewConnectionWizard) getWizard();
////            StringBuffer sum = new StringBuffer();
////            // First we get our position in the summary, assuming
////            // that only enabled elements are summarized.
////            int x = 0;
////            for (int a = 0; a <= i; a++)
////            {
////                data = (Object[]) item[a].getData();
////                if (((Boolean) data[0]).booleanValue())
////                    x++;
////            }
////            // Then we get the existing summary
////            String andor = null;
////            String key = null;
////            if (table == schemaTable)
////            {
////                andor = getSchemaOperator();
////                key = getString("CUI_NEWCW_SUMMARY_SET_SCHEMA_FILTERS_UI_");
////            }
////            else
////            {
////                if (table == tableTable)
////                {
////                    andor = getObjectOperator(true);
////                    key = getString("CUI_NEWCW_SUMMARY_SET_TABLE_FILTERS_UI_");
////                }
////                else
////                // Routine table
////                {
////                    andor = getObjectOperator(false);
////                    key = getString("CUI_NEWCW_SUMMARY_SET_ROUTINE_FILTERS_UI_");
////                }
////            }
//// //           String setting = wiz.getSetting(key);
////            // Tokenize the setting
////            StringBuffer sep = new StringBuffer(10);
////            sep.append(' ').append(getString("CUI_NEWCW_SUMMARY_VAL_AND_UI_")).append(' ');
////            setting = StringUtility.change(setting, sep.toString(), ";");
////            sep.setLength(1);
////            sep.append(getString("CUI_NEWCW_SUMMARY_VAL_OR_UI_")).append(' ');
////            setting = StringUtility.change(setting, sep.toString(), ";");
////            StringTokenizer st = new StringTokenizer(setting, ";", false);
////            // Scan to the right position:
////            int a = 0;
////            while (st.hasMoreTokens() && a < x - 1)
////            {
////                if (a > 0)
////                    sum.append(andor);
////                sum.append(st.nextToken().trim());
////                a++;
////            }
////            // If previouslyEnabled but not now, we remove the summary of the
////            // element.
////            // If not previouslyEnabled but it is now, we insert the summary of
////            // the element.
////            // Otherwise, we just update the summary of the element.
////            if (previouslyEnabled && st.hasMoreTokens())
////                st.nextToken(); // skip the old summary
////            if (enabled) // append the new summary
////            {
////                if (sum.length() > 0)
////                    sum.append(andor);
////                sum.append(target).append(' ').append(predicate).append(' ').append(text);
////            }
////            while (st.hasMoreTokens())
////            {
////                if (sum.length() > 0)
////                    sum.append(andor);
////                sum.append(st.nextToken().trim());
////            }
////  //          wiz.setSetting(key, sum.toString());
////        }
////    }
//
//    /**
//     * Gets the index for a combo box cell from its editor.
//     * 
//     * @param table
//     *            The table.
//     * @param col
//     *            The index of the column.
//     * @param value
//     *            A String value to be found in the states of the editor for the
//     *            given column.
//     * @return An Integer containing the index of the states.
//     */
//    protected Integer getEditorIndex(Table table, int col, String value)
//    {
//        String[] items = null;
//        if (col == 1)
//        {
//            if (table == schemaTable)
//                items = getTargetStates(schemaTable);
//            else if (table == tableTable)
//                items = getTargetStates(tableTable);
//            else
//                //if (table == routineTable)
//                items = getTargetStates(routineTable);
//        }
//        else
//        {
//            TableViewer viewer = (TableViewer) table.getData();
//            CellEditor editor = viewer.getCellEditors()[col];
//            if (editor instanceof ComboBoxCellEditor)
//            {
//                items = ((ComboBoxCellEditor) editor).getItems();
//            }
//        }
//        if (items != null)
//        {
//            for (int i = 0; i < items.length; i++)
//            {
//                if (items[i].equals(value))
//                    return new Integer(i);
//            }
//        }
//        return new Integer(0);
//    }
//
//    /**
//     * Removes a filter from a given table.
//     * 
//     * @param table
//     *            The table whose selected filter should be removed.
//     */
//    protected void removeFilter(Table table)
//    {
//        if (table == null)
//            return;
//        int selectedIndex = table.getSelectionIndex();
//        if (selectedIndex < 0)
//            return;
//        table.remove(selectedIndex);
//    }
//
//    /**
//     * Gets the column index of a filter table given its property.
//     * 
//     * @return The column index; or -1 if the property isn't known.
//     */
//    protected int getColumnIndex(String property)
//    {
//        int i;
//        for (i = 0; i < tableColumnProperties.length; i++)
//        {
//            if (tableColumnProperties[i] == property)
//                return i;
//        }
//        return -1;
//    }
//
//    /**
//     * Checks whether the given property of the given element can be modified.
//     * This is an ICellModifier method.
//     * 
//     * @param element
//     *            The table item data.
//     * @param property
//     *            A key signifying the column.
//     * @return <code>true</code> if the cell can be modified, and
//     *         <code>false</code> if it is not modifiable
//     */
//    public boolean canModify(Object element, String property)
//    {
//        if (property.equals(P_TARGET_READONLY))
//            return false; // Schema target
//        else if (!property.equals(P_ENABLE) && ((Object[]) element)[1] instanceof String)
//            return false; // Language clause
//        else
//            return true;
//    }
//
//    /**
//     * Returns the value for the given property of the given element. Returns
//     * <code>null</code> if the element does not have the given property. This
//     * is an ICellModifier method.
//     * 
//     * @param element
//     *            the element
//     * @param property
//     *            the property
//     * @return the property value
//     */
//    public Object getValue(Object element, String property)
//    {
//        int i = getColumnIndex(property);
//        if (i > -1)
//            return ((Object[]) element)[i];
//        else
//            return null;
//    }
//
//    /**
//     * Modifies the value for the given property of the given element. Has no
//     * effect if the element does not have the given property, or if the
//     * property cannot be modified. This is an ICellModifier method.
//     * <p>
//     * Note that it is possible for an SWT Item to be passed instead of the
//     * model element. To handle this case in a safe way, use:
//     * 
//     * <pre>
//     * if (element instanceof Item)
//     * {
//     *     element = ((Item) element).getData();
//     * }
//     * // modify the element's property here
//     * 
//     * </pre>
//     * 
//     * </p>
//     * 
//     * @param element
//     *            the model element or SWT Item (see above)
//     * @param property
//     *            the property
//     * @param value
//     *            the new property value
//     * 
//     * @see org.eclipse.swt.widgets.Item
//     */
//    public void modify(Object element, String property, Object value)
//    {
//        int i = getColumnIndex(property);
//        if (i > -1)
//        {
//            Table table;
//            TableItem item = (TableItem) element;
//            Object[] data = (Object[]) item.getData();
//            data[i] = value;
//            switch (i)
//            {
//                case 0:
//                    item
//                            .setImage(i, ((Boolean) value).booleanValue() ? CHECK_IMAGE
//                                    : UNCHECK_IMAGE);
//                    table = (Table) item.getParent();
//                    TableViewer viewer = (TableViewer) table.getData();
//                    viewer.refresh();
//                    // It doesn't do any good to deactivate the default checkbox
//                    // editor
//                    // because its control is null.
//                    //CellEditor editor = viewer.getCellEditors()[0];
//                    //editor.deactivate();
//                    break;
//                case 1:
//                    table = (Table) item.getParent();
//                    // schemaTable target is not supposed to be editable
//                    if (table == tableTable)
//                        item.setText(i, getTargetStates(tableTable)[((Integer) value).intValue()]);
//                    else
//                        item
//                                .setText(i, getTargetStates(routineTable)[((Integer) value)
//                                        .intValue()]);
//                    break;
//                case 2:
//                    item.setText(i, predicateStates[((Integer) value).intValue()]);
//                    break;
//                //case 4:
//                //   item.setText(i, operatorStates[((Integer)value).intValue()]);
//                //   break;
//                default:
//                    item.setText(i, value.toString());
//            }
//        }
//    }
//
//    protected void enableAll(boolean enable)
//    {
//        //connectionName.setEnabled(enable && (contentOptions &
//        // DISABLE_CON_NAME) == 0);
//        //databaseName.setEnabled(enable && (contentOptions & DISABLE_DB) ==
//        // 0);
//        //userId.setEnabled(enable && !currentCheck.getSelection());
//        //password.setEnabled(enable && !currentCheck.getSelection());
//    }
//
//    /**
//     * Sets the connection details. Used for populating new connections.
//     * 
//     * @param connection
//     *            An RDBConnection object to reflect the choices in this panel.
//     */
//    public void setConnectionDetails(ConnectionInfo connection)
//    {
//        updateFromTables();
///*        connection.setFilter(rdbConFilter);
//*/    }
//
//    /**
//     * Fills all the entry fields with information from the passed connection.
//     * Listeners are disabled.
//     */
//    protected void fillFromConnection(ConnectionInfo connection)
//    {
///*        rdbConFilter = (RDBConnectionFilter) EtoolsCopyUtility.createCopy(connection.getFilter());
//        repopulateFilterTables();
//*/    }
//
//    /**
//     * Loads widget values from values saved by the previous instance of this
//     * class.
//     */
//    protected void internalLoadWidgetValues()
//    {
//        // set default values
//
//    }
//
//    /**
//     * Saves widget values for the next instance of this class.
//     */
//    public void internalSaveWidgetValues()
//    {
//        //IDialogSettings dialogSettings = getWizard().getDialogSettings();
//        //if (dialogSettings != null)
//        //{
//        //}
//    }
//
//    /**
//     * Disposes of this content provider. This is called by the viewer when it
//     * is disposed.
//     * <p>
//     * The viewer should not updated during this call, as it is in the process
//     * of being disposed.
//     * </p>
//     * <p>
//     * Required for an IStructuredContentProvider and an ITableLabelProvider.
//     */
//    public void dispose()
//    {
//    }
//
//    /**
//     * Notifies this content provider that the given viewer's input has been
//     * switched to a different element.
//     * <p>
//     * A typical use for this method is registering the content provider as a
//     * listener to changes on the new input (using model-specific means), and
//     * deregistering the viewer from the old input. In response to these change
//     * notifications, the content provider should update the viewer (see the
//     * add, remove, update and refresh methods on the viewers).
//     * </p>
//     * <p>
//     * The viewer should not updated during this call, as it might be in the
//     * process of being disposed.
//     * </p>
//     * <p>
//     * Required for an IStructuredContentProvider.
//     * 
//     * @param viewer
//     *            the viewer
//     * @param oldInput
//     *            the old input element, or <code>null</code> if the viewer
//     *            did not previously have an input
//     * @param newInput
//     *            the new input element, or <code>null</code> if the viewer
//     *            does not have an input
//     */
//    public void inputChanged(Viewer viewer, Object oldInput, Object newInput)
//    {
//    }
//
//    /**
//     * Returns the elements to display in the viewer when its input is set to
//     * the given element. This returns an array of Object[], which is the
//     * TableItem data for each row in the table being managed. These elements
//     * can be presented as rows in a table, items in a list, etc. The result is
//     * not modified by the viewer.
//     * <p>
//     * Required for an IStructuredContentProvider.
//     * 
//     * @param inputElement
//     *            the input element
//     * @return the array of elements to display in the viewer
//     */
//    public Object[] getElements(Object inputElement)
//    {
//        // the inputElement is the table I'm dealing with...
//        Table table = (Table) inputElement;
//        TableItem[] items = table.getItems();
//        Object[] elements = new Object[items.length];
//        for (int i = 0; i < items.length; i++)
//        {
//            elements[i] = items[i].getData();
//        }
//        return elements;
//    }
//
//    protected class TableLabelProvider implements ITableLabelProvider
//    {
//        public static final String copyright = "(c) Copyright IBM Corporation 2000, 2004.";
//
//        /** Listeners for ILabelProvider. */
//        protected ListenerList labelProviderListeners = new ListenerList(1);
//
//        /** The table we are providing for. */
//        protected Table table;
//
//        public TableLabelProvider(Table table)
//        {
//            this.table = table;
//        }
//
//        /**
//         * Returns the label image for the given column of the given element.
//         * <p>
//         * Required for an ITableLabelProvider.
//         * 
//         * @param element
//         *            the object representing the entire row, or
//         *            <code>null</code> indicating that no input object is set
//         *            in the viewer
//         * @param columnIndex
//         *            the zero-based index of the column in which the label
//         *            appears
//         */
//        public Image getColumnImage(Object element, int columnIndex)
//        {
//            Image g = null;
//            if (columnIndex == 0)
//            {
//                Boolean b = (Boolean) ((Object[]) element)[columnIndex];
//                g = b.booleanValue() ? CHECK_IMAGE : UNCHECK_IMAGE;
//            }
//            return g;
//        }
//
//        /**
//         * 
//         * We cannot tell what table this comes from (unless we add a table
//         * reference to the element array--yech). So a separate LabelProvider
//         * must be constructed with a table reference.
//         * 
//         * Returns the label text for the given column of the given element.
//         * <p>
//         * Required for an ITableLabelProvider.
//         * 
//         * @param element
//         *            the object representing the entire row, or
//         *            <code>null</code> indicating that no input object is set
//         *            in the viewer
//         * @param columnIndex
//         *            the zero-based index of the column in which the label
//         *            appears
//         */
//        public String getColumnText(Object element, int columnIndex)
//        {
//            if (columnIndex > 0)
//            {
//                Object o = ((Object[]) element)[columnIndex];
//                if (o instanceof String)
//                {
//                    return (String) o;
//                }
//                else if (o instanceof Integer)
//                {
//                    int i = ((Integer) o).intValue();
//                    String[] states;
//                    if (columnIndex == 1)
//                        states = getTargetStates(table);
//                    else
//                        //if (columnIndex == 2)
//                        states = getPredicateStates();
//                    //else
//                    //   states = getOperatorStates();
//                    if (i < states.length)
//                        return states[i];
//                    /*
//                     * else {
//                     * System.out.println("NewCWFilterPage$TableLabelProvider.getColumnText
//                     * index out of range"); System.out.println("\tcolumnIndex: " +
//                     * columnIndex); System.out.println("\tstates length: " +
//                     * states.length); System.out.println("\tindex: " + i); }
//                     */
//                }
//            }
//            return "";
//        }
//
//        /**
//         * Adds a listener to this label provider. Has no effect if an identical
//         * listener is already registered.
//         * <p>
//         * Label provider listeners are informed about state changes that affect
//         * the rendering of the viewer that uses this label provider.
//         * </p>
//         * <p>
//         * Required for an ITableLabelProvider.
//         * 
//         * @param listener
//         *            a label provider listener
//         */
//        public void addListener(ILabelProviderListener listener)
//        {
//            labelProviderListeners.add(listener);
//        }
//
//        /**
//         * Disposes of this label provider. When a label provider is attached to
//         * a viewer, the viewer will automatically call this method when the
//         * viewer is being closed. When label providers are used outside of the
//         * context of a viewer, it is the client's responsibility to ensure that
//         * this method is called when the provider is no longer needed.
//         */
//        public void dispose()
//        {
//        }
//
//        /**
//         * Returns whether the label would be affected by a change to the given
//         * property of the given element. This can be used to optimize a
//         * non-structural viewer update. If the property mentioned in the update
//         * does not affect the label, then the viewer need not update the label.
//         * <p>
//         * Required for an ITableLabelProvider.
//         * 
//         * @param element
//         *            the element
//         * @param property
//         *            the property
//         * @return <code>true</code> if the label would be affected, and
//         *         <code>false</code> if it would be unaffected
//         */
//        public boolean isLabelProperty(Object element, String property)
//        {
//            return true;
//        }
//
//        /**
//         * Removes a listener to this label provider. Has no affect if an
//         * identical listener is not registered.
//         * <p>
//         * Required for an ITableLabelProvider.
//         * 
//         * @param listener
//         *            a label provider listener
//         */
//        public void removeListener(ILabelProviderListener listener)
//        {
//            labelProviderListeners.remove(listener);
//        }
//
//        /**
//         * Fires a label provider changed event to all registered listeners Only
//         * listeners registered at the time this method is called are notified.
//         * 
//         * @param event
//         *            a label provider changed event
//         * 
//         * @see ILabelProviderListener#labelProviderChanged protected void
//         *      fireLabelProviderChanged(final LabelProviderChangedEvent event) {
//         *      Object[] listeners = this.labelProviderListeners.getListeners();
//         *      for (int i = 0; i < listeners.length; ++i) { final
//         *      ILabelProviderListener l = (ILabelProviderListener)listeners[i];
//         *      Platform.run(new SafeRunnable() { public void run() {
//         *      l.labelProviderChanged(event); } public void
//         *      handleException(Throwable e) { super.handleException(e); //If
//         *      and unexpected exception happens, remove it //to make sure the
//         *      workbench keeps running. removeListener(l); } }); } }
//         */
//    }
//}
