#!/bin/sh
echo 'name: hashed-storage
version: 0.5.4
id: hashed-storage-0.5.4-69957c611730233f4806cbb3022f849b

license: BSD3
copyright: 2009 Petr Rockai <me@mornfall.net>
maintainer: Petr Rockai <me@mornfall.net>
stability:
homepage:
package-url:
description: Support code for reading and manipulating hashed file storage
             (where each file and directory is associated with a
             cryptographic hash, for corruption-resistant storage and fast
             comparisons).
             .
             The supported storage formats include darcs hashed pristine, a
             plain filesystem tree and an indexed plain tree (where the index
             maintains hashes of the plain files and directories).
category: System
author: Petr Rockai <me@mornfall.net>
pkgpath: devel/hs-hashed-storage
exposed: True
exposed-modules: Storage.Hashed Storage.Hashed.AnchoredPath
                 Storage.Hashed.Index Storage.Hashed.Monad Storage.Hashed.Tree
                 Storage.Hashed.Hash Storage.Hashed.Packed Storage.Hashed.Plain
                 Storage.Hashed.Darcs
hidden-modules: Bundled.Posix Bundled.SHA256 Storage.Hashed.Utils
import-dirs: /usr/local/lib/ghc/hashed-storage-0.5.4
library-dirs: /usr/local/lib/ghc/hashed-storage-0.5.4
hs-libraries: HShashed-storage-0.5.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         binary-0.5.0.2-3f773de18069700f41149a59414ce3dd
         bytestring-0.9.1.10-2da7b519f76934c0e733bf92c23382ec
         containers-0.4.0.0-8781485edb2ac0db733a9f9c72e27945
         dataenc-0.13.0.4-60062ed2c12da5ce3d65ff0a06d67873
         directory-1.1.0.0-9315160d2d0511510edc9d31fb968f3c
         extensible-exceptions-0.1.1.2-d8c5b906654260efd7249f497d17a831
         filepath-1.2.0.0-b273467b63dd15270d77af61bc610112
         mmap-0.5.6-72008e526742af90cfe6995cc9623b60
         mtl-2.0.1.0-91f62d81c946aa60137dcc008e554a3a
         zlib-0.5.3.1-a78f28b72a90bc6d93acffb0c82dfef3
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hashed-storage-0.5.4/html/hashed-storage.haddock
haddock-html: /usr/local/share/doc/hs-hashed-storage-0.5.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
