#!/bin/sh
echo 'name: snap-core
version: 0.2.16
id: snap-core-0.2.16-ee1c2db118dead382dac82919589b39c

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
description: This is the first developer prerelease of the Snap framework.  Snap is a
             simple and fast web development framework and server written in Haskell. For
             more information or to download the latest version, you can visit the Snap
             project website at <http://snapframework.com/>.
             .
             This library contains the core definitions and types for the Snap framework,
             including:
             .
             1. Primitive types and functions for HTTP (requests, responses, cookies,
             post/query parameters, etc)
             .
             2. Type aliases and helper functions for Iteratee I/O
             .
             3. A monad for programming web handlers called \"Snap\", inspired by
             happstack'\''s (<http://happstack.com/index.html>), which allows:
             .
             * Stateful access to the HTTP request and response objects
             .
             * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
             to handle requests and chaining handlers together
             .
             * Early termination of the computation if you know early what you want
             to return and want to prevent further monadic processing
             .
             /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Types",
             some iteratee utilities are in "Snap.Iteratee".
             .
             Higher-level facilities for building web applications (like user/session
             management, component interfaces, data modeling, etc.) are planned but not
             yet implemented, so this release will mostly be of interest for those who:
             .
             * need a fast and minimal HTTP API at roughly the same level of abstraction
             as Java servlets, or
             .
             * are interested in contributing to the Snap Framework project.
category: Web
author: James Sanders, Shu-yu Guo, Gregory Collins, Doug Beardsley
pkgpath: www/hs-snap-core
exposed: True
exposed-modules: Data.CIByteString Snap.Types Snap.Iteratee
                 Snap.Internal.Debug Snap.Internal.Http.Types
                 Snap.Internal.Iteratee.Debug Snap.Util.FileServe Snap.Util.GZip
hidden-modules: Snap.Internal.Parsing Snap.Internal.Routing
                Snap.Internal.Types
import-dirs: /usr/local/lib/ghc/snap-core-0.2.16
library-dirs: /usr/local/lib/ghc/snap-core-0.2.16
hs-libraries: HSsnap-core-0.2.16
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: ListLike-1.0.1-d20539bf018f98b954f0bc3cc134ea6a
         MonadCatchIO-transformers-0.2.2.0-46756a5c6600c69053d790039b4afb28
         attoparsec-0.8.1.0-5003cd2b2c51a438d6ecd9f637ceb9cf
         base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         bytestring-0.9.1.10-2da7b519f76934c0e733bf92c23382ec
         bytestring-nums-0.3.2-932910cf91e53a13446e910ca668a823
         bytestring-show-0.3.4-faada813d6c053fb2540a9373503e943
         cereal-0.3.0.0-ee33e7a9312912eef09d2af1b20190e8
         containers-0.4.0.0-8781485edb2ac0db733a9f9c72e27945
         deepseq-1.1.0.2-677f443f43caba0d312ab80199d4a233
         directory-1.1.0.0-9315160d2d0511510edc9d31fb968f3c
         directory-tree-0.2.0-145217ccc5bf3ca44803c4301eccb2f6
         dlist-0.5-b61cdbf07dfc72a8eed9080438e6dda5
         filepath-1.2.0.0-b273467b63dd15270d77af61bc610112
         haskell98-1.1.0.1-94f7a5cdbf7a4c3cb91e841ae24bf4c0
         iteratee-0.3.5-66510f0e2568fc33a799d6286f582f08
         monads-fd-0.1.0.1-7ee4e1f2ba5eddcd55683e3f0a70fb11
         old-locale-1.0.0.2-cc522edd16b73a70b897598c5f5d20c7
         old-time-1.0.0.6-dfdb9c34ec39bc9a2a57345b38e135d4
         template-haskell-2.5.0.0-2ccdf1e9ca6c0f55d47fb724a693009c
         text-0.11.0.6-8c4af07195c37bf4d73ffb41fc92ea29
         time-1.2.0.3-4f1bed38bdf37d398ba8f4311cbdac4a
         transformers-0.2.2.0-7341f4d82874561a0431f4b264319cf8
         unix-compat-0.2-addbf3d59c5d92d1df87f240055c1d73
         zlib-0.5.3.1-a78f28b72a90bc6d93acffb0c82dfef3
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-core-0.2.16/html/snap-core.haddock
haddock-html: /usr/local/share/doc/hs-snap-core-0.2.16/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
