/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.ArtifactId;
import fr.jayasoft.ivy.DependencyArtifactDescriptor;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.matcher.MatcherHelper;
import fr.jayasoft.ivy.namespace.NameSpaceHelper;
import fr.jayasoft.ivy.namespace.Namespace;
import fr.jayasoft.ivy.namespace.NamespaceTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDependencyDescriptor
implements DependencyDescriptor {
    private static final Pattern SELF_FALLBACK_PATTERN = Pattern.compile("@(\\(.*\\))?");
    private static final Pattern THIS_FALLBACK_PATTERN = Pattern.compile("#(\\(.*\\))?");
    private ModuleRevisionId _revId;
    private Map _confs = new HashMap();
    private Map _artifactsIncludes = new HashMap();
    private Map _artifactsExcludes = new HashMap();
    private Set _extends = new HashSet();
    private boolean _force;
    private boolean _changing;
    private ModuleRevisionId _parentId;
    private boolean _transitive = true;
    private Namespace _namespace = null;
    private ModuleDescriptor _md;
    private DependencyDescriptor _asSystem = this;

    public static DependencyDescriptor transformInstance(DependencyDescriptor dd, Namespace ns) {
        NamespaceTransformer t = ns.getToSystemTransformer();
        if (t.isIdentity()) {
            return dd;
        }
        DefaultDependencyDescriptor newdd = DefaultDependencyDescriptor.transformInstance(dd, t, false);
        newdd._namespace = ns;
        return newdd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultDependencyDescriptor transformInstance(DependencyDescriptor dd, NamespaceTransformer t, boolean fromSystem) {
        ModuleRevisionId transformParentId = t.transform(dd.getParentRevisionId());
        ModuleRevisionId transformMrid = t.transform(dd.getDependencyRevisionId());
        DefaultDependencyDescriptor newdd = new DefaultDependencyDescriptor();
        newdd._parentId = transformParentId;
        newdd._revId = transformMrid;
        newdd._force = dd.isForce();
        newdd._changing = dd.isChanging();
        newdd._transitive = dd.isTransitive();
        String[] moduleConfs = dd.getModuleConfigurations();
        if (moduleConfs.length == 1 && "*".equals(moduleConfs[0])) {
            if (!(dd instanceof DefaultDependencyDescriptor)) throw new IllegalArgumentException("dependency descriptor transformation does not support * module confs with descriptors which aren't DefaultDependencyDescriptor");
            DefaultDependencyDescriptor ddd = (DefaultDependencyDescriptor)dd;
            newdd._confs = new HashMap(ddd._confs);
            newdd._artifactsExcludes = new HashMap(ddd._artifactsExcludes);
            newdd._artifactsIncludes = new HashMap(ddd._artifactsIncludes);
        } else {
            for (int i = 0; i < moduleConfs.length; ++i) {
                newdd._confs.put(moduleConfs[i], new ArrayList<String>(Arrays.asList(dd.getDependencyConfigurations(moduleConfs[i]))));
                newdd._artifactsExcludes.put(moduleConfs[i], new ArrayList<DependencyArtifactDescriptor>(Arrays.asList(dd.getDependencyArtifactsExcludes(moduleConfs[i]))));
                newdd._artifactsIncludes.put(moduleConfs[i], new ArrayList<DependencyArtifactDescriptor>(Arrays.asList(dd.getDependencyArtifactsIncludes(moduleConfs[i]))));
            }
        }
        if (!fromSystem) return newdd;
        newdd._asSystem = dd;
        return newdd;
    }

    public DefaultDependencyDescriptor(DependencyDescriptor dd, String revision) {
        this._parentId = dd.getParentRevisionId();
        this._revId = ModuleRevisionId.newInstance(dd.getDependencyRevisionId(), revision);
        this._force = dd.isForce();
        this._changing = dd.isChanging();
        this._transitive = dd.isTransitive();
        String[] moduleConfs = dd.getModuleConfigurations();
        for (int i = 0; i < moduleConfs.length; ++i) {
            this._confs.put(moduleConfs[i], new ArrayList<String>(Arrays.asList(dd.getDependencyConfigurations(moduleConfs[i]))));
            this._artifactsExcludes.put(moduleConfs[i], new ArrayList<DependencyArtifactDescriptor>(Arrays.asList(dd.getDependencyArtifactsExcludes(moduleConfs[i]))));
            this._artifactsIncludes.put(moduleConfs[i], new ArrayList<DependencyArtifactDescriptor>(Arrays.asList(dd.getDependencyArtifactsIncludes(moduleConfs[i]))));
        }
    }

    public DefaultDependencyDescriptor(ModuleDescriptor md, ModuleRevisionId mrid, boolean force, boolean changing, boolean transitive) {
        this._md = md;
        this._revId = mrid;
        this._force = force;
        this._changing = changing;
        this._transitive = transitive;
    }

    public DefaultDependencyDescriptor(ModuleRevisionId mrid, boolean force) {
        this(mrid, force, false);
    }

    public DefaultDependencyDescriptor(ModuleRevisionId mrid, boolean force, boolean changing) {
        this._revId = mrid;
        this._force = force;
        this._changing = changing;
    }

    private DefaultDependencyDescriptor() {
    }

    public ModuleId getDependencyId() {
        return this.getDependencyRevisionId().getModuleId();
    }

    public ModuleRevisionId getDependencyRevisionId() {
        return this._revId;
    }

    public String[] getModuleConfigurations() {
        return this._confs.keySet().toArray(new String[this._confs.keySet().size()]);
    }

    public String[] getDependencyConfigurations(String moduleConfiguration) {
        return this.getDependencyConfigurations(moduleConfiguration, moduleConfiguration);
    }

    public String[] getDependencyConfigurations(String moduleConfiguration, String requestedConfiguration) {
        List confs = (List)this._confs.get(moduleConfiguration);
        if (confs == null) {
            confs = (List)this._confs.get("%");
        }
        List defConfs = (List)this._confs.get("*");
        LinkedHashSet<Object> ret = new LinkedHashSet();
        if (confs != null) {
            ret.addAll(confs);
        }
        if (defConfs != null) {
            ret.addAll(defConfs);
        }
        LinkedHashSet<String> replacedRet = new LinkedHashSet<String>();
        Iterator iter = ret.iterator();
        while (iter.hasNext()) {
            String c = (String)iter.next();
            String replacedConf = DefaultDependencyDescriptor.replaceSelfFallbackPattern(c, moduleConfiguration);
            if (replacedConf == null) {
                replacedConf = DefaultDependencyDescriptor.replaceThisFallbackPattern(c, requestedConfiguration);
            }
            if (replacedConf != null) {
                c = replacedConf;
            }
            replacedRet.add(c);
        }
        ret = replacedRet;
        if (ret.remove("*")) {
            StringBuffer r = new StringBuffer("*");
            Iterator iter2 = ret.iterator();
            while (iter2.hasNext()) {
                String c = (String)iter2.next();
                if (!c.startsWith("!")) continue;
                r.append(c);
            }
            return new String[]{r.toString()};
        }
        return ret.toArray(new String[ret.size()]);
    }

    protected static String replaceSelfFallbackPattern(String conf, String moduleConfiguration) {
        return DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(SELF_FALLBACK_PATTERN, conf, moduleConfiguration);
    }

    protected static String replaceThisFallbackPattern(String conf, String requestedConfiguration) {
        return DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(THIS_FALLBACK_PATTERN, conf, requestedConfiguration);
    }

    protected static String replaceFallbackConfigurationPattern(Pattern pattern, String conf, String moduleConfiguration) {
        Matcher matcher = pattern.matcher(conf);
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                return moduleConfiguration + matcher.group(1);
            }
            return moduleConfiguration;
        }
        return null;
    }

    public String[] getDependencyConfigurations(String[] moduleConfigurations) {
        LinkedHashSet<String> confs = new LinkedHashSet<String>();
        for (int i = 0; i < moduleConfigurations.length; ++i) {
            confs.addAll(Arrays.asList(this.getDependencyConfigurations(moduleConfigurations[i])));
        }
        if (confs.contains("*")) {
            return new String[]{"*"};
        }
        return confs.toArray(new String[confs.size()]);
    }

    public DependencyArtifactDescriptor[] getDependencyArtifactsIncludes(String moduleConfiguration) {
        return this.getDependencyArtifacts(moduleConfiguration, this._artifactsIncludes);
    }

    public DependencyArtifactDescriptor[] getDependencyArtifactsExcludes(String moduleConfiguration) {
        return this.getDependencyArtifacts(moduleConfiguration, this._artifactsExcludes);
    }

    private DependencyArtifactDescriptor[] getDependencyArtifacts(String moduleConfiguration, Map artifactsMap) {
        if (artifactsMap.isEmpty()) {
            return new DependencyArtifactDescriptor[0];
        }
        Collection artifacts = (Collection)artifactsMap.get(moduleConfiguration);
        Collection defArtifacts = (Collection)artifactsMap.get("*");
        HashSet ret = new HashSet();
        if (artifacts != null) {
            ret.addAll(artifacts);
        }
        if (defArtifacts != null) {
            ret.addAll(defArtifacts);
        }
        return ret.toArray(new DependencyArtifactDescriptor[ret.size()]);
    }

    public DependencyArtifactDescriptor[] getDependencyArtifactsIncludes(String[] moduleConfigurations) {
        HashSet<DependencyArtifactDescriptor> artifacts = new HashSet<DependencyArtifactDescriptor>();
        for (int i = 0; i < moduleConfigurations.length; ++i) {
            artifacts.addAll(Arrays.asList(this.getDependencyArtifactsIncludes(moduleConfigurations[i])));
        }
        return artifacts.toArray(new DependencyArtifactDescriptor[artifacts.size()]);
    }

    public DependencyArtifactDescriptor[] getDependencyArtifactsExcludes(String[] moduleConfigurations) {
        HashSet<DependencyArtifactDescriptor> artifacts = new HashSet<DependencyArtifactDescriptor>();
        for (int i = 0; i < moduleConfigurations.length; ++i) {
            artifacts.addAll(Arrays.asList(this.getDependencyArtifactsExcludes(moduleConfigurations[i])));
        }
        return artifacts.toArray(new DependencyArtifactDescriptor[artifacts.size()]);
    }

    public DependencyArtifactDescriptor[] getAllDependencyArtifactsIncludes() {
        return this.getAllDependencyArtifacts(this._artifactsIncludes);
    }

    public DependencyArtifactDescriptor[] getAllDependencyArtifactsExcludes() {
        return this.getAllDependencyArtifacts(this._artifactsExcludes);
    }

    private DependencyArtifactDescriptor[] getAllDependencyArtifacts(Map artifactsMap) {
        HashSet ret = new HashSet();
        Iterator it = artifactsMap.values().iterator();
        while (it.hasNext()) {
            Collection artifacts = (Collection)it.next();
            ret.addAll(artifacts);
        }
        return ret.toArray(new DependencyArtifactDescriptor[ret.size()]);
    }

    public void addDependencyConfiguration(String masterConf, String depConf) {
        ArrayList<String> confs = (ArrayList<String>)this._confs.get(masterConf);
        if (confs == null) {
            confs = new ArrayList<String>();
            this._confs.put(masterConf, confs);
        }
        if (!confs.contains(depConf)) {
            confs.add(depConf);
        }
    }

    public void addDependencyArtifactIncludes(String masterConf, DependencyArtifactDescriptor dad) {
        this.addDependencyArtifacts(masterConf, dad, this._artifactsIncludes);
    }

    public void addDependencyArtifactExcludes(String masterConf, DependencyArtifactDescriptor dad) {
        this.addDependencyArtifacts(masterConf, dad, this._artifactsExcludes);
    }

    private void addDependencyArtifacts(String masterConf, DependencyArtifactDescriptor dad, Map artifactsMap) {
        ArrayList<DependencyArtifactDescriptor> artifacts = (ArrayList<DependencyArtifactDescriptor>)artifactsMap.get(masterConf);
        if (artifacts == null) {
            artifacts = new ArrayList<DependencyArtifactDescriptor>();
            artifactsMap.put(masterConf, artifacts);
        }
        artifacts.add(dad);
    }

    public boolean doesExclude(String[] moduleConfigurations, ArtifactId artifactId) {
        if (this._namespace != null) {
            artifactId = NameSpaceHelper.transform(artifactId, this._namespace.getFromSystemTransformer());
        }
        DependencyArtifactDescriptor[] dads = this.getDependencyArtifactsExcludes(moduleConfigurations);
        for (int i = 0; i < dads.length; ++i) {
            if (!MatcherHelper.matches(dads[i].getMatcher(), dads[i].getId(), artifactId)) continue;
            return true;
        }
        return false;
    }

    public boolean canExclude() {
        return !this._artifactsExcludes.isEmpty();
    }

    public void addExtends(String conf) {
        this._extends.add(conf);
    }

    public String toString() {
        return "dependency: " + this._revId + " " + this._confs;
    }

    public boolean isForce() {
        return this._force;
    }

    public ModuleRevisionId getParentRevisionId() {
        return this._md != null ? this._md.getResolvedModuleRevisionId() : this._parentId;
    }

    public boolean isChanging() {
        return this._changing;
    }

    public boolean isTransitive() {
        return this._transitive;
    }

    public Namespace getNamespace() {
        return this._namespace;
    }

    public String getAttribute(String attName) {
        return this._revId.getAttribute(attName);
    }

    public Map getAttributes() {
        return this._revId.getAttributes();
    }

    public String getExtraAttribute(String attName) {
        return this._revId.getExtraAttribute(attName);
    }

    public Map getExtraAttributes() {
        return this._revId.getExtraAttributes();
    }

    public String getStandardAttribute(String attName) {
        return this._revId.getStandardAttribute(attName);
    }

    public Map getStandardAttributes() {
        return this._revId.getStandardAttributes();
    }

    public DependencyDescriptor asSystem() {
        return this._asSystem;
    }
}

