/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.win32;

import java.io.Serializable;

class Win32LDTEntry
implements Serializable {
    private short limitLow;
    private short baseLow;
    private byte baseMid;
    private byte flags1;
    private byte flags2;
    private byte baseHi;

    private Win32LDTEntry() {
    }

    public Win32LDTEntry(short limitLow, short baseLow, byte baseMid, byte flags1, byte flags2, byte baseHi) {
        this.limitLow = limitLow;
        this.baseLow = baseLow;
        this.baseMid = baseMid;
        this.flags1 = flags1;
        this.flags2 = flags2;
        this.baseHi = baseHi;
    }

    public long getBase() {
        return (this.baseLow & 0xFFFF | (this.baseMid & 0xFF) << 16 | (this.baseHi & 0xFF) << 24) & 0xFFFFFFFF;
    }

    public short getLimitLow() {
        return this.limitLow;
    }

    public short getBaseLow() {
        return this.baseLow;
    }

    public byte getBaseMid() {
        return this.baseMid;
    }

    public byte getBaseHi() {
        return this.baseHi;
    }

    public int getType() {
        return this.flags1 & 0x1F;
    }

    public int getPrivilegeLevel() {
        return (this.flags1 & 0x60) >> 5;
    }

    public boolean isSegmentPhysical() {
        return (this.flags1 & 0x70) != 0;
    }

    public int getLimitHi() {
        return this.flags2 & 0xF;
    }

    public boolean isDefaultBig() {
        return (this.flags2 & 0x40) != 0;
    }

    public boolean isPageGranular() {
        return (this.flags2 & 0x80) != 0;
    }
}

