/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import java.util.ArrayList;
import java.util.HashMap;

public class ParserConfigurationSettings
implements XMLComponentManager {
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected ArrayList fRecognizedProperties;
    protected HashMap fProperties;
    protected ArrayList fRecognizedFeatures = new ArrayList();
    protected HashMap fFeatures;
    protected XMLComponentManager fParentSettings;

    public ParserConfigurationSettings() {
        this(null);
    }

    public ParserConfigurationSettings(XMLComponentManager parent) {
        this.fRecognizedProperties = new ArrayList();
        this.fFeatures = new HashMap();
        this.fProperties = new HashMap();
        this.fParentSettings = parent;
    }

    public void addRecognizedFeatures(String[] featureIds) {
        int featureIdsCount = featureIds != null ? featureIds.length : 0;
        for (int i = 0; i < featureIdsCount; ++i) {
            String featureId = featureIds[i];
            if (this.fRecognizedFeatures.contains(featureId)) continue;
            this.fRecognizedFeatures.add(featureId);
        }
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        this.checkFeature(featureId);
        this.fFeatures.put(featureId, state ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addRecognizedProperties(String[] propertyIds) {
        int propertyIdsCount = propertyIds != null ? propertyIds.length : 0;
        for (int i = 0; i < propertyIdsCount; ++i) {
            String propertyId = propertyIds[i];
            if (this.fRecognizedProperties.contains(propertyId)) continue;
            this.fRecognizedProperties.add(propertyId);
        }
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        this.checkProperty(propertyId);
        this.fProperties.put(propertyId, value);
    }

    @Override
    public boolean getFeature(String featureId) throws XMLConfigurationException {
        Boolean state = (Boolean)this.fFeatures.get(featureId);
        if (state == null) {
            this.checkFeature(featureId);
            return false;
        }
        return state;
    }

    @Override
    public Object getProperty(String propertyId) throws XMLConfigurationException {
        Object propertyValue = this.fProperties.get(propertyId);
        if (propertyValue == null) {
            this.checkProperty(propertyId);
        }
        return propertyValue;
    }

    protected void checkFeature(String featureId) throws XMLConfigurationException {
        if (!this.fRecognizedFeatures.contains(featureId)) {
            if (this.fParentSettings != null) {
                this.fParentSettings.getFeature(featureId);
            } else {
                short type = 0;
                throw new XMLConfigurationException(type, featureId);
            }
        }
    }

    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        if (!this.fRecognizedProperties.contains(propertyId)) {
            if (this.fParentSettings != null) {
                this.fParentSettings.getProperty(propertyId);
            } else {
                short type = 0;
                throw new XMLConfigurationException(type, propertyId);
            }
        }
    }
}

