/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

public class ForkJoinPool
extends AbstractExecutorService {
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
    private static final RuntimePermission modifyThreadPermission = new RuntimePermission("modifyThread");
    private static final AtomicInteger poolNumberGenerator = new AtomicInteger();
    private static final long JOIN_TIMEOUT_MILLIS = 250L;
    private static final long SHRINK_RATE_NANOS = 30000000000L;
    private static final int MAX_WORKERS = Short.MAX_VALUE;
    volatile ForkJoinWorkerThread[] workers;
    private final LinkedTransferQueue<ForkJoinTask<?>> submissionQueue;
    private final ReentrantLock workerLock;
    private final Phaser termination;
    private final ForkJoinWorkerThreadFactory factory;
    private volatile long stealCount;
    private volatile long eventWaiters;
    private static final int EVENT_COUNT_SHIFT = 32;
    private static final long WAITER_ID_MASK = 65535L;
    private volatile int eventCount;
    private volatile int spareWaiters;
    private static final int SPARE_COUNT_SHIFT = 16;
    private static final int SPARE_ID_MASK = 65535;
    volatile int runState;
    private static final int RUNLEVEL_SHIFT = 16;
    private static final int SHUTDOWN = 65536;
    private static final int TERMINATING = 131072;
    private static final int TERMINATED = 262144;
    private static final int ACTIVE_COUNT_MASK = 65535;
    private volatile int workerCounts;
    private static final int TOTAL_COUNT_SHIFT = 16;
    private static final int RUNNING_COUNT_MASK = 65535;
    private static final int ONE_RUNNING = 1;
    private static final int ONE_TOTAL = 65536;
    final int parallelism;
    final boolean locallyFifo;
    private final Thread.UncaughtExceptionHandler ueh;
    private final int poolNumber;
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final long workerCountsOffset = ForkJoinPool.objectFieldOffset("workerCounts", ForkJoinPool.class);
    private static final long runStateOffset = ForkJoinPool.objectFieldOffset("runState", ForkJoinPool.class);
    private static final long eventCountOffset = ForkJoinPool.objectFieldOffset("eventCount", ForkJoinPool.class);
    private static final long eventWaitersOffset = ForkJoinPool.objectFieldOffset("eventWaiters", ForkJoinPool.class);
    private static final long stealCountOffset = ForkJoinPool.objectFieldOffset("stealCount", ForkJoinPool.class);
    private static final long spareWaitersOffset = ForkJoinPool.objectFieldOffset("spareWaiters", ForkJoinPool.class);

    private static void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(modifyThreadPermission);
        }
    }

    final void incrementRunningCount() {
        int n;
        while (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, n = this.workerCounts, n + 1)) {
        }
    }

    final boolean tryDecrementRunningCount() {
        int n = this.workerCounts;
        if ((n & 0xFFFF) == 0) {
            return false;
        }
        return UNSAFE.compareAndSwapInt(this, workerCountsOffset, n, n - 1);
    }

    private void decrementWorkerCounts(int n, int n2) {
        int n3;
        do {
            if (((n3 = this.workerCounts) & 0xFFFF) - n >= 0 && (n3 >>> 16) - n2 >= 0) continue;
            if ((this.runState & 0x40000) != 0) {
                return;
            }
            Thread.yield();
        } while (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, n3, n3 - (n + n2)));
    }

    final boolean tryDecrementActiveCount() {
        int n = this.runState;
        return UNSAFE.compareAndSwapInt(this, runStateOffset, n, n - 1);
    }

    private boolean advanceRunLevel(int n) {
        int n2;
        do {
            if (((n2 = this.runState) & n) == 0) continue;
            return false;
        } while (!UNSAFE.compareAndSwapInt(this, runStateOffset, n2, n2 | n));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recordWorker(ForkJoinWorkerThread forkJoinWorkerThread) {
        int n = (this.workerCounts >>> 16) - 1;
        ReentrantLock reentrantLock = this.workerLock;
        reentrantLock.lock();
        try {
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
            int n2 = forkJoinWorkerThreadArray.length;
            if (n < 0 || n >= n2 || forkJoinWorkerThreadArray[n] != null) {
                for (n = 0; n < n2 && forkJoinWorkerThreadArray[n] != null; ++n) {
                }
                if (n == n2) {
                    forkJoinWorkerThreadArray = Arrays.copyOf(forkJoinWorkerThreadArray, n2 << 1);
                }
            }
            forkJoinWorkerThreadArray[n] = forkJoinWorkerThread;
            this.workers = forkJoinWorkerThreadArray;
        }
        finally {
            reentrantLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetWorker(ForkJoinWorkerThread forkJoinWorkerThread) {
        int n = forkJoinWorkerThread.poolIndex;
        ReentrantLock reentrantLock = this.workerLock;
        reentrantLock.lock();
        try {
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
            if (n >= 0 && n < forkJoinWorkerThreadArray.length && forkJoinWorkerThreadArray[n] == forkJoinWorkerThread) {
                forkJoinWorkerThreadArray[n] = null;
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    final void workerTerminated(ForkJoinWorkerThread forkJoinWorkerThread) {
        this.forgetWorker(forkJoinWorkerThread);
        this.decrementWorkerCounts(forkJoinWorkerThread.isTrimmed() ? 0 : 1, 65536);
        while (forkJoinWorkerThread.stealCount != 0) {
            this.tryAccumulateStealCount(forkJoinWorkerThread);
        }
        this.tryTerminate(false);
    }

    private void releaseEventWaiters() {
        ForkJoinWorkerThread forkJoinWorkerThread;
        int n;
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
        int n2 = forkJoinWorkerThreadArray.length;
        long l = this.eventWaiters;
        int n3 = this.eventCount;
        boolean bl = false;
        while ((n = (int)(l & 0xFFFFL) - 1) >= 0 && (int)(l >>> 32) != n3 && n < n2 && (forkJoinWorkerThread = forkJoinWorkerThreadArray[n]) != null) {
            if (UNSAFE.compareAndSwapLong(this, eventWaitersOffset, l, forkJoinWorkerThread.nextWaiter)) {
                LockSupport.unpark(forkJoinWorkerThread);
                if (bl) break;
                bl = true;
            }
            if (this.eventCount != n3) break;
            l = this.eventWaiters;
        }
    }

    final void signalWork() {
        int n = this.eventCount;
        UNSAFE.compareAndSwapInt(this, eventCountOffset, n, n + 1);
        if (this.eventWaiters != 0L) {
            this.releaseEventWaiters();
        }
    }

    private void eventSync(ForkJoinWorkerThread forkJoinWorkerThread, int n) {
        long l;
        long l2 = (long)n << 32 | (long)(forkJoinWorkerThread.poolIndex + 1);
        while (!(this.runState >= 65536 && this.tryTerminate(false) || (int)((l = this.eventWaiters) & 0xFFFFL) != 0 && (int)(l >>> 32) != n || this.eventCount != n)) {
            forkJoinWorkerThread.nextWaiter = l;
            if (!UNSAFE.compareAndSwapLong(this, eventWaitersOffset, forkJoinWorkerThread.nextWaiter, l2)) continue;
            this.awaitEvent(forkJoinWorkerThread, n);
            break;
        }
    }

    private void awaitEvent(ForkJoinWorkerThread forkJoinWorkerThread, int n) {
        while (this.eventCount == n) {
            if (!this.tryAccumulateStealCount(forkJoinWorkerThread)) continue;
            boolean bl = forkJoinWorkerThread.nextWaiter != 0L || (this.workerCounts & 0xFFFF) <= 1;
            long l = bl ? 0L : System.nanoTime();
            Thread.interrupted();
            if (this.eventCount != n || forkJoinWorkerThread.isTerminating()) break;
            if (bl) {
                LockSupport.park(forkJoinWorkerThread);
                continue;
            }
            LockSupport.parkNanos(forkJoinWorkerThread, 30000000000L);
            if (this.eventCount != n || forkJoinWorkerThread.isTerminating()) break;
            if (System.nanoTime() - l < 30000000000L) continue;
            this.tryShutdownUnusedWorker(n);
        }
    }

    final void pushSpare(ForkJoinWorkerThread forkJoinWorkerThread) {
        int n = ++forkJoinWorkerThread.spareCount << 16 | forkJoinWorkerThread.poolIndex + 1;
        while (!UNSAFE.compareAndSwapInt(this, spareWaitersOffset, forkJoinWorkerThread.nextSpare = this.spareWaiters, n)) {
        }
    }

    private void tryResumeSpare() {
        ForkJoinWorkerThread forkJoinWorkerThread;
        int n;
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
        int n2 = forkJoinWorkerThreadArray.length;
        int n3 = this.spareWaiters;
        if (n3 != 0 && (n = (n3 & 0xFFFF) - 1) >= 0 && n < n2 && (forkJoinWorkerThread = forkJoinWorkerThreadArray[n]) != null && (this.workerCounts & 0xFFFF) < this.parallelism && this.spareWaiters == n3 && UNSAFE.compareAndSwapInt(this, spareWaitersOffset, n3, forkJoinWorkerThread.nextSpare)) {
            int n4;
            while (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, n4 = this.workerCounts, n4 + 1)) {
            }
            if (forkJoinWorkerThread.tryUnsuspend()) {
                LockSupport.unpark(forkJoinWorkerThread);
            } else {
                this.decrementWorkerCounts(1, 0);
            }
        }
    }

    private void helpMaintainParallelism() {
        int n;
        int n2;
        int n3 = this.parallelism;
        while (((n2 = this.workerCounts) & 0xFFFF) < n3 && (n = this.runState) < 131072) {
            if (this.spareWaiters != 0) {
                this.tryResumeSpare();
                continue;
            }
            int n4 = n2 >>> 16;
            if (n4 >= Short.MAX_VALUE || n4 >= n3 && (n & 0xFFFF) != n4) break;
            if (this.runState != n || this.workerCounts != n2 || !UNSAFE.compareAndSwapInt(this, workerCountsOffset, n2, n2 + 65537)) continue;
            ForkJoinWorkerThread forkJoinWorkerThread = null;
            Throwable throwable = null;
            try {
                forkJoinWorkerThread = this.factory.newThread(this);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            if (forkJoinWorkerThread == null) {
                this.decrementWorkerCounts(1, 65536);
                this.tryTerminate(false);
                if (throwable == null || this.runState >= 131072 || Thread.currentThread() instanceof ForkJoinWorkerThread) break;
                UNSAFE.throwException(throwable);
                break;
            }
            forkJoinWorkerThread.start(this.recordWorker(forkJoinWorkerThread), this.ueh);
            if (this.workerCounts >>> 16 < n3) continue;
            int n5 = this.eventCount;
            UNSAFE.compareAndSwapInt(this, eventCountOffset, n5, n5 + 1);
            break;
        }
        if (this.eventWaiters != 0L) {
            this.releaseEventWaiters();
        }
    }

    private void tryShutdownUnusedWorker(int n) {
        if (this.runState == 0 && this.eventCount == n) {
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.workers;
            int n2 = forkJoinWorkerThreadArray.length;
            ForkJoinWorkerThread forkJoinWorkerThread = null;
            boolean bl = false;
            int n3 = this.spareWaiters;
            if (n3 != 0) {
                int n4 = (n3 & 0xFFFF) - 1;
                if (n4 >= 0 && n4 < n2 && (forkJoinWorkerThread = forkJoinWorkerThreadArray[n4]) != null && UNSAFE.compareAndSwapInt(this, spareWaitersOffset, n3, forkJoinWorkerThread.nextSpare)) {
                    bl = true;
                }
            } else {
                long l;
                int n5;
                long l2 = this.eventWaiters;
                if (l2 != 0L && (n5 = (int)(l2 & 0xFFFFL) - 1) >= 0 && n5 < n2 && (forkJoinWorkerThread = forkJoinWorkerThreadArray[n5]) != null && (l = forkJoinWorkerThread.nextWaiter) != 0L && UNSAFE.compareAndSwapLong(this, eventWaitersOffset, l2, l)) {
                    bl = true;
                }
            }
            if (forkJoinWorkerThread != null && bl) {
                forkJoinWorkerThread.shutdown();
                LockSupport.unpark(forkJoinWorkerThread);
            }
        }
        this.releaseEventWaiters();
    }

    final void preStep(ForkJoinWorkerThread forkJoinWorkerThread, boolean bl) {
        int n = forkJoinWorkerThread.lastEventCount;
        boolean bl2 = forkJoinWorkerThread.active;
        boolean bl3 = false;
        int n2 = this.parallelism;
        while (forkJoinWorkerThread.runState == 0) {
            int n3;
            int n4 = this.runState;
            if (n4 >= 131072) {
                forkJoinWorkerThread.shutdown();
                break;
            }
            if ((bl3 || bl2 && (n4 & 0xFFFF) >= n2) && UNSAFE.compareAndSwapInt(this, runStateOffset, n4, n4 - 1)) {
                forkJoinWorkerThread.active = false;
                bl2 = false;
                bl3 = false;
            }
            if (((n3 = this.workerCounts) & 0xFFFF) > n2) {
                if ((bl3 |= bl2) || this.workerCounts != n3 || !UNSAFE.compareAndSwapInt(this, workerCountsOffset, n3, n3 - 1)) continue;
                forkJoinWorkerThread.suspendAsSpare();
                continue;
            }
            if (n3 >>> 16 < n2) {
                this.helpMaintainParallelism();
                continue;
            }
            if (bl) break;
            long l = this.eventWaiters;
            int n5 = this.eventCount;
            if (l != 0L && (int)(l >>> 32) != n5) {
                this.releaseEventWaiters();
                continue;
            }
            if (n5 != n) {
                forkJoinWorkerThread.lastEventCount = n5;
                break;
            }
            if (bl3 |= bl2) continue;
            this.eventSync(forkJoinWorkerThread, n);
        }
    }

    final void awaitJoin(ForkJoinTask<?> forkJoinTask, ForkJoinWorkerThread forkJoinWorkerThread) {
        int n = 2 + (this.parallelism >> 2);
        while (forkJoinTask.status >= 0) {
            int n2;
            long l;
            int n3;
            forkJoinWorkerThread.helpJoinTask(forkJoinTask);
            if (forkJoinTask.status < 0) break;
            if (n > 0) {
                --n;
                continue;
            }
            int n4 = this.workerCounts;
            if ((n4 & 0xFFFF) == 0 || !UNSAFE.compareAndSwapInt(this, workerCountsOffset, n4, n4 - 1)) continue;
            while ((n3 = forkJoinTask.status) >= 0 && (l = this.eventWaiters) != 0L && (int)(l >>> 32) != this.eventCount) {
                this.releaseEventWaiters();
            }
            if (n3 >= 0 && ((this.workerCounts & 0xFFFF) == 0 || (n3 = forkJoinTask.internalAwaitDone(250L)) >= 0)) {
                this.helpMaintainParallelism();
            }
            while (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, n2 = this.workerCounts, n2 + 1)) {
            }
            if (n3 >= 0) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void awaitBlocker(ManagedBlocker managedBlocker) throws InterruptedException {
        block3: while (!managedBlocker.isReleasable()) {
            int n = this.workerCounts;
            if ((n & 0xFFFF) == 0 || !UNSAFE.compareAndSwapInt(this, workerCountsOffset, n, n - 1)) continue;
            try {
                while (!managedBlocker.isReleasable()) {
                    long l = this.eventWaiters;
                    if (l != 0L && (int)(l >>> 32) != this.eventCount) {
                        this.releaseEventWaiters();
                        continue;
                    }
                    if ((this.workerCounts & 0xFFFF) == 0 && this.runState < 131072) {
                        this.helpMaintainParallelism();
                        continue;
                    }
                    if (!managedBlocker.block()) continue;
                    break block3;
                }
                break;
            }
            finally {
                int n2;
                while (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, n2 = this.workerCounts, n2 + 1)) {
                }
            }
        }
    }

    private boolean tryTerminate(boolean bl) {
        if (bl) {
            this.advanceRunLevel(65536);
        } else if (this.runState < 65536 || !this.submissionQueue.isEmpty() || (this.runState & 0xFFFF) != 0) {
            return false;
        }
        if (this.advanceRunLevel(131072)) {
            this.startTerminating();
        }
        if (this.workerCounts >>> 16 == 0) {
            this.advanceRunLevel(262144);
            this.termination.arrive();
        }
        return true;
    }

    private void startTerminating() {
        this.cancelSubmissions();
        for (int i = 0; i < 4 && this.workerCounts != 0; ++i) {
            int n = this.eventCount;
            UNSAFE.compareAndSwapInt(this, eventCountOffset, n, n + 1);
            this.eventWaiters = 0L;
            this.spareWaiters = 0;
            for (ForkJoinWorkerThread forkJoinWorkerThread : this.workers) {
                if (forkJoinWorkerThread == null) continue;
                forkJoinWorkerThread.shutdown();
                if (i <= 0 || forkJoinWorkerThread.isTerminated()) continue;
                forkJoinWorkerThread.cancelTasks();
                LockSupport.unpark(forkJoinWorkerThread);
                if (i <= 1 || forkJoinWorkerThread.isInterrupted()) continue;
                try {
                    forkJoinWorkerThread.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }

    private void cancelSubmissions() {
        ForkJoinTask<?> forkJoinTask;
        while ((forkJoinTask = this.submissionQueue.poll()) != null) {
            try {
                forkJoinTask.cancel(false);
            }
            catch (Throwable throwable) {}
        }
    }

    final int getPoolNumber() {
        return this.poolNumber;
    }

    final boolean tryAccumulateStealCount(ForkJoinWorkerThread forkJoinWorkerThread) {
        long l = this.stealCount;
        int n = forkJoinWorkerThread.stealCount;
        if (UNSAFE.compareAndSwapLong(this, stealCountOffset, l, l + (long)n)) {
            if (n != 0) {
                forkJoinWorkerThread.stealCount = 0;
            }
            return true;
        }
        return n == 0;
    }

    final int idlePerActive() {
        int n = this.parallelism;
        int n2 = this.runState;
        return n <= n2 ? 0 : (n >>> 1 <= n2 ? 1 : (n >>> 2 <= n2 ? 3 : n >>> 3));
    }

    public ForkJoinPool() {
        this(Runtime.getRuntime().availableProcessors(), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n) {
        this(n, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n, ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean bl) {
        ForkJoinPool.checkPermission();
        if (forkJoinWorkerThreadFactory == null) {
            throw new NullPointerException();
        }
        if (n <= 0 || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.parallelism = n;
        this.factory = forkJoinWorkerThreadFactory;
        this.ueh = uncaughtExceptionHandler;
        this.locallyFifo = bl;
        int n2 = ForkJoinPool.initialArraySizeFor(n);
        this.workers = new ForkJoinWorkerThread[n2];
        this.submissionQueue = new LinkedTransferQueue();
        this.workerLock = new ReentrantLock();
        this.termination = new Phaser(1);
        this.poolNumber = poolNumberGenerator.incrementAndGet();
    }

    private static int initialArraySizeFor(int n) {
        int n2 = n < Short.MAX_VALUE ? n + 1 : Short.MAX_VALUE;
        n2 |= n2 >>> 1;
        n2 |= n2 >>> 2;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 8;
        return n2 + 1;
    }

    private <T> void doSubmit(ForkJoinTask<T> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        if (this.runState >= 65536) {
            throw new RejectedExecutionException();
        }
        this.submissionQueue.offer(forkJoinTask);
        int n = this.eventCount;
        UNSAFE.compareAndSwapInt(this, eventCountOffset, n, n + 1);
        this.helpMaintainParallelism();
    }

    public <T> T invoke(ForkJoinTask<T> forkJoinTask) {
        this.doSubmit(forkJoinTask);
        return forkJoinTask.join();
    }

    public void execute(ForkJoinTask<?> forkJoinTask) {
        this.doSubmit(forkJoinTask);
    }

    @Override
    public void execute(Runnable runnable) {
        ForkJoinTask<Object> forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask<Object>)((Object)runnable) : ForkJoinTask.adapt(runnable, null);
        this.doSubmit(forkJoinTask);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> forkJoinTask) {
        this.doSubmit(forkJoinTask);
        return forkJoinTask;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> callable) {
        ForkJoinTask<T> forkJoinTask = ForkJoinTask.adapt(callable);
        this.doSubmit(forkJoinTask);
        return forkJoinTask;
    }

    public <T> ForkJoinTask<T> submit(Runnable runnable, T t) {
        ForkJoinTask<T> forkJoinTask = ForkJoinTask.adapt(runnable, t);
        this.doSubmit(forkJoinTask);
        return forkJoinTask;
    }

    public ForkJoinTask<?> submit(Runnable runnable) {
        ForkJoinTask<Object> forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask<Object>)((Object)runnable) : ForkJoinTask.adapt(runnable, null);
        this.doSubmit(forkJoinTask);
        return forkJoinTask;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        for (Callable<T> callable : collection) {
            arrayList.add(ForkJoinTask.adapt(callable));
        }
        this.invoke(new InvokeAll(arrayList));
        ArrayList arrayList2 = arrayList;
        return arrayList2;
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getPoolSize() {
        return this.workerCounts >>> 16;
    }

    public boolean getAsyncMode() {
        return this.locallyFifo;
    }

    public int getRunningThreadCount() {
        return this.workerCounts & 0xFFFF;
    }

    public int getActiveThreadCount() {
        return this.runState & 0xFFFF;
    }

    public boolean isQuiescent() {
        return (this.runState & 0xFFFF) == 0;
    }

    public long getStealCount() {
        return this.stealCount;
    }

    public long getQueuedTaskCount() {
        long l = 0L;
        for (ForkJoinWorkerThread forkJoinWorkerThread : this.workers) {
            if (forkJoinWorkerThread == null) continue;
            l += (long)forkJoinWorkerThread.getQueueSize();
        }
        return l;
    }

    public int getQueuedSubmissionCount() {
        return this.submissionQueue.size();
    }

    public boolean hasQueuedSubmissions() {
        return !this.submissionQueue.isEmpty();
    }

    protected ForkJoinTask<?> pollSubmission() {
        return this.submissionQueue.poll();
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> collection) {
        int n = this.submissionQueue.drainTo(collection);
        for (ForkJoinWorkerThread forkJoinWorkerThread : this.workers) {
            if (forkJoinWorkerThread == null) continue;
            n += forkJoinWorkerThread.drainTasksTo(collection);
        }
        return n;
    }

    public String toString() {
        long l = this.getStealCount();
        long l2 = this.getQueuedTaskCount();
        long l3 = this.getQueuedSubmissionCount();
        int n = this.workerCounts;
        int n2 = n >>> 16;
        int n3 = n & 0xFFFF;
        int n4 = this.parallelism;
        int n5 = this.runState;
        int n6 = n5 & 0xFFFF;
        return super.toString() + "[" + ForkJoinPool.runLevelToString(n5) + ", parallelism = " + n4 + ", size = " + n2 + ", active = " + n6 + ", running = " + n3 + ", steals = " + l + ", tasks = " + l2 + ", submissions = " + l3 + "]";
    }

    private static String runLevelToString(int n) {
        return (n & 0x40000) != 0 ? "Terminated" : ((n & 0x20000) != 0 ? "Terminating" : ((n & 0x10000) != 0 ? "Shutting down" : "Running"));
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.advanceRunLevel(65536);
        this.tryTerminate(false);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return this.runState >= 262144;
    }

    public boolean isTerminating() {
        return (this.runState & 0x60000) == 131072;
    }

    final boolean isAtLeastTerminating() {
        return this.runState >= 131072;
    }

    @Override
    public boolean isShutdown() {
        return this.runState >= 65536;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        try {
            return this.termination.awaitAdvanceInterruptibly(0, l, timeUnit) > 0;
        }
        catch (TimeoutException timeoutException) {
            return false;
        }
    }

    public static void managedBlock(ManagedBlocker managedBlocker) throws InterruptedException {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            forkJoinWorkerThread.pool.awaitBlocker(managedBlocker);
        } else {
            while (!managedBlocker.isReleasable() && !managedBlocker.block()) {
            }
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return (RunnableFuture)((Object)ForkJoinTask.adapt(runnable, t));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return (RunnableFuture)((Object)ForkJoinTask.adapt(callable));
    }

    private static long objectFieldOffset(String string, Class<?> clazz) {
        try {
            return UNSAFE.objectFieldOffset(clazz.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(string);
            noSuchFieldError.initCause(noSuchFieldException);
            throw noSuchFieldError;
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class InvokeAll<T>
    extends RecursiveAction {
        final ArrayList<ForkJoinTask<T>> tasks;
        private static final long serialVersionUID = -7914297376763021607L;

        InvokeAll(ArrayList<ForkJoinTask<T>> arrayList) {
            this.tasks = arrayList;
        }

        @Override
        public void compute() {
            try {
                InvokeAll.invokeAll(this.tasks);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
            return new ForkJoinWorkerThread(forkJoinPool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

