/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.CallSite;
import java.dyn.ConstantCallSite;
import java.dyn.InvokeDynamicBootstrapError;
import java.dyn.MethodHandle;
import java.dyn.MethodHandleProvider;
import java.dyn.MethodType;
import java.dyn.NoAccessException;
import sun.dyn.Access;
import sun.dyn.MemberName;
import sun.dyn.MethodHandleImpl;
import sun.dyn.MethodHandleNatives;

public class CallSiteImpl {
    private static final MethodHandle PRIVATE_INITIALIZE_CALL_SITE;

    static CallSite makeSite(MethodHandle methodHandle, String string, MethodType methodType, Object object, MemberName memberName, int n) {
        CallSite callSite;
        Class<?> clazz = memberName.getDeclaringClass();
        if (methodHandle == null) {
            throw new IncompatibleClassChangeError("Class " + clazz.getName() + " has not declared a bootstrap method for invokedynamic");
        }
        try {
            Object object2 = methodHandle.invokeVarargs(clazz, string, methodType);
            if (object2 instanceof CallSite) {
                callSite = (CallSite)object2;
            } else if (object2 instanceof MethodHandleProvider) {
                MethodHandle methodHandle2 = ((MethodHandleProvider)object2).asMethodHandle();
                callSite = new ConstantCallSite(methodHandle2);
            } else {
                throw new ClassCastException("bootstrap method failed to produce a MethodHandle or CallSite");
            }
            PRIVATE_INITIALIZE_CALL_SITE.invokeExact(callSite, string, methodType, memberName, n);
            assert (callSite.getTarget() != null);
            assert (callSite.getTarget().type().equals((Object)methodType));
        }
        catch (Throwable throwable) {
            InvokeDynamicBootstrapError invokeDynamicBootstrapError = throwable instanceof InvokeDynamicBootstrapError ? (InvokeDynamicBootstrapError)throwable : new InvokeDynamicBootstrapError("call site initialization exception", throwable);
            throw invokeDynamicBootstrapError;
        }
        return callSite;
    }

    public static void setCallSiteTarget(Access access, CallSite callSite, MethodHandle methodHandle) {
        Access.check(access);
        MethodHandleNatives.setCallSiteTarget(callSite, methodHandle);
    }

    static {
        try {
            PRIVATE_INITIALIZE_CALL_SITE = MethodHandleImpl.IMPL_LOOKUP.findVirtual(CallSite.class, "initializeFromJVM", MethodType.methodType(Void.TYPE, String.class, MethodType.class, MemberName.class, Integer.TYPE));
        }
        catch (NoAccessException noAccessException) {
            throw MemberName.uncaughtException(noAccessException);
        }
    }
}

