/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.CallSite;
import java.dyn.MethodHandle;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import java.dyn.NoAccessException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import sun.dyn.Access;
import sun.dyn.AdapterMethodHandle;
import sun.dyn.BoundMethodHandle;
import sun.dyn.CallSiteImpl;
import sun.dyn.DirectMethodHandle;
import sun.dyn.MemberName;
import sun.dyn.MethodHandleImpl;
import sun.dyn.MethodTypeImpl;

class MethodHandleNatives {
    public static final boolean JVM_SUPPORT;
    static final int JVM_PUSH_LIMIT;
    static final int JVM_STACK_MOVE_UNIT;
    static final int CONV_OP_IMPLEMENTED_MASK;

    private MethodHandleNatives() {
    }

    static native void init(MemberName var0, Object var1);

    static native void expand(MemberName var0);

    static native void resolve(MemberName var0, Class<?> var1);

    static native int getMembers(Class<?> var0, String var1, String var2, int var3, Class<?> var4, int var5, MemberName[] var6);

    static native void init(AdapterMethodHandle var0, MethodHandle var1, int var2);

    static native void init(BoundMethodHandle var0, Object var1, int var2);

    static native void init(DirectMethodHandle var0, Object var1, boolean var2, Class<?> var3);

    static native void init(MethodType var0);

    static native void registerBootstrap(Class<?> var0, MethodHandle var1);

    static native MethodHandle getBootstrap(Class<?> var0);

    static native void setCallSiteTarget(CallSite var0, MethodHandle var1);

    static native Object getTarget(MethodHandle var0, int var1);

    static MemberName getMethodName(MethodHandle methodHandle) {
        if (!JVM_SUPPORT) {
            return null;
        }
        return (MemberName)MethodHandleNatives.getTarget(methodHandle, 2);
    }

    static AccessibleObject getTargetMethod(MethodHandle methodHandle) {
        if (!JVM_SUPPORT) {
            return null;
        }
        return (AccessibleObject)MethodHandleNatives.getTarget(methodHandle, 3);
    }

    static Object getTargetInfo(MethodHandle methodHandle) {
        if (!JVM_SUPPORT) {
            return null;
        }
        return MethodHandleNatives.getTarget(methodHandle, 0);
    }

    static Object[] makeTarget(Class<?> clazz, String string, String string2, int n, Class<?> clazz2) {
        return new Object[]{clazz, string, string2, n, clazz2};
    }

    static native int getConstant(int var0);

    private static native void registerNatives();

    private static native int getNamedCon(int var0, Object[] var1);

    static boolean verifyConstants() {
        Object[] objectArray = new Object[]{null};
        int n = 0;
        while (true) {
            objectArray[0] = null;
            int n2 = MethodHandleNatives.getNamedCon(n, objectArray);
            if (objectArray[0] == null) break;
            String string = (String)objectArray[0];
            try {
                Field field = Constants.class.getDeclaredField(string);
                int n3 = field.getInt(null);
                if (n3 != n2) {
                    throw new InternalError(string + ": JVM has " + n2 + " while Java has " + n3);
                }
            }
            catch (Exception exception) {
                throw new InternalError(string + ": access failed, got " + exception);
            }
            ++n;
        }
        return true;
    }

    static CallSite makeDynamicCallSite(MethodHandle methodHandle, String string, MethodType methodType, Object object, MemberName memberName, int n) {
        return CallSiteImpl.makeSite(methodHandle, string, methodType, object, memberName, n);
    }

    static MethodType findMethodHandleType(Class<?> clazz, Class<?>[] classArray) {
        MethodType.genericMethodType(0);
        return MethodTypeImpl.makeImpl(Access.TOKEN, clazz, classArray, true);
    }

    static MethodHandle linkMethodHandleConstant(Class<?> clazz, int n, Class<?> clazz2, String string, Object object) {
        try {
            MethodHandles.Lookup lookup = MethodHandleImpl.IMPL_LOOKUP.in(clazz);
            switch (n) {
                case 1: {
                    return lookup.findGetter(clazz2, string, (Class)object);
                }
                case 2: {
                    return lookup.findStaticGetter(clazz2, string, (Class)object);
                }
                case 3: {
                    return lookup.findSetter(clazz2, string, (Class)object);
                }
                case 4: {
                    return lookup.findStaticSetter(clazz2, string, (Class)object);
                }
                case 5: {
                    return lookup.findVirtual(clazz2, string, (MethodType)object);
                }
                case 6: {
                    return lookup.findStatic(clazz2, string, (MethodType)object);
                }
                case 7: {
                    return lookup.findSpecial(clazz2, string, (MethodType)object, clazz);
                }
                case 8: {
                    return lookup.findConstructor(clazz2, (MethodType)object);
                }
                case 9: {
                    return lookup.findVirtual(clazz2, string, (MethodType)object);
                }
            }
            throw new IllegalArgumentException("bad MethodHandle constant " + string + " : " + object);
        }
        catch (NoAccessException noAccessException) {
            IncompatibleClassChangeError incompatibleClassChangeError = new IncompatibleClassChangeError();
            incompatibleClassChangeError.initCause(noAccessException);
            throw incompatibleClassChangeError;
        }
    }

    static {
        int n;
        int n2;
        int n3;
        boolean bl;
        try {
            MethodHandleNatives.registerNatives();
            bl = true;
            n3 = MethodHandleNatives.getConstant(0);
            n2 = MethodHandleNatives.getConstant(1);
            n = MethodHandleNatives.getConstant(2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            boolean bl2 = false;
            int n4 = 3;
            int n5 = -1;
            boolean bl3 = false;
            JVM_SUPPORT = bl2;
            JVM_PUSH_LIMIT = n4;
            JVM_STACK_MOVE_UNIT = n5;
            throw unsatisfiedLinkError;
        }
        JVM_SUPPORT = bl;
        JVM_PUSH_LIMIT = n3;
        JVM_STACK_MOVE_UNIT = n2;
        if (n == 0) {
            n = 991;
        }
        CONV_OP_IMPLEMENTED_MASK = n;
        if (JVM_SUPPORT) {
            MethodHandleNatives.verifyConstants();
        }
    }

    static class Constants {
        static final int GC_JVM_PUSH_LIMIT = 0;
        static final int GC_JVM_STACK_MOVE_UNIT = 1;
        static final int GC_CONV_OP_IMPLEMENTED_MASK = 2;
        static final int ETF_HANDLE_OR_METHOD_NAME = 0;
        static final int ETF_DIRECT_HANDLE = 1;
        static final int ETF_METHOD_NAME = 2;
        static final int ETF_REFLECT_METHOD = 3;
        static final int MN_IS_METHOD = 65536;
        static final int MN_IS_CONSTRUCTOR = 131072;
        static final int MN_IS_FIELD = 262144;
        static final int MN_IS_TYPE = 524288;
        static final int MN_SEARCH_SUPERCLASSES = 0x100000;
        static final int MN_SEARCH_INTERFACES = 0x200000;
        static final int VM_INDEX_UNINITIALIZED = -99;
        static final int OP_RETYPE_ONLY = 0;
        static final int OP_RETYPE_RAW = 1;
        static final int OP_CHECK_CAST = 2;
        static final int OP_PRIM_TO_PRIM = 3;
        static final int OP_REF_TO_PRIM = 4;
        static final int OP_PRIM_TO_REF = 5;
        static final int OP_SWAP_ARGS = 6;
        static final int OP_ROT_ARGS = 7;
        static final int OP_DUP_ARGS = 8;
        static final int OP_DROP_ARGS = 9;
        static final int OP_COLLECT_ARGS = 10;
        static final int OP_SPREAD_ARGS = 11;
        static final int OP_FLYBY = 12;
        static final int OP_RICOCHET = 13;
        static final int CONV_OP_LIMIT = 14;
        static final int CONV_OP_MASK = 3840;
        static final int CONV_VMINFO_MASK = 255;
        static final int CONV_VMINFO_SHIFT = 0;
        static final int CONV_OP_SHIFT = 8;
        static final int CONV_DEST_TYPE_SHIFT = 12;
        static final int CONV_SRC_TYPE_SHIFT = 16;
        static final int CONV_STACK_MOVE_SHIFT = 20;
        static final int CONV_STACK_MOVE_MASK = 4095;
        static final int DEFAULT_CONV_OP_IMPLEMENTED_MASK = 991;
        static final int T_BOOLEAN = 4;
        static final int T_CHAR = 5;
        static final int T_FLOAT = 6;
        static final int T_DOUBLE = 7;
        static final int T_BYTE = 8;
        static final int T_SHORT = 9;
        static final int T_INT = 10;
        static final int T_LONG = 11;
        static final int T_OBJECT = 12;
        static final int T_VOID = 14;
        static final int REF_getField = 1;
        static final int REF_getStatic = 2;
        static final int REF_putField = 3;
        static final int REF_putStatic = 4;
        static final int REF_invokeVirtual = 5;
        static final int REF_invokeStatic = 6;
        static final int REF_invokeSpecial = 7;
        static final int REF_newInvokeSpecial = 8;
        static final int REF_invokeInterface = 9;

        Constants() {
        }
    }
}

