/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import sun.awt.SunToolkit;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.ProcessPath;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;
import sun.java2d.xr.MaskTileManager;
import sun.java2d.xr.XRSurfaceData;

public class XRRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe {
    XRDrawHandler drawHandler;
    MaskTileManager tileManager;

    public XRRenderer(MaskTileManager maskTileManager) {
        this.tileManager = maskTileManager;
        this.drawHandler = new XRDrawHandler();
    }

    private final void validateSurface(SunGraphics2D sunGraphics2D) {
        XRSurfaceData xRSurfaceData = (XRSurfaceData)sunGraphics2D.surfaceData;
        xRSurfaceData.validateAsDestination(sunGraphics2D, sunGraphics2D.getCompClip());
        xRSurfaceData.maskBuffer.validateCompositeState(sunGraphics2D.composite, sunGraphics2D.transform, sunGraphics2D.paint, sunGraphics2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        try {
            SunToolkit.awtLock();
            this.validateSurface(sunGraphics2D);
            int n5 = sunGraphics2D.transX;
            int n6 = sunGraphics2D.transY;
            XRSurfaceData xRSurfaceData = (XRSurfaceData)sunGraphics2D.surfaceData;
            this.tileManager.addLine(n + n5, n2 + n6, n3 + n5, n4 + n6);
            this.tileManager.fillMask(xRSurfaceData);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    @Override
    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.draw(sunGraphics2D, new Rectangle2D.Float(n, n2, n3, n4));
    }

    @Override
    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        Path2D.Float float_ = new Path2D.Float();
        if (n > 1) {
            float_.moveTo(nArray[0], nArray2[0]);
            for (int i = 1; i < n; ++i) {
                float_.lineTo(nArray[i], nArray2[i]);
            }
        }
        this.draw(sunGraphics2D, float_);
    }

    @Override
    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.draw(sunGraphics2D, new Polygon(nArray, nArray2, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        SunToolkit.awtLock();
        try {
            this.validateSurface(sunGraphics2D);
            XRSurfaceData xRSurfaceData = (XRSurfaceData)sunGraphics2D.surfaceData;
            n = (int)((double)n + sunGraphics2D.transform.getTranslateX());
            n2 = (int)((double)n2 + sunGraphics2D.transform.getTranslateY());
            this.tileManager.addRect(n, n2, n3, n4);
            this.tileManager.fillMask(xRSurfaceData);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    @Override
    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.fill(sunGraphics2D, new Polygon(nArray, nArray2, n));
    }

    @Override
    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.draw(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    @Override
    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.fill(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    @Override
    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    @Override
    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPath(SunGraphics2D sunGraphics2D, Path2D.Float float_, int n, int n2) {
        SunToolkit.awtLock();
        try {
            this.validateSurface(sunGraphics2D);
            this.drawHandler.validate(sunGraphics2D);
            ProcessPath.drawPath(this.drawHandler, float_, n, n2);
            this.tileManager.fillMask((XRSurfaceData)sunGraphics2D.surfaceData);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillPath(SunGraphics2D sunGraphics2D, Path2D.Float float_, int n, int n2) {
        SunToolkit.awtLock();
        try {
            this.validateSurface(sunGraphics2D);
            this.drawHandler.validate(sunGraphics2D);
            ProcessPath.fillPath(this.drawHandler, float_, n, n2);
            this.tileManager.fillMask((XRSurfaceData)sunGraphics2D.surfaceData);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator, int n, int n2) {
        SunToolkit.awtLock();
        try {
            this.validateSurface(sunGraphics2D);
            int[] nArray = new int[4];
            while (spanIterator.nextSpan(nArray)) {
                this.tileManager.addRect(nArray[0] + n, nArray[1] + n2, nArray[2] - nArray[0], nArray[3] - nArray[1]);
            }
            this.tileManager.fillMask((XRSurfaceData)sunGraphics2D.surfaceData);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.strokeState == 0) {
            int n;
            int n2;
            Path2D.Float float_;
            if (sunGraphics2D.transformState <= 1) {
                float_ = shape instanceof Path2D.Float ? (Path2D.Float)shape : new Path2D.Float(shape);
                n2 = sunGraphics2D.transX;
                n = sunGraphics2D.transY;
            } else {
                float_ = new Path2D.Float(shape, sunGraphics2D.transform);
                n2 = 0;
                n = 0;
            }
            this.drawPath(sunGraphics2D, float_, n2, n);
        } else if (sunGraphics2D.strokeState < 3) {
            ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
            try {
                this.fillSpans(sunGraphics2D, shapeSpanIterator, 0, 0);
            }
            finally {
                shapeSpanIterator.dispose();
            }
        } else {
            this.fill(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        int n;
        int n2;
        AffineTransform affineTransform;
        if (sunGraphics2D.strokeState == 0) {
            int n3;
            int n4;
            Path2D.Float float_;
            if (sunGraphics2D.transformState <= 1) {
                float_ = shape instanceof Path2D.Float ? (Path2D.Float)shape : new Path2D.Float(shape);
                n4 = sunGraphics2D.transX;
                n3 = sunGraphics2D.transY;
            } else {
                float_ = new Path2D.Float(shape, sunGraphics2D.transform);
                n4 = 0;
                n3 = 0;
            }
            this.fillPath(sunGraphics2D, float_, n4, n3);
            return;
        }
        if (sunGraphics2D.transformState <= 1) {
            affineTransform = null;
            n2 = sunGraphics2D.transX;
            n = sunGraphics2D.transY;
        } else {
            affineTransform = sunGraphics2D.transform;
            n = 0;
            n2 = 0;
        }
        ShapeSpanIterator shapeSpanIterator = LoopPipe.getFillSSI(sunGraphics2D);
        try {
            Region region = sunGraphics2D.getCompClip();
            shapeSpanIterator.setOutputAreaXYXY(region.getLoX() - n2, region.getLoY() - n, region.getHiX() - n2, region.getHiY() - n);
            shapeSpanIterator.appendPath(shape.getPathIterator(affineTransform));
            this.fillSpans(sunGraphics2D, shapeSpanIterator, n2, n);
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    private class XRDrawHandler
    extends ProcessPath.DrawHandler {
        XRDrawHandler() {
            super(0, 0, 0, 0);
        }

        void validate(SunGraphics2D sunGraphics2D) {
            Region region = sunGraphics2D.getCompClip();
            this.setBounds(region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY(), sunGraphics2D.strokeHint);
            XRRenderer.this.validateSurface(sunGraphics2D);
        }

        @Override
        public void drawLine(int n, int n2, int n3, int n4) {
            XRRenderer.this.tileManager.addLine(n, n2, n3, n4);
        }

        @Override
        public void drawPixel(int n, int n2) {
            XRRenderer.this.tileManager.addRect(n, n2, 1, 1);
        }

        @Override
        public void drawScanline(int n, int n2, int n3) {
            XRRenderer.this.tileManager.addRect(n, n3, n2 - n + 1, 1);
        }
    }
}

