/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.StandardWatchEventKind;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import sun.nio.fs.AbstractWatchService;

abstract class AbstractWatchKey
extends WatchKey {
    static final int MAX_EVENT_LIST_SIZE = 512;
    static final Event<Void> OVERFLOW_EVENT = new Event<Object>(StandardWatchEventKind.OVERFLOW, null);
    private final AbstractWatchService watcher;
    private State state;
    private List<WatchEvent<?>> events;
    private Map<Object, WatchEvent<?>> lastModifyEvents;

    protected AbstractWatchKey(AbstractWatchService abstractWatchService) {
        this.watcher = abstractWatchService;
        this.state = State.READY;
        this.events = new ArrayList();
        this.lastModifyEvents = new HashMap();
    }

    final AbstractWatchService watcher() {
        return this.watcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void signal() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            if (this.state == State.READY) {
                this.state = State.SIGNALLED;
                this.watcher.enqueueKey(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void signalEvent(WatchEvent.Kind<?> kind, Object object) {
        boolean bl = kind == StandardWatchEventKind.ENTRY_MODIFY;
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            WatchEvent watchEvent;
            int n = this.events.size();
            if (n > 0) {
                watchEvent = this.events.get(n - 1);
                if (watchEvent.kind() == StandardWatchEventKind.OVERFLOW || kind == watchEvent.kind() && Objects.equals(object, watchEvent.context())) {
                    ((Event)watchEvent).increment();
                    return;
                }
                if (!this.lastModifyEvents.isEmpty()) {
                    if (bl) {
                        WatchEvent<?> watchEvent2 = this.lastModifyEvents.get(object);
                        if (watchEvent2 != null) {
                            assert (watchEvent2.kind() == StandardWatchEventKind.ENTRY_MODIFY);
                            ((Event)watchEvent2).increment();
                            return;
                        }
                    } else {
                        this.lastModifyEvents.remove(object);
                    }
                }
                if (n >= 512) {
                    kind = StandardWatchEventKind.OVERFLOW;
                    bl = false;
                    object = null;
                }
            }
            watchEvent = new Event<Object>(kind, object);
            if (bl) {
                this.lastModifyEvents.put(object, watchEvent);
            } else if (kind == StandardWatchEventKind.OVERFLOW) {
                this.events.clear();
                this.lastModifyEvents.clear();
            }
            this.events.add(watchEvent);
            this.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<WatchEvent<?>> pollEvents() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            List<WatchEvent<?>> list = this.events;
            this.events = new ArrayList();
            this.lastModifyEvents.clear();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean reset() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            if (this.state == State.SIGNALLED && this.isValid()) {
                if (this.events.isEmpty()) {
                    this.state = State.READY;
                } else {
                    this.watcher.enqueueKey(this);
                }
            }
            return this.isValid();
        }
    }

    private static class Event<T>
    extends WatchEvent<T> {
        private final WatchEvent.Kind<T> kind;
        private final T context;
        private int count;

        Event(WatchEvent.Kind<T> kind, T t) {
            this.kind = kind;
            this.context = t;
            this.count = 1;
        }

        @Override
        public WatchEvent.Kind<T> kind() {
            return this.kind;
        }

        @Override
        public T context() {
            return this.context;
        }

        @Override
        public int count() {
            return this.count;
        }

        void increment() {
            ++this.count;
        }
    }

    private static enum State {
        READY,
        SIGNALLED;

    }
}

