/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipFileSystem;
import com.sun.nio.zipfs.ZipPath;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.file.FileRef;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ZipFileSystemProvider
extends FileSystemProvider {
    private final Map<Path, ZipFileSystem> filesystems = new HashMap<Path, ZipFileSystem>();

    @Override
    public String getScheme() {
        return "zip";
    }

    protected Path uriToPath(URI uRI) {
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme is not '" + this.getScheme() + "'");
        }
        try {
            return Paths.get(new URI("file", uRI.getHost(), uRI.getPath(), null)).toAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
    }

    @Override
    public FileSystem newFileSystem(URI uRI, Map<String, ?> map) throws IOException {
        return this.newFileSystem(this.uriToPath(uRI), map);
    }

    public FileSystem newFileSystem(FileRef fileRef, Map<String, ?> map) throws IOException {
        if (!(fileRef instanceof Path)) {
            throw new UnsupportedOperationException();
        }
        Path path = (Path)fileRef;
        if (!path.toUri().getScheme().equalsIgnoreCase("file")) {
            throw new UnsupportedOperationException();
        }
        return this.newFileSystem(path, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private FileSystem newFileSystem(Path path, Map<String, ?> map) throws IOException {
        Map<Path, ZipFileSystem> map2 = this.filesystems;
        synchronized (map2) {
            Path path2 = null;
            if (path.exists() && this.filesystems.containsKey(path2 = path.toRealPath(true))) {
                throw new FileSystemAlreadyExistsException();
            }
            ZipFileSystem zipFileSystem = new ZipFileSystem(this, path, map);
            if (path2 == null) {
                path2 = path.toRealPath(true);
            }
            this.filesystems.put(path2, zipFileSystem);
            return zipFileSystem;
        }
    }

    @Override
    public Path getPath(URI uRI) {
        FileSystem fileSystem = this.getFileSystem(uRI);
        String string = uRI.getFragment();
        if (string == null) {
            throw new IllegalArgumentException("URI: " + uRI + " does not contain path fragment ex. zip:///c:/foo.zip#/BAR");
        }
        return fileSystem.getPath(string);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        if (path instanceof ZipPath) {
            return ((ZipPath)path).newFileChannel(set, fileAttributeArray);
        }
        throw new ProviderMismatchException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem getFileSystem(URI uRI) {
        Map<Path, ZipFileSystem> map = this.filesystems;
        synchronized (map) {
            ZipFileSystem zipFileSystem = null;
            try {
                zipFileSystem = this.filesystems.get(this.uriToPath(uRI).toRealPath(true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (zipFileSystem == null) {
                throw new FileSystemNotFoundException();
            }
            return zipFileSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileSystem(Path path) throws IOException {
        Map<Path, ZipFileSystem> map = this.filesystems;
        synchronized (map) {
            this.filesystems.remove(path.toRealPath(true));
        }
    }
}

