/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.api.server.SDDocumentSource;
import com.sun.xml.internal.ws.api.server.ServiceDefinition;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.MetadataUtil;
import com.sun.xml.internal.ws.util.pipe.AbstractSchemaValidationTube;
import com.sun.xml.internal.ws.util.xml.MetadataDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ServerSchemaValidationTube
extends AbstractSchemaValidationTube {
    private static final Logger LOGGER = Logger.getLogger(ServerSchemaValidationTube.class.getName());
    private final Schema schema;
    private final Validator validator;
    private final boolean noValidation;
    private final SEIModel seiModel;
    private final WSDLPort wsdlPort;

    public ServerSchemaValidationTube(WSEndpoint endpoint, WSBinding binding, SEIModel seiModel, WSDLPort wsdlPort, Tube next) {
        super(binding, next);
        Source[] sources;
        this.seiModel = seiModel;
        this.wsdlPort = wsdlPort;
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            sf.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (Source source : sources = this.getSchemaSources(endpoint.getServiceDefinition())) {
            LOGGER.fine("Constructing validation Schema from = " + source.getSystemId());
        }
        if (sources.length != 0) {
            this.noValidation = false;
            sf.setResourceResolver(new MetadataResolverImpl(endpoint.getServiceDefinition()));
            try {
                this.schema = sf.newSchema(sources);
            }
            catch (SAXException e) {
                throw new WebServiceException(e);
            }
            this.validator = this.schema.newValidator();
            try {
                this.validator.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
            }
            catch (Exception e) {}
        } else {
            this.noValidation = true;
            this.schema = null;
            this.validator = null;
        }
    }

    private Source[] getSchemaSources(ServiceDefinition sd) {
        String primary = sd.getPrimary().getURL().toExternalForm();
        MetadataResolverImpl mdresolver = new MetadataResolverImpl(sd);
        return super.getSchemaSources(primary, mdresolver);
    }

    @Override
    protected Validator getValidator() {
        return this.validator;
    }

    @Override
    protected boolean isNoValidation() {
        return this.noValidation;
    }

    @Override
    public NextAction processRequest(Packet request) {
        if (this.isNoValidation() || !request.getMessage().hasPayload() || request.getMessage().isFault()) {
            return super.processRequest(request);
        }
        try {
            this.doProcess(request);
        }
        catch (SAXException se) {
            LOGGER.log(Level.WARNING, "Client Request doesn't pass Service's Schema Validation", se);
            SOAPVersion soapVersion = this.binding.getSOAPVersion();
            Message faultMsg = SOAPFaultBuilder.createSOAPFaultMessage(soapVersion, null, se, soapVersion.faultCodeClient);
            return this.doReturnWith(request.createServerResponse(faultMsg, this.wsdlPort, this.seiModel, this.binding));
        }
        return super.processRequest(request);
    }

    @Override
    public NextAction processResponse(Packet response) {
        if (this.isNoValidation() || response.getMessage() == null || !response.getMessage().hasPayload() || response.getMessage().isFault()) {
            return super.processResponse(response);
        }
        try {
            this.doProcess(response);
        }
        catch (SAXException se) {
            throw new WebServiceException(se);
        }
        return super.processResponse(response);
    }

    protected ServerSchemaValidationTube(ServerSchemaValidationTube that, TubeCloner cloner) {
        super(that, cloner);
        this.schema = that.schema;
        this.validator = this.schema.newValidator();
        this.noValidation = that.noValidation;
        this.seiModel = that.seiModel;
        this.wsdlPort = that.wsdlPort;
    }

    @Override
    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new ServerSchemaValidationTube(this, cloner);
    }

    private class MetadataResolverImpl
    implements MetadataUtil.MetadataResolver,
    LSResourceResolver {
        Map<String, SDDocument> docs = new HashMap<String, SDDocument>();

        MetadataResolverImpl(ServiceDefinition sd) {
            for (SDDocument doc : sd) {
                this.docs.put(doc.getURL().toExternalForm(), doc);
            }
        }

        @Override
        public SDDocument resolveEntity(String systemId) {
            SDDocument sdi = this.docs.get(systemId);
            if (sdi == null) {
                SDDocumentSource sds;
                try {
                    sds = SDDocumentSource.create(new URL(systemId));
                }
                catch (MalformedURLException e) {
                    throw new WebServiceException(e);
                }
                sdi = MetadataDocument.create(sds, new QName(""), new QName(""));
                this.docs.put(systemId, sdi);
            }
            return sdi;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            LOGGER.fine("type=" + type + " namespaceURI=" + namespaceURI + " publicId=" + publicId + " systemId=" + systemId + " baseURI=" + baseURI);
            try {
                URL base = baseURI == null ? null : new URL(baseURI);
                final URL rel = new URL(base, systemId);
                final SDDocument doc = this.docs.get(rel.toExternalForm());
                if (doc != null) {
                    return new LSInput(){

                        @Override
                        public Reader getCharacterStream() {
                            return null;
                        }

                        @Override
                        public void setCharacterStream(Reader characterStream) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public InputStream getByteStream() {
                            ByteArrayBuffer bab = new ByteArrayBuffer();
                            try {
                                doc.writeTo(null, ServerSchemaValidationTube.this.resolver, bab);
                            }
                            catch (IOException ioe) {
                                throw new WebServiceException(ioe);
                            }
                            return bab.newInputStream();
                        }

                        @Override
                        public void setByteStream(InputStream byteStream) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getStringData() {
                            return null;
                        }

                        @Override
                        public void setStringData(String stringData) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getSystemId() {
                            return rel.toExternalForm();
                        }

                        @Override
                        public void setSystemId(String systemId) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getPublicId() {
                            return null;
                        }

                        @Override
                        public void setPublicId(String publicId) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getBaseURI() {
                            return rel.toExternalForm();
                        }

                        @Override
                        public void setBaseURI(String baseURI) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getEncoding() {
                            return null;
                        }

                        @Override
                        public void setEncoding(String encoding) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean getCertifiedText() {
                            return false;
                        }

                        @Override
                        public void setCertifiedText(boolean certifiedText) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception in LSResourceResolver impl", e);
            }
            LOGGER.fine("Don't know about systemId=" + systemId + " baseURI=" + baseURI);
            return null;
        }
    }
}

