/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOVecWrapper;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Util;

class IOUtil {
    private IOUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int write(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer, l, nativeDispatcher, object);
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(n3);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            byteBuffer.position(n);
            int n4 = IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer2, l, nativeDispatcher, object);
            if (n4 > 0) {
                byteBuffer.position(n + n4);
            }
            int n5 = n4;
            return n5;
        }
        finally {
            Util.offerFirstTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private static int writeFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = 0;
        if (n3 == 0) {
            return 0;
        }
        n4 = l != -1L ? nativeDispatcher.pwrite(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3, l, object) : nativeDispatcher.write(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3);
        if (n4 > 0) {
            byteBuffer.position(n + n4);
        }
        return n4;
    }

    static long write(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        return IOUtil.write(fileDescriptor, byteBufferArray, 0, byteBufferArray.length, nativeDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long write(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, int n, int n2, NativeDispatcher nativeDispatcher) throws IOException {
        int n3;
        IOVecWrapper iOVecWrapper = IOVecWrapper.get(n2);
        boolean bl = false;
        int n4 = 0;
        try {
            long l;
            ByteBuffer byteBuffer;
            int n5;
            int n6 = n + n2;
            for (int i = n; i < n6; ++i) {
                ByteBuffer byteBuffer2 = byteBufferArray[i];
                n3 = byteBuffer2.position();
                int n7 = byteBuffer2.limit();
                assert (n3 <= n7);
                int n8 = n5 = n3 <= n7 ? n7 - n3 : 0;
                if (n5 <= 0) continue;
                iOVecWrapper.setBuffer(n4, byteBuffer2, n3, n5);
                if (!(byteBuffer2 instanceof DirectBuffer)) {
                    byteBuffer = Util.getTemporaryDirectBuffer(n5);
                    byteBuffer.put(byteBuffer2);
                    byteBuffer.flip();
                    iOVecWrapper.setShadow(n4, byteBuffer);
                    byteBuffer2.position(n3);
                    byteBuffer2 = byteBuffer;
                    n3 = byteBuffer.position();
                }
                iOVecWrapper.putBase(n4, ((DirectBuffer)((Object)byteBuffer2)).address() + (long)n3);
                iOVecWrapper.putLen(n4, n5);
                ++n4;
            }
            if (n4 == 0) {
                long l2 = 0L;
                return l2;
            }
            long l3 = l = nativeDispatcher.writev(fileDescriptor, iOVecWrapper.address, n4);
            for (n5 = 0; n5 < n4; ++n5) {
                if (l3 > 0L) {
                    byteBuffer = iOVecWrapper.getBuffer(n5);
                    int n9 = iOVecWrapper.getPosition(n5);
                    int n10 = iOVecWrapper.getRemaining(n5);
                    int n11 = l3 > (long)n10 ? n10 : (int)l3;
                    byteBuffer.position(n9 + n11);
                    l3 -= (long)n11;
                }
                if ((byteBuffer = iOVecWrapper.getShadow(n5)) != null) {
                    Util.offerLastTemporaryDirectBuffer(byteBuffer);
                }
                iOVecWrapper.clearRefs(n5);
            }
            bl = true;
            long l4 = l;
            return l4;
        }
        finally {
            if (!bl) {
                for (n3 = 0; n3 < n4; ++n3) {
                    ByteBuffer byteBuffer = iOVecWrapper.getShadow(n3);
                    if (byteBuffer != null) {
                        Util.offerLastTemporaryDirectBuffer(byteBuffer);
                    }
                    iOVecWrapper.clearRefs(n3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int read(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer, l, nativeDispatcher, object);
        }
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
            int n = IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer2, l, nativeDispatcher, object);
            byteBuffer2.flip();
            if (n > 0) {
                byteBuffer.put(byteBuffer2);
            }
            int n2 = n;
            return n2;
        }
        finally {
            Util.offerFirstTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private static int readIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            return 0;
        }
        int n5 = 0;
        n5 = l != -1L ? nativeDispatcher.pread(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n, l, object) : nativeDispatcher.read(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    static long read(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        return IOUtil.read(fileDescriptor, byteBufferArray, 0, byteBufferArray.length, nativeDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long read(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, int n, int n2, NativeDispatcher nativeDispatcher) throws IOException {
        int n3;
        IOVecWrapper iOVecWrapper = IOVecWrapper.get(n2);
        boolean bl = false;
        int n4 = 0;
        try {
            long l;
            ByteBuffer byteBuffer;
            int n5;
            int n6 = n + n2;
            for (int i = n; i < n6; ++i) {
                ByteBuffer byteBuffer2 = byteBufferArray[i];
                if (byteBuffer2.isReadOnly()) {
                    throw new IllegalArgumentException("Read-only buffer");
                }
                n3 = byteBuffer2.position();
                int n7 = byteBuffer2.limit();
                assert (n3 <= n7);
                int n8 = n5 = n3 <= n7 ? n7 - n3 : 0;
                if (n5 <= 0) continue;
                iOVecWrapper.setBuffer(n4, byteBuffer2, n3, n5);
                if (!(byteBuffer2 instanceof DirectBuffer)) {
                    byteBuffer = Util.getTemporaryDirectBuffer(n5);
                    iOVecWrapper.setShadow(n4, byteBuffer);
                    byteBuffer2 = byteBuffer;
                    n3 = byteBuffer.position();
                }
                iOVecWrapper.putBase(n4, ((DirectBuffer)((Object)byteBuffer2)).address() + (long)n3);
                iOVecWrapper.putLen(n4, n5);
                ++n4;
            }
            if (n4 == 0) {
                long l2 = 0L;
                return l2;
            }
            long l3 = l = nativeDispatcher.readv(fileDescriptor, iOVecWrapper.address, n4);
            for (n5 = 0; n5 < n4; ++n5) {
                byteBuffer = iOVecWrapper.getShadow(n5);
                if (l3 > 0L) {
                    int n9;
                    ByteBuffer byteBuffer3 = iOVecWrapper.getBuffer(n5);
                    int n10 = iOVecWrapper.getRemaining(n5);
                    int n11 = n9 = l3 > (long)n10 ? n10 : (int)l3;
                    if (byteBuffer == null) {
                        int n12 = iOVecWrapper.getPosition(n5);
                        byteBuffer3.position(n12 + n9);
                    } else {
                        byteBuffer.limit(byteBuffer.position() + n9);
                        byteBuffer3.put(byteBuffer);
                    }
                    l3 -= (long)n9;
                }
                if (byteBuffer != null) {
                    Util.offerLastTemporaryDirectBuffer(byteBuffer);
                }
                iOVecWrapper.clearRefs(n5);
            }
            bl = true;
            long l4 = l;
            return l4;
        }
        finally {
            if (!bl) {
                for (n3 = 0; n3 < n4; ++n3) {
                    ByteBuffer byteBuffer = iOVecWrapper.getShadow(n3);
                    if (byteBuffer != null) {
                        Util.offerLastTemporaryDirectBuffer(byteBuffer);
                    }
                    iOVecWrapper.clearRefs(n3);
                }
            }
        }
    }

    static FileDescriptor newFD(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        IOUtil.setfdVal(fileDescriptor, n);
        return fileDescriptor;
    }

    static native boolean randomBytes(byte[] var0);

    static native long makePipe(boolean var0);

    static native boolean drain(int var0) throws IOException;

    static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    static native int fdVal(FileDescriptor var0);

    static native void setfdVal(FileDescriptor var0, int var1);

    static native void initIDs();

    static {
        Util.load();
    }
}

