/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.kerberos.KerberosKey;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.EncryptionKey;

public class Krb5AcceptCredential
extends KerberosKey
implements Krb5CredElement {
    private static final long serialVersionUID = 7714332137352567952L;
    private Krb5NameElement name;
    private EncryptionKey[] krb5EncryptionKeys;

    private Krb5AcceptCredential(Krb5NameElement krb5NameElement, KerberosKey[] kerberosKeyArray) {
        super(kerberosKeyArray[0].getPrincipal(), kerberosKeyArray[0].getEncoded(), kerberosKeyArray[0].getKeyType(), kerberosKeyArray[0].getVersionNumber());
        this.name = krb5NameElement;
        this.krb5EncryptionKeys = new EncryptionKey[kerberosKeyArray.length];
        for (int i = 0; i < kerberosKeyArray.length; ++i) {
            this.krb5EncryptionKeys[i] = new EncryptionKey(kerberosKeyArray[i].getEncoded(), kerberosKeyArray[i].getKeyType(), new Integer(kerberosKeyArray[i].getVersionNumber()));
        }
    }

    static Krb5AcceptCredential getInstance(final GSSCaller gSSCaller, Krb5NameElement krb5NameElement) throws GSSException {
        KerberosKey[] kerberosKeyArray;
        final String string = krb5NameElement == null ? null : krb5NameElement.getKrb5PrincipalName().getName();
        final AccessControlContext accessControlContext = AccessController.getContext();
        try {
            kerberosKeyArray = AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosKey[]>(){

                @Override
                public KerberosKey[] run() throws Exception {
                    return Krb5Util.getKeys(gSSCaller == GSSCaller.CALLER_UNKNOWN ? GSSCaller.CALLER_ACCEPT : gSSCaller, string, accessControlContext);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            GSSException gSSException = new GSSException(13, -1, "Attempt to obtain new ACCEPT credentials failed!");
            gSSException.initCause(privilegedActionException.getException());
            throw gSSException;
        }
        if (kerberosKeyArray == null || kerberosKeyArray.length == 0) {
            throw new GSSException(13, -1, "Failed to find any Kerberos Key");
        }
        if (krb5NameElement == null) {
            String string2 = kerberosKeyArray[0].getPrincipal().getName();
            krb5NameElement = Krb5NameElement.getInstance(string2, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
        }
        return new Krb5AcceptCredential(krb5NameElement, kerberosKeyArray);
    }

    @Override
    public final GSSNameSpi getName() throws GSSException {
        return this.name;
    }

    @Override
    public int getInitLifetime() throws GSSException {
        return 0;
    }

    @Override
    public int getAcceptLifetime() throws GSSException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isInitiatorCredential() throws GSSException {
        return false;
    }

    @Override
    public boolean isAcceptorCredential() throws GSSException {
        return true;
    }

    @Override
    public final Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    @Override
    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    EncryptionKey[] getKrb5EncryptionKeys() {
        return this.krb5EncryptionKeys;
    }

    @Override
    public void dispose() throws GSSException {
        try {
            this.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            GSSException gSSException = new GSSException(11, -1, "Could not destroy credentials - " + destroyFailedException.getMessage());
            gSSException.initCause(destroyFailedException);
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (this.krb5EncryptionKeys != null) {
            for (int i = 0; i < this.krb5EncryptionKeys.length; ++i) {
                this.krb5EncryptionKeys[i].destroy();
            }
            this.krb5EncryptionKeys = null;
        }
        super.destroy();
    }
}

