/*
 * Decompiled with CFR 0.152.
 */
package junit.samples;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class VectorTest
extends TestCase {
    protected Vector fEmpty;
    protected Vector fFull;

    public static void main(String[] args) {
        TestRunner.run(VectorTest.suite());
    }

    protected void setUp() {
        this.fEmpty = new Vector();
        this.fFull = new Vector();
        this.fFull.addElement(new Integer(1));
        this.fFull.addElement(new Integer(2));
        this.fFull.addElement(new Integer(3));
    }

    public static Test suite() {
        return new TestSuite(VectorTest.class);
    }

    public void testCapacity() {
        int size = this.fFull.size();
        for (int i = 0; i < 100; ++i) {
            this.fFull.addElement(new Integer(i));
        }
        VectorTest.assertTrue(this.fFull.size() == 100 + size);
    }

    public void testClone() {
        Vector clone = (Vector)this.fFull.clone();
        VectorTest.assertTrue(clone.size() == this.fFull.size());
        VectorTest.assertTrue(clone.contains(new Integer(1)));
    }

    public void testContains() {
        VectorTest.assertTrue(this.fFull.contains(new Integer(1)));
        VectorTest.assertTrue(!this.fEmpty.contains(new Integer(1)));
    }

    public void testElementAt() {
        Integer i = (Integer)this.fFull.elementAt(0);
        VectorTest.assertTrue(i == 1);
        try {
            this.fFull.elementAt(this.fFull.size());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        VectorTest.fail("Should raise an ArrayIndexOutOfBoundsException");
    }

    public void testRemoveAll() {
        this.fFull.removeAllElements();
        this.fEmpty.removeAllElements();
        VectorTest.assertTrue(this.fFull.isEmpty());
        VectorTest.assertTrue(this.fEmpty.isEmpty());
    }

    public void testRemoveElement() {
        this.fFull.removeElement(new Integer(3));
        VectorTest.assertTrue(!this.fFull.contains(new Integer(3)));
    }
}

