/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Filter;

public class RangeFilter
extends Filter {
    private String fieldName;
    private String lowerTerm;
    private String upperTerm;
    private boolean includeLower;
    private boolean includeUpper;

    public RangeFilter(String fieldName, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        this.fieldName = fieldName;
        this.lowerTerm = lowerTerm;
        this.upperTerm = upperTerm;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
        if (null == lowerTerm && null == upperTerm) {
            throw new IllegalArgumentException("At least one value must be non-null");
        }
        if (includeLower && null == lowerTerm) {
            throw new IllegalArgumentException("The lower bound must be non-null to be inclusive");
        }
        if (includeUpper && null == upperTerm) {
            throw new IllegalArgumentException("The upper bound must be non-null to be inclusive");
        }
    }

    public static RangeFilter Less(String fieldName, String upperTerm) {
        return new RangeFilter(fieldName, null, upperTerm, false, true);
    }

    public static RangeFilter More(String fieldName, String lowerTerm) {
        return new RangeFilter(fieldName, lowerTerm, null, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader reader) throws IOException {
        TermEnum enumerator;
        BitSet bits;
        block9: {
            bits = new BitSet(reader.maxDoc());
            enumerator = null != this.lowerTerm ? reader.terms(new Term(this.fieldName, this.lowerTerm)) : reader.terms(new Term(this.fieldName, ""));
            if (enumerator.term() != null) break block9;
            BitSet bitSet = bits;
            Object var11_6 = null;
            enumerator.close();
            return bitSet;
        }
        try {
            boolean checkLower = false;
            if (!this.includeLower) {
                checkLower = true;
            }
            TermDocs termDocs = reader.termDocs();
            try {
                Term term;
                while ((term = enumerator.term()) != null && term.field().equals(this.fieldName)) {
                    if (!checkLower || null == this.lowerTerm || term.text().compareTo(this.lowerTerm) > 0) {
                        int compare;
                        checkLower = false;
                        if (this.upperTerm != null && ((compare = this.upperTerm.compareTo(term.text())) < 0 || !this.includeUpper && compare == 0)) break;
                        termDocs.seek(enumerator.term());
                        while (termDocs.next()) {
                            bits.set(termDocs.doc());
                        }
                    }
                    if (enumerator.next()) continue;
                    break;
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                termDocs.close();
                throw throwable;
            }
            termDocs.close();
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            enumerator.close();
            throw throwable;
        }
        enumerator.close();
        return bits;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fieldName);
        buffer.append(":");
        buffer.append(this.includeLower ? "[" : "{");
        if (null != this.lowerTerm) {
            buffer.append(this.lowerTerm);
        }
        buffer.append("-");
        if (null != this.upperTerm) {
            buffer.append(this.upperTerm);
        }
        buffer.append(this.includeUpper ? "]" : "}");
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeFilter)) {
            return false;
        }
        RangeFilter other = (RangeFilter)o;
        if (!this.fieldName.equals(other.fieldName) || this.includeLower != other.includeLower || this.includeUpper != other.includeUpper) {
            return false;
        }
        if (this.lowerTerm != null ? !this.lowerTerm.equals(other.lowerTerm) : other.lowerTerm != null) {
            return false;
        }
        return !(this.upperTerm != null ? !this.upperTerm.equals(other.upperTerm) : other.upperTerm != null);
    }

    public int hashCode() {
        int h = this.fieldName.hashCode();
        h ^= this.lowerTerm != null ? this.lowerTerm.hashCode() : -1225987966;
        h = h << 1 | h >>> 31;
        h ^= this.upperTerm != null ? this.upperTerm.hashCode() : -1849769278;
        return h ^= (this.includeLower ? -729499341 : 0) ^ (this.includeUpper ? 1793336236 : 0);
    }
}

