/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.ui.console.IConsoleFactory;
import org.python.pydev.core.Tuple3;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.newconsole.PydevConsole;
import org.python.pydev.debug.newconsole.PydevConsoleCommunication;
import org.python.pydev.debug.newconsole.PydevConsoleInterpreter;
import org.python.pydev.debug.newconsole.env.IProcessFactory;
import org.python.pydev.debug.newconsole.env.UserCanceledException;
import org.python.pydev.dltk.console.ui.ScriptConsole;
import org.python.pydev.dltk.console.ui.ScriptConsoleManager;
import org.python.pydev.plugin.PydevPlugin;

public class PydevConsoleFactory
implements IConsoleFactory {
    public void openConsole() {
        this.createConsole();
    }

    public PydevConsole createConsole() {
        ScriptConsoleManager manager = ScriptConsoleManager.getInstance();
        try {
            PydevConsoleInterpreter interpreter = PydevConsoleFactory.createDefaultPydevInterpreter();
            if (interpreter != null) {
                PydevConsole console = new PydevConsole(interpreter);
                manager.add((ScriptConsole)console, true);
                return console;
            }
        }
        catch (Exception e) {
            PydevPlugin.log((Throwable)e);
        }
        return null;
    }

    public static PydevConsoleInterpreter createDefaultPydevInterpreter() throws Exception, UserCanceledException {
        IProcessFactory iprocessFactory = new IProcessFactory();
        Tuple3<Launch, Process, Integer> launchAndProcess = iprocessFactory.createInteractiveLaunch();
        if (launchAndProcess == null) {
            return null;
        }
        final ILaunch launch = (ILaunch)launchAndProcess.o1;
        if (launch == null) {
            return null;
        }
        PydevConsoleInterpreter consoleInterpreter = new PydevConsoleInterpreter();
        int port = Integer.parseInt(launch.getAttribute("INTERACTIVE_LAUNCH_PORT"));
        consoleInterpreter.setConsoleCommunication(new PydevConsoleCommunication(port, (Process)launchAndProcess.o2, (Integer)launchAndProcess.o3));
        consoleInterpreter.setNaturesUsed(iprocessFactory.getNaturesUsed());
        PydevDebugPlugin.getDefault().addConsoleLaunch(launch);
        consoleInterpreter.addCloseOperation(new Runnable(){

            public void run() {
                PydevDebugPlugin.getDefault().removeConsoleLaunch(launch);
            }
        });
        return consoleInterpreter;
    }
}

