/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.python.pydev.core.ICallback;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.bundle.BundleInfo;
import org.python.pydev.core.bundle.IBundleInfo;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.ui.interpreters.JythonInterpreterManager;
import org.python.pydev.ui.interpreters.PythonInterpreterManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevPlugin
extends AbstractUIPlugin
implements Preferences.IPropertyChangeListener {
    public static final String version = "1.4.6.2788";
    public static IBundleInfo info;
    private static IInterpreterManager pythonInterpreterManager;
    private static IInterpreterManager jythonInterpreterManager;
    private static PydevPlugin plugin;
    private ResourceBundle resourceBundle;
    public static final String DEFAULT_PYDEV_SCOPE = "org.python.pydev";
    private static final String[][] IMAGES;

    static {
        IMAGES = new String[][]{{"icons/save.gif", "save.gif"}, {"icons/terminate.gif", "terminate.gif"}};
    }

    public static IBundleInfo getBundleInfo() {
        if (info == null) {
            info = new BundleInfo(PydevPlugin.getDefault().getBundle());
        }
        return info;
    }

    public static void setBundleInfo(IBundleInfo b) {
        info = b;
    }

    public static void setPythonInterpreterManager(IInterpreterManager interpreterManager) {
        pythonInterpreterManager = interpreterManager;
    }

    public static IInterpreterManager getPythonInterpreterManager() {
        return PydevPlugin.getPythonInterpreterManager(false);
    }

    public static IInterpreterManager getPythonInterpreterManager(boolean haltOnStub) {
        return pythonInterpreterManager;
    }

    public static void setJythonInterpreterManager(IInterpreterManager interpreterManager) {
        jythonInterpreterManager = interpreterManager;
    }

    public static IInterpreterManager getJythonInterpreterManager() {
        return PydevPlugin.getJythonInterpreterManager(false);
    }

    public static IInterpreterManager getJythonInterpreterManager(boolean haltOnStub) {
        return jythonInterpreterManager;
    }

    public static IInterpreterManager getInterpreterManager(IPythonNature nature) {
        try {
            if (nature.isJython()) {
                return jythonInterpreterManager;
            }
            if (nature.isPython()) {
                return pythonInterpreterManager;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Unable to get the interpreter manager for the nature passed.");
    }

    public PydevPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.python.pydev.PyDevPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        Preferences preferences = plugin.getPluginPreferences();
        preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        PydevPlugin.setPythonInterpreterManager(new PythonInterpreterManager(preferences));
        PydevPlugin.setJythonInterpreterManager(new JythonInterpreterManager(preferences));
    }

    public static boolean isPythonInterpreterInitialized() {
        return true;
    }

    public static boolean isJythonInterpreterInitialized() {
        return true;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            AbstractShell.shutdownAllShells();
            Preferences preferences = plugin.getPluginPreferences();
            preferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
            for (PythonNature nature : PythonNature.getInitializedPythonNatures()) {
                try {
                    nature.saveAstManager();
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                }
            }
        }
        finally {
            super.stop(context);
        }
    }

    public static PydevPlugin getDefault() {
        return plugin;
    }

    public static String getPluginID() {
        return PydevPlugin.getBundleInfo().getPluginID();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Status makeStatus(int errorLevel, String message, Throwable e) {
        return new Status(errorLevel, PydevPlugin.getPluginID(), errorLevel, message, e);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = plugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
    }

    public static void log(String message, Throwable e) {
        PydevPlugin.log(4, message, e);
    }

    public static void log(int errorLevel, String message, Throwable e) {
        PydevPlugin.log(errorLevel, message, e, true);
    }

    public static void log(String message, Throwable e, boolean printToConsole) {
        PydevPlugin.log(4, message, e, printToConsole);
    }

    public static void logInfo(Exception e) {
        PydevPlugin.log(1, e.getMessage(), e, true);
    }

    public static void log(int errorLevel, String message, Throwable e, boolean printToConsole) {
        if (printToConsole) {
            if (errorLevel == 4) {
                System.out.println("Error received...");
            } else {
                System.out.println("Log received...");
            }
            System.out.println(message);
            System.err.println(message);
            if (e != null) {
                e.printStackTrace();
            }
        }
        try {
            Status s = new Status(errorLevel, PydevPlugin.getPluginID(), errorLevel, message, e);
            PydevPlugin.getDefault().getLog().log((IStatus)s);
        }
        catch (Throwable throwable) {}
    }

    public static void log(IStatus status) {
        PydevPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PydevPlugin.log(e, true);
    }

    public static void log(Throwable e, boolean printToConsole) {
        PydevPlugin.log(4, e.getMessage() != null ? e.getMessage() : "No message gotten.", e, printToConsole);
    }

    public static void logInfo(String msg) {
        Status s = PydevPlugin.makeStatus(1, msg, null);
        PydevPlugin plug = PydevPlugin.getDefault();
        if (plug == null) {
            System.out.println(msg);
        } else {
            plug.getLog().log((IStatus)s);
        }
    }

    public static CoreException log(String msg) {
        Status s = PydevPlugin.makeStatus(4, msg, new RuntimeException(msg));
        CoreException e = new CoreException((IStatus)s);
        PydevPlugin.log(e);
        return e;
    }

    public static File getScriptWithinPySrc(String targetExec) throws CoreException {
        IPath relative = new Path("PySrc").addTrailingSeparator().append(targetExec);
        return PydevPlugin.getBundleInfo().getRelativePath(relative);
    }

    public static ImageCache getImageCache() {
        return PydevPlugin.getBundleInfo().getImageCache();
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        int i = 0;
        while (i < IMAGES.length) {
            URL url = PydevPlugin.getDefault().getBundle().getEntry(IMAGES[i][0]);
            registry.put(IMAGES[i][1], ImageDescriptor.createFromURL((URL)url));
            ++i;
        }
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    public static Tuple<SystemPythonNature, String> getInfoForFile(File file) {
        String modName = null;
        IInterpreterManager pythonInterpreterManager = PydevPlugin.getPythonInterpreterManager(false);
        IInterpreterManager jythonInterpreterManager = PydevPlugin.getJythonInterpreterManager(false);
        if (pythonInterpreterManager == null || jythonInterpreterManager == null) {
            return null;
        }
        SystemPythonNature systemPythonNature = null;
        SystemPythonNature pySystemPythonNature = null;
        SystemPythonNature jySystemPythonNature = null;
        try {
            pySystemPythonNature = systemPythonNature = new SystemPythonNature(pythonInterpreterManager);
            modName = systemPythonNature.resolveModule(file);
        }
        catch (Exception exception) {}
        if (modName == null) {
            try {
                jySystemPythonNature = systemPythonNature = new SystemPythonNature(jythonInterpreterManager);
                modName = systemPythonNature.resolveModule(file);
            }
            catch (Exception exception) {}
        }
        if (modName != null) {
            return new Tuple((Object)systemPythonNature, (Object)modName);
        }
        try {
            pythonInterpreterManager.getDefaultInterpreter();
            modName = PydevPlugin.getModNameFromFile(file);
            return new Tuple((Object)pySystemPythonNature, (Object)modName);
        }
        catch (Exception exception) {
            try {
                jythonInterpreterManager.getDefaultInterpreter();
                modName = PydevPlugin.getModNameFromFile(file);
                return new Tuple((Object)jySystemPythonNature, (Object)modName);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    private static String getModNameFromFile(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int i = name.indexOf(46);
        if (i != -1) {
            return name.substring(0, i);
        }
        return name;
    }

    public static String getIResourceOSString(IResource f) {
        IPath rawLocation = f.getRawLocation();
        if (rawLocation == null) {
            return null;
        }
        String fullPath = rawLocation.toOSString();
        File file = new File(fullPath);
        if (file.exists()) {
            return REF.getFileAbsolutePath((File)file);
        }
        IProject project = f.getProject();
        IPath location = project.getLocation();
        File projectFile = location.toFile();
        if (projectFile.exists()) {
            String projectFilePath = REF.getFileAbsolutePath((File)projectFile);
            if (fullPath.startsWith(projectFilePath)) {
                return fullPath;
            }
            if (fullPath.toLowerCase().startsWith(projectFilePath.toLowerCase())) {
                String relativePart = fullPath.substring(projectFilePath.length());
                return new StringBuffer(String.valueOf(projectFilePath)).append(relativePart).toString();
            }
        }
        return fullPath;
    }

    public static void writeToWorkspaceMetadata(Object obj, String fileName) {
        Bundle bundle = Platform.getBundle((String)DEFAULT_PYDEV_SCOPE);
        IPath path = Platform.getStateLocation((Bundle)bundle);
        path = path.addTrailingSeparator();
        path = path.append(fileName);
        try {
            FileOutputStream out = new FileOutputStream(path.toFile());
            REF.writeToStreamAndCloseIt((Object)obj, (OutputStream)out);
        }
        catch (Exception e) {
            PydevPlugin.log(e);
            throw new RuntimeException(e);
        }
    }

    public static Object readFromWorkspaceMetadata(String fileName) {
        Bundle bundle = Platform.getBundle((String)DEFAULT_PYDEV_SCOPE);
        IPath path = Platform.getStateLocation((Bundle)bundle);
        path = path.addTrailingSeparator();
        path = path.append(fileName);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(path.toFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return REF.readFromInputStreamAndCloseIt((ICallback)new ICallback<Object, ObjectInputStream>(){

            public Object call(ObjectInputStream arg) {
                try {
                    return arg.readObject();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public /* synthetic */ Object call(Object object) {
                return this.call((ObjectInputStream)object);
            }
        }, (InputStream)fileInputStream);
    }
}

