##
# Continuation objects are generated by Kernel#callcc. They hold a return
# address and execution context, allowing a nonlocal return to the end of the
# callcc block from anywhere within a program.  Continuations are somewhat
# analogous to a structured version of C's setjmp/longjmp (although they
# contain more state, so you might consider them closer to threads).
#
# For instance:
#
#   arr = [ "Freddie", "Herbie", "Ron", "Max", "Ringo" ]
#   callcc{|$cc|}
#   puts(message = arr.shift)
#   $cc.call unless message =~ /Max/
#
# produces:
#
#   Freddie
#   Herbie
#   Ron
#   Max
#
# This (somewhat contrived) example allows the inner loop to abandon
# processing early:
#
#   callcc {|cont|
#     for i in 0..4
#       print "\n#{i}: "
#       for j in i*5...(i+1)*5
#         cont.call() if j == 17
#         printf "%3d", j
#       end
#     end
#   }
#   print "\n"
#
# produces:
#
#   0:   0  1  2  3  4
#   1:   5  6  7  8  9
#   2:  10 11 12 13 14
#   3:  15 16

class Continuation
#  def self.create(task=nil)
#    cont = self.allocate
#    cont.setup(task)
#    cont
#  end
#  
#  def setup(task=nil)
#    @task = task
#    @value = nil
#  end
#  
#  def call(*value)
#    task = @task.dup
#    if value.empty?
#      @value = nil
#    elsif value.size == 1
#      @value = value.pop
#    else
#      @value = value
#    end
#    Rubinius::Task.current = task
#  end
#
#  alias_method :[], :call
end

module Kernel

  def callcc
    raise NotImplementedError, "call/cc is not implemented!"
#    cont = Continuation.create
#    # Task#dup appears as though it returns nil in the dup'd
#    # task, kinda like fork().
#    task = Rubinius::Task.current.dup
#    if task
#      cont.task = task
#      yield cont
#    else
#      return cont.value
#    end
  end
  module_function :callcc
end
