/*
 * Decompiled with CFR 0.152.
 */
package tr.swing.editorpane;

import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import tr.swing.editorpane.Utils;

public class JEditorPaneExt
extends JEditorPane {
    private static final String CONTENT_TYPE_TEXT = "text/plain";
    private static final String CONTENT_TYPE_HTML = "text/html";
    private final EditorKit editorKitTEXT = JEditorPaneExt.createEditorKitForContentType("text/plain");
    private final EditorKit editorKitHTML = new HTMLEditorKit();
    final Document textDocument;
    private transient String text = "";

    public JEditorPaneExt() {
        super.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        super.setFont(new JTextField().getFont());
        super.setEditorKitForContentType(CONTENT_TYPE_TEXT, this.editorKitTEXT);
        super.setEditorKitForContentType(CONTENT_TYPE_HTML, this.editorKitHTML);
        super.setContentType(CONTENT_TYPE_TEXT);
        this.textDocument = super.getDocument();
        super.setEditable(true);
        super.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    e.consume();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
                if (e.getKeyCode() == 9 && e.isShiftDown()) {
                    e.consume();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                }
            }
        });
    }

    public void setEditable(boolean editable) {
        if (editable == super.isEditable()) {
            return;
        }
        if (editable) {
            super.setContentType(CONTENT_TYPE_TEXT);
            if (this.textDocument != null) {
                super.setDocument(this.textDocument);
            }
            super.setText(this.text);
            super.setEditable(true);
        } else {
            super.setEditable(false);
            this.text = super.getText();
            super.setContentType(CONTENT_TYPE_HTML);
            super.setText(Utils.text2html(this.text));
            if (this.hasFocus()) {
                this.transferFocus();
            }
        }
    }

    public String getText() {
        if (this.isEditable()) {
            return super.getText();
        }
        return this.text;
    }

    public void setText(String text) {
        if (this.isEditable()) {
            this.text = text;
            super.setText(text);
        } else {
            this.setEditable(true);
            this.text = text;
            super.setText(text);
            this.setEditable(false);
        }
    }
}

