/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.RequestInfo;

public class AccessLogValve
extends ValveBase
implements Lifecycle {
    private static final char MARK_EMPTY = '-';
    private String dateStamp = "";
    private String directory = "logs";
    protected static final String info = "org.apache.catalina.valves.AccessLogValve/1.1";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private boolean common = false;
    private boolean combined = false;
    private String pattern = null;
    private String prefix = "access_log.";
    private boolean rotatable = true;
    private StringManager sm = StringManager.getManager("org.apache.catalina.valves");
    private boolean started = false;
    private String suffix = "";
    private PrintWriter writer = null;
    private SimpleDateFormat fileDateFormatter = null;
    private static final TimeZone timezone = TimeZone.getDefault();
    private static final String timeZoneNoDST = AccessLogValve.calculateTimeZoneOffset(timezone.getRawOffset());
    private static final String timeZoneDST;
    private static ThreadLocal currentDateStruct;
    private static final char space = ' ';
    private boolean resolveHosts = false;
    private volatile long rotationLastChecked = 0L;
    private String condition = null;
    private String fileDateFormat = null;

    public AccessLogValve() {
        this.setPattern("common");
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getInfo() {
        return info;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            pattern = "";
        }
        if (pattern.equals("common")) {
            pattern = "%h %l %u %t \"%r\" %s %b";
        }
        if (pattern.equals("combined")) {
            pattern = "%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        this.pattern = pattern;
        this.common = this.pattern.equals("%h %l %u %t \"%r\" %s %b");
        this.combined = this.pattern.equals("%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setResolveHosts(boolean resolveHosts) {
        this.resolveHosts = resolveHosts;
    }

    public boolean isResolveHosts() {
        return this.resolveHosts;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    public void setFileDateFormat(String fileDateFormat) {
        this.fileDateFormat = fileDateFormat;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        long t1 = System.currentTimeMillis();
        this.getNext().invoke(request, response);
        long t2 = System.currentTimeMillis();
        long time = t2 - t1;
        if (this.condition != null && null != request.getRequest().getAttribute(this.condition)) {
            return;
        }
        AccessDateStruct struct = (AccessDateStruct)currentDateStruct.get();
        Date date = struct.getDate();
        StringBuffer result = new StringBuffer(128);
        if (this.common || this.combined) {
            if (this.isResolveHosts()) {
                result.append(request.getRemoteHost());
            } else {
                result.append(request.getRemoteAddr());
            }
            result.append(" - ");
            String value = request.getRemoteUser();
            if (value == null) {
                result.append("- ");
            } else {
                result.append(value);
                result.append(' ');
            }
            result.append(struct.getCurrentDateString());
            result.append(" \"");
            result.append(request.getMethod());
            result.append(' ');
            result.append(request.getRequestURI());
            if (request.getQueryString() != null) {
                result.append('?');
                result.append(request.getQueryString());
            }
            result.append(' ');
            result.append(request.getProtocol());
            result.append("\" ");
            result.append(response.getStatus());
            result.append(' ');
            long length = response.getContentCountLong();
            if (length <= 0L) {
                result.append('-');
            } else {
                result.append(length);
            }
            if (this.combined) {
                result.append(' ');
                result.append('\"');
                String referer = request.getHeader("referer");
                if (referer != null) {
                    result.append(referer);
                } else {
                    result.append('-');
                }
                result.append('\"');
                result.append(' ');
                result.append('\"');
                String ua = request.getHeader("user-agent");
                if (ua != null) {
                    result.append(ua);
                } else {
                    result.append('-');
                }
                result.append('\"');
            }
        } else {
            boolean replace = false;
            for (int i = 0; i < this.pattern.length(); ++i) {
                char ch = this.pattern.charAt(i);
                if (replace) {
                    if ('{' == ch) {
                        int j;
                        for (j = i + 1; j < this.pattern.length() && '}' != this.pattern.charAt(j); ++j) {
                        }
                        if (j + 1 < this.pattern.length()) {
                            this.replace(result, this.pattern.substring(i + 1, ++j - 1), this.pattern.charAt(j), request, response);
                            i = j;
                        } else {
                            this.replace(result, ch, struct, request, response, time);
                        }
                    } else {
                        this.replace(result, ch, struct, request, response, time);
                    }
                    replace = false;
                    continue;
                }
                if (ch == '%') {
                    replace = true;
                    continue;
                }
                result.append(ch);
            }
        }
        this.log(result.toString(), date);
    }

    private synchronized void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.dateStamp = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message, Date date) {
        long systime;
        if (this.rotatable && (systime = System.currentTimeMillis()) - this.rotationLastChecked > 1000L) {
            AccessLogValve accessLogValve = this;
            synchronized (accessLogValve) {
                if (systime - this.rotationLastChecked > 1000L) {
                    this.rotationLastChecked = systime;
                    String tsDate = this.fileDateFormatter.format(new Date(systime));
                    if (!this.dateStamp.equals(tsDate)) {
                        this.close();
                        this.dateStamp = tsDate;
                        this.open();
                    }
                }
            }
        }
        AccessLogValve accessLogValve = this;
        synchronized (accessLogValve) {
            if (this.writer != null) {
                this.writer.println(message);
            }
        }
    }

    private static String lookup(String month) {
        int index;
        try {
            index = Integer.parseInt(month) - 1;
        }
        catch (Throwable t) {
            index = 0;
        }
        return months[index];
    }

    private synchronized void open() {
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(System.getProperty("catalina.base"), this.directory);
        }
        dir.mkdirs();
        try {
            String pathname = this.rotatable ? dir.getAbsolutePath() + File.separator + this.prefix + this.dateStamp + this.suffix : dir.getAbsolutePath() + File.separator + this.prefix + this.suffix;
            this.writer = new PrintWriter((Writer)new FileWriter(pathname, true), true);
        }
        catch (IOException e) {
            this.writer = null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replace(StringBuffer result, char pattern, AccessDateStruct struct, Request request, Response response, long time) {
        void var8_7;
        String value;
        if (pattern == 'a') {
            value = request.getRemoteAddr();
        } else if (pattern == 'A') {
            try {
                value = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable e) {
                value = "127.0.0.1";
            }
        } else {
            if (pattern == 'b') {
                long length = response.getContentCountLong();
                if (length <= 0L) {
                    result.append('-');
                    return;
                }
                result.append(length);
                return;
            }
            if (pattern == 'B') {
                result.append(response.getContentCountLong());
                return;
            }
            if (pattern == 'h') {
                value = request.getRemoteHost();
            } else if (pattern == 'H') {
                value = request.getProtocol();
            } else {
                if (pattern == 'l') {
                    result.append('-');
                    return;
                }
                if (pattern == 'm') {
                    value = request != null ? request.getMethod() : "";
                } else {
                    if (pattern == 'p') {
                        result.append(request.getServerPort());
                        return;
                    }
                    if (pattern == 'D') {
                        result.append(time);
                        return;
                    }
                    if (pattern == 'q') {
                        String query = null;
                        if (request != null) {
                            query = request.getQueryString();
                        }
                        if (query == null) return;
                        result.append('?').append(query);
                        return;
                    }
                    if (pattern == 'r') {
                        if (request == null) {
                            result.append("- - -");
                            return;
                        }
                        result.append(request.getMethod());
                        result.append(' ');
                        result.append(request.getRequestURI());
                        if (request.getQueryString() != null) {
                            result.append('?');
                            result.append(request.getQueryString());
                        }
                        result.append(' ');
                        result.append(request.getProtocol());
                        return;
                    }
                    if (pattern == 'S') {
                        if (request != null && request.getSession(false) != null) {
                            result.append(request.getSessionInternal(false).getIdInternal());
                            return;
                        }
                        result.append('-');
                        return;
                    }
                    if (pattern == 's') {
                        if (response != null) {
                            result.append(response.getStatus());
                            return;
                        }
                        result.append('-');
                        return;
                    }
                    if (pattern == 't') {
                        result.append(struct.getCurrentDateString());
                        return;
                    }
                    if (pattern == 'T') {
                        result.append(struct.formatTimeTaken(time));
                        return;
                    }
                    if (pattern == 'u') {
                        String value2;
                        if (request != null && (value2 = request.getRemoteUser()) != null) {
                            result.append(value2);
                            return;
                        }
                        result.append('-');
                        return;
                    }
                    if (pattern == 'U') {
                        if (request == null) {
                            result.append('-');
                            return;
                        }
                        value = request.getRequestURI();
                    } else if (pattern == 'v') {
                        value = request.getServerName();
                    } else {
                        if (pattern != 'I') {
                            result.append("???").append(pattern).append("???");
                            return;
                        }
                        RequestInfo info = request.getCoyoteRequest().getRequestProcessor();
                        if (info == null) {
                            result.append('-');
                            return;
                        }
                        value = info.getWorkerThreadName();
                    }
                }
            }
        }
        if (var8_7 == null) return;
        result.append((String)var8_7);
    }

    private void replace(StringBuffer result, String header, char type, Request request, Response response) {
        Object value;
        block1 : switch (type) {
            case 'i': {
                if (null != request) {
                    value = request.getHeader(header);
                    break;
                }
                value = "??";
                break;
            }
            case 'o': {
                if (null != response) {
                    String[] values = response.getHeaderValues(header);
                    if (values.length > 0) {
                        for (int i = 0; i < values.length; ++i) {
                            String string = values[i];
                            result.append(string);
                            if (i + 1 >= values.length) continue;
                            result.append(',');
                        }
                        return;
                    }
                    value = null;
                    break;
                }
                value = "??";
                break;
            }
            case 'c': {
                value = null;
                Cookie[] c = request.getCookies();
                for (int i = 0; c != null && i < c.length; ++i) {
                    if (!header.equals(c[i].getName())) continue;
                    value = c[i].getValue();
                    break block1;
                }
                break;
            }
            case 'r': {
                if (null != request) {
                    value = request.getAttribute(header);
                    break;
                }
                value = "??";
                break;
            }
            case 's': {
                HttpSession sess;
                value = null;
                if (null == request || null == (sess = request.getSession(false))) break;
                value = sess.getAttribute(header);
                break;
            }
            default: {
                value = "???";
            }
        }
        try {
            if (value != null) {
                result.append(value.toString());
            } else {
                result.append('-');
            }
        }
        catch (Throwable e) {
            result.append('-');
        }
    }

    private static String getTimeZone(Date date) {
        if (timezone.inDaylightTime(date)) {
            return timeZoneDST;
        }
        return timeZoneNoDST;
    }

    private static String calculateTimeZoneOffset(long offset) {
        StringBuffer tz = new StringBuffer();
        if (offset < 0L) {
            tz.append('-');
            offset = -offset;
        } else {
            tz.append('+');
        }
        long hourOffset = offset / 3600000L;
        long minuteOffset = offset / 60000L % 60L;
        if (hourOffset < 10L) {
            tz.append('0');
        }
        tz.append(hourOffset);
        if (minuteOffset < 10L) {
            tz.append('0');
        }
        tz.append(minuteOffset);
        return tz.toString();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.fileDateFormat == null || this.fileDateFormat.length() == 0) {
            this.fileDateFormat = "yyyy-MM-dd";
        }
        AccessLogValve accessLogValve = this;
        synchronized (accessLogValve) {
            this.fileDateFormatter = new SimpleDateFormat(this.fileDateFormat);
            this.fileDateFormatter.setTimeZone(timezone);
            this.dateStamp = this.fileDateFormatter.format(new Date());
        }
        this.open();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.close();
    }

    static {
        int offset = timezone.getDSTSavings();
        timeZoneDST = AccessLogValve.calculateTimeZoneOffset(timezone.getRawOffset() + offset);
        currentDateStruct = new ThreadLocal(){

            protected Object initialValue() {
                return new AccessDateStruct();
            }
        };
    }

    private static class AccessDateStruct {
        private Date currentDate = new Date();
        private String currentDateString = null;
        private SimpleDateFormat dayFormatter = new SimpleDateFormat("dd");
        private SimpleDateFormat monthFormatter = new SimpleDateFormat("MM");
        private SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");
        private SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
        private DecimalFormat timeTakenFormatter;

        public AccessDateStruct() {
            this.dayFormatter.setTimeZone(timezone);
            this.monthFormatter.setTimeZone(timezone);
            this.yearFormatter.setTimeZone(timezone);
            this.timeFormatter.setTimeZone(timezone);
        }

        public Date getDate() {
            long systime = System.currentTimeMillis();
            if (systime - this.currentDate.getTime() > 1000L) {
                this.currentDate.setTime(systime);
                this.currentDateString = null;
            }
            return this.currentDate;
        }

        public String getCurrentDateString() {
            if (this.currentDateString == null) {
                StringBuffer current = new StringBuffer(32);
                current.append('[');
                current.append(this.dayFormatter.format(this.currentDate));
                current.append('/');
                current.append(AccessLogValve.lookup(this.monthFormatter.format(this.currentDate)));
                current.append('/');
                current.append(this.yearFormatter.format(this.currentDate));
                current.append(':');
                current.append(this.timeFormatter.format(this.currentDate));
                current.append(' ');
                current.append(AccessLogValve.getTimeZone(this.currentDate));
                current.append(']');
                this.currentDateString = current.toString();
            }
            return this.currentDateString;
        }

        public String formatTimeTaken(long time) {
            if (this.timeTakenFormatter == null) {
                this.timeTakenFormatter = new DecimalFormat("0.000");
            }
            return this.timeTakenFormatter.format((double)time / 1000.0);
        }
    }
}

