<?php

class WikiParser_PluginArgumentParser
{
	function parse( $data )
	{
		$arguments = array();

		// Handle parameters one by one
		while( false !== $pos = strpos( $data, '=' ) ) {
			$name = substr( $data, 0, $pos );
			$name = ltrim( $name, ', ' );
			$name = trim( $name );
			$value = '';

			// Consider =>
			if( $data{$pos + 1} == '>' )
				$pos++;

			// Cut off the name part
			$data = substr( $data, $pos + 1 );
			$data = ltrim( $data );

			if( !empty($data) && $data{0} == '"' ) {
				$quote = 0;
				// Parameter between quotes, find closing quote not escaped by a \
				while( false !== $quote = strpos( $data, '"', $quote + 1 ) ) {
					if( $data{$quote - 1} != "\\" )
						break;
				}

				// Closing quote found
				if( $quote !== false ) {
					$value = substr( $data, 1, $quote - 1 );
					$arguments[$name] = str_replace( '\"', '"', $value );

					$data = substr( $data, $quote + 1 );
					continue;
				}

				// Not found, fallback as if opening quote was part of the string
			}

			// If last parameter, consider next as end of string
			if( preg_match( "/[\s,]\w+=/", $data, $parts ) ) {
				$end = strpos( $data, $parts[0] );
				$value = substr( $data, 0, $end );
				$data = substr( $data, $end );
			} else {
				$value = $data;
				$data = '';
			}

			$value = rtrim( $value, ', ' );
			$arguments[$name] = $value;
		}

		return $arguments;
	}
}
