/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.ba.URLClassPathRepository;
import edu.umd.cs.findbugs.util.Archive;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class URLClassPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Entry> entryList;
    private Set<String> classesThatCantBeFound = new HashSet<String>();

    public URLClassPath() {
        this.entryList = new LinkedList<Entry>();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addURL(String fileName) throws IOException {
        void var5_11;
        String fileExtension;
        boolean isArchive;
        String protocol = URLClassPath.getURLProtocol(fileName);
        if (protocol == null) {
            fileName = "file:" + fileName;
            protocol = "file";
        }
        boolean bl = isArchive = (fileExtension = URLClassPath.getFileExtension(fileName)) != null && URLClassPath.isArchiveExtension(fileExtension);
        if (protocol.equals("file")) {
            String localFileName = fileName.substring("file:".length());
            if (fileName.endsWith("/") || new File(localFileName).isDirectory()) {
                LocalDirectoryEntry localDirectoryEntry = new LocalDirectoryEntry(localFileName);
            } else {
                if (!isArchive) throw new IOException("Classpath entry " + fileName + " is not a directory or archive file");
                LocalArchiveEntry localArchiveEntry = new LocalArchiveEntry(localFileName);
            }
        } else if (fileName.endsWith("/")) {
            RemoteDirectoryEntry remoteDirectoryEntry = new RemoteDirectoryEntry(new URL(fileName));
        } else {
            if (!isArchive) throw new IOException("Classpath entry " + fileName + "  is not a remote directory or archive file");
            RemoteArchiveEntry remoteArchiveEntry = new RemoteArchiveEntry(new URL(fileName));
        }
        this.entryList.add((Entry)var5_11);
    }

    public String getClassPath() {
        StringBuffer buf = new StringBuffer();
        Iterator<Entry> i$ = this.entryList.iterator();
        while (i$.hasNext()) {
            Entry entry = i$.next();
            if (buf.length() > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(entry.getURL());
        }
        return buf.toString();
    }

    private InputStream getInputStreamForResource(String resourceName) throws IOException {
        Iterator<Entry> i$ = this.entryList.iterator();
        while (i$.hasNext()) {
            Entry entry = i$.next();
            try {
                InputStream in = entry.openStream(resourceName);
                if (in == null) continue;
                if (URLClassPathRepository.DEBUG) {
                    System.out.println("\t==> found " + resourceName + " in " + entry.getURL());
                }
                return in;
            }
            catch (IOException ignore) {
            }
        }
        if (URLClassPathRepository.DEBUG) {
            System.out.println("\t==> could not find " + resourceName + " on classpath");
        }
        return null;
    }

    public JavaClass lookupClass(String className) throws ClassNotFoundException {
        if (this.classesThatCantBeFound.contains(className)) {
            throw new ClassNotFoundException("Error while looking for class " + className + ": class not found");
        }
        String resourceName = className.replace('.', '/') + ".class";
        InputStream in = null;
        boolean parsedClass = false;
        try {
            in = this.getInputStreamForResource(resourceName);
            if (in == null) {
                this.classesThatCantBeFound.add(className);
                throw new ClassNotFoundException("Error while looking for class " + className + ": class not found");
            }
            ClassParser classParser = new ClassParser(in, resourceName);
            JavaClass javaClass = classParser.parse();
            parsedClass = true;
            JavaClass javaClass2 = javaClass;
            return javaClass2;
        }
        catch (IOException e) {
            this.classesThatCantBeFound.add(className);
            throw new ClassNotFoundException("IOException while looking for class " + className + ": " + e.toString());
        }
        finally {
            if (in != null && !parsedClass) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public void close() {
        Iterator<Entry> i$ = this.entryList.iterator();
        while (i$.hasNext()) {
            Entry entry = i$.next();
            entry.close();
        }
        this.entryList.clear();
    }

    public static String getURLProtocol(String urlString) {
        String specifiedProtocol;
        String protocol = null;
        int firstColon = urlString.indexOf(58);
        if (firstColon >= 0 && FindBugs.knownURLProtocolSet.contains(specifiedProtocol = urlString.substring(0, firstColon))) {
            protocol = specifiedProtocol;
        }
        return protocol;
    }

    public static String getFileExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        return lastDot >= 0 ? fileName.substring(lastDot) : null;
    }

    public static boolean isArchiveExtension(String fileExtension) {
        return Archive.ARCHIVE_EXTENSION_SET.contains(fileExtension);
    }

    private static class RemoteDirectoryEntry
    implements Entry {
        private URL remoteDirURL;

        public RemoteDirectoryEntry(URL remoteDirURL) {
            this.remoteDirURL = remoteDirURL;
        }

        public InputStream openStream(String resourceName) throws IOException {
            URL remoteFileURL = new URL(this.remoteDirURL.toString() + resourceName);
            try {
                return remoteFileURL.openStream();
            }
            catch (IOException e) {
                return null;
            }
        }

        public String getURL() {
            return this.remoteDirURL.toString();
        }

        public void close() {
        }
    }

    private static class RemoteArchiveEntry
    implements Entry {
        private URL remoteArchiveURL;

        public RemoteArchiveEntry(URL remoteArchiveURL) {
            this.remoteArchiveURL = remoteArchiveURL;
        }

        public InputStream openStream(String resourceName) throws IOException {
            URL remoteFileURL = new URL("jar:" + this.remoteArchiveURL.toString() + "/" + resourceName);
            try {
                return remoteFileURL.openStream();
            }
            catch (IOException e) {
                return null;
            }
        }

        public String getURL() {
            return this.remoteArchiveURL.toString();
        }

        public void close() {
        }
    }

    private static class LocalDirectoryEntry
    implements Entry {
        private String dirName;

        public LocalDirectoryEntry(String dirName) throws IOException {
            this.dirName = dirName;
            if (!new File(dirName).isDirectory()) {
                throw new IOException(dirName + " is not a directory");
            }
        }

        public InputStream openStream(String resourceName) throws IOException {
            File file = new File(this.dirName, resourceName);
            if (!file.exists()) {
                return null;
            }
            return new BufferedInputStream(new FileInputStream(file));
        }

        public String getURL() {
            return this.dirName;
        }

        public void close() {
        }
    }

    private static class LocalArchiveEntry
    implements Entry {
        private ZipFile zipFile;

        public LocalArchiveEntry(String fileName) throws IOException {
            try {
                this.zipFile = new ZipFile(fileName);
            }
            catch (IOException e) {
                IOException ioe = new IOException("Could not open archive file " + fileName);
                ioe.initCause(e);
                throw ioe;
            }
        }

        public InputStream openStream(String resourceName) throws IOException {
            ZipEntry zipEntry = this.zipFile.getEntry(resourceName);
            if (zipEntry == null) {
                return null;
            }
            return this.zipFile.getInputStream(zipEntry);
        }

        public String getURL() {
            return this.zipFile.getName();
        }

        public void close() {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static interface Entry {
        public InputStream openStream(String var1) throws IOException;

        public String getURL();

        public void close();
    }
}

