require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&EAP_ICSC)) {
    sub EAP_ICSC () {	0x;}
}
unless(defined(&EAP_SERR_DISABLE)) {
    sub EAP_SERR_DISABLE () {	0x1;}
}
unless(defined(&EAP_CDC_EN)) {
    sub EAP_CDC_EN () {	0x2;}
}
unless(defined(&EAP_JYSTK_EN)) {
    sub EAP_JYSTK_EN () {	0x4;}
}
unless(defined(&EAP_UART_EN)) {
    sub EAP_UART_EN () {	0x8;}
}
unless(defined(&EAP_ADC_EN)) {
    sub EAP_ADC_EN () {	0x10;}
}
unless(defined(&EAP_DAC2_EN)) {
    sub EAP_DAC2_EN () {	0x20;}
}
unless(defined(&EAP_DAC1_EN)) {
    sub EAP_DAC1_EN () {	0x40;}
}
unless(defined(&EAP_BREQ)) {
    sub EAP_BREQ () {	0x80;}
}
unless(defined(&EAP_XTCL0)) {
    sub EAP_XTCL0 () {	0x100;}
}
unless(defined(&EAP_M_CB)) {
    sub EAP_M_CB () {	0x200;}
}
unless(defined(&EAP_CCB_INTRM)) {
    sub EAP_CCB_INTRM () {	0x400;}
}
unless(defined(&EAP_DAC_SYNC)) {
    sub EAP_DAC_SYNC () {	0x800;}
}
unless(defined(&EAP_WTSRSEL)) {
    sub EAP_WTSRSEL () {	0x3000;}
}
unless(defined(&EAP_WTSRSEL_5)) {
    sub EAP_WTSRSEL_5 () {	0x;}
}
unless(defined(&EAP_WTSRSEL_11)) {
    sub EAP_WTSRSEL_11 () {	0x1000;}
}
unless(defined(&EAP_WTSRSEL_22)) {
    sub EAP_WTSRSEL_22 () {	0x2000;}
}
unless(defined(&EAP_WTSRSEL_44)) {
    sub EAP_WTSRSEL_44 () {	0x3000;}
}
unless(defined(&EAP_M_SBB)) {
    sub EAP_M_SBB () {	0x4000;}
}
unless(defined(&E1371_SYNC_RES)) {
    sub E1371_SYNC_RES () {	0x4000;}
}
unless(defined(&EAP_MSFMTSEL)) {
    sub EAP_MSFMTSEL () {	0x8000;}
}
unless(defined(&EAP_SET_PCLKDIV)) {
    sub EAP_SET_PCLKDIV {
	my($n) = @_;
	eval q(((($n)&0x1fff)<<16));
    }
}
unless(defined(&EAP_GET_PCLKDIV)) {
    sub EAP_GET_PCLKDIV {
	my($n) = @_;
	eval q(((($n)>>16)&0x1fff));
    }
}
unless(defined(&EAP_PCLKBITS)) {
    sub EAP_PCLKBITS () {	0x1fff0000;}
}
unless(defined(&EAP_XTCL1)) {
    sub EAP_XTCL1 () {	0x40000000;}
}
unless(defined(&EAP_ADC_STOP)) {
    sub EAP_ADC_STOP () {	0x80000000;}
}
unless(defined(&EAP_ICSS)) {
    sub EAP_ICSS () {	0x4;}
}
unless(defined(&EAP_I_ADC)) {
    sub EAP_I_ADC () {	0x1;}
}
unless(defined(&EAP_I_DAC2)) {
    sub EAP_I_DAC2 () {	0x2;}
}
unless(defined(&EAP_I_DAC1)) {
    sub EAP_I_DAC1 () {	0x4;}
}
unless(defined(&EAP_I_UART)) {
    sub EAP_I_UART () {	0x8;}
}
unless(defined(&EAP_I_MCCB)) {
    sub EAP_I_MCCB () {	0x10;}
}
unless(defined(&EAP_VC)) {
    sub EAP_VC () {	0x60;}
}
unless(defined(&EAP_CWRIP)) {
    sub EAP_CWRIP () {	0x100;}
}
unless(defined(&EAP_CBUSY)) {
    sub EAP_CBUSY () {	0x200;}
}
unless(defined(&EAP_CSTAT)) {
    sub EAP_CSTAT () {	0x400;}
}
unless(defined(&EAP_CT5880_AC97_RESET)) {
    sub EAP_CT5880_AC97_RESET () {	0x20000000;}
}
unless(defined(&EAP_INTR)) {
    sub EAP_INTR () {	0x80000000;}
}
unless(defined(&EAP_UART_DATA)) {
    sub EAP_UART_DATA () {	0x8;}
}
unless(defined(&EAP_UART_STATUS)) {
    sub EAP_UART_STATUS () {	0x9;}
}
unless(defined(&EAP_US_RXRDY)) {
    sub EAP_US_RXRDY () {	0x1;}
}
unless(defined(&EAP_US_TXRDY)) {
    sub EAP_US_TXRDY () {	0x2;}
}
unless(defined(&EAP_US_TXINT)) {
    sub EAP_US_TXINT () {	0x4;}
}
unless(defined(&EAP_US_RXINT)) {
    sub EAP_US_RXINT () {	0x80;}
}
unless(defined(&EAP_UART_CONTROL)) {
    sub EAP_UART_CONTROL () {	0x9;}
}
unless(defined(&EAP_UC_CNTRL)) {
    sub EAP_UC_CNTRL () {	0x3;}
}
unless(defined(&EAP_UC_TXINTEN)) {
    sub EAP_UC_TXINTEN () {	0x20;}
}
unless(defined(&EAP_UC_RXINTEN)) {
    sub EAP_UC_RXINTEN () {	0x80;}
}
unless(defined(&EAP_MEMPAGE)) {
    sub EAP_MEMPAGE () {	0xc;}
}
unless(defined(&EAP_CODEC)) {
    sub EAP_CODEC () {	0x10;}
}
unless(defined(&EAP_SET_CODEC)) {
    sub EAP_SET_CODEC {
	my($a,$d) = @_;
	eval q(((($a)<<8) | ($d)));
    }
}
unless(defined(&E1371_CODEC)) {
    sub E1371_CODEC () {	0x14;}
}
unless(defined(&E1371_CODEC_VALID)) {
    sub E1371_CODEC_VALID () {	0x80000000;}
}
unless(defined(&E1371_CODEC_WIP)) {
    sub E1371_CODEC_WIP () {	0x40000000;}
}
unless(defined(&E1371_CODEC_READ)) {
    sub E1371_CODEC_READ () {	0x800000;}
}
unless(defined(&E1371_SET_CODEC)) {
    sub E1371_SET_CODEC {
	my($a,$d) = @_;
	eval q(((($a)<<16) | ($d)));
    }
}
unless(defined(&E1371_SRC)) {
    sub E1371_SRC () {	0x10;}
}
unless(defined(&E1371_SRC_RAMWE)) {
    sub E1371_SRC_RAMWE () {	0x1000000;}
}
unless(defined(&E1371_SRC_RBUSY)) {
    sub E1371_SRC_RBUSY () {	0x800000;}
}
unless(defined(&E1371_SRC_DISABLE)) {
    sub E1371_SRC_DISABLE () {	0x400000;}
}
unless(defined(&E1371_SRC_DISP1)) {
    sub E1371_SRC_DISP1 () {	0x200000;}
}
unless(defined(&E1371_SRC_DISP2)) {
    sub E1371_SRC_DISP2 () {	0x100000;}
}
unless(defined(&E1371_SRC_DISREC)) {
    sub E1371_SRC_DISREC () {	0x80000;}
}
unless(defined(&E1371_SRC_ADDR)) {
    sub E1371_SRC_ADDR {
	my($a) = @_;
	eval q((($a)<<25));
    }
}
unless(defined(&E1371_SRC_DATA)) {
    sub E1371_SRC_DATA {
	my($d) = @_;
	eval q(($d));
    }
}
unless(defined(&E1371_SRC_DATAMASK)) {
    sub E1371_SRC_DATAMASK () {	0xffff;}
}
unless(defined(&E1371_SRC_CTLMASK)) {
    sub E1371_SRC_CTLMASK () {	( &E1371_SRC_DISABLE |  &E1371_SRC_DISP1 |  &E1371_SRC_DISP2 |  &E1371_SRC_DISREC);}
}
unless(defined(&E1371_SRC_STATE_MASK)) {
    sub E1371_SRC_STATE_MASK () {	0x870000;}
}
unless(defined(&E1371_SRC_STATE_OK)) {
    sub E1371_SRC_STATE_OK () {	0x10000;}
}
unless(defined(&E1371_LEGACY)) {
    sub E1371_LEGACY () {	0x18;}
}
unless(defined(&ESRC_ADC)) {
    sub ESRC_ADC () {	0x78;}
}
unless(defined(&ESRC_DAC1)) {
    sub ESRC_DAC1 () {	0x74;}
}
unless(defined(&ESRC_DAC2)) {
    sub ESRC_DAC2 () {	0x70;}
}
unless(defined(&ESRC_ADC_VOLL)) {
    sub ESRC_ADC_VOLL () {	0x6c;}
}
unless(defined(&ESRC_ADC_VOLR)) {
    sub ESRC_ADC_VOLR () {	0x6d;}
}
unless(defined(&ESRC_DAC1_VOLL)) {
    sub ESRC_DAC1_VOLL () {	0x7c;}
}
unless(defined(&ESRC_DAC1_VOLR)) {
    sub ESRC_DAC1_VOLR () {	0x7d;}
}
unless(defined(&ESRC_DAC2_VOLL)) {
    sub ESRC_DAC2_VOLL () {	0x7e;}
}
unless(defined(&ESRC_DAC2_VOLR)) {
    sub ESRC_DAC2_VOLR () {	0x7f;}
}
unless(defined(&ESRC_TRUNC_N)) {
    sub ESRC_TRUNC_N () {	0x;}
}
unless(defined(&ESRC_IREGS)) {
    sub ESRC_IREGS () {	0x1;}
}
unless(defined(&ESRC_ACF)) {
    sub ESRC_ACF () {	0x2;}
}
unless(defined(&ESRC_VFF)) {
    sub ESRC_VFF () {	0x3;}
}
unless(defined(&ESRC_SET_TRUNC)) {
    sub ESRC_SET_TRUNC {
	my($n) = @_;
	eval q((($n)<<9));
    }
}
unless(defined(&ESRC_SET_N)) {
    sub ESRC_SET_N {
	my($n) = @_;
	eval q((($n)<<4));
    }
}
unless(defined(&ESRC_SMF)) {
    sub ESRC_SMF () {	0x8000;}
}
unless(defined(&ESRC_SET_VFI)) {
    sub ESRC_SET_VFI {
	my($n) = @_;
	eval q((($n)<<10));
    }
}
unless(defined(&ESRC_SET_ACI)) {
    sub ESRC_SET_ACI {
	my($n) = @_;
	eval q(($n));
    }
}
unless(defined(&ESRC_SET_ADC_VOL)) {
    sub ESRC_SET_ADC_VOL {
	my($n) = @_;
	eval q((($n)<<8));
    }
}
unless(defined(&ESRC_SET_DAC_VOLI)) {
    sub ESRC_SET_DAC_VOLI {
	my($n) = @_;
	eval q((($n)<<12));
    }
}
unless(defined(&ESRC_SET_DAC_VOLF)) {
    sub ESRC_SET_DAC_VOLF {
	my($n) = @_;
	eval q(($n));
    }
}
unless(defined(&SRC_MAGIC)) {
    sub SRC_MAGIC () {	((1<15)|(1<<13)|(1<<11)|(1<<9));}
}
unless(defined(&EAP_SIC)) {
    sub EAP_SIC () {	0x20;}
}
unless(defined(&EAP_P1_S_MB)) {
    sub EAP_P1_S_MB () {	0x1;}
}
unless(defined(&EAP_P1_S_EB)) {
    sub EAP_P1_S_EB () {	0x2;}
}
unless(defined(&EAP_P2_S_MB)) {
    sub EAP_P2_S_MB () {	0x4;}
}
unless(defined(&EAP_P2_S_EB)) {
    sub EAP_P2_S_EB () {	0x8;}
}
unless(defined(&EAP_R1_S_MB)) {
    sub EAP_R1_S_MB () {	0x10;}
}
unless(defined(&EAP_R1_S_EB)) {
    sub EAP_R1_S_EB () {	0x20;}
}
unless(defined(&EAP_P2_DAC_SEN)) {
    sub EAP_P2_DAC_SEN () {	0x40;}
}
unless(defined(&EAP_P1_SCT_RLD)) {
    sub EAP_P1_SCT_RLD () {	0x80;}
}
unless(defined(&EAP_P1_INTR_EN)) {
    sub EAP_P1_INTR_EN () {	0x100;}
}
unless(defined(&EAP_P2_INTR_EN)) {
    sub EAP_P2_INTR_EN () {	0x200;}
}
unless(defined(&EAP_R1_INTR_EN)) {
    sub EAP_R1_INTR_EN () {	0x400;}
}
unless(defined(&EAP_P1_PAUSE)) {
    sub EAP_P1_PAUSE () {	0x800;}
}
unless(defined(&EAP_P2_PAUSE)) {
    sub EAP_P2_PAUSE () {	0x1000;}
}
unless(defined(&EAP_P1_LOOP_SEL)) {
    sub EAP_P1_LOOP_SEL () {	0x2000;}
}
unless(defined(&EAP_P2_LOOP_SEL)) {
    sub EAP_P2_LOOP_SEL () {	0x4000;}
}
unless(defined(&EAP_R1_LOOP_SEL)) {
    sub EAP_R1_LOOP_SEL () {	0x8000;}
}
unless(defined(&EAP_SET_P2_ST_INC)) {
    sub EAP_SET_P2_ST_INC {
	my($i) = @_;
	eval q((($i) << 16));
    }
}
unless(defined(&EAP_SET_P2_END_INC)) {
    sub EAP_SET_P2_END_INC {
	my($i) = @_;
	eval q((($i) << 19));
    }
}
unless(defined(&EAP_INC_BITS)) {
    sub EAP_INC_BITS () {	0x3f0000;}
}
unless(defined(&EAP_DAC1_CSR)) {
    sub EAP_DAC1_CSR () {	0x24;}
}
unless(defined(&EAP_DAC2_CSR)) {
    sub EAP_DAC2_CSR () {	0x28;}
}
unless(defined(&EAP_ADC_CSR)) {
    sub EAP_ADC_CSR () {	0x2c;}
}
unless(defined(&EAP_GET_CURRSAMP)) {
    sub EAP_GET_CURRSAMP {
	my($r) = @_;
	eval q((($r) >> 16));
    }
}
unless(defined(&EAP_DAC_PAGE)) {
    sub EAP_DAC_PAGE () {	0xc;}
}
unless(defined(&EAP_ADC_PAGE)) {
    sub EAP_ADC_PAGE () {	0xd;}
}
unless(defined(&EAP_UART_PAGE1)) {
    sub EAP_UART_PAGE1 () {	0xe;}
}
unless(defined(&EAP_UART_PAGE2)) {
    sub EAP_UART_PAGE2 () {	0xf;}
}
unless(defined(&EAP_DAC1_ADDR)) {
    sub EAP_DAC1_ADDR () {	0x30;}
}
unless(defined(&EAP_DAC1_SIZE)) {
    sub EAP_DAC1_SIZE () {	0x34;}
}
unless(defined(&EAP_DAC2_ADDR)) {
    sub EAP_DAC2_ADDR () {	0x38;}
}
unless(defined(&EAP_DAC2_SIZE)) {
    sub EAP_DAC2_SIZE () {	0x3c;}
}
unless(defined(&EAP_ADC_ADDR)) {
    sub EAP_ADC_ADDR () {	0x30;}
}
unless(defined(&EAP_ADC_SIZE)) {
    sub EAP_ADC_SIZE () {	0x34;}
}
unless(defined(&EAP_SET_SIZE)) {
    sub EAP_SET_SIZE {
	my($c,$s) = @_;
	eval q(((($c)<<16) | ($s)));
    }
}
unless(defined(&EAP_READ_TIMEOUT)) {
    sub EAP_READ_TIMEOUT () {	5000;}
}
unless(defined(&EAP_WRITE_TIMEOUT)) {
    sub EAP_WRITE_TIMEOUT () {	5000;}
}
unless(defined(&EAP_XTAL_FREQ)) {
    sub EAP_XTAL_FREQ () {	1411200;}
}
unless(defined(&AK_MASTER_L)) {
    sub AK_MASTER_L () {	0x;}
}
unless(defined(&AK_MASTER_R)) {
    sub AK_MASTER_R () {	0x1;}
}
unless(defined(&AK_VOICE_L)) {
    sub AK_VOICE_L () {	0x2;}
}
unless(defined(&AK_VOICE_R)) {
    sub AK_VOICE_R () {	0x3;}
}
unless(defined(&AK_FM_L)) {
    sub AK_FM_L () {	0x4;}
}
unless(defined(&AK_FM_R)) {
    sub AK_FM_R () {	0x5;}
}
unless(defined(&AK_CD_L)) {
    sub AK_CD_L () {	0x6;}
}
unless(defined(&AK_CD_R)) {
    sub AK_CD_R () {	0x7;}
}
unless(defined(&AK_LINE_L)) {
    sub AK_LINE_L () {	0x8;}
}
unless(defined(&AK_LINE_R)) {
    sub AK_LINE_R () {	0x9;}
}
unless(defined(&AK_AUX_L)) {
    sub AK_AUX_L () {	0xa;}
}
unless(defined(&AK_AUX_R)) {
    sub AK_AUX_R () {	0xb;}
}
unless(defined(&AK_MONO1)) {
    sub AK_MONO1 () {	0xc;}
}
unless(defined(&AK_MONO2)) {
    sub AK_MONO2 () {	0xd;}
}
unless(defined(&AK_MIC)) {
    sub AK_MIC () {	0xe;}
}
unless(defined(&AK_MONO)) {
    sub AK_MONO () {	0xf;}
}
unless(defined(&AK_OUT_MIXER1)) {
    sub AK_OUT_MIXER1 () {	0x10;}
}
unless(defined(&AK_M_FM_L)) {
    sub AK_M_FM_L () {	0x40;}
}
unless(defined(&AK_M_FM_R)) {
    sub AK_M_FM_R () {	0x20;}
}
unless(defined(&AK_M_LINE_L)) {
    sub AK_M_LINE_L () {	0x10;}
}
unless(defined(&AK_M_LINE_R)) {
    sub AK_M_LINE_R () {	0x8;}
}
unless(defined(&AK_M_CD_L)) {
    sub AK_M_CD_L () {	0x4;}
}
unless(defined(&AK_M_CD_R)) {
    sub AK_M_CD_R () {	0x2;}
}
unless(defined(&AK_M_MIC)) {
    sub AK_M_MIC () {	0x1;}
}
unless(defined(&AK_OUT_MIXER2)) {
    sub AK_OUT_MIXER2 () {	0x11;}
}
unless(defined(&AK_M_AUX_L)) {
    sub AK_M_AUX_L () {	0x20;}
}
unless(defined(&AK_M_AUX_R)) {
    sub AK_M_AUX_R () {	0x10;}
}
unless(defined(&AK_M_VOICE_L)) {
    sub AK_M_VOICE_L () {	0x8;}
}
unless(defined(&AK_M_VOICE_R)) {
    sub AK_M_VOICE_R () {	0x4;}
}
unless(defined(&AK_M_MONO2)) {
    sub AK_M_MONO2 () {	0x2;}
}
unless(defined(&AK_M_MONO1)) {
    sub AK_M_MONO1 () {	0x1;}
}
unless(defined(&AK_IN_MIXER1_L)) {
    sub AK_IN_MIXER1_L () {	0x12;}
}
unless(defined(&AK_IN_MIXER1_R)) {
    sub AK_IN_MIXER1_R () {	0x13;}
}
unless(defined(&AK_IN_MIXER2_L)) {
    sub AK_IN_MIXER2_L () {	0x14;}
}
unless(defined(&AK_IN_MIXER2_R)) {
    sub AK_IN_MIXER2_R () {	0x15;}
}
unless(defined(&AK_M_TMIC)) {
    sub AK_M_TMIC () {	0x80;}
}
unless(defined(&AK_M_TMONO1)) {
    sub AK_M_TMONO1 () {	0x40;}
}
unless(defined(&AK_M_TMONO2)) {
    sub AK_M_TMONO2 () {	0x20;}
}
unless(defined(&AK_M2_AUX_L)) {
    sub AK_M2_AUX_L () {	0x10;}
}
unless(defined(&AK_M2_AUX_R)) {
    sub AK_M2_AUX_R () {	0x8;}
}
unless(defined(&AK_M_VOICE)) {
    sub AK_M_VOICE () {	0x4;}
}
unless(defined(&AK_M2_MONO2)) {
    sub AK_M2_MONO2 () {	0x2;}
}
unless(defined(&AK_M2_MONO1)) {
    sub AK_M2_MONO1 () {	0x1;}
}
unless(defined(&AK_RESET)) {
    sub AK_RESET () {	0x16;}
}
unless(defined(&AK_PD)) {
    sub AK_PD () {	0x2;}
}
unless(defined(&AK_NRST)) {
    sub AK_NRST () {	0x1;}
}
unless(defined(&AK_CS)) {
    sub AK_CS () {	0x17;}
}
unless(defined(&AK_ADSEL)) {
    sub AK_ADSEL () {	0x18;}
}
unless(defined(&AK_MGAIN)) {
    sub AK_MGAIN () {	0x19;}
}
unless(defined(&AK_NPORTS)) {
    sub AK_NPORTS () {	0x20;}
}
unless(defined(&VOL_TO_ATT5)) {
    sub VOL_TO_ATT5 {
	my($v) = @_;
	eval q((0x1f - (($v) >> 3)));
    }
}
unless(defined(&VOL_TO_GAIN5)) {
    sub VOL_TO_GAIN5 {
	my($v) = @_;
	eval q( &VOL_TO_ATT5($v));
    }
}
unless(defined(&ATT5_TO_VOL)) {
    sub ATT5_TO_VOL {
	my($v) = @_;
	eval q(((0x1f - ($v)) << 3));
    }
}
unless(defined(&GAIN5_TO_VOL)) {
    sub GAIN5_TO_VOL {
	my($v) = @_;
	eval q( &ATT5_TO_VOL($v));
    }
}
unless(defined(&VOL_0DB)) {
    sub VOL_0DB () {	200;}
}
unless(defined(&EAP_MASTER_VOL)) {
    sub EAP_MASTER_VOL () {	0;}
}
unless(defined(&EAP_VOICE_VOL)) {
    sub EAP_VOICE_VOL () {	1;}
}
unless(defined(&EAP_FM_VOL)) {
    sub EAP_FM_VOL () {	2;}
}
unless(defined(&EAP_VIDEO_VOL)) {
    sub EAP_VIDEO_VOL () {	2;}
}
unless(defined(&EAP_CD_VOL)) {
    sub EAP_CD_VOL () {	3;}
}
unless(defined(&EAP_LINE_VOL)) {
    sub EAP_LINE_VOL () {	4;}
}
unless(defined(&EAP_AUX_VOL)) {
    sub EAP_AUX_VOL () {	5;}
}
unless(defined(&EAP_MIC_VOL)) {
    sub EAP_MIC_VOL () {	6;}
}
unless(defined(&EAP_RECORD_SOURCE)) {
    sub EAP_RECORD_SOURCE () {	7;}
}
unless(defined(&EAP_INPUT_SOURCE)) {
    sub EAP_INPUT_SOURCE () {	8;}
}
unless(defined(&EAP_MIC_PREAMP)) {
    sub EAP_MIC_PREAMP () {	9;}
}
unless(defined(&EAP_OUTPUT_CLASS)) {
    sub EAP_OUTPUT_CLASS () {	10;}
}
unless(defined(&EAP_RECORD_CLASS)) {
    sub EAP_RECORD_CLASS () {	11;}
}
unless(defined(&EAP_INPUT_CLASS)) {
    sub EAP_INPUT_CLASS () {	12;}
}
unless(defined(&MIDI_BUSY_WAIT)) {
    sub MIDI_BUSY_WAIT () {	100;}
}
unless(defined(&MIDI_BUSY_DELAY)) {
    sub MIDI_BUSY_DELAY () {	100;}
}
unless(defined(&EAP_EV1938_A)) {
    sub EAP_EV1938_A () {	0x;}
}
unless(defined(&EAP_ES1371_A)) {
    sub EAP_ES1371_A () {	0x2;}
}
unless(defined(&EAP_CT5880_C)) {
    sub EAP_CT5880_C () {	0x2;}
}
unless(defined(&EAP_CT5880_D)) {
    sub EAP_CT5880_D () {	0x3;}
}
unless(defined(&EAP_ES1373_A)) {
    sub EAP_ES1373_A () {	0x4;}
}
unless(defined(&EAP_ES1373_B)) {
    sub EAP_ES1373_B () {	0x6;}
}
unless(defined(&EAP_CT5880_A)) {
    sub EAP_CT5880_A () {	0x7;}
}
unless(defined(&EAP_ES1373_8)) {
    sub EAP_ES1373_8 () {	0x8;}
}
unless(defined(&EAP_ES1371_B)) {
    sub EAP_ES1371_B () {	0x9;}
}
1;
