require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UVM_UVM_MAP_H_)) {
    eval 'sub _UVM_UVM_MAP_H_ () {1;}' unless defined(&_UVM_UVM_MAP_H_);
    require 'sys/rwlock.ph';
    if(defined(&_KERNEL)) {
	eval 'sub UVM_MAP_CLIP_START {
	    my($MAP,$ENTRY,$VA) = @_;
    	    eval q({  &if (($VA) > ($ENTRY)-> &start)  &uvm_map_clip_start($MAP,$ENTRY,$VA); });
	}' unless defined(&UVM_MAP_CLIP_START);
	eval 'sub UVM_MAP_CLIP_END {
	    my($MAP,$ENTRY,$VA) = @_;
    	    eval q({  &if (($VA) < ($ENTRY)-> &end)  &uvm_map_clip_end($MAP,$ENTRY,$VA); });
	}' unless defined(&UVM_MAP_CLIP_END);
	eval 'sub UVM_EXTRACT_REMOVE () {0x1;}' unless defined(&UVM_EXTRACT_REMOVE);
	eval 'sub UVM_EXTRACT_CONTIG () {0x2;}' unless defined(&UVM_EXTRACT_CONTIG);
	eval 'sub UVM_EXTRACT_QREF () {0x4;}' unless defined(&UVM_EXTRACT_QREF);
	eval 'sub UVM_EXTRACT_FIXPROT () {0x8;}' unless defined(&UVM_EXTRACT_FIXPROT);
    }
    require 'uvm/uvm_anon.ph';
    eval 'sub uvm_map_entry_stop_copy () { &flags;}' unless defined(&uvm_map_entry_stop_copy);
    eval 'sub UVM_MAP_STATIC () {0x1;}' unless defined(&UVM_MAP_STATIC);
    eval 'sub UVM_MAP_KMEM () {0x2;}' unless defined(&UVM_MAP_KMEM);
    eval 'sub MAP_ET_KVAGUARD () {0x10;}' unless defined(&MAP_ET_KVAGUARD);
    eval 'sub VM_MAPENT_ISWIRED {
        my($entry) = @_;
	    eval q((($entry)-> &wired_count != 0));
    }' unless defined(&VM_MAPENT_ISWIRED);
    eval 'sub min_offset () { ($header->{start});}' unless defined(&min_offset);
    eval 'sub max_offset () { ($header->{end});}' unless defined(&max_offset);
    eval 'sub VM_MAP_PAGEABLE () {0x1;}' unless defined(&VM_MAP_PAGEABLE);
    eval 'sub VM_MAP_INTRSAFE () {0x2;}' unless defined(&VM_MAP_INTRSAFE);
    eval 'sub VM_MAP_WIREFUTURE () {0x4;}' unless defined(&VM_MAP_WIREFUTURE);
    eval 'sub VM_MAP_BUSY () {0x8;}' unless defined(&VM_MAP_BUSY);
    eval 'sub VM_MAP_WANTLOCK () {0x10;}' unless defined(&VM_MAP_WANTLOCK);
    if(!defined(&MAX_KMAPENT)) {
	eval 'sub MAX_KMAPENT () {1024;}' unless defined(&MAX_KMAPENT);
    }
    if(defined(&_KERNEL)) {
	eval 'sub vm_map_modflags {
	    my($map, $set, $clear) = @_;
    	    eval q( &do { ($map)-> &flags = (($map)-> &flags | ($set)) & ~($clear); }  &while (0));
	}' unless defined(&vm_map_modflags);
    }
    if(defined(&_KERNEL)) {
	if(defined(&PMAP_GROWKERNEL)) {
	}
	eval 'sub uvm_map_hint {
	    my($p, $prot) = @_;
    	    eval q( &uvm_map_hint1($p, $prot, 1));
	}' unless defined(&uvm_map_hint);
	eval 'sub uvm_unmap {
	    my($_m, $_s, $_e) = @_;
    	    eval q( &uvm_unmap_p($_m, $_s, $_e, 0));
	}' unless defined(&uvm_unmap);
    }
    if(defined(&_KERNEL)) {
	require 'sys/time.ph';
	require 'sys/systm.ph';
	eval 'sub vm_map_lock_try {
	    my($map) = @_;
    	    eval q({  &boolean_t  &rv;  &if ( ($map->{flags}) &  &VM_MAP_INTRSAFE) {  &rv =  &TRUE; }  &else {  &if ( ($map->{flags}) &  &VM_MAP_BUSY) { ( &FALSE); }  &rv = ( &rw_enter( ($map->{lock}),  &RW_WRITE| &RW_NOSLEEP) == 0); }  &if ( &rv)  ($map->{timestamp})++; ( &rv); });
	}' unless defined(&vm_map_lock_try);
	eval 'sub vm_map_lock {
	    my($map) = @_;
    	    eval q({  &if ( ($map->{flags}) &  &VM_MAP_INTRSAFE) ;  &do {  &while ( ($map->{flags}) &  &VM_MAP_BUSY) {  ($map->{flags}) |=  &VM_MAP_WANTLOCK;  &tsleep( ($map->{flags}),  &PVM,  &vmmapbsy, 0); } }  &while ( &rw_enter( ($map->{lock}),  &RW_WRITE| &RW_SLEEPFAIL) != 0);  ($map->{timestamp})++; });
	}' unless defined(&vm_map_lock);
	eval 'sub vm_map_lock_read {
	    my($map) = @_;
    	    eval q( &rw_enter_read(($map)-> &lock));
	}' unless defined(&vm_map_lock_read);
	eval 'sub vm_map_unlock {
	    my($map) = @_;
    	    eval q( &do {  &if ((($map)-> &flags &  &VM_MAP_INTRSAFE) == 0)  &rw_exit(($map)-> &lock); }  &while (0));
	}' unless defined(&vm_map_unlock);
	eval 'sub vm_map_unlock_read {
	    my($map) = @_;
    	    eval q( &rw_exit_read(($map)-> &lock));
	}' unless defined(&vm_map_unlock_read);
	eval 'sub vm_map_downgrade {
	    my($map) = @_;
    	    eval q( &rw_enter(($map)-> &lock,  &RW_DOWNGRADE));
	}' unless defined(&vm_map_downgrade);
	eval 'sub vm_map_upgrade {
	    my($map) = @_;
    	    eval q( &do {  &rw_exit_read(($map)-> &lock);  &rw_enter_write(($map)-> &lock); }  &while (0));
	}' unless defined(&vm_map_upgrade);
	eval 'sub vm_map_busy {
	    my($map) = @_;
    	    eval q( &do { ($map)-> &flags |=  &VM_MAP_BUSY; }  &while (0));
	}' unless defined(&vm_map_busy);
	eval 'sub vm_map_unbusy {
	    my($map) = @_;
    	    eval q( &do { \'int\'  &oflags;  &oflags = ($map)-> &flags; ($map)-> &flags &= ~( &VM_MAP_BUSY| &VM_MAP_WANTLOCK);  &if ( &oflags &  &VM_MAP_WANTLOCK)  &wakeup(($map)-> &flags); }  &while (0));
	}' unless defined(&vm_map_unbusy);
    }
    eval 'sub vm_map_min {
        my($map) = @_;
	    eval q((($map)-> &min_offset));
    }' unless defined(&vm_map_min);
    eval 'sub vm_map_max {
        my($map) = @_;
	    eval q((($map)-> &max_offset));
    }' unless defined(&vm_map_max);
    eval 'sub vm_map_pmap {
        my($map) = @_;
	    eval q((($map)-> &pmap));
    }' unless defined(&vm_map_pmap);
}
1;
