require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_PARAM_H_)) {
    eval 'sub _MACHINE_PARAM_H_ () {1;}' unless defined(&_MACHINE_PARAM_H_);
    eval 'sub _MACHINE () { &sparc;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"sparc";}' unless defined(&MACHINE);
    eval 'sub _MACHINE_ARCH () { &sparc;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"sparc";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_SPARC;}' unless defined(&MID_MACHINE);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub ALIGNBYTES () { &_ALIGNBYTES;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q( &_ALIGN($p));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        my($p,$t) = @_;
	    eval q( &_ALIGNED_POINTER($p,$t));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub SUN4_PGSHIFT () {13;}' unless defined(&SUN4_PGSHIFT);
    eval 'sub SUN4CM_PGSHIFT () {12;}' unless defined(&SUN4CM_PGSHIFT);
    eval 'sub KERNBASE () {0xf8000000;}' unless defined(&KERNBASE);
    eval 'sub KERNTEXTOFF () {0xf8004000;}' unless defined(&KERNTEXTOFF);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub USPACE () {8192;}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(0);}' unless defined(&USPACE_ALIGN);
    eval 'sub NMBCLUSTERS () {2048;}' unless defined(&NMBCLUSTERS);
    eval 'sub MSGBUFSIZE () {4096;}' unless defined(&MSGBUFSIZE);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub ctod {
        my($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        my($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub btodb {
        my($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        my($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    eval 'sub dvma_malloc {
	        my($len,$kaddr,$flags) = @_;
    		eval q( &dvma_malloc_space($len,$kaddr,$flags,0));
	    }' unless defined(&dvma_malloc);
	    eval 'sub DELAY {
	        my($n) = @_;
    		eval q( &delay($n));
	    }' unless defined(&DELAY);
	    if(0) {
	    }
	}
    }
    eval 'sub CPU_SUN4 () {0;}' unless defined(&CPU_SUN4);
    eval 'sub CPU_SUN4E () {1;}' unless defined(&CPU_SUN4E);
    eval 'sub CPU_SUN4C () {2;}' unless defined(&CPU_SUN4C);
    eval 'sub CPU_SUN4M () {3;}' unless defined(&CPU_SUN4M);
    eval 'sub CPU_SUN4D () {4;}' unless defined(&CPU_SUN4D);
    if((defined(&SUN4) || defined(&SUN4E))  && !(defined(&SUN4C) || defined(&SUN4D) || defined(&SUN4M))) {
	eval 'sub PAGE_SIZE () {8192;}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
	eval 'sub PAGE_SHIFT () { &SUN4_PGSHIFT;}' unless defined(&PAGE_SHIFT);
    }
 elsif((defined(&SUN4C) || defined(&SUN4D) || defined(&SUN4M))  && !(defined(&SUN4) || defined(&SUN4E))) {
	eval 'sub PAGE_SIZE () {4096;}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
	eval 'sub PAGE_SHIFT () { &SUN4CM_PGSHIFT;}' unless defined(&PAGE_SHIFT);
    } else {
	if(defined(&STANDALONE)) {
	    eval 'sub PAGE_SIZE () { &nbpg;}' unless defined(&PAGE_SIZE);
	    eval 'sub PAGE_MASK () { &pgofset;}' unless defined(&PAGE_MASK);
	    eval 'sub PAGE_SHIFT () { &pgshift;}' unless defined(&PAGE_SHIFT);
	} else {
	    eval 'sub PAGE_SIZE () { ($uvmexp->{pagesize});}' unless defined(&PAGE_SIZE);
	    eval 'sub PAGE_MASK () { ($uvmexp->{pagemask});}' unless defined(&PAGE_MASK);
	    eval 'sub PAGE_SHIFT () { ($uvmexp->{pageshift});}' unless defined(&PAGE_SHIFT);
	}
    }
    eval 'sub NBPG () { &PAGE_SIZE;}' unless defined(&NBPG);
    eval 'sub PGOFSET () { &PAGE_MASK;}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () { &PAGE_SHIFT;}' unless defined(&PGSHIFT);
    if(defined(&SUN4)  && !(defined(&SUN4C) || defined(&SUN4D) || defined(&SUN4E) || defined(&SUN4M))) {
	eval 'sub CPU_ISSUN4 () {(1);}' unless defined(&CPU_ISSUN4);
    }
 elsif(defined(&SUN4C)  && !(defined(&SUN4) || defined(&SUN4D) || defined(&SUN4E) || defined(&SUN4M))) {
	eval 'sub CPU_ISSUN4C () {(1);}' unless defined(&CPU_ISSUN4C);
    }
 elsif(defined(&SUN4D)  && !(defined(&SUN4) || defined(&SUN4C) || defined(&SUN4E) || defined(&SUN4M))) {
	eval 'sub CPU_ISSUN4D () {(1);}' unless defined(&CPU_ISSUN4D);
    }
 elsif(defined(&SUN4E)  && !(defined(&SUN4) || defined(&SUN4C) || defined(&SUN4D) || defined(&SUN4M))) {
	eval 'sub CPU_ISSUN4E () {(1);}' unless defined(&CPU_ISSUN4E);
    }
 elsif(defined(&SUN4M)  && !(defined(&SUN4) || defined(&SUN4C) || defined(&SUN4D) || defined(&SUN4E))) {
	eval 'sub CPU_ISSUN4M () {(1);}' unless defined(&CPU_ISSUN4M);
    }
 elsif((defined(&SUN4) || defined(&SUN4C))  && !(defined(&SUN4D) || defined(&SUN4E) || defined(&SUN4M))) {
	eval 'sub CPU_ISSUN4OR4C () {(1);}' unless defined(&CPU_ISSUN4OR4C);
    }
 elsif((defined(&SUN4) || defined(&SUN4C) || defined(&SUN4E))  && !(defined(&SUN4D) || defined(&SUN4M))) {
	eval 'sub CPU_ISSUN4OR4COR4E () {(1);}' unless defined(&CPU_ISSUN4OR4COR4E);
    }
 elsif((defined(&SUN4) || defined(&SUN4E))  && !(defined(&SUN4C) || defined(&SUN4D) || defined(&SUN4M))) {
	eval 'sub CPU_ISSUN4OR4E () {(1);}' unless defined(&CPU_ISSUN4OR4E);
    }
 elsif((defined(&SUN4C) || defined(&SUN4M))  && !(defined(&SUN4) || defined(&SUN4D) || defined(&SUN4E))) {
	eval 'sub CPU_ISSUN4COR4M () {(1);}' unless defined(&CPU_ISSUN4COR4M);
    }
 elsif((defined(&SUN4D) || defined(&SUN4M))  && !(defined(&SUN4) || defined(&SUN4C) || defined(&SUN4E))) {
	eval 'sub CPU_ISSUN4DOR4M () {(1);}' unless defined(&CPU_ISSUN4DOR4M);
    }
    if(!defined(&CPU_ISSUN4)) {
	if(defined(&SUN4)) {
	    eval 'sub CPU_ISSUN4 () {( &cputyp ==  &CPU_SUN4);}' unless defined(&CPU_ISSUN4);
	} else {
	    eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
	}
    }
    if(!defined(&CPU_ISSUN4C)) {
	if(defined(&SUN4C)) {
	    eval 'sub CPU_ISSUN4C () {( &cputyp ==  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4C);
	} else {
	    eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
	}
    }
    if(!defined(&CPU_ISSUN4D)) {
	if(defined(&SUN4D)) {
	    eval 'sub CPU_ISSUN4D () {( &cputyp ==  &CPU_SUN4D);}' unless defined(&CPU_ISSUN4D);
	} else {
	    eval 'sub CPU_ISSUN4D () {(0);}' unless defined(&CPU_ISSUN4D);
	}
    }
    if(!defined(&CPU_ISSUN4E)) {
	if(defined(&SUN4E)) {
	    eval 'sub CPU_ISSUN4E () {( &cputyp ==  &CPU_SUN4E);}' unless defined(&CPU_ISSUN4E);
	} else {
	    eval 'sub CPU_ISSUN4E () {(0);}' unless defined(&CPU_ISSUN4E);
	}
    }
    if(!defined(&CPU_ISSUN4M)) {
	if(defined(&SUN4M)) {
	    eval 'sub CPU_ISSUN4M () {( &cputyp ==  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4M);
	} else {
	    eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
	}
    }
    if(!defined(&CPU_ISSUN4OR4C)) {
	eval 'sub CPU_ISSUN4OR4C () {( &CPU_ISSUN4 ||  &CPU_ISSUN4C);}' unless defined(&CPU_ISSUN4OR4C);
    }
    if(!defined(&CPU_ISSUN4OR4E)) {
	eval 'sub CPU_ISSUN4OR4E () {( &cputyp <=  &CPU_SUN4E);}' unless defined(&CPU_ISSUN4OR4E);
    }
    if(!defined(&CPU_ISSUN4OR4COR4E)) {
	eval 'sub CPU_ISSUN4OR4COR4E () {( &cputyp <=  &CPU_SUN4C);}' unless defined(&CPU_ISSUN4OR4COR4E);
    }
    if(!defined(&CPU_ISSUN4COR4M)) {
	eval 'sub CPU_ISSUN4COR4M () {( &CPU_ISSUN4C ||  &CPU_ISSUN4M);}' unless defined(&CPU_ISSUN4COR4M);
    }
    if(!defined(&CPU_ISSUN4DOR4M)) {
	eval 'sub CPU_ISSUN4DOR4M () {( &cputyp >=  &CPU_SUN4M);}' unless defined(&CPU_ISSUN4DOR4M);
    }
}
1;
