/*************************************************************************
** psdefs.cpp                                                           **
**                                                                      **
** This file is part of dvisvgm -- a fast DVI to SVG converter          **
** Copyright (C) 2005-2025 Martin Gieseking <martin.gieseking@uos.de>   **
**                                                                      **
** This program is free software; you can redistribute it and/or        **
** modify it under the terms of the GNU General Public License as       **
** published by the Free Software Foundation; either version 3 of       **
** the License, or (at your option) any later version.                  **
**                                                                      **
** This program is distributed in the hope that it will be useful, but  **
** WITHOUT ANY WARRANTY; without even the implied warranty of           **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with this program; if not, see <http://www.gnu.org/licenses/>. **
*************************************************************************/

#include "PSInterpreter.hpp"

const char *PSInterpreter::PSDEFS =
"<</Install{matrix setmatrix}/HWResolution[72 72]/PageSize[10000 10000]/Imaging"
"BBox null>>setpagedevice/@dodraw true store/@GD globaldict def/@SD systemdict "
"def/@UD userdict def @GD/@nulldev false put @GD/@patcnt 0 put true setglobal @"
"SD/:setpagedevice @SD/setpagedevice get put @SD/:save @SD/save get put @SD/:re"
"store @SD/restore get put @SD/:gsave @SD/gsave get put @SD/:grestore @SD/grest"
"ore get put @SD/:grestoreall @SD/grestoreall get put @SD/:newpath @SD/newpath "
"get put @SD/:stroke @SD/stroke get put @SD/:fill @SD/fill get put @SD/:eofill "
"@SD/eofill get put @SD/:clip @SD/clip get put @SD/:eoclip @SD/eoclip get put @"
"SD/:charpath @SD/charpath get put @SD/:show @SD/show get put @SD/:stringwidth "
"@SD/stringwidth get put @SD/:nulldevice @SD/nulldevice get put @SD/:image @SD/"
"image get put @SD/:colorimage @SD/colorimage get put @SD/.setopacityalpha know"
"n not{@SD/.setopacityalpha{pop}put}if @SD/.setshapealpha known not{@SD/.setsha"
"pealpha{pop}put}if @SD/.setblendmode known not{@SD/.setblendmode{pop}put}if @S"
"D/prseq{[exch 1 add 1 roll]{=only( )print}forall}put @SD/prcmd{( )exch(\\ndvi."
")3{print}repeat prseq(| )print}put @SD/cvxall{{cvx}forall}put @SD/defpr{[exch/"
"copy cvx @SD 4 index[/get/exec]cvxall 5 index 3 index dup length string cvs/pr"
"cmd cvx]cvx bind def}put @SD/querypos{{currentpoint}stopped{$error/newerror fa"
"lse put}{2(querypos)prcmd}ifelse}put @SD/applyscalevals{1 0 dtransform exch du"
"p mul exch dup mul add sqrt 0 1 dtransform exch dup mul exch dup mul add sqrt "
"1 0 dtransform dup mul exch dup dup mul 3 -1 roll add dup 0 eq{pop}{sqrt div}i"
"felse 3(applyscalevals)prcmd}put @SD/prpath{{2(moveto)prcmd}{2(lineto)prcmd}{6"
"(curveto)prcmd}{0(closepath)prcmd}pathforall}put @SD/nulldevice{@GD/@nulldev t"
"rue put :nulldevice 1 1(setnulldevice)prcmd}put @SD/charpath{/@dodraw false st"
"ore :charpath/@dodraw true store}put @SD/stringwidth{/@dodraw false store :str"
"ingwidth/@dodraw true store}put @SD/show{@dodraw @GD/@nulldev get not and{dup "
":gsave currentpoint 2{50 mul exch}repeat :newpath moveto 50 50/scale sysexec t"
"rue charpath fill :grestore/@dodraw false store :show/@dodraw true store}{:sho"
"w}ifelse}put @SD/varxyshow{dup 0 ge{<</chr 3 -1 roll string/prc 5 -1 roll/arr "
"7 -1 roll/str 9 -1 roll/idx 0>>begin 0 chr length str length 1 sub{str exch ch"
"r length getinterval/chr exch store :gsave chr show :grestore currentpoint prc"
" moveto/idx idx 1 add store}for end}{pop pop show}ifelse}put @SD/xyshow{dup du"
"p type/arraytype eq exch length 0 gt and{dup length 2 idiv 2 index length exch"
" idiv}{-1}ifelse{exch arr idx 2 mul get add exch arr idx 2 mul 1 add get add}e"
"xch varxyshow}put @SD/xshow{dup dup type/arraytype eq exch length 0 gt and{dup"
" length 2 index length exch idiv}{-1}ifelse{exch arr idx get add exch}exch var"
"xyshow}put @SD/yshow{dup dup type/arraytype eq exch length 0 gt and{dup length"
" 2 index length exch idiv}{-1}ifelse{arr idx get add}exch varxyshow}put @SD/aw"
"idthshow{{1 string dup 0 5 index put :gsave show :grestore pop 0 rmoveto 3 ind"
"ex eq{4 index 4 index rmoveto}if 1 index 1 index rmoveto}exch cshow 5{pop}repe"
"at}put @SD/widthshow{0 0 3 -1 roll awidthshow}put @SD/ashow{0 0 0 6 3 roll awi"
"dthshow}put @SD/newpath{:newpath 1 1(newpath)prcmd}put @SD/stroke{@dodraw @GD/"
"@nulldev get not and{prcolor 0 1(newpath)prcmd prpath 0(stroke)prcmd :newpath}"
"{:stroke}ifelse}put @SD/fill{@dodraw @GD/@nulldev get not and{prcolor 0 1(newp"
"ath)prcmd prpath 0(fill)prcmd :newpath}{:fill}ifelse}put @SD/eofill{@dodraw @G"
"D/@nulldev get not and{prcolor 0 1(newpath)prcmd prpath 0(eofill)prcmd :newpat"
"h}{:eofill}ifelse}put/.fillstroke{:gsave fill :grestore .swapcolors stroke .sw"
"apcolors}bind def/.eofillstroke{:gsave eofill :grestore .swapcolors stroke .sw"
"apcolors}bind def @SD/clip{:clip @GD/@nulldev get not{0 1(newpath)prcmd prpath"
" 0(clip)prcmd}if}put @SD/eoclip{:eoclip @GD/@nulldev get not{0 1(newpath)prcmd"
" prpath 0(eoclip)prcmd}if}put @SD/shfill{begin currentdict/ShadingType known c"
"urrentdict/ColorSpace known and currentdict/DataSource known and currentdict/F"
"unction known not and ShadingType 4 ge{DataSource type/arraytype eq{<</DeviceG"
"ray 1/DeviceRGB 3/DeviceCMYK 4/bgknown currentdict/Background known/bbknown cu"
"rrentdict/BBox known>>begin currentdict ColorSpace known{ShadingType ColorSpac"
"e load bgknown{1 Background aload pop}{0}ifelse bbknown{1 BBox aload pop}{0}if"
"else ShadingType 5 eq{VerticesPerRow}if DataSource aload length 4 add bgknown{"
"ColorSpace load add}if bbknown{4 add}if ShadingType 5 eq{1 add}if(shfill)prcmd"
"}if end}if}if end}put @SD/image{dup type/dicttype eq{dup}{<</Width 6 index/Hei"
"ght 7 index/colorimg false>>}ifelse @execimg}put @SD/colorimage{<<2 index{/Wid"
"th 2 index 7 add index/Height 4 index 8 add index}{/Width 8 index/Height 9 ind"
"ex}ifelse/colorimg true>>@execimg}put/@imgbase(./)def/@imgdevice(jpeg)def/@exe"
"cimg{@GD/@imgcnt 2 copy .knownget{1 add}{1}ifelse put begin<</imgid @GD/@imgcn"
"t get/ispng @imgdevice 0 3 getinterval(png)eq dup/suffix exch{(.png)}{(.jpg)}i"
"felse/colorimg currentdict/colorimg .knownget dup{pop}if/colordev 1 index curr"
"entcolorspace dup length 1 ne exch 0 get/DeviceGray ne or or>>begin @imgdevice"
"(png)ne @imgdevice(jpeg)ne and{@imgdevice cvn}{colordev{ispng{/png16m}{/jpeg}i"
"felse}{ispng{/pnggray}{/jpeggray}ifelse}ifelse}ifelse devicedict exch known{:g"
"save matrix currentmatrix/currentcolorspace sysexec<</OutputDevice @imgdevice/"
"OutputFile @imgbase imgid 20 string cvs strconcat suffix strconcat/PageSize[Wi"
"dth Height]/UseFastColor true ispng{@imgdevice(pngmonod)eq{/MinFeatureSize whe"
"re{pop/MinFeatureSize MinFeatureSize}if}if}{/JPEGQ where{pop/JPEGQ JPEGQ}if}if"
"else>>:setpagedevice/setcolorspace sysexec/setmatrix sysexec[Width 0 0 Height "
"neg 0 Height]/setmatrix sysexec colorimg{:colorimage}{:image}ifelse/copypage s"
"ysexec<</OutputDevice @imgdevice/OutputFile()>>:setpagedevice :grestore imgid "
"Width Height 3(image)prcmd}{pop colorimg{:colorimage}{:image}ifelse}ifelse end"
" end}def/@rect{4 -2 roll moveto exch dup 0 rlineto exch 0 exch rlineto neg 0 r"
"lineto closepath}bind def/@rectcc{4 -2 roll moveto 2 copy 0 lt exch 0 lt xor{d"
"up 0 exch rlineto exch 0 rlineto neg 0 exch rlineto}{exch dup 0 rlineto exch 0"
" exch rlineto neg 0 rlineto}ifelse closepath}bind def @SD/rectclip{:newpath du"
"p type/arraytype eq{aload length 4 idiv{@rectcc}repeat}{@rectcc}ifelse clip :n"
"ewpath}put @SD/rectfill{:gsave :newpath dup type/arraytype eq{aload length 4 i"
"div{@rectcc}repeat}{@rectcc}ifelse fill :grestore}put @SD/rectstroke{gsave :ne"
"wpath dup type/arraytype eq{aload length 4 idiv{@rect}repeat}{@rect}ifelse str"
"oke grestore}put false setglobal @SD readonly pop/initclip 0 defpr/clippath 0 "
"defpr/sysexec{@SD exch get exec}def/adddot{dup length 1 add string dup 0 46 pu"
"t dup 3 -1 roll 1 exch putinterval}def/setlinewidth{dup/setlinewidth sysexec 1"
"(setlinewidth)prcmd}def/setlinecap 1 defpr/setlinejoin 1 defpr/setmiterlimit 1"
" defpr/setdash{mark 3 1 roll 2 copy/setdash sysexec exch aload length 1 add -1"
" roll counttomark(setdash)prcmd pop}def/@setpagedevice{pop<<>>:setpagedevice m"
"atrix setmatrix newpath 0(setpagedevice)prcmd}def/@checknulldev{@GD/@nulldev g"
"et{currentpagedevice maxlength 0 ne{@GD/@nulldev false put 0 1(setnulldevice)p"
"rcmd}if}if}def/prcolor{currentcolorspace @setcolorspace currentrgbcolor 3(setr"
"gbcolor)prcmd}def/printgstate{@dodraw @GD/@nulldev get not and{matrix currentm"
"atrix aload pop 6(setmatrix)prcmd applyscalevals currentlinewidth 1(setlinewid"
"th)prcmd currentlinecap 1(setlinecap)prcmd currentlinejoin 1(setlinejoin)prcmd"
" currentmiterlimit 1(setmiterlimit)prcmd revision dup 952 lt{pop}{.currentblen"
"dmode .setblendmode 952 eq{.currentopacityalpha .setopacityalpha .currentshape"
"alpha .setshapealpha}{.currentalphaisshape{1}{0}ifelse 1(setalphaisshape)prcmd"
" .currentstrokeconstantalpha 1(setstrokeconstantalpha)prcmd .currentfillconsta"
"ntalpha 1(setfillconstantalpha)prcmd}ifelse}ifelse prcolor currentdash mark 3 "
"1 roll exch aload length 1 add -1 roll counttomark(setdash)prcmd pop}if}def/st"
"rconcat{exch dup length 2 index length add string dup dup 4 2 roll copy length"
" 4 -1 roll putinterval}def/setgstate{/setgstate sysexec printgstate}def/save{@"
"UD begin/@saveID vmstatus pop pop def end :save @saveID 1(save)prcmd}def/resto"
"re{:restore @checknulldev printgstate @UD/@saveID known{@UD begin @saveID end}"
"{0}ifelse 1(restore)prcmd}def/gsave 0 defpr/grestore{:grestore @checknulldev p"
"rintgstate 0(grestore)prcmd}def/grestoreall{:grestoreall @checknulldev setstat"
"e 0(grestoreall)prcmd}def/rotate{dup type/arraytype ne @dodraw and{dup 1(rotat"
"e)prcmd}if/rotate sysexec applyscalevals}def/scale{dup type/arraytype ne @dodr"
"aw and{2 copy 2(scale)prcmd}if/scale sysexec applyscalevals}def/translate{dup "
"type/arraytype ne @dodraw and{2 copy 2(translate)prcmd}if/translate sysexec}de"
"f/setmatrix{dup/setmatrix sysexec @dodraw{aload pop 6(setmatrix)prcmd applysca"
"levals}{pop}ifelse}def/initmatrix{matrix setmatrix}def/concat{matrix currentma"
"trix matrix concatmatrix setmatrix}def/makepattern{gsave<</mx 3 -1 roll>>begin"
"<</XUID[1000000 @patcnt]>>copy mx/makepattern sysexec dup begin PatternType 2 "
"lt{PatternType @patcnt BBox aload pop XStep YStep PaintType mx aload pop 15(ma"
"kepattern)prcmd :newpath matrix setmatrix dup PaintProc 0 1(makepattern)prcmd "
"@GD/@patcnt @patcnt 1 add put}if end end grestore}def/setpattern{dup begin Pat"
"ternType end 1 eq{begin PaintType 1 eq{XUID aload pop exch pop 1}{:gsave[curre"
"ntcolorspace aload length -1 roll pop]/setcolorspace sysexec/setcolor sysexec "
"XUID aload pop exch pop currentrgbcolor :grestore 4}ifelse(setpattern)prcmd cu"
"rrentcolorspace 0 get/Pattern ne{[/Pattern currentcolorspace]/setcolorspace sy"
"sexec}if currentcolorspace @setcolorspace end}{/setpattern sysexec}ifelse}def/"
"setcolor{dup type/dicttype eq{setpattern}{/setcolor sysexec/currentrgbcolor sy"
"sexec setrgbcolor}ifelse}def/setcolorspace{dup/setcolorspace sysexec @setcolor"
"space}def/@setcolorspace{dup type/arraytype eq{0 get}if/Pattern eq{1}{0}ifelse"
" 1(setcolorspace)prcmd}def/setgray 1 defpr/setcmykcolor 4 defpr/sethsbcolor 3 "
"defpr/setrgbcolor 3 defpr/.setalphaisshape{@SD/.setalphaisshape known{dup/.set"
"alphaisshape sysexec}if{1}{0}ifelse 1(setalphaisshape)prcmd}bind def/.setfillc"
"onstantalpha{@SD/.setfillconstantalpha known{dup/.setfillconstantalpha sysexec"
"}if 1(setfillconstantalpha)prcmd}bind def/.setstrokeconstantalpha{@SD/.setstro"
"keconstantalpha known{dup/.setstrokeconstantalpha sysexec}if 1(setstrokeconsta"
"ntalpha)prcmd}bind def/.setopacityalpha{false .setalphaisshape dup .setfillcon"
"stantalpha .setstrokeconstantalpha}bind def/.setshapealpha{true .setalphaissha"
"pe dup .setfillconstantalpha .setstrokeconstantalpha}bind def/.setblendmode{du"
"p/.setblendmode sysexec<</Normal 0/Compatible 0/Multiply 1/Screen 2/Overlay 3/"
"SoftLight 4/HardLight 5/ColorDodge 6/ColorBurn 7/Darken 8/Lighten 9/Difference"
" 10/Exclusion 11/Hue 12/Saturation 13/Color 14/Luminosity 15/CompatibleOverpri"
"nt 16>>exch get 1(setblendmode)prcmd}def/@pdfpagecount{(r)file runpdfbegin pdf"
"pagecount runpdfend}def/@pdfpagebox{(r)file runpdfbegin dup dup 1 lt exch pdfp"
"agecount gt or{pop}{pdfgetpage/MediaBox pget pop aload pop}ifelse runpdfend}de"
"f DELAYBIND{.bindnow}if ";

