"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CGsubGposTable = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ImpLib = require("@ot-builder/common-impl");
const errors_1 = require("@ot-builder/errors");
const feature_list_1 = require("./feature-list");
const feature_variation_1 = require("./feature-variation");
const read_lookup_list_1 = require("./read-lookup-list");
const script_lang_1 = require("./script-lang");
const trick_1 = require("./trick");
const write_lookup_list_1 = require("./write-lookup-list");
class CGsubGposTable {
    read(view, cfg, lrf, trc) {
        const majorVersion = view.uint16();
        const minorVersion = view.uint16();
        errors_1.Assert.SubVersionSupported("Table", majorVersion, minorVersion, [1, 0], [1, 1]);
        const vScriptList = view.ptr16();
        const vFeatureList = view.ptr16();
        const vLookupList = view.ptr16();
        const vFeatureVariation = minorVersion > 0 ? view.ptr32Nullable() : null;
        const lrc = { ...trc };
        const lookups = vLookupList.next(new read_lookup_list_1.CReadLookupList(), lrf, lrc);
        const lOrd = ImpLib.Order.fromList(`Lookups`, lookups);
        const features = vFeatureList.next(new feature_list_1.CFeatureList(), lOrd);
        const fOrd = ImpLib.Order.fromList(`Features`, features);
        const scripts = vScriptList.next(new script_lang_1.CScriptList(), fOrd);
        const featureVariations = vFeatureVariation && trc.designSpace && trc.designSpace.length
            ? vFeatureVariation.next(new feature_variation_1.CFeatureVariations(), trc.designSpace, fOrd, lOrd)
            : null;
        return { scripts, features, lookups, featureVariations };
    }
    write(frag, table, cfg, lwf, twc) {
        const lwc = { ...twc, tricks: (0, trick_1.setLookupTricks)(table, cfg) };
        const fLookups = bin_util_1.Frag.solidFrom(write_lookup_list_1.WriteLookupList, table.lookups, lwf, lwc);
        const lOrd = ImpLib.Order.fromList(`Lookups`, table.lookups);
        // Feature list is sorted by tag
        // https://docs.microsoft.com/en-us/typography/opentype/spec/chapter2#flTbl
        const sortedFeatures = Array.from(table.features).sort(compareFeature);
        const fFeatures = bin_util_1.Frag.solidFrom(new feature_list_1.CFeatureList(), sortedFeatures, lOrd);
        const fOrd = ImpLib.Order.fromList(`Features`, sortedFeatures);
        // Script list
        const fScripts = bin_util_1.Frag.solidFrom(new script_lang_1.CScriptList(), table.scripts, fOrd);
        const fFeatureVariations = !table.featureVariations || !twc.designSpace || !twc.designSpace.length
            ? null
            : bin_util_1.Frag.solidFrom(new feature_variation_1.CFeatureVariations(), table.featureVariations, twc.designSpace, fOrd, lOrd);
        // Write it!
        const minorVersion = fFeatureVariations ? 1 : 0;
        frag.uint16(1).uint16(minorVersion);
        frag.ptr16(fScripts);
        frag.ptr16(fFeatures);
        frag.ptr16(fLookups);
        if (minorVersion)
            frag.ptr32(fFeatureVariations);
    }
}
exports.CGsubGposTable = CGsubGposTable;
function compareFeature(a, b) {
    return a.tag < b.tag ? -1 : a.tag > b.tag ? 1 : 0;
}
//# sourceMappingURL=table.js.map