"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VerdaConfig = void 0;
const tslib_1 = require("tslib");
const os = tslib_1.__importStar(require("os"));
const path = tslib_1.__importStar(require("path"));
const proxy_1 = require("../reporter/proxy");
const quiet_1 = require("../reporter/quiet");
class VerdaConfig {
    createActionEnv() {
        return {
            cd: this.cwd,
            cwd: this.cwd,
            env: { ...this.env },
            rulePath: this.rulePath,
            reporter: new proxy_1.ProxyReporter(() => this.reporter),
        };
    }
    constructor(options) {
        this.rulePath = "";
        this.cwd = process.cwd();
        this.env = process.env;
        this.param = {};
        this.journal = "";
        this.objectives = [];
        this.jCmd = 0;
        this.verbosity = 6;
        this.reporter = new quiet_1.QuietReporter();
        this.bind(options);
    }
    bind(options) {
        if (options.rulePath) {
            this.rulePath = options.rulePath;
            this.cwd = path.dirname(this.rulePath);
        }
        if (options.cwd) {
            if (!this.journal)
                this.journal = path.join(options.cwd, ".verda-journal");
            this.cwd = options.cwd;
        }
        this.jCmd = options.jCmd || os.cpus().length;
        this.verbosity = options.verbosity && options.verbosity >= 0 ? options.verbosity : 6;
    }
}
exports.VerdaConfig = VerdaConfig;
