"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const ava_1 = tslib_1.__importDefault(require("ava"));
const fs = tslib_1.__importStar(require("fs-extra"));
const config_1 = require("../config");
const director_1 = tslib_1.__importDefault(require("../core/director"));
const file_1 = require("../rule-types/file");
const task_1 = require("../rule-types/task");
const test_helper_1 = require("../test-helper");
(0, ava_1.default)("Dir content test", async (t) => {
    const director = new director_1.default();
    const { dc } = (0, file_1.ImplicitFileRules)(new config_1.VerdaConfig({ rulePath: "./package.json" }), director);
    const { task } = (0, task_1.Task)(director);
    let triggeredRebuild = false;
    const start = task(`start`, async (t) => {
        await t.need(dc `payloads/dir-content/some-test`);
        triggeredRebuild = true;
    });
    async function rebuild() {
        triggeredRebuild = false;
        await (0, test_helper_1.wait)(100);
        await director.reset();
        await director.want(start);
    }
    await fs.ensureDir("payloads/dir-content/some-test");
    await (0, test_helper_1.tamper)("payloads/dir-content/some-test/a.txt", "");
    await rebuild();
    t.is(triggeredRebuild, true);
    await rebuild();
    t.is(triggeredRebuild, false);
    await (0, test_helper_1.tamper)("payloads/dir-content/some-test/a.txt", "a");
    await rebuild();
    t.is(triggeredRebuild, true);
    await (0, test_helper_1.tamper)("payloads/dir-content/some-test/a.txt", "b");
    await rebuild();
    t.is(triggeredRebuild, false);
    await (0, test_helper_1.tamper)("payloads/dir-content/some-test/a.txt", "");
    await rebuild();
    t.is(triggeredRebuild, true);
    await (0, test_helper_1.tamper)("payloads/dir-content/some-test/a.txt", "");
    await rebuild();
    t.is(triggeredRebuild, false);
});
