// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2019 MediaTek Inc.
 * Copyright (C) 2024 Collabora Ltd.
 *                    AngeloGioacchino Del Regno <angelogioacchino.delregno@collabora.com>
 */

#include <linux/module.h>
#include "pinctrl-mtk-mt6893.h"
#include "pinctrl-paris.h"

#define PIN_FIELD_BASE(s_pin, e_pin, i_base, s_addr, x_addrs, s_bit, x_bits)  \
	PIN_FIELD_CALC(s_pin, e_pin, i_base, s_addr, x_addrs, s_bit, x_bits, \
		32, 0)

#define PINS_FIELD_BASE(s_pin, e_pin, i_base, s_addr, x_addrs, s_bit, x_bits) \
	PIN_FIELD_CALC(s_pin, e_pin, i_base, s_addr, x_addrs, s_bit, x_bits, \
		32, 1)

static const struct mtk_pin_field_calc mt6893_pin_mode_range[] = {
	PIN_FIELD(0, 219, 0x0300, 0x10, 0, 4),
};

static const struct mtk_pin_field_calc mt6893_pin_dir_range[] = {
	PIN_FIELD(0, 219, 0x0000, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt6893_pin_di_range[] = {
	PIN_FIELD(0, 219, 0x0200, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt6893_pin_do_range[] = {
	PIN_FIELD(0, 219, 0x0100, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt6893_pin_smt_range[] = {
	PINS_FIELD_BASE(0, 9, 2, 0x00f0, 0x10, 7, 1),
	PINS_FIELD_BASE(10, 15, 1, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(16, 17, 5, 0x00c0, 0x10, 8, 1),
	PINS_FIELD_BASE(18, 25, 7, 0x00f0, 0x10, 1, 1),
	PINS_FIELD_BASE(26, 30, 6, 0x00e0, 0x10, 6, 1),
	PINS_FIELD_BASE(31, 35, 6, 0x00e0, 0x10, 2, 1),
	PIN_FIELD_BASE(36, 36, 6, 0x00e0, 0x10, 16, 1),
	PINS_FIELD_BASE(37, 39, 6, 0x00e0, 0x10, 15, 1),
	PIN_FIELD_BASE(40, 41, 6, 0x00e0, 0x10, 0, 1),
	PIN_FIELD_BASE(42, 42, 6, 0x00e0, 0x10, 5, 1),
	PIN_FIELD_BASE(43, 44, 6, 0x00e0, 0x10, 3, 1),
	PIN_FIELD_BASE(45, 45, 6, 0x00e0, 0x10, 12, 1),
	PIN_FIELD_BASE(46, 46, 6, 0x00e0, 0x10, 14, 1),
	PIN_FIELD_BASE(47, 47, 6, 0x00e0, 0x10, 13, 1),
	PIN_FIELD_BASE(48, 49, 6, 0x00e0, 0x10, 10, 1),
	PIN_FIELD_BASE(50, 50, 6, 0x00e0, 0x10, 9, 1),
	PIN_FIELD_BASE(51, 52, 3, 0x0090, 0x10, 6, 1),
	PINS_FIELD_BASE(53, 56, 3, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(57, 60, 3, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(61, 61, 3, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(62, 62, 4, 0x0050, 0x10, 1, 1),
	PINS_FIELD_BASE(63, 73, 3, 0x0090, 0x10, 0, 1),
	PINS_FIELD_BASE(74, 84, 4, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(85, 86, 4, 0x0050, 0x10, 4, 1),
	PIN_FIELD_BASE(87, 88, 4, 0x0050, 0x10, 2, 1),
	PIN_FIELD_BASE(89, 90, 2, 0x00f0, 0x10, 26, 1),
	PIN_FIELD_BASE(91, 91, 2, 0x00f0, 0x10, 0, 1),
	PINS_FIELD_BASE(92, 95, 2, 0x0100, 0x10, 0, 1),
	PIN_FIELD_BASE(96, 96, 2, 0x00f0, 0x10, 30, 1),
	PIN_FIELD_BASE(97, 97, 2, 0x00f0, 0x10, 28, 1),
	PIN_FIELD_BASE(98, 98, 2, 0x00f0, 0x10, 31, 1),
	PINS_FIELD_BASE(99, 102, 2, 0x00f0, 0x10, 29, 1),
	PINS_FIELD_BASE(103, 105, 2, 0x00f0, 0x10, 24, 1),
	PIN_FIELD_BASE(106, 106, 2, 0x00f0, 0x10, 25, 1),
	PIN_FIELD_BASE(107, 108, 2, 0x00f0, 0x10, 5, 1),
	PINS_FIELD_BASE(109, 113, 2, 0x00f0, 0x10, 8, 1),
	PINS_FIELD_BASE(114, 116, 2, 0x00f0, 0x10, 16, 1),
	PIN_FIELD_BASE(117, 117, 2, 0x00f0, 0x10, 17, 1),
	PIN_FIELD_BASE(118, 118, 2, 0x00f0, 0x10, 10, 1),
	PIN_FIELD_BASE(119, 119, 2, 0x00f0, 0x10, 18, 1),
	PIN_FIELD_BASE(120, 120, 2, 0x00f0, 0x10, 15, 1),
	PIN_FIELD_BASE(121, 121, 2, 0x00f0, 0x10, 23, 1),
	PIN_FIELD_BASE(122, 122, 2, 0x00f0, 0x10, 14, 1),
	PIN_FIELD_BASE(123, 123, 2, 0x00f0, 0x10, 22, 1),
	PIN_FIELD_BASE(124, 124, 2, 0x00f0, 0x10, 13, 1),
	PIN_FIELD_BASE(125, 125, 2, 0x00f0, 0x10, 21, 1),
	PINS_FIELD_BASE(126, 129, 2, 0x00f0, 0x10, 9, 1),
	PINS_FIELD_BASE(130, 135, 2, 0x00f0, 0x10, 4, 1),
	PIN_FIELD_BASE(136, 138, 2, 0x00f0, 0x10, 1, 1),
	PIN_FIELD_BASE(139, 139, 2, 0x00f0, 0x10, 12, 1),
	PIN_FIELD_BASE(140, 140, 2, 0x00f0, 0x10, 20, 1),
	PIN_FIELD_BASE(141, 141, 2, 0x00f0, 0x10, 11, 1),
	PIN_FIELD_BASE(142, 142, 2, 0x00f0, 0x10, 19, 1),
	PINS_FIELD_BASE(143, 148, 1, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(149, 151, 1, 0x0090, 0x10, 0, 1),
	PINS_FIELD_BASE(152, 155, 5, 0x00c0, 0x10, 10, 1),
	PIN_FIELD_BASE(156, 156, 5, 0x00c0, 0x10, 14, 1),
	PINS_FIELD_BASE(157, 159, 5, 0x00c0, 0x10, 13, 1),
	PIN_FIELD_BASE(160, 161, 5, 0x00c0, 0x10, 11, 1),
	PINS_FIELD_BASE(162, 171, 5, 0x00c0, 0x10, 0, 1),
	PIN_FIELD_BASE(172, 173, 5, 0x00c0, 0x10, 4, 1),
	PIN_FIELD_BASE(174, 174, 5, 0x00c0, 0x10, 3, 1),
	PIN_FIELD_BASE(175, 175, 5, 0x00c0, 0x10, 6, 1),
	PIN_FIELD_BASE(176, 177, 5, 0x00c0, 0x10, 1, 1),
	PINS_FIELD_BASE(178, 182, 5, 0x00c0, 0x10, 7, 1),
	PIN_FIELD_BASE(183, 183, 7, 0x00f0, 0x10, 3, 1),
	PINS_FIELD_BASE(184, 190, 7, 0x00f0, 0x10, 4, 1),
	PIN_FIELD_BASE(191, 191, 7, 0x00f0, 0x10, 5, 1),
	PIN_FIELD_BASE(192, 192, 7, 0x00f0, 0x10, 2, 1),
	PIN_FIELD_BASE(193, 193, 7, 0x00f0, 0x10, 4, 1),
	PIN_FIELD_BASE(194, 194, 7, 0x00f0, 0x10, 6, 1),
	PIN_FIELD_BASE(195, 195, 7, 0x00f0, 0x10, 12, 1),
	PINS_FIELD_BASE(196, 199, 7, 0x00f0, 0x10, 0, 1),
	PIN_FIELD_BASE(200, 200, 7, 0x00f0, 0x10, 11, 1),
	PIN_FIELD_BASE(201, 201, 7, 0x00f0, 0x10, 14, 1),
	PIN_FIELD_BASE(202, 202, 7, 0x00f0, 0x10, 10, 1),
	PIN_FIELD_BASE(203, 203, 7, 0x00f0, 0x10, 13, 1),
	PIN_FIELD_BASE(204, 205, 6, 0x00e0, 0x10, 7, 1),
	PIN_FIELD_BASE(206, 208, 7, 0x00f0, 0x10, 15, 1),
	PINS_FIELD_BASE(209, 211, 7, 0x00f0, 0x10, 7, 1),
	PIN_FIELD_BASE(212, 213, 7, 0x00f0, 0x10, 8, 1),
	PINS_FIELD_BASE(214, 219, 7, 0x00f0, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt6893_pin_ies_range[] = {
	PIN_FIELD_BASE(0, 9, 2, 0x0060, 0x10, 12, 1),
	PIN_FIELD_BASE(10, 15, 1, 0x0020, 0x10, 9, 1),
	PIN_FIELD_BASE(16, 17, 5, 0x0030, 0x10, 21, 1),
	PIN_FIELD_BASE(18, 25, 7, 0x0050, 0x10, 10, 1),
	PIN_FIELD_BASE(26, 30, 6, 0x0040, 0x10, 10, 1),
	PIN_FIELD_BASE(31, 31, 6, 0x0040, 0x10, 6, 1),
	PIN_FIELD_BASE(32, 32, 6, 0x0040, 0x10, 3, 1),
	PIN_FIELD_BASE(33, 33, 6, 0x0040, 0x10, 5, 1),
	PIN_FIELD_BASE(34, 34, 6, 0x0040, 0x10, 2, 1),
	PIN_FIELD_BASE(35, 35, 6, 0x0040, 0x10, 4, 1),
	PIN_FIELD_BASE(36, 39, 6, 0x0040, 0x10, 23, 1),
	PIN_FIELD_BASE(40, 41, 6, 0x0040, 0x10, 0, 1),
	PIN_FIELD_BASE(42, 42, 6, 0x0040, 0x10, 9, 1),
	PIN_FIELD_BASE(43, 44, 6, 0x0040, 0x10, 7, 1),
	PIN_FIELD_BASE(45, 45, 6, 0x0040, 0x10, 20, 1),
	PIN_FIELD_BASE(46, 46, 6, 0x0040, 0x10, 22, 1),
	PIN_FIELD_BASE(47, 47, 6, 0x0040, 0x10, 21, 1),
	PIN_FIELD_BASE(48, 49, 6, 0x0040, 0x10, 18, 1),
	PIN_FIELD_BASE(50, 50, 6, 0x0040, 0x10, 17, 1),
	PIN_FIELD_BASE(51, 52, 3, 0x0020, 0x10, 16, 1),
	PIN_FIELD_BASE(53, 53, 3, 0x0020, 0x10, 21, 1),
	PIN_FIELD_BASE(54, 54, 3, 0x0020, 0x10, 18, 1),
	PIN_FIELD_BASE(55, 55, 3, 0x0020, 0x10, 20, 1),
	PIN_FIELD_BASE(56, 56, 3, 0x0020, 0x10, 19, 1),
	PIN_FIELD_BASE(57, 60, 3, 0x0020, 0x10, 12, 1),
	PIN_FIELD_BASE(61, 61, 3, 0x0020, 0x10, 11, 1),
	PIN_FIELD_BASE(62, 62, 4, 0x0010, 0x10, 11, 1),
	PIN_FIELD_BASE(63, 64, 3, 0x0020, 0x10, 0, 1),
	PIN_FIELD_BASE(65, 72, 3, 0x0020, 0x10, 3, 1),
	PIN_FIELD_BASE(73, 73, 3, 0x0020, 0x10, 2, 1),
	PIN_FIELD_BASE(74, 84, 4, 0x0010, 0x10, 0, 1),
	PIN_FIELD_BASE(85, 86, 4, 0x0010, 0x10, 14, 1),
	PIN_FIELD_BASE(87, 88, 4, 0x0010, 0x10, 12, 1),
	PIN_FIELD_BASE(89, 90, 2, 0x0070, 0x10, 19, 1),
	PIN_FIELD_BASE(91, 91, 2, 0x0060, 0x10, 0, 1),
	PIN_FIELD_BASE(92, 92, 2, 0x0070, 0x10, 28, 1),
	PIN_FIELD_BASE(93, 93, 2, 0x0070, 0x10, 30, 1),
	PIN_FIELD_BASE(94, 94, 2, 0x0070, 0x10, 29, 1),
	PIN_FIELD_BASE(95, 95, 2, 0x0070, 0x10, 31, 1),
	PIN_FIELD_BASE(96, 96, 2, 0x0070, 0x10, 26, 1),
	PIN_FIELD_BASE(97, 97, 2, 0x0070, 0x10, 21, 1),
	PIN_FIELD_BASE(98, 98, 2, 0x0070, 0x10, 27, 1),
	PIN_FIELD_BASE(99, 102, 2, 0x0070, 0x10, 22, 1),
	PIN_FIELD_BASE(103, 103, 2, 0x0070, 0x10, 17, 1),
	PIN_FIELD_BASE(104, 104, 2, 0x0070, 0x10, 16, 1),
	PIN_FIELD_BASE(105, 105, 2, 0x0070, 0x10, 18, 1),
	PIN_FIELD_BASE(106, 106, 2, 0x0070, 0x10, 15, 1),
	PIN_FIELD_BASE(107, 108, 2, 0x0060, 0x10, 10, 1),
	PIN_FIELD_BASE(109, 109, 2, 0x0060, 0x10, 25, 1),
	PIN_FIELD_BASE(110, 110, 2, 0x0060, 0x10, 22, 1),
	PIN_FIELD_BASE(111, 111, 2, 0x0060, 0x10, 24, 1),
	PIN_FIELD_BASE(112, 112, 2, 0x0060, 0x10, 26, 1),
	PIN_FIELD_BASE(113, 113, 2, 0x0060, 0x10, 23, 1),
	PIN_FIELD_BASE(114, 114, 2, 0x0070, 0x10, 7, 1),
	PIN_FIELD_BASE(115, 115, 2, 0x0070, 0x10, 6, 1),
	PIN_FIELD_BASE(116, 116, 2, 0x0070, 0x10, 8, 1),
	PIN_FIELD_BASE(117, 117, 2, 0x0070, 0x10, 5, 1),
	PIN_FIELD_BASE(118, 118, 2, 0x0060, 0x10, 31, 1),
	PIN_FIELD_BASE(119, 119, 2, 0x0070, 0x10, 9, 1),
	PIN_FIELD_BASE(120, 120, 2, 0x0070, 0x10, 4, 1),
	PIN_FIELD_BASE(121, 121, 2, 0x0070, 0x10, 14, 1),
	PIN_FIELD_BASE(122, 122, 2, 0x0070, 0x10, 3, 1),
	PIN_FIELD_BASE(123, 123, 2, 0x0070, 0x10, 13, 1),
	PIN_FIELD_BASE(124, 124, 2, 0x0070, 0x10, 2, 1),
	PIN_FIELD_BASE(125, 125, 2, 0x0070, 0x10, 12, 1),
	PIN_FIELD_BASE(126, 129, 2, 0x0060, 0x10, 27, 1),
	PIN_FIELD_BASE(130, 132, 2, 0x0060, 0x10, 7, 1),
	PIN_FIELD_BASE(133, 135, 2, 0x0060, 0x10, 4, 1),
	PIN_FIELD_BASE(136, 138, 2, 0x0060, 0x10, 1, 1),
	PIN_FIELD_BASE(139, 139, 2, 0x0070, 0x10, 1, 1),
	PIN_FIELD_BASE(140, 140, 2, 0x0070, 0x10, 11, 1),
	PIN_FIELD_BASE(141, 141, 2, 0x0070, 0x10, 0, 1),
	PIN_FIELD_BASE(142, 142, 2, 0x0070, 0x10, 10, 1),
	PIN_FIELD_BASE(143, 145, 1, 0x0020, 0x10, 6, 1),
	PIN_FIELD_BASE(146, 148, 1, 0x0020, 0x10, 3, 1),
	PIN_FIELD_BASE(149, 151, 1, 0x0020, 0x10, 0, 1),
	PIN_FIELD_BASE(152, 152, 5, 0x0030, 0x10, 26, 1),
	PIN_FIELD_BASE(153, 153, 5, 0x0030, 0x10, 25, 1),
	PIN_FIELD_BASE(154, 155, 5, 0x0030, 0x10, 23, 1),
	PIN_FIELD_BASE(156, 158, 5, 0x0030, 0x10, 29, 1),
	PIN_FIELD_BASE(159, 159, 5, 0x0040, 0x10, 0, 1),
	PIN_FIELD_BASE(160, 161, 5, 0x0030, 0x10, 27, 1),
	PIN_FIELD_BASE(162, 171, 5, 0x0030, 0x10, 0, 1),
	PIN_FIELD_BASE(172, 173, 5, 0x0030, 0x10, 13, 1),
	PIN_FIELD_BASE(174, 174, 5, 0x0030, 0x10, 12, 1),
	PIN_FIELD_BASE(175, 175, 5, 0x0030, 0x10, 15, 1),
	PIN_FIELD_BASE(176, 177, 5, 0x0030, 0x10, 10, 1),
	PIN_FIELD_BASE(178, 182, 5, 0x0030, 0x10, 16, 1),
	PIN_FIELD_BASE(183, 184, 7, 0x0050, 0x10, 19, 1),
	PIN_FIELD_BASE(185, 185, 7, 0x0050, 0x10, 22, 1),
	PIN_FIELD_BASE(186, 186, 7, 0x0050, 0x10, 24, 1),
	PIN_FIELD_BASE(187, 187, 7, 0x0050, 0x10, 26, 1),
	PIN_FIELD_BASE(188, 188, 7, 0x0050, 0x10, 21, 1),
	PIN_FIELD_BASE(189, 189, 7, 0x0050, 0x10, 25, 1),
	PIN_FIELD_BASE(190, 191, 7, 0x0050, 0x10, 27, 1),
	PIN_FIELD_BASE(192, 192, 7, 0x0050, 0x10, 18, 1),
	PIN_FIELD_BASE(193, 193, 7, 0x0050, 0x10, 23, 1),
	PIN_FIELD_BASE(194, 194, 7, 0x0050, 0x10, 29, 1),
	PIN_FIELD_BASE(195, 195, 7, 0x0060, 0x10, 5, 1),
	PIN_FIELD_BASE(196, 196, 7, 0x0050, 0x10, 6, 1),
	PIN_FIELD_BASE(197, 197, 7, 0x0050, 0x10, 8, 1),
	PIN_FIELD_BASE(198, 198, 7, 0x0050, 0x10, 7, 1),
	PIN_FIELD_BASE(199, 199, 7, 0x0050, 0x10, 3, 1),
	PIN_FIELD_BASE(200, 200, 7, 0x0060, 0x10, 4, 1),
	PIN_FIELD_BASE(201, 201, 7, 0x0060, 0x10, 7, 1),
	PIN_FIELD_BASE(202, 202, 7, 0x0060, 0x10, 3, 1),
	PIN_FIELD_BASE(203, 203, 7, 0x0060, 0x10, 6, 1),
	PIN_FIELD_BASE(204, 205, 6, 0x0040, 0x10, 15, 1),
	PIN_FIELD_BASE(206, 208, 7, 0x0060, 0x10, 8, 1),
	PIN_FIELD_BASE(209, 209, 7, 0x0060, 0x10, 0, 1),
	PIN_FIELD_BASE(210, 210, 7, 0x0050, 0x10, 31, 1),
	PIN_FIELD_BASE(211, 211, 7, 0x0060, 0x10, 1, 1),
	PIN_FIELD_BASE(212, 212, 7, 0x0050, 0x10, 30, 1),
	PIN_FIELD_BASE(213, 213, 7, 0x0060, 0x10, 2, 1),
	PIN_FIELD_BASE(214, 214, 7, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(215, 215, 7, 0x0050, 0x10, 9, 1),
	PIN_FIELD_BASE(216, 217, 7, 0x0050, 0x10, 4, 1),
	PIN_FIELD_BASE(218, 219, 7, 0x0050, 0x10, 1, 1),
};

static const struct mtk_pin_field_calc mt6893_pin_pu_range[] = {
	PIN_FIELD_BASE(0, 9, 2, 0x00a0, 0x10, 12, 1),
	PIN_FIELD_BASE(16, 17, 5, 0x0070, 0x10, 21, 1),
	PIN_FIELD_BASE(18, 25, 7, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(26, 30, 6, 0x0080, 0x10, 10, 1),
	PIN_FIELD_BASE(31, 31, 6, 0x0080, 0x10, 6, 1),
	PIN_FIELD_BASE(32, 32, 6, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(33, 33, 6, 0x0080, 0x10, 5, 1),
	PIN_FIELD_BASE(34, 34, 6, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(35, 35, 6, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(36, 39, 6, 0x0080, 0x10, 17, 1),
	PIN_FIELD_BASE(40, 41, 6, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(42, 42, 6, 0x0080, 0x10, 9, 1),
	PIN_FIELD_BASE(43, 44, 6, 0x0080, 0x10, 7, 1),
	PIN_FIELD_BASE(57, 60, 3, 0x0050, 0x10, 12, 1),
	PIN_FIELD_BASE(61, 61, 3, 0x0050, 0x10, 11, 1),
	PIN_FIELD_BASE(62, 62, 4, 0x0030, 0x10, 11, 1),
	PIN_FIELD_BASE(63, 64, 3, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(65, 72, 3, 0x0050, 0x10, 3, 1),
	PIN_FIELD_BASE(73, 73, 3, 0x0050, 0x10, 2, 1),
	PIN_FIELD_BASE(74, 84, 4, 0x0030, 0x10, 0, 1),
	PIN_FIELD_BASE(85, 86, 4, 0x0030, 0x10, 14, 1),
	PIN_FIELD_BASE(87, 88, 4, 0x0030, 0x10, 12, 1),
	PIN_FIELD_BASE(89, 90, 2, 0x00b0, 0x10, 19, 1),
	PIN_FIELD_BASE(91, 91, 2, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(92, 92, 2, 0x00b0, 0x10, 28, 1),
	PIN_FIELD_BASE(93, 93, 2, 0x00b0, 0x10, 30, 1),
	PIN_FIELD_BASE(94, 94, 2, 0x00b0, 0x10, 29, 1),
	PIN_FIELD_BASE(95, 95, 2, 0x00b0, 0x10, 31, 1),
	PIN_FIELD_BASE(96, 96, 2, 0x00b0, 0x10, 26, 1),
	PIN_FIELD_BASE(97, 97, 2, 0x00b0, 0x10, 21, 1),
	PIN_FIELD_BASE(98, 98, 2, 0x00b0, 0x10, 27, 1),
	PIN_FIELD_BASE(99, 102, 2, 0x00b0, 0x10, 22, 1),
	PIN_FIELD_BASE(103, 103, 2, 0x00b0, 0x10, 17, 1),
	PIN_FIELD_BASE(104, 104, 2, 0x00b0, 0x10, 16, 1),
	PIN_FIELD_BASE(105, 105, 2, 0x00b0, 0x10, 18, 1),
	PIN_FIELD_BASE(106, 106, 2, 0x00b0, 0x10, 15, 1),
	PIN_FIELD_BASE(107, 108, 2, 0x00a0, 0x10, 10, 1),
	PIN_FIELD_BASE(109, 109, 2, 0x00a0, 0x10, 25, 1),
	PIN_FIELD_BASE(110, 110, 2, 0x00a0, 0x10, 22, 1),
	PIN_FIELD_BASE(111, 111, 2, 0x00a0, 0x10, 24, 1),
	PIN_FIELD_BASE(112, 112, 2, 0x00a0, 0x10, 26, 1),
	PIN_FIELD_BASE(113, 113, 2, 0x00a0, 0x10, 23, 1),
	PIN_FIELD_BASE(114, 114, 2, 0x00b0, 0x10, 7, 1),
	PIN_FIELD_BASE(115, 115, 2, 0x00b0, 0x10, 6, 1),
	PIN_FIELD_BASE(116, 116, 2, 0x00b0, 0x10, 8, 1),
	PIN_FIELD_BASE(117, 117, 2, 0x00b0, 0x10, 5, 1),
	PIN_FIELD_BASE(118, 118, 2, 0x00a0, 0x10, 31, 1),
	PIN_FIELD_BASE(119, 119, 2, 0x00b0, 0x10, 9, 1),
	PIN_FIELD_BASE(120, 120, 2, 0x00b0, 0x10, 4, 1),
	PIN_FIELD_BASE(121, 121, 2, 0x00b0, 0x10, 14, 1),
	PIN_FIELD_BASE(122, 122, 2, 0x00b0, 0x10, 3, 1),
	PIN_FIELD_BASE(123, 123, 2, 0x00b0, 0x10, 13, 1),
	PIN_FIELD_BASE(124, 124, 2, 0x00b0, 0x10, 2, 1),
	PIN_FIELD_BASE(125, 125, 2, 0x00b0, 0x10, 12, 1),
	PIN_FIELD_BASE(126, 129, 2, 0x00a0, 0x10, 27, 1),
	PIN_FIELD_BASE(130, 132, 2, 0x00a0, 0x10, 7, 1),
	PIN_FIELD_BASE(133, 135, 2, 0x00a0, 0x10, 4, 1),
	PIN_FIELD_BASE(136, 138, 2, 0x00a0, 0x10, 1, 1),
	PIN_FIELD_BASE(139, 139, 2, 0x00b0, 0x10, 1, 1),
	PIN_FIELD_BASE(140, 140, 2, 0x00b0, 0x10, 11, 1),
	PIN_FIELD_BASE(141, 141, 2, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(142, 142, 2, 0x00b0, 0x10, 10, 1),
	PIN_FIELD_BASE(143, 145, 1, 0x0050, 0x10, 6, 1),
	PIN_FIELD_BASE(146, 148, 1, 0x0050, 0x10, 3, 1),
	PIN_FIELD_BASE(149, 151, 1, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(156, 159, 5, 0x0070, 0x10, 25, 1),
	PIN_FIELD_BASE(160, 161, 5, 0x0070, 0x10, 23, 1),
	PIN_FIELD_BASE(162, 171, 5, 0x0070, 0x10, 0, 1),
	PIN_FIELD_BASE(172, 173, 5, 0x0070, 0x10, 13, 1),
	PIN_FIELD_BASE(174, 174, 5, 0x0070, 0x10, 12, 1),
	PIN_FIELD_BASE(175, 175, 5, 0x0070, 0x10, 15, 1),
	PIN_FIELD_BASE(176, 177, 5, 0x0070, 0x10, 10, 1),
	PIN_FIELD_BASE(178, 182, 5, 0x0070, 0x10, 16, 1),
	PIN_FIELD_BASE(195, 195, 7, 0x0090, 0x10, 25, 1),
	PIN_FIELD_BASE(196, 196, 7, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(197, 197, 7, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(198, 198, 7, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(199, 199, 7, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(200, 200, 7, 0x0090, 0x10, 24, 1),
	PIN_FIELD_BASE(201, 201, 7, 0x0090, 0x10, 27, 1),
	PIN_FIELD_BASE(202, 202, 7, 0x0090, 0x10, 23, 1),
	PIN_FIELD_BASE(203, 203, 7, 0x0090, 0x10, 26, 1),
	PIN_FIELD_BASE(204, 205, 6, 0x0080, 0x10, 15, 1),
	PIN_FIELD_BASE(206, 208, 7, 0x0090, 0x10, 28, 1),
	PIN_FIELD_BASE(209, 209, 7, 0x0090, 0x10, 20, 1),
	PIN_FIELD_BASE(210, 210, 7, 0x0090, 0x10, 19, 1),
	PIN_FIELD_BASE(211, 211, 7, 0x0090, 0x10, 21, 1),
	PIN_FIELD_BASE(212, 212, 7, 0x0090, 0x10, 18, 1),
	PIN_FIELD_BASE(213, 213, 7, 0x0090, 0x10, 22, 1),
	PIN_FIELD_BASE(214, 214, 7, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(215, 215, 7, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(216, 217, 7, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(218, 219, 7, 0x0090, 0x10, 1, 1),
};

static const struct mtk_pin_field_calc mt6893_pin_pd_range[] = {
	PIN_FIELD_BASE(0, 9, 2, 0x0080, 0x10, 12, 1),
	PIN_FIELD_BASE(16, 17, 5, 0x0050, 0x10, 21, 1),
	PIN_FIELD_BASE(18, 25, 7, 0x0070, 0x10, 10, 1),
	PIN_FIELD_BASE(26, 30, 6, 0x0060, 0x10, 10, 1),
	PIN_FIELD_BASE(31, 31, 6, 0x0060, 0x10, 6, 1),
	PIN_FIELD_BASE(32, 32, 6, 0x0060, 0x10, 3, 1),
	PIN_FIELD_BASE(33, 33, 6, 0x0060, 0x10, 5, 1),
	PIN_FIELD_BASE(34, 34, 6, 0x0060, 0x10, 2, 1),
	PIN_FIELD_BASE(35, 35, 6, 0x0060, 0x10, 4, 1),
	PIN_FIELD_BASE(36, 39, 6, 0x0060, 0x10, 17, 1),
	PIN_FIELD_BASE(40, 41, 6, 0x0060, 0x10, 0, 1),
	PIN_FIELD_BASE(42, 42, 6, 0x0060, 0x10, 9, 1),
	PIN_FIELD_BASE(43, 44, 6, 0x0060, 0x10, 7, 1),
	PIN_FIELD_BASE(57, 60, 3, 0x0030, 0x10, 12, 1),
	PIN_FIELD_BASE(61, 61, 3, 0x0030, 0x10, 11, 1),
	PIN_FIELD_BASE(62, 62, 4, 0x0020, 0x10, 11, 1),
	PIN_FIELD_BASE(63, 64, 3, 0x0030, 0x10, 0, 1),
	PIN_FIELD_BASE(65, 72, 3, 0x0030, 0x10, 3, 1),
	PIN_FIELD_BASE(73, 73, 3, 0x0030, 0x10, 2, 1),
	PIN_FIELD_BASE(74, 84, 4, 0x0020, 0x10, 0, 1),
	PIN_FIELD_BASE(85, 86, 4, 0x0020, 0x10, 14, 1),
	PIN_FIELD_BASE(87, 88, 4, 0x0020, 0x10, 12, 1),
	PIN_FIELD_BASE(89, 90, 2, 0x0090, 0x10, 19, 1),
	PIN_FIELD_BASE(91, 91, 2, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(92, 92, 2, 0x0090, 0x10, 28, 1),
	PIN_FIELD_BASE(93, 93, 2, 0x0090, 0x10, 30, 1),
	PIN_FIELD_BASE(94, 94, 2, 0x0090, 0x10, 29, 1),
	PIN_FIELD_BASE(95, 95, 2, 0x0090, 0x10, 31, 1),
	PIN_FIELD_BASE(96, 96, 2, 0x0090, 0x10, 26, 1),
	PIN_FIELD_BASE(97, 97, 2, 0x0090, 0x10, 21, 1),
	PIN_FIELD_BASE(98, 98, 2, 0x0090, 0x10, 27, 1),
	PIN_FIELD_BASE(99, 102, 2, 0x0090, 0x10, 22, 1),
	PIN_FIELD_BASE(103, 103, 2, 0x0090, 0x10, 17, 1),
	PIN_FIELD_BASE(104, 104, 2, 0x0090, 0x10, 16, 1),
	PIN_FIELD_BASE(105, 105, 2, 0x0090, 0x10, 18, 1),
	PIN_FIELD_BASE(106, 106, 2, 0x0090, 0x10, 15, 1),
	PIN_FIELD_BASE(107, 108, 2, 0x0080, 0x10, 10, 1),
	PIN_FIELD_BASE(109, 109, 2, 0x0080, 0x10, 25, 1),
	PIN_FIELD_BASE(110, 110, 2, 0x0080, 0x10, 22, 1),
	PIN_FIELD_BASE(111, 111, 2, 0x0080, 0x10, 24, 1),
	PIN_FIELD_BASE(112, 112, 2, 0x0080, 0x10, 26, 1),
	PIN_FIELD_BASE(113, 113, 2, 0x0080, 0x10, 23, 1),
	PIN_FIELD_BASE(114, 114, 2, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(115, 115, 2, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(116, 116, 2, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(117, 117, 2, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(118, 118, 2, 0x0080, 0x10, 31, 1),
	PIN_FIELD_BASE(119, 119, 2, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(120, 120, 2, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(121, 121, 2, 0x0090, 0x10, 14, 1),
	PIN_FIELD_BASE(122, 122, 2, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(123, 123, 2, 0x0090, 0x10, 13, 1),
	PIN_FIELD_BASE(124, 124, 2, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(125, 125, 2, 0x0090, 0x10, 12, 1),
	PIN_FIELD_BASE(126, 129, 2, 0x0080, 0x10, 27, 1),
	PIN_FIELD_BASE(130, 132, 2, 0x0080, 0x10, 7, 1),
	PIN_FIELD_BASE(133, 135, 2, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(136, 138, 2, 0x0080, 0x10, 1, 1),
	PIN_FIELD_BASE(139, 139, 2, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(140, 140, 2, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(141, 141, 2, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(142, 142, 2, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(143, 145, 1, 0x0030, 0x10, 6, 1),
	PIN_FIELD_BASE(146, 148, 1, 0x0030, 0x10, 3, 1),
	PIN_FIELD_BASE(149, 151, 1, 0x0030, 0x10, 0, 1),
	PIN_FIELD_BASE(156, 159, 5, 0x0050, 0x10, 25, 1),
	PIN_FIELD_BASE(160, 161, 5, 0x0050, 0x10, 23, 1),
	PIN_FIELD_BASE(162, 171, 5, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(172, 173, 5, 0x0050, 0x10, 13, 1),
	PIN_FIELD_BASE(174, 174, 5, 0x0050, 0x10, 12, 1),
	PIN_FIELD_BASE(175, 175, 5, 0x0050, 0x10, 15, 1),
	PIN_FIELD_BASE(176, 177, 5, 0x0050, 0x10, 10, 1),
	PIN_FIELD_BASE(178, 182, 5, 0x0050, 0x10, 16, 1),
	PIN_FIELD_BASE(195, 195, 7, 0x0070, 0x10, 25, 1),
	PIN_FIELD_BASE(196, 196, 7, 0x0070, 0x10, 6, 1),
	PIN_FIELD_BASE(197, 197, 7, 0x0070, 0x10, 8, 1),
	PIN_FIELD_BASE(198, 198, 7, 0x0070, 0x10, 7, 1),
	PIN_FIELD_BASE(199, 199, 7, 0x0070, 0x10, 3, 1),
	PIN_FIELD_BASE(200, 200, 7, 0x0070, 0x10, 24, 1),
	PIN_FIELD_BASE(201, 201, 7, 0x0070, 0x10, 27, 1),
	PIN_FIELD_BASE(202, 202, 7, 0x0070, 0x10, 23, 1),
	PIN_FIELD_BASE(203, 203, 7, 0x0070, 0x10, 26, 1),
	PIN_FIELD_BASE(204, 205, 6, 0x0060, 0x10, 15, 1),
	PIN_FIELD_BASE(206, 208, 7, 0x0070, 0x10, 28, 1),
	PIN_FIELD_BASE(209, 209, 7, 0x0070, 0x10, 20, 1),
	PIN_FIELD_BASE(210, 210, 7, 0x0070, 0x10, 19, 1),
	PIN_FIELD_BASE(211, 211, 7, 0x0070, 0x10, 21, 1),
	PIN_FIELD_BASE(212, 212, 7, 0x0070, 0x10, 18, 1),
	PIN_FIELD_BASE(213, 213, 7, 0x0070, 0x10, 22, 1),
	PIN_FIELD_BASE(214, 214, 7, 0x0070, 0x10, 0, 1),
	PIN_FIELD_BASE(215, 215, 7, 0x0070, 0x10, 9, 1),
	PIN_FIELD_BASE(216, 217, 7, 0x0070, 0x10, 4, 1),
	PIN_FIELD_BASE(218, 219, 7, 0x0070, 0x10, 1, 1),
};

static const struct mtk_pin_field_calc mt6893_pin_drv_range[] = {
	PINS_FIELD_BASE(0, 9, 2, 0x0000, 0x10, 21, 3),
	PINS_FIELD_BASE(10, 15, 1, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(16, 17, 5, 0x0000, 0x10, 18, 3),
	PINS_FIELD_BASE(18, 25, 7, 0x0000, 0x10, 3, 3),
	PINS_FIELD_BASE(26, 30, 6, 0x0000, 0x10, 15, 3),
	PINS_FIELD_BASE(31, 35, 6, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(36, 36, 6, 0x0010, 0x10, 7, 3),
	PINS_FIELD_BASE(37, 39, 6, 0x0010, 0x10, 4, 3),
	PIN_FIELD_BASE(40, 41, 6, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(42, 42, 6, 0x0000, 0x10, 12, 3),
	PINS_FIELD_BASE(43, 44, 6, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(45, 45, 6, 0x0000, 0x10, 30, 2),
	PIN_FIELD_BASE(46, 46, 6, 0x0010, 0x10, 2, 2),
	PIN_FIELD_BASE(47, 47, 6, 0x0010, 0x10, 0, 2),
	PIN_FIELD_BASE(48, 49, 6, 0x0000, 0x10, 26, 2),
	PIN_FIELD_BASE(50, 50, 6, 0x0000, 0x10, 24, 2),
	PIN_FIELD_BASE(51, 52, 3, 0x0000, 0x10, 18, 3),
	PINS_FIELD_BASE(53, 56, 3, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(57, 60, 3, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(61, 61, 3, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(62, 62, 4, 0x0000, 0x10, 3, 3),
	PINS_FIELD_BASE(63, 73, 3, 0x0000, 0x10, 0, 3),
	PINS_FIELD_BASE(74, 84, 4, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(85, 86, 4, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(87, 88, 4, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(89, 90, 2, 0x0020, 0x10, 15, 3),
	PIN_FIELD_BASE(91, 91, 2, 0x0000, 0x10, 0, 3),
	PINS_FIELD_BASE(92, 95, 2, 0x0030, 0x10, 3, 3),
	PIN_FIELD_BASE(96, 96, 2, 0x0020, 0x10, 27, 3),
	PIN_FIELD_BASE(97, 97, 2, 0x0020, 0x10, 21, 3),
	PIN_FIELD_BASE(98, 98, 2, 0x0030, 0x10, 0, 3),
	PINS_FIELD_BASE(99, 102, 2, 0x0020, 0x10, 24, 3),
	PINS_FIELD_BASE(103, 105, 2, 0x0020, 0x10, 9, 3),
	PIN_FIELD_BASE(106, 106, 2, 0x0020, 0x10, 12, 3),
	PIN_FIELD_BASE(107, 108, 2, 0x0000, 0x10, 15, 3),
	PINS_FIELD_BASE(109, 113, 2, 0x0000, 0x10, 24, 3),
	PINS_FIELD_BASE(114, 117, 2, 0x0010, 0x10, 18, 3),
	PIN_FIELD_BASE(118, 118, 2, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(119, 119, 2, 0x0010, 0x10, 21, 3),
	PIN_FIELD_BASE(120, 120, 2, 0x0010, 0x10, 15, 3),
	PIN_FIELD_BASE(121, 121, 2, 0x0020, 0x10, 6, 3),
	PIN_FIELD_BASE(122, 122, 2, 0x0010, 0x10, 12, 3),
	PIN_FIELD_BASE(123, 123, 2, 0x0020, 0x10, 3, 3),
	PIN_FIELD_BASE(124, 124, 2, 0x0010, 0x10, 9, 3),
	PIN_FIELD_BASE(125, 125, 2, 0x0020, 0x10, 0, 3),
	PINS_FIELD_BASE(126, 129, 2, 0x0000, 0x10, 27, 3),
	PINS_FIELD_BASE(130, 135, 2, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(136, 138, 2, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(139, 139, 2, 0x0010, 0x10, 6, 3),
	PIN_FIELD_BASE(140, 140, 2, 0x0010, 0x10, 27, 3),
	PIN_FIELD_BASE(141, 141, 2, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(142, 142, 2, 0x0010, 0x10, 24, 3),
	PINS_FIELD_BASE(143, 148, 1, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(149, 151, 1, 0x0000, 0x10, 0, 3),
	PINS_FIELD_BASE(152, 155, 5, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(156, 156, 5, 0x0010, 0x10, 6, 3),
	PINS_FIELD_BASE(157, 159, 5, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(160, 160, 5, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(161, 161, 5, 0x0010, 0x10, 0, 3),
	PINS_FIELD_BASE(162, 171, 5, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(172, 172, 5, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(173, 173, 5, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(174, 174, 5, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(175, 177, 5, 0x0000, 0x10, 3, 3),
	PINS_FIELD_BASE(178, 182, 5, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(183, 183, 7, 0x0000, 0x10, 9, 3),
	PINS_FIELD_BASE(184, 190, 7, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(191, 191, 7, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(192, 192, 7, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(193, 193, 7, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(194, 194, 7, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(195, 195, 7, 0x0010, 0x10, 3, 3),
	PINS_FIELD_BASE(196, 199, 7, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(200, 200, 7, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(201, 201, 7, 0x0010, 0x10, 9, 3),
	PIN_FIELD_BASE(202, 202, 7, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(203, 203, 7, 0x0010, 0x10, 6, 3),
	PIN_FIELD_BASE(204, 205, 6, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(206, 208, 7, 0x0010, 0x10, 12, 3),
	PINS_FIELD_BASE(209, 212, 7, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(213, 213, 7, 0x0000, 0x10, 24, 3),
	PINS_FIELD_BASE(214, 219, 7, 0x0000, 0x10, 0, 3),
};

static const struct mtk_pin_field_calc mt6893_pin_pupd_range[] = {
	PIN_FIELD_BASE(10, 15, 1, 0x0040, 0x10, 0, 1),
	PIN_FIELD_BASE(45, 45, 6, 0x0070, 0x10, 3, 1),
	PIN_FIELD_BASE(46, 46, 6, 0x0070, 0x10, 5, 1),
	PIN_FIELD_BASE(47, 47, 6, 0x0070, 0x10, 4, 1),
	PIN_FIELD_BASE(48, 49, 6, 0x0070, 0x10, 1, 1),
	PIN_FIELD_BASE(50, 50, 6, 0x0070, 0x10, 0, 1),
	PIN_FIELD_BASE(51, 52, 3, 0x0040, 0x10, 0, 1),
	PIN_FIELD_BASE(53, 53, 3, 0x0040, 0x10, 5, 1),
	PIN_FIELD_BASE(54, 54, 3, 0x0040, 0x10, 2, 1),
	PIN_FIELD_BASE(55, 55, 3, 0x0040, 0x10, 4, 1),
	PIN_FIELD_BASE(56, 56, 3, 0x0040, 0x10, 3, 1),
	PIN_FIELD_BASE(152, 152, 5, 0x0060, 0x10, 3, 1),
	PIN_FIELD_BASE(153, 153, 5, 0x0060, 0x10, 2, 1),
	PIN_FIELD_BASE(154, 155, 5, 0x0060, 0x10, 0, 1),
	PIN_FIELD_BASE(183, 184, 7, 0x0080, 0x10, 1, 1),
	PIN_FIELD_BASE(185, 185, 7, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(186, 186, 7, 0x0080, 0x10, 6, 1),
	PIN_FIELD_BASE(187, 187, 7, 0x0080, 0x10, 8, 1),
	PIN_FIELD_BASE(188, 188, 7, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(189, 189, 7, 0x0080, 0x10, 7, 1),
	PIN_FIELD_BASE(190, 191, 7, 0x0080, 0x10, 9, 1),
	PIN_FIELD_BASE(192, 192, 7, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(193, 193, 7, 0x0080, 0x10, 5, 1),
	PIN_FIELD_BASE(194, 194, 7, 0x0080, 0x10, 11, 1),
};

static const struct mtk_pin_field_calc mt6893_pin_r0_range[] = {
	PIN_FIELD_BASE(10, 15, 1, 0x0060, 0x10, 0, 1),
	PIN_FIELD_BASE(24, 24, 7, 0x00e0, 0x10, 0, 1),
	PIN_FIELD_BASE(25, 25, 7, 0x00e0, 0x10, 2, 1),
	PIN_FIELD_BASE(45, 45, 6, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(46, 46, 6, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(47, 47, 6, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(48, 49, 6, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(50, 50, 6, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(51, 52, 3, 0x0060, 0x10, 0, 1),
	PIN_FIELD_BASE(53, 53, 3, 0x0060, 0x10, 5, 1),
	PIN_FIELD_BASE(54, 54, 3, 0x0060, 0x10, 2, 1),
	PIN_FIELD_BASE(55, 55, 3, 0x0060, 0x10, 4, 1),
	PIN_FIELD_BASE(56, 56, 3, 0x0060, 0x10, 3, 1),
	PIN_FIELD_BASE(118, 118, 2, 0x00e0, 0x10, 0, 1),
	PIN_FIELD_BASE(119, 119, 2, 0x00e0, 0x10, 12, 1),
	PIN_FIELD_BASE(120, 120, 2, 0x00e0, 0x10, 10, 1),
	PIN_FIELD_BASE(121, 121, 2, 0x00e0, 0x10, 22, 1),
	PIN_FIELD_BASE(122, 122, 2, 0x00e0, 0x10, 8, 1),
	PIN_FIELD_BASE(123, 123, 2, 0x00e0, 0x10, 20, 1),
	PIN_FIELD_BASE(124, 124, 2, 0x00e0, 0x10, 6, 1),
	PIN_FIELD_BASE(125, 125, 2, 0x00e0, 0x10, 18, 1),
	PIN_FIELD_BASE(139, 139, 2, 0x00e0, 0x10, 4, 1),
	PIN_FIELD_BASE(140, 140, 2, 0x00e0, 0x10, 16, 1),
	PIN_FIELD_BASE(141, 141, 2, 0x00e0, 0x10, 2, 1),
	PIN_FIELD_BASE(142, 142, 2, 0x00e0, 0x10, 14, 1),
	PIN_FIELD_BASE(152, 152, 5, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(153, 153, 5, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(154, 155, 5, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(160, 160, 5, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(161, 161, 5, 0x00b0, 0x10, 2, 1),
	PIN_FIELD_BASE(183, 184, 7, 0x00a0, 0x10, 1, 1),
	PIN_FIELD_BASE(185, 185, 7, 0x00a0, 0x10, 4, 1),
	PIN_FIELD_BASE(186, 186, 7, 0x00a0, 0x10, 6, 1),
	PIN_FIELD_BASE(187, 187, 7, 0x00a0, 0x10, 8, 1),
	PIN_FIELD_BASE(188, 188, 7, 0x00a0, 0x10, 3, 1),
	PIN_FIELD_BASE(189, 189, 7, 0x00a0, 0x10, 7, 1),
	PIN_FIELD_BASE(190, 191, 7, 0x00a0, 0x10, 9, 1),
	PIN_FIELD_BASE(192, 192, 7, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(193, 193, 7, 0x00a0, 0x10, 5, 1),
	PIN_FIELD_BASE(194, 194, 7, 0x00a0, 0x10, 11, 1),
	PIN_FIELD_BASE(200, 200, 7, 0x00e0, 0x10, 6, 1),
	PIN_FIELD_BASE(201, 201, 7, 0x00e0, 0x10, 10, 1),
	PIN_FIELD_BASE(202, 202, 7, 0x00e0, 0x10, 4, 1),
	PIN_FIELD_BASE(203, 203, 7, 0x00e0, 0x10, 8, 1),
	PIN_FIELD_BASE(204, 204, 6, 0x00d0, 0x10, 0, 1),
	PIN_FIELD_BASE(205, 205, 6, 0x00d0, 0x10, 2, 1),
};

static const struct mtk_pin_field_calc mt6893_pin_r1_range[] = {
	PIN_FIELD_BASE(10, 15, 1, 0x0070, 0x10, 0, 1),
	PIN_FIELD_BASE(24, 24, 7, 0x00e0, 0x10, 1, 1),
	PIN_FIELD_BASE(25, 25, 7, 0x00e0, 0x10, 3, 1),
	PIN_FIELD_BASE(45, 45, 6, 0x00a0, 0x10, 3, 1),
	PIN_FIELD_BASE(46, 46, 6, 0x00a0, 0x10, 5, 1),
	PIN_FIELD_BASE(47, 47, 6, 0x00a0, 0x10, 4, 1),
	PIN_FIELD_BASE(48, 49, 6, 0x00a0, 0x10, 1, 1),
	PIN_FIELD_BASE(50, 50, 6, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(51, 52, 3, 0x0070, 0x10, 0, 1),
	PIN_FIELD_BASE(53, 53, 3, 0x0070, 0x10, 5, 1),
	PIN_FIELD_BASE(54, 54, 3, 0x0070, 0x10, 2, 1),
	PIN_FIELD_BASE(55, 55, 3, 0x0070, 0x10, 4, 1),
	PIN_FIELD_BASE(56, 56, 3, 0x0070, 0x10, 3, 1),
	PIN_FIELD_BASE(118, 118, 2, 0x00e0, 0x10, 1, 1),
	PIN_FIELD_BASE(119, 119, 2, 0x00e0, 0x10, 13, 1),
	PIN_FIELD_BASE(120, 120, 2, 0x00e0, 0x10, 11, 1),
	PIN_FIELD_BASE(121, 121, 2, 0x00e0, 0x10, 23, 1),
	PIN_FIELD_BASE(122, 122, 2, 0x00e0, 0x10, 9, 1),
	PIN_FIELD_BASE(123, 123, 2, 0x00e0, 0x10, 21, 1),
	PIN_FIELD_BASE(124, 124, 2, 0x00e0, 0x10, 7, 1),
	PIN_FIELD_BASE(125, 125, 2, 0x00e0, 0x10, 19, 1),
	PIN_FIELD_BASE(139, 139, 2, 0x00e0, 0x10, 5, 1),
	PIN_FIELD_BASE(140, 140, 2, 0x00e0, 0x10, 17, 1),
	PIN_FIELD_BASE(141, 141, 2, 0x00e0, 0x10, 3, 1),
	PIN_FIELD_BASE(142, 142, 2, 0x00e0, 0x10, 15, 1),
	PIN_FIELD_BASE(152, 152, 5, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(153, 153, 5, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(154, 155, 5, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(160, 160, 5, 0x00b0, 0x10, 1, 1),
	PIN_FIELD_BASE(161, 161, 5, 0x00b0, 0x10, 3, 1),
	PIN_FIELD_BASE(183, 184, 7, 0x00b0, 0x10, 1, 1),
	PIN_FIELD_BASE(185, 185, 7, 0x00b0, 0x10, 4, 1),
	PIN_FIELD_BASE(186, 186, 7, 0x00b0, 0x10, 6, 1),
	PIN_FIELD_BASE(187, 187, 7, 0x00b0, 0x10, 8, 1),
	PIN_FIELD_BASE(188, 188, 7, 0x00b0, 0x10, 3, 1),
	PIN_FIELD_BASE(189, 189, 7, 0x00b0, 0x10, 7, 1),
	PIN_FIELD_BASE(190, 191, 7, 0x00b0, 0x10, 9, 1),
	PIN_FIELD_BASE(192, 192, 7, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(193, 193, 7, 0x00b0, 0x10, 5, 1),
	PIN_FIELD_BASE(194, 194, 7, 0x00b0, 0x10, 11, 1),
	PIN_FIELD_BASE(200, 200, 7, 0x00e0, 0x10, 7, 1),
	PIN_FIELD_BASE(201, 201, 7, 0x00e0, 0x10, 11, 1),
	PIN_FIELD_BASE(202, 202, 7, 0x00e0, 0x10, 5, 1),
	PIN_FIELD_BASE(203, 203, 7, 0x00e0, 0x10, 9, 1),
	PIN_FIELD_BASE(204, 204, 6, 0x00d0, 0x10, 1, 1),
	PIN_FIELD_BASE(205, 205, 6, 0x00d0, 0x10, 3, 1),
};

static const struct mtk_pin_field_calc mt6893_pin_drv_adv_range[] = {
	PIN_FIELD_BASE(24, 24, 7, 0x0030, 0x10, 0, 3),
	PIN_FIELD_BASE(25, 25, 7, 0x0030, 0x10, 3, 3),
	PIN_FIELD_BASE(89, 89, 2, 0x0050, 0x10, 6, 5),
	PIN_FIELD_BASE(90, 90, 2, 0x0050, 0x10, 11, 5),
	PIN_FIELD_BASE(118, 118, 2, 0x0040, 0x10, 0, 3),
	PIN_FIELD_BASE(119, 119, 2, 0x0040, 0x10, 18, 3),
	PIN_FIELD_BASE(120, 120, 2, 0x0040, 0x10, 15, 3),
	PIN_FIELD_BASE(121, 121, 2, 0x0050, 0x10, 3, 3),
	PIN_FIELD_BASE(122, 122, 2, 0x0040, 0x10, 12, 3),
	PIN_FIELD_BASE(123, 123, 2, 0x0050, 0x10, 0, 3),
	PIN_FIELD_BASE(124, 124, 2, 0x0040, 0x10, 9, 3),
	PIN_FIELD_BASE(125, 125, 2, 0x0040, 0x10, 27, 3),
	PIN_FIELD_BASE(139, 139, 2, 0x0040, 0x10, 6, 3),
	PIN_FIELD_BASE(140, 140, 2, 0x0040, 0x10, 24, 3),
	PIN_FIELD_BASE(141, 141, 2, 0x0040, 0x10, 3, 3),
	PIN_FIELD_BASE(142, 142, 2, 0x0040, 0x10, 21, 3),
	PIN_FIELD_BASE(160, 160, 5, 0x0020, 0x10, 0, 3),
	PIN_FIELD_BASE(161, 161, 5, 0x0020, 0x10, 3, 3),
	PIN_FIELD_BASE(200, 200, 7, 0x0030, 0x10, 9, 3),
	PIN_FIELD_BASE(201, 201, 7, 0x0030, 0x10, 15, 3),
	PIN_FIELD_BASE(202, 202, 7, 0x0030, 0x10, 6, 3),
	PIN_FIELD_BASE(203, 203, 7, 0x0030, 0x10, 12, 3),
	PIN_FIELD_BASE(204, 204, 6, 0x0020, 0x10, 0, 3),
	PIN_FIELD_BASE(205, 205, 6, 0x0020, 0x10, 3, 3),
};

static const struct mtk_pin_field_calc mt6893_pin_rsel_range[] = {
	PIN_FIELD_BASE(24, 24, 7, 0x00e0, 0x10, 0, 2),
	PIN_FIELD_BASE(25, 25, 7, 0x00e0, 0x10, 2, 2),
	PIN_FIELD_BASE(118, 118, 2, 0x00e0, 0x10, 0, 2),
	PIN_FIELD_BASE(119, 119, 2, 0x00e0, 0x10, 12, 2),
	PIN_FIELD_BASE(120, 120, 2, 0x00e0, 0x10, 10, 2),
	PIN_FIELD_BASE(121, 121, 2, 0x00e0, 0x10, 22, 2),
	PIN_FIELD_BASE(122, 122, 2, 0x00e0, 0x10, 8, 2),
	PIN_FIELD_BASE(123, 123, 2, 0x00e0, 0x10, 20, 2),
	PIN_FIELD_BASE(124, 124, 2, 0x00e0, 0x10, 6, 2),
	PIN_FIELD_BASE(125, 125, 2, 0x00e0, 0x10, 18, 2),
	PIN_FIELD_BASE(139, 139, 2, 0x00e0, 0x10, 4, 2),
	PIN_FIELD_BASE(140, 140, 2, 0x00e0, 0x10, 16, 2),
	PIN_FIELD_BASE(141, 141, 2, 0x00e0, 0x10, 2, 2),
	PIN_FIELD_BASE(142, 142, 2, 0x00e0, 0x10, 14, 2),
	PIN_FIELD_BASE(160, 160, 5, 0x00b0, 0x10, 0, 2),
	PIN_FIELD_BASE(161, 161, 5, 0x00b0, 0x10, 2, 2),
	PIN_FIELD_BASE(200, 200, 7, 0x00e0, 0x10, 6, 2),
	PIN_FIELD_BASE(201, 201, 7, 0x00e0, 0x10, 10, 2),
	PIN_FIELD_BASE(202, 202, 7, 0x00e0, 0x10, 4, 2),
	PIN_FIELD_BASE(203, 203, 7, 0x00e0, 0x10, 8, 2),
	PIN_FIELD_BASE(204, 204, 6, 0x00d0, 0x10, 0, 2),
	PIN_FIELD_BASE(205, 205, 6, 0x00d0, 0x10, 2, 2),
};

static const unsigned int mt6893_pull_type[] = {
	MTK_PULL_PU_PD_TYPE, /* 0 */		MTK_PULL_PU_PD_TYPE, /* 1 */
	MTK_PULL_PU_PD_TYPE, /* 2 */		MTK_PULL_PU_PD_TYPE, /* 3 */
	MTK_PULL_PU_PD_TYPE, /* 4 */		MTK_PULL_PU_PD_TYPE, /* 5 */
	MTK_PULL_PU_PD_TYPE, /* 6 */		MTK_PULL_PU_PD_TYPE, /* 7 */
	MTK_PULL_PU_PD_TYPE, /* 8 */		MTK_PULL_PU_PD_TYPE, /* 9 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 10 */	MTK_PULL_PUPD_R1R0_TYPE, /* 11 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 12 */	MTK_PULL_PUPD_R1R0_TYPE, /* 13 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 14 */	MTK_PULL_PUPD_R1R0_TYPE, /* 15 */
	MTK_PULL_PU_PD_TYPE, /* 16 */		MTK_PULL_PU_PD_TYPE, /* 17 */
	MTK_PULL_PU_PD_TYPE, /* 18 */		MTK_PULL_PU_PD_TYPE, /* 19 */
	MTK_PULL_PU_PD_TYPE, /* 20 */		MTK_PULL_PU_PD_TYPE, /* 21 */
	MTK_PULL_PU_PD_TYPE, /* 22 */		MTK_PULL_PU_PD_TYPE, /* 23 */
	MTK_PULL_PU_PD_RSEL_TYPE, /* 24 */	MTK_PULL_PU_PD_RSEL_TYPE, /* 25 */
	MTK_PULL_PU_PD_TYPE, /* 26 */		MTK_PULL_PU_PD_TYPE, /* 27 */
	MTK_PULL_PU_PD_TYPE, /* 28 */		MTK_PULL_PU_PD_TYPE, /* 29 */
	MTK_PULL_PU_PD_TYPE, /* 30 */		MTK_PULL_PU_PD_TYPE, /* 31 */
	MTK_PULL_PU_PD_TYPE, /* 32 */		MTK_PULL_PU_PD_TYPE, /* 33 */
	MTK_PULL_PU_PD_TYPE, /* 34 */		MTK_PULL_PU_PD_TYPE, /* 35 */
	MTK_PULL_PU_PD_TYPE, /* 36 */		MTK_PULL_PU_PD_TYPE, /* 37 */
	MTK_PULL_PU_PD_TYPE, /* 38 */		MTK_PULL_PU_PD_TYPE, /* 39 */
	MTK_PULL_PU_PD_TYPE, /* 40 */		MTK_PULL_PU_PD_TYPE, /* 41 */
	MTK_PULL_PU_PD_TYPE, /* 42 */		MTK_PULL_PU_PD_TYPE, /* 43 */
	MTK_PULL_PU_PD_TYPE, /* 44 */		MTK_PULL_PUPD_R1R0_TYPE, /* 45 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 46 */	MTK_PULL_PUPD_R1R0_TYPE, /* 47 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 48 */	MTK_PULL_PUPD_R1R0_TYPE, /* 49 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 50 */	MTK_PULL_PUPD_R1R0_TYPE, /* 51 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 52 */	MTK_PULL_PUPD_R1R0_TYPE, /* 53 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 54 */	MTK_PULL_PUPD_R1R0_TYPE, /* 55 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 56 */	MTK_PULL_PU_PD_TYPE, /* 57 */
	MTK_PULL_PU_PD_TYPE, /* 58 */		MTK_PULL_PU_PD_TYPE, /* 59 */
	MTK_PULL_PU_PD_TYPE, /* 60 */		MTK_PULL_PU_PD_TYPE, /* 61 */
	MTK_PULL_PU_PD_TYPE, /* 62 */		MTK_PULL_PU_PD_TYPE, /* 63 */
	MTK_PULL_PU_PD_TYPE, /* 64 */		MTK_PULL_PU_PD_TYPE, /* 65 */
	MTK_PULL_PU_PD_TYPE, /* 66 */		MTK_PULL_PU_PD_TYPE, /* 67 */
	MTK_PULL_PU_PD_TYPE, /* 68 */		MTK_PULL_PU_PD_TYPE, /* 69 */
	MTK_PULL_PU_PD_TYPE, /* 70 */		MTK_PULL_PU_PD_TYPE, /* 71 */
	MTK_PULL_PU_PD_TYPE, /* 72 */		MTK_PULL_PU_PD_TYPE, /* 73 */
	MTK_PULL_PU_PD_TYPE, /* 74 */		MTK_PULL_PU_PD_TYPE, /* 75 */
	MTK_PULL_PU_PD_TYPE, /* 76 */		MTK_PULL_PU_PD_TYPE, /* 77 */
	MTK_PULL_PU_PD_TYPE, /* 78 */		MTK_PULL_PU_PD_TYPE, /* 79 */
	MTK_PULL_PU_PD_TYPE, /* 80 */		MTK_PULL_PU_PD_TYPE, /* 81 */
	MTK_PULL_PU_PD_TYPE, /* 82 */		MTK_PULL_PU_PD_TYPE, /* 83 */
	MTK_PULL_PU_PD_TYPE, /* 84 */		MTK_PULL_PU_PD_TYPE, /* 85 */
	MTK_PULL_PU_PD_TYPE, /* 86 */		MTK_PULL_PU_PD_TYPE, /* 87 */
	MTK_PULL_PU_PD_TYPE, /* 88 */		MTK_PULL_PU_PD_TYPE, /* 89 */
	MTK_PULL_PU_PD_TYPE, /* 90 */		MTK_PULL_PU_PD_TYPE, /* 91 */
	MTK_PULL_PU_PD_TYPE, /* 92 */		MTK_PULL_PU_PD_TYPE, /* 93 */
	MTK_PULL_PU_PD_TYPE, /* 94 */		MTK_PULL_PU_PD_TYPE, /* 95 */
	MTK_PULL_PU_PD_TYPE, /* 96 */		MTK_PULL_PU_PD_TYPE, /* 97 */
	MTK_PULL_PU_PD_TYPE, /* 98 */		MTK_PULL_PU_PD_TYPE, /* 99 */
	MTK_PULL_PU_PD_TYPE, /* 100 */		MTK_PULL_PU_PD_TYPE, /* 101 */
	MTK_PULL_PU_PD_TYPE, /* 102 */		MTK_PULL_PU_PD_TYPE, /* 103 */
	MTK_PULL_PU_PD_TYPE, /* 104 */		MTK_PULL_PU_PD_TYPE, /* 105 */
	MTK_PULL_PU_PD_TYPE, /* 106 */		MTK_PULL_PU_PD_TYPE, /* 107 */
	MTK_PULL_PU_PD_TYPE, /* 108 */		MTK_PULL_PU_PD_TYPE, /* 109 */
	MTK_PULL_PU_PD_TYPE, /* 110 */		MTK_PULL_PU_PD_TYPE, /* 111 */
	MTK_PULL_PU_PD_TYPE, /* 112 */		MTK_PULL_PU_PD_TYPE, /* 113 */
	MTK_PULL_PU_PD_TYPE, /* 114 */		MTK_PULL_PU_PD_TYPE, /* 115 */
	MTK_PULL_PU_PD_TYPE, /* 116 */		MTK_PULL_PU_PD_TYPE, /* 117 */
	MTK_PULL_PU_PD_RSEL_TYPE, /* 118 */	MTK_PULL_PU_PD_RSEL_TYPE, /* 119 */
	MTK_PULL_PU_PD_RSEL_TYPE, /* 120 */	MTK_PULL_PU_PD_RSEL_TYPE, /* 121 */
	MTK_PULL_PU_PD_RSEL_TYPE, /* 122 */	MTK_PULL_PU_PD_RSEL_TYPE, /* 123 */
	MTK_PULL_PU_PD_RSEL_TYPE, /* 124 */	MTK_PULL_PU_PD_RSEL_TYPE, /* 125 */
	MTK_PULL_PU_PD_TYPE, /* 126 */		MTK_PULL_PU_PD_TYPE, /* 127 */
	MTK_PULL_PU_PD_TYPE, /* 128 */		MTK_PULL_PU_PD_TYPE, /* 129 */
	MTK_PULL_PU_PD_TYPE, /* 130 */		MTK_PULL_PU_PD_TYPE, /* 131 */
	MTK_PULL_PU_PD_TYPE, /* 132 */		MTK_PULL_PU_PD_TYPE, /* 133 */
	MTK_PULL_PU_PD_TYPE, /* 134 */		MTK_PULL_PU_PD_TYPE, /* 135 */
	MTK_PULL_PU_PD_TYPE, /* 136 */		MTK_PULL_PU_PD_TYPE, /* 137 */
	MTK_PULL_PU_PD_TYPE, /* 138 */		MTK_PULL_PU_PD_TYPE, /* 139 */
	MTK_PULL_PU_PD_RSEL_TYPE, /* 140 */	MTK_PULL_PU_PD_RSEL_TYPE, /* 141 */
	MTK_PULL_PU_PD_RSEL_TYPE, /* 142 */	MTK_PULL_PU_PD_TYPE, /* 143 */
	MTK_PULL_PU_PD_TYPE, /* 144 */		MTK_PULL_PU_PD_TYPE, /* 145 */
	MTK_PULL_PU_PD_TYPE, /* 146 */		MTK_PULL_PU_PD_TYPE, /* 147 */
	MTK_PULL_PU_PD_TYPE, /* 148 */		MTK_PULL_PU_PD_TYPE, /* 149 */
	MTK_PULL_PU_PD_TYPE, /* 150 */		MTK_PULL_PU_PD_TYPE, /* 151 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 152 */	MTK_PULL_PUPD_R1R0_TYPE, /* 153 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 154 */	MTK_PULL_PUPD_R1R0_TYPE, /* 155 */
	MTK_PULL_PU_PD_TYPE, /* 156 */		MTK_PULL_PU_PD_TYPE, /* 157 */
	MTK_PULL_PU_PD_TYPE, /* 158 */		MTK_PULL_PU_PD_TYPE, /* 159 */
	MTK_PULL_PU_PD_RSEL_TYPE, /* 160 */	MTK_PULL_PU_PD_RSEL_TYPE, /* 161 */
	MTK_PULL_PU_PD_TYPE, /* 162 */		MTK_PULL_PU_PD_TYPE, /* 163 */
	MTK_PULL_PU_PD_TYPE, /* 164 */		MTK_PULL_PU_PD_TYPE, /* 165 */
	MTK_PULL_PU_PD_TYPE, /* 166 */		MTK_PULL_PU_PD_TYPE, /* 167 */
	MTK_PULL_PU_PD_TYPE, /* 168 */		MTK_PULL_PU_PD_TYPE, /* 169 */
	MTK_PULL_PU_PD_TYPE, /* 170 */		MTK_PULL_PU_PD_TYPE, /* 171 */
	MTK_PULL_PU_PD_TYPE, /* 172 */		MTK_PULL_PU_PD_TYPE, /* 173 */
	MTK_PULL_PU_PD_TYPE, /* 174 */		MTK_PULL_PU_PD_TYPE, /* 175 */
	MTK_PULL_PU_PD_TYPE, /* 176 */		MTK_PULL_PU_PD_TYPE, /* 177 */
	MTK_PULL_PU_PD_TYPE, /* 178 */		MTK_PULL_PU_PD_TYPE, /* 179 */
	MTK_PULL_PU_PD_TYPE, /* 180 */		MTK_PULL_PU_PD_TYPE, /* 181 */
	MTK_PULL_PU_PD_TYPE, /* 182 */		MTK_PULL_PUPD_R1R0_TYPE, /* 183 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 184 */	MTK_PULL_PUPD_R1R0_TYPE, /* 185 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 186 */	MTK_PULL_PUPD_R1R0_TYPE, /* 187 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 188 */	MTK_PULL_PUPD_R1R0_TYPE, /* 189 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 190 */	MTK_PULL_PUPD_R1R0_TYPE, /* 191 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 192 */	MTK_PULL_PUPD_R1R0_TYPE, /* 193 */
	MTK_PULL_PUPD_R1R0_TYPE, /* 194 */	MTK_PULL_PU_PD_TYPE, /* 195 */
	MTK_PULL_PU_PD_TYPE, /* 196 */		MTK_PULL_PU_PD_TYPE, /* 197 */
	MTK_PULL_PU_PD_TYPE, /* 198 */		MTK_PULL_PU_PD_TYPE, /* 199 */
	MTK_PULL_PU_PD_RSEL_TYPE, /* 200 */	MTK_PULL_PU_PD_RSEL_TYPE, /* 201 */
	MTK_PULL_PU_PD_RSEL_TYPE, /* 202 */	MTK_PULL_PU_PD_RSEL_TYPE, /* 203 */
	MTK_PULL_PU_PD_RSEL_TYPE, /* 204 */	MTK_PULL_PU_PD_RSEL_TYPE, /* 205 */
	MTK_PULL_PU_PD_TYPE, /* 206 */		MTK_PULL_PU_PD_TYPE, /* 207 */
	MTK_PULL_PU_PD_TYPE, /* 208 */		MTK_PULL_PU_PD_TYPE, /* 209 */
	MTK_PULL_PU_PD_TYPE, /* 210 */		MTK_PULL_PU_PD_TYPE, /* 211 */
	MTK_PULL_PU_PD_TYPE, /* 212 */		MTK_PULL_PU_PD_TYPE, /* 213 */
	MTK_PULL_PU_PD_TYPE, /* 214 */		MTK_PULL_PU_PD_TYPE, /* 215 */
	MTK_PULL_PU_PD_TYPE, /* 216 */		MTK_PULL_PU_PD_TYPE, /* 217 */
	MTK_PULL_PU_PD_TYPE, /* 218 */		MTK_PULL_PU_PD_TYPE, /* 219 */
};

static const char * const mt6893_pinctrl_register_base_name[] = {
	"base", "rm", "bm", "bl", "br", "lm", "lb", "rt", "lt", "tl",
};

static const struct mtk_pin_reg_calc mt6893_reg_cals[PINCTRL_PIN_REG_MAX] = {
	[PINCTRL_PIN_REG_MODE] = MTK_RANGE(mt6893_pin_mode_range),
	[PINCTRL_PIN_REG_DIR] = MTK_RANGE(mt6893_pin_dir_range),
	[PINCTRL_PIN_REG_DI] = MTK_RANGE(mt6893_pin_di_range),
	[PINCTRL_PIN_REG_DO] = MTK_RANGE(mt6893_pin_do_range),
	[PINCTRL_PIN_REG_SR] = MTK_RANGE(mt6893_pin_dir_range),
	[PINCTRL_PIN_REG_SMT] = MTK_RANGE(mt6893_pin_smt_range),
	[PINCTRL_PIN_REG_IES] = MTK_RANGE(mt6893_pin_ies_range),
	[PINCTRL_PIN_REG_PU] = MTK_RANGE(mt6893_pin_pu_range),
	[PINCTRL_PIN_REG_PD] = MTK_RANGE(mt6893_pin_pd_range),
	[PINCTRL_PIN_REG_DRV] = MTK_RANGE(mt6893_pin_drv_range),
	[PINCTRL_PIN_REG_PUPD] = MTK_RANGE(mt6893_pin_pupd_range),
	[PINCTRL_PIN_REG_R0] = MTK_RANGE(mt6893_pin_r0_range),
	[PINCTRL_PIN_REG_R1] = MTK_RANGE(mt6893_pin_r1_range),
	[PINCTRL_PIN_REG_DRV_ADV] = MTK_RANGE(mt6893_pin_drv_adv_range),
	[PINCTRL_PIN_REG_RSEL] = MTK_RANGE(mt6893_pin_rsel_range),
};

static const struct mtk_eint_hw mt6893_eint_hw = {
	.port_mask = 7,
	.ports     = 7,
	.ap_num    = 224,
	.db_cnt    = 32,
	.db_time   = debounce_time_mt6765,
};

static const struct mtk_pin_soc mt6893_data = {
	.reg_cal = mt6893_reg_cals,
	.pins = mtk_pins_mt6893,
	.npins = ARRAY_SIZE(mtk_pins_mt6893),
	.ngrps = ARRAY_SIZE(mtk_pins_mt6893),
	.eint_hw = &mt6893_eint_hw,
	.nfuncs = 8,
	.gpio_m = 0,
	.base_names = mt6893_pinctrl_register_base_name,
	.nbase_names = ARRAY_SIZE(mt6893_pinctrl_register_base_name),
	.pull_type = mt6893_pull_type,
	.bias_set_combo = mtk_pinconf_bias_set_combo,
	.bias_get_combo = mtk_pinconf_bias_get_combo,
	.drive_set = mtk_pinconf_drive_set_rev1,
	.drive_get = mtk_pinconf_drive_get_rev1,
	.adv_drive_set = mtk_pinconf_adv_drive_set_raw,
	.adv_drive_get = mtk_pinconf_adv_drive_get_raw,
};

static const struct of_device_id mt6893_pinctrl_of_match[] = {
	{ .compatible = "mediatek,mt6893-pinctrl", .data = &mt6893_data },
	{ /* sentinel */ }
};

static struct platform_driver mt6893_pinctrl_driver = {
	.driver = {
		.name = "mt6893-pinctrl",
		.of_match_table = mt6893_pinctrl_of_match,
		.pm = pm_sleep_ptr(&mtk_paris_pinctrl_pm_ops)
	},
	.probe = mtk_paris_pinctrl_probe,
};

static int __init mt6893_pinctrl_init(void)
{
	return platform_driver_register(&mt6893_pinctrl_driver);
}

arch_initcall(mt6893_pinctrl_init);

MODULE_DESCRIPTION("MediaTek MT6893 Pinctrl Driver");
