/* $Id: TMgr_IdentityId.cpp 477867 2015-09-02 13:52:21Z meric $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'trackmgr.asn'.
 */

#include <ncbi_pch.hpp>
#include <objects/trackmgr/TMgr_IdentityId.hpp>

BEGIN_NCBI_SCOPE
BEGIN_objects_SCOPE // namespace ncbi::objects::


// destructor
CTMgr_IdentityId::~CTMgr_IdentityId(void)
{
}


CRef<CTMgr_IdentityId>
CTMgr_IdentityId::FromMyNCBIId(const int myncbi_id)
{
    return FromMyNCBIId(NStr::IntToString(myncbi_id));
}

CRef<CTMgr_IdentityId>
CTMgr_IdentityId::FromMyNCBIId(const string& myncbi_id)
{
    CRef<CTMgr_IdentityId> id(new CTMgr_IdentityId());
    id->SetId(myncbi_id);
    id->SetId_type(eTMgr_IdentityIdType_myncbi_id);
    return id;
}

CRef<CTMgr_IdentityId>
CTMgr_IdentityId::FromSessionId(const string& session_id)
{
    CRef<CTMgr_IdentityId> id(new CTMgr_IdentityId());
    id->SetId(session_id);
    id->SetId_type(eTMgr_IdentityIdType_ncbi_sid);
    return id;
}


END_objects_SCOPE // namespace ncbi::objects::
END_NCBI_SCOPE

