/*
 * Odyssey.
 *
 * Scalable PostgreSQL connection pooler.
 */

#include <odyssey.h>

#include <machinarium/machinarium.h>

#include <thread_global.h>
#include <global.h>
#include <instance.h>
#include <od_memory.h>

od_retcode_t od_thread_global_init(od_thread_global **gl)
{
	*gl = od_malloc(sizeof(od_thread_global));
	if (*gl == NULL) {
		return NOT_OK_RESPONSE;
	}

	if (od_conn_eject_info_init(
		    &(*gl)->info,
		    &od_global_get_instance()->config.conn_drop_options) != 0) {
		od_free(*gl);
		return NOT_OK_RESPONSE;
	}

	return OK_RESPONSE;
}

od_thread_global **od_thread_global_get(void)
{
	return (od_thread_global **)machine_thread_private();
}

od_retcode_t od_thread_global_free(od_thread_global *gl)
{
	od_retcode_t rc = od_conn_eject_info_free(gl->info);

	if (rc != OK_RESPONSE) {
		return rc;
	}

	od_free(gl);

	return OK_RESPONSE;
}
