/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_SLEEP_ASSESSMENT_MESG_HPP)
#define FIT_SLEEP_ASSESSMENT_MESG_HPP

#include "fit_mesg.hpp"

namespace fit
{

class SleepAssessmentMesg : public Mesg
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 CombinedAwakeScore = 0;
       static const FIT_UINT8 AwakeTimeScore = 1;
       static const FIT_UINT8 AwakeningsCountScore = 2;
       static const FIT_UINT8 DeepSleepScore = 3;
       static const FIT_UINT8 SleepDurationScore = 4;
       static const FIT_UINT8 LightSleepScore = 5;
       static const FIT_UINT8 OverallSleepScore = 6;
       static const FIT_UINT8 SleepQualityScore = 7;
       static const FIT_UINT8 SleepRecoveryScore = 8;
       static const FIT_UINT8 RemSleepScore = 9;
       static const FIT_UINT8 SleepRestlessnessScore = 10;
       static const FIT_UINT8 AwakeningsCount = 11;
       static const FIT_UINT8 InterruptionsScore = 14;
       static const FIT_UINT8 AverageStressDuringSleep = 15;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    SleepAssessmentMesg(void) : Mesg(Profile::MESG_SLEEP_ASSESSMENT)
    {
    }

    SleepAssessmentMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of combined_awake_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCombinedAwakeScoreValid() const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns combined_awake_score field
    // Comment: Average of awake_time_score and awakenings_count_score. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetCombinedAwakeScore(void) const
    {
        return GetFieldUINT8Value(0, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set combined_awake_score field
    // Comment: Average of awake_time_score and awakenings_count_score. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetCombinedAwakeScore(FIT_UINT8 combinedAwakeScore)
    {
        SetFieldUINT8Value(0, combinedAwakeScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of awake_time_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAwakeTimeScoreValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns awake_time_score field
    // Comment: Score that evaluates the total time spent awake between sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAwakeTimeScore(void) const
    {
        return GetFieldUINT8Value(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set awake_time_score field
    // Comment: Score that evaluates the total time spent awake between sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetAwakeTimeScore(FIT_UINT8 awakeTimeScore)
    {
        SetFieldUINT8Value(1, awakeTimeScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of awakenings_count_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAwakeningsCountScoreValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns awakenings_count_score field
    // Comment: Score that evaluates the number of awakenings that interrupt sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAwakeningsCountScore(void) const
    {
        return GetFieldUINT8Value(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set awakenings_count_score field
    // Comment: Score that evaluates the number of awakenings that interrupt sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetAwakeningsCountScore(FIT_UINT8 awakeningsCountScore)
    {
        SetFieldUINT8Value(2, awakeningsCountScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of deep_sleep_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDeepSleepScoreValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns deep_sleep_score field
    // Comment: Score that evaluates the amount of deep sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetDeepSleepScore(void) const
    {
        return GetFieldUINT8Value(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set deep_sleep_score field
    // Comment: Score that evaluates the amount of deep sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetDeepSleepScore(FIT_UINT8 deepSleepScore)
    {
        SetFieldUINT8Value(3, deepSleepScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sleep_duration_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSleepDurationScoreValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sleep_duration_score field
    // Comment: Score that evaluates the quality of sleep based on sleep stages, heart-rate variability and possible awakenings during the night. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetSleepDurationScore(void) const
    {
        return GetFieldUINT8Value(4, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sleep_duration_score field
    // Comment: Score that evaluates the quality of sleep based on sleep stages, heart-rate variability and possible awakenings during the night. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetSleepDurationScore(FIT_UINT8 sleepDurationScore)
    {
        SetFieldUINT8Value(4, sleepDurationScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of light_sleep_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLightSleepScoreValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns light_sleep_score field
    // Comment: Score that evaluates the amount of light sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetLightSleepScore(void) const
    {
        return GetFieldUINT8Value(5, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set light_sleep_score field
    // Comment: Score that evaluates the amount of light sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetLightSleepScore(FIT_UINT8 lightSleepScore)
    {
        SetFieldUINT8Value(5, lightSleepScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of overall_sleep_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsOverallSleepScoreValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns overall_sleep_score field
    // Comment: Total score that summarizes the overall quality of sleep, combining sleep duration and quality. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetOverallSleepScore(void) const
    {
        return GetFieldUINT8Value(6, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set overall_sleep_score field
    // Comment: Total score that summarizes the overall quality of sleep, combining sleep duration and quality. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetOverallSleepScore(FIT_UINT8 overallSleepScore)
    {
        SetFieldUINT8Value(6, overallSleepScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sleep_quality_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSleepQualityScoreValid() const
    {
        const Field* field = GetField(7);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sleep_quality_score field
    // Comment: Score that evaluates the quality of sleep based on sleep stages, heart-rate variability and possible awakenings during the night. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetSleepQualityScore(void) const
    {
        return GetFieldUINT8Value(7, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sleep_quality_score field
    // Comment: Score that evaluates the quality of sleep based on sleep stages, heart-rate variability and possible awakenings during the night. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetSleepQualityScore(FIT_UINT8 sleepQualityScore)
    {
        SetFieldUINT8Value(7, sleepQualityScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sleep_recovery_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSleepRecoveryScoreValid() const
    {
        const Field* field = GetField(8);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sleep_recovery_score field
    // Comment: Score that evaluates stress and recovery during sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetSleepRecoveryScore(void) const
    {
        return GetFieldUINT8Value(8, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sleep_recovery_score field
    // Comment: Score that evaluates stress and recovery during sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetSleepRecoveryScore(FIT_UINT8 sleepRecoveryScore)
    {
        SetFieldUINT8Value(8, sleepRecoveryScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of rem_sleep_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRemSleepScoreValid() const
    {
        const Field* field = GetField(9);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns rem_sleep_score field
    // Comment: Score that evaluates the amount of REM sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetRemSleepScore(void) const
    {
        return GetFieldUINT8Value(9, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set rem_sleep_score field
    // Comment: Score that evaluates the amount of REM sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetRemSleepScore(FIT_UINT8 remSleepScore)
    {
        SetFieldUINT8Value(9, remSleepScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sleep_restlessness_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSleepRestlessnessScoreValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sleep_restlessness_score field
    // Comment: Score that evaluates the amount of restlessness during sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetSleepRestlessnessScore(void) const
    {
        return GetFieldUINT8Value(10, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sleep_restlessness_score field
    // Comment: Score that evaluates the amount of restlessness during sleep. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetSleepRestlessnessScore(FIT_UINT8 sleepRestlessnessScore)
    {
        SetFieldUINT8Value(10, sleepRestlessnessScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of awakenings_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAwakeningsCountValid() const
    {
        const Field* field = GetField(11);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns awakenings_count field
    // Comment: The number of awakenings during sleep.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAwakeningsCount(void) const
    {
        return GetFieldUINT8Value(11, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set awakenings_count field
    // Comment: The number of awakenings during sleep.
    ///////////////////////////////////////////////////////////////////////
    void SetAwakeningsCount(FIT_UINT8 awakeningsCount)
    {
        SetFieldUINT8Value(11, awakeningsCount, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of interruptions_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsInterruptionsScoreValid() const
    {
        const Field* field = GetField(14);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns interruptions_score field
    // Comment: Score that evaluates the sleep interruptions. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetInterruptionsScore(void) const
    {
        return GetFieldUINT8Value(14, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set interruptions_score field
    // Comment: Score that evaluates the sleep interruptions. If valid: 0 (worst) to 100 (best). If unknown: FIT_UINT8_INVALID.
    ///////////////////////////////////////////////////////////////////////
    void SetInterruptionsScore(FIT_UINT8 interruptionsScore)
    {
        SetFieldUINT8Value(14, interruptionsScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of average_stress_during_sleep field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAverageStressDuringSleepValid() const
    {
        const Field* field = GetField(15);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns average_stress_during_sleep field
    // Comment: Excludes stress during awake periods in the sleep window
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAverageStressDuringSleep(void) const
    {
        return GetFieldFLOAT32Value(15, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set average_stress_during_sleep field
    // Comment: Excludes stress during awake periods in the sleep window
    ///////////////////////////////////////////////////////////////////////
    void SetAverageStressDuringSleep(FIT_FLOAT32 averageStressDuringSleep)
    {
        SetFieldFLOAT32Value(15, averageStressDuringSleep, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

};

} // namespace fit

#endif // !defined(FIT_SLEEP_ASSESSMENT_MESG_HPP)
