% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{scaleInfReps}
\alias{scaleInfReps}
\title{Scale inferential replicate counts}
\usage{
scaleInfReps(
  y,
  lengthCorrect = TRUE,
  meanDepth = NULL,
  sfFun = NULL,
  minCount = 10,
  minN = 3,
  saveMeanScaled = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{y}{a SummarizedExperiment with: \code{infReps} a list of
inferential replicate count matrices, \code{counts} the
estimated counts matrix, and \code{length} the effective
lengths matrix}

\item{lengthCorrect}{whether to use effective length correction
(default is TRUE)}

\item{meanDepth}{(optional) user can
specify a different mean sequencing depth. By default
the geometric mean sequencing depth is computed}

\item{sfFun}{(optional) size factors function. An
alternative to the median ratio can be provided here to adjust
the scaledTPM so as to remove remaining library size differences.
Alternatively, one can provide a numeric vector of size factors}

\item{minCount}{for internal filtering, the minimum count}

\item{minN}{for internal filtering, the minimum sample size
at \code{minCount}}

\item{saveMeanScaled}{store the mean of scaled inferential
replicates as an assay 'meanScaled'}

\item{quiet}{display no messages}
}
\value{
a SummarizedExperiment with the inferential replicates
as scaledTPM with library size already corrected (no need for further
normalization). A column \code{log10mean} is also added which is the
log10 of the mean of scaled counts across all samples and all inferential
replicates.
}
\description{
A helper function to scale the inferential replicates
to the mean sequencing depth. The scaling takes into account
a robust estimator of size factor (median ratio method is used).
First, counts are corrected per row using the effective lengths
(for gene counts, the average transcript lengths), then scaled
per column to the geometric mean sequence depth, and finally are
adjusted per-column up or down by the median ratio size factor to
minimize systematic differences across samples.
}
\examples{

y <- makeSimSwishData()
y <- scaleInfReps(y)

}
