% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_class.R
\docType{class}
\name{region_cossim-class}
\alias{region_cossim-class}
\title{An S4 class to store the results of a regional mutation pattern similarity
analysis}
\description{
An S4 class to store the results of a regional mutation pattern similarity
analysis
}
\section{Slots}{

\describe{
\item{\code{sim_tb}}{A tibble containing the calculated similarities of the windows.}

\item{\code{pos_tb}}{A tibble containing the mutation positions.}

\item{\code{chr_lengths}}{Vector containing the chromosome lengths.}

\item{\code{window_size}}{The number of mutations in a window.}

\item{\code{max_window_size_gen}}{The maximum size of a window before it is removed.}

\item{\code{ref_genome}}{BSgenome reference genome object}

\item{\code{muts_per_chr}}{Vector containing the number of mutations per chromosome.}

\item{\code{mean_window_size}}{The mean length of the genome covered by the windows.}

\item{\code{stepsize}}{The number of mutations that a window slides in each step.}

\item{\code{extension}}{The number of bases, that's extracted upstream and
downstream of the base substitutions, to create the mutation matrices.}

\item{\code{chromosomes}}{Vector of chromosome/contig names of the reference genome
to be plotted.}

\item{\code{exclude_self_mut_mat}}{Boolean describing whether the mutations in a
window should be subtracted from the global mutation matrix.}
}}

