% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/almostAllAccessors.R
\docType{methods}
\name{refseq}
\alias{refseq}
\alias{refseq,ANY-method}
\alias{refseq,XStringSet-method}
\title{Retrieve reference sequences (\code{\link[Biostrings]{XStringSet}}-class) from object.}
\usage{
refseq(physeq, errorIfNULL=TRUE)

\S4method{refseq}{ANY}(physeq, errorIfNULL = TRUE)

\S4method{refseq}{XStringSet}(physeq)
}
\arguments{
\item{physeq}{(Required). An instance of phyloseq-class
that contains a phylogenetic tree. If physeq is a phylogenetic
tree (a component data class), then it is returned as-is.}

\item{errorIfNULL}{(Optional). Logical. Should the accessor stop with 
an error if the slot is empty (\code{NULL})? Default \code{TRUE}.}
}
\value{
The \code{\link[ape]{phylo}}-class object contained within \code{physeq};
 or NULL if \code{physeq} does not have a tree.
 This method stops with an error in the latter NULL case be default, which
 can be over-ridden by changing the value of \code{errorIfNULL} to \code{FALSE}.
}
\description{
This is the suggested method
for accessing
the phylogenetic tree, (\code{\link[Biostrings]{XStringSet}}-class)
from a phyloseq data object (\code{\link{phyloseq-class}}).
Like other accessors (see See Also, below), the default behavior of this method
is to stop with an
error if \code{physeq} is a \code{phyloseq-class} but does not 
contain reference sequences (the component data type you are trying to access in this case).
}
\examples{
 data(GlobalPatterns)
 refseq(GlobalPatterns, FALSE)
}
\seealso{
\code{\link{otu_table}}, \code{\link{sample_data}}, \code{\link{tax_table}}
 \code{\link{phy_tree}},
 \code{\link{phyloseq}}, \code{\link{merge_phyloseq}}
}
