% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{TCGAanalyze_LevelTab}
\alias{TCGAanalyze_LevelTab}
\title{Adding information related to DEGs genes from DEA as mean values in two conditions.}
\usage{
TCGAanalyze_LevelTab(
  FC_FDR_table_mRNA,
  typeCond1,
  typeCond2,
  TableCond1,
  TableCond2,
  typeOrder = TRUE
)
}
\arguments{
\item{FC_FDR_table_mRNA}{Output of dataDEGs filter by abs(LogFC) >=1}

\item{typeCond1}{a string containing the class label of the samples
in TableCond1  (e.g., control group)}

\item{typeCond2}{a string containing the class label of the samples
in TableCond2  (e.g., case group)}

\item{TableCond1}{numeric matrix, each row represents a gene, each column
represents a sample with Cond1type}

\item{TableCond2}{numeric matrix, each row represents a gene, each column
represents a sample with Cond2type}

\item{typeOrder}{typeOrder}
}
\value{
table with DEGs, log Fold Change (FC), false discovery rate (FDR),
the gene expression level
for samples in  Cond1type, and Cond2type, and Delta value (the difference
of gene expression between the two
conditions multiplied logFC)
}
\description{
TCGAanalyze_LevelTab allows user to add information related to DEGs genes from
   Differentially expression analysis (DEA) such as mean values and in two conditions.
}
\examples{
dataNorm <- TCGAbiolinks::TCGAanalyze_Normalization(dataBRCA, geneInfo)
dataFilt <- TCGAanalyze_Filtering(tabDF = dataBRCA, method = "quantile", qnt.cut =  0.25)
samplesNT <- TCGAquery_SampleTypes(colnames(dataFilt), typesample = c("NT"))
samplesTP <- TCGAquery_SampleTypes(colnames(dataFilt), typesample = c("TP"))
dataDEGs <- TCGAanalyze_DEA(
  dataFilt[,samplesNT],
  dataFilt[,samplesTP],
  Cond1type = "Normal",
  Cond2type = "Tumor"
)
dataDEGsFilt <- dataDEGs[abs(dataDEGs$logFC) >= 1,]
dataTP <- dataFilt[,samplesTP]
dataTN <- dataFilt[,samplesNT]
dataDEGsFiltLevel <- TCGAanalyze_LevelTab(
  FC_FDR_table_mRNA = dataDEGsFilt,
  typeCond1 = "Tumor",
  typeCond2 = "Normal",
  TableCond1 = dataTP,
  TableCond2 = dataTN
)
}
