% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_attr.R
\name{bold_get_attr}
\alias{bold_get_attr}
\alias{bold_get_errors}
\alias{bold_get_params}
\title{Get the error messages and parameters used for a request from a bold output.}
\usage{
bold_get_attr(x)

bold_get_errors(x)

bold_get_params(x)
}
\arguments{
\item{x}{Any object with an attribute "params". Usually the output of \code{\link{bold_tax_name}} or \code{\link{bold_tax_id2}}.}
}
\value{
A list of the attributes 'errors' and 'params' of the object.

The 'errors' attribute of the object.

The 'params' attribute of the object.
}
\description{
Get the error messages and parameters used for a request from a bold output.

Get the error messages from a bold output.

Get the parameters used for a request from a bold output.
}
\examples{
\dontrun{
x <- bold_tax_name(name=c("Apis","Felis","Pinus"), tax_division = "Animalia")
bold_get_errors(x)
y <- bold_tax_id2(id = c(88899999, 125295, NA_integer_), dataTypes = c("basic", "stats"))
bold_get_errors(y)
}
\dontrun{
x <- bold_tax_name(name=c("Apis","Felis","Pinus"), tax_division = "Animalia")
bold_get_errors(x)
y <- bold_tax_id2(id = c(88899999, 125295, NA_integer_), dataTypes = c("basic", "stats"))
bold_get_errors(y)
}
\dontrun{
x <- bold_tax_name(name=c("Apis","Felis","Pinus"), tax_division = "Animalia")
bold_get_params(x)
y <- bold_tax_id2(id = c(88899999, 125295, NA_integer_), dataTypes = c("basic", "stats"))
bold_get_params(y)
}
}
